/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.util.Vector;

public class EntryFlavor
implements Cloneable {
    protected boolean isDraggableFlavor;
    protected String className;
    protected String humanReadable;
    protected Vector<Integer> tableIds = new Vector();

    public EntryFlavor() {
    }

    public EntryFlavor(String className, String humanReadable, boolean isDraggableFlavor, int[] dndTableIds) {
        this.className = className;
        this.humanReadable = humanReadable;
        this.isDraggableFlavor = isDraggableFlavor;
        if (dndTableIds != null) {
            int[] nArray = dndTableIds;
            int n = dndTableIds.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                this.tableIds.add(id);
                ++n2;
            }
        }
    }

    public boolean isDraggableFlavor() {
        return this.isDraggableFlavor;
    }

    public String getClassName() {
        return this.className;
    }

    public String getHumanReadable() {
        return this.humanReadable;
    }

    public void setHumanReadable(String humanReadable) {
        this.humanReadable = humanReadable;
    }

    public Vector<Integer> getTableIds() {
        return this.tableIds;
    }

    public void setDraggableFlavor(boolean isDraggableFlavor) {
        this.isDraggableFlavor = isDraggableFlavor;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setTableIds(Vector<Integer> tableIds) {
        this.tableIds = tableIds;
    }

    public Class<?> getDataFlavorClass() {
        try {
            return Class.forName(this.className);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(EntryFlavor.class, ex);
            throw new RuntimeException(ex);
        }
    }

    public int[] getTableIdsAsArray() {
        int[] ids = new int[this.tableIds.size()];
        int i = 0;
        for (int id : this.tableIds) {
            ids[i++] = id;
        }
        return ids;
    }

    protected Object clone() throws CloneNotSupportedException {
        EntryFlavor ef = (EntryFlavor)super.clone();
        ef.className = this.className;
        ef.humanReadable = this.humanReadable;
        ef.isDraggableFlavor = this.isDraggableFlavor;
        ef.tableIds = new Vector<Integer>(this.tableIds);
        return ef;
    }

    public static void config(XStream xstream) {
        xstream.alias("flavor", EntryFlavor.class);
        xstream.useAttributeFor(EntryFlavor.class, "isDraggableFlavor");
        xstream.useAttributeFor(EntryFlavor.class, "className");
        xstream.useAttributeFor(EntryFlavor.class, "humanReadable");
        xstream.aliasAttribute(EntryFlavor.class, "className", "classname");
        xstream.aliasAttribute(EntryFlavor.class, "humanReadable", "humanreadable");
        xstream.aliasAttribute(EntryFlavor.class, "isDraggableFlavor", "isdrag");
    }
}

