/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.NavBoxMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.Trash;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class DatasetNavBoxMgr {
    private static final Logger log = Logger.getLogger(DatasetNavBoxMgr.class);
    private final List<WeakReference<DataSetNavBox>> navBoxes = new LinkedList<WeakReference<DataSetNavBox>>();
    private final WorkbenchTask workbenchTask;

    public DatasetNavBoxMgr(WorkbenchTask workbenchTask) {
        this.workbenchTask = workbenchTask;
    }

    public NavBox createWorkbenchNavBox(String actionType) {
        DataSetNavBox navBox;
        block7: {
            navBox = null;
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                try {
                    navBox = new DataSetNavBox(UIRegistry.getResourceString("WB_DATASETS"), false, true, actionType);
                    List<?> list = session.getDataList("From Workbench where SpecifyUserID = " + AppContextMgr.getInstance().getClassObject(SpecifyUser.class).getSpecifyUserId() + " order by name");
                    for (Object obj : list) {
                        this.addWorkbenchToNavBox(navBox, (Workbench)obj);
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(DatasetNavBoxMgr.class, ex);
                    log.error((Object)ex);
                    ex.printStackTrace();
                    session.close();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                session.close();
                throw throwable;
            }
            session.close();
        }
        if (navBox != null) {
            this.navBoxes.add(new WeakReference<DataSetNavBox>(navBox));
        }
        return navBox;
    }

    public void addWorkbench(Workbench workbench) {
        for (WeakReference<DataSetNavBox> boxRef : this.navBoxes) {
            if (boxRef.get() == null) continue;
            this.addWorkbenchToNavBox((DataSetNavBox)boxRef.get(), workbench);
        }
    }

    public void removeWorkbench(Workbench workbench) {
        for (WeakReference<DataSetNavBox> boxRef : this.navBoxes) {
            if (boxRef.get() == null) continue;
            NavBox nb = (NavBox)boxRef.get();
            NavBoxItemIFace nbi = WorkbenchTask.getBoxByTitle(nb, workbench.getName());
            if (nbi == null) {
                log.error((Object)("couldn't find nbi for Workbench [" + workbench.getName() + "]"));
                return;
            }
            if (!(nbi instanceof GhostActionable)) continue;
            UIRegistry.getGlassPane().remove((GhostActionable)((Object)nbi));
            nb.remove(nbi);
            NavBoxMgr.getInstance().validate();
            NavBoxMgr.getInstance().invalidate();
            NavBoxMgr.getInstance().doLayout();
            NavBoxMgr.getInstance().repaint();
            UIRegistry.forceTopFrameRepaint();
        }
    }

    private RolloverCommand addWorkbenchToNavBox(DataSetNavBox navBox, Workbench workbench) {
        CommandAction cmd = new CommandAction(navBox.actionType, "WB.SelectedWorkbench", Workbench.getClassTableId());
        RecordSet rs = new RecordSet();
        rs.initialize();
        rs.set(workbench.getName(), Workbench.getClassTableId(), RecordSet.GLOBAL);
        rs.addItem(workbench.getWorkbenchId());
        cmd.setProperty("workbench", rs);
        CommandAction deleteCmd = null;
        if (this.workbenchTask.isPermitted()) {
            deleteCmd = new CommandAction("Workbench", "Delete", rs);
        }
        final RolloverCommand roc = (RolloverCommand)((Object)WorkbenchTask.makeDnDNavBtn(navBox, workbench.getName(), "DataSet16", cmd, deleteCmd, true, true));
        if (this.workbenchTask.isPermitted()) {
            roc.setToolTip(UIRegistry.getResourceString("WB_CLICK_EDIT_DATA_TT"));
        }
        if (deleteCmd != null) {
            roc.addDragDataFlavor(Trash.TRASH_FLAVOR);
        }
        roc.addDragDataFlavor(WorkbenchTask.DATASET_FLAVOR);
        if (this.workbenchTask.isPermitted()) {
            roc.addDropDataFlavor(new DataFlavor(Workbench.class, "WB.ExportData"));
        }
        if (this.workbenchTask.canViewReports()) {
            roc.addDropDataFlavor(new DataFlavor(Workbench.class, "Report"));
        }
        JPopupMenu popupMenu = new JPopupMenu();
        String menuTitle = "WB_EDIT_PROPS";
        String mneu = "WB_EDIT_PROPS_MNEU";
        UIHelper.createLocalizedMenuItem(popupMenu, menuTitle, mneu, null, true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetNavBoxMgr.this.workbenchTask.editWorkbenchProps(roc);
                UsageTracker.incrUsageCount("WB.ShowWorkbenchProps");
            }
        });
        menuTitle = "WB_EDIT_DATASET_MAPPING";
        mneu = "WB_EDIT_DATASET_MAPPING_MNEU";
        UIHelper.createLocalizedMenuItem(popupMenu, menuTitle, mneu, null, true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench wb = DatasetNavBoxMgr.this.workbenchTask.getWorkbenchFromCmd(roc.getData(), "WorkbenchEditMapping");
                if (wb != null) {
                    UsageTracker.incrUsageCount("WB.EditMappings");
                    DatasetNavBoxMgr.this.workbenchTask.editTemplate(wb.getWorkbenchTemplate());
                }
            }
        });
        if (this.workbenchTask.isPermitted()) {
            popupMenu.addSeparator();
            menuTitle = "Delete";
            mneu = "DELETE_MNEU";
            UIHelper.createLocalizedMenuItem(popupMenu, menuTitle, mneu, null, true, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommandAction subCmd;
                    RecordSetIFace recordSet;
                    UsageTracker.incrUsageCount("WB.DeletedWorkbench");
                    Object cmdActionObj = roc.getData();
                    if (cmdActionObj != null && cmdActionObj instanceof CommandAction && (recordSet = (RecordSetIFace)(subCmd = (CommandAction)cmdActionObj).getProperty("workbench")) != null) {
                        DatasetNavBoxMgr.this.workbenchTask.deleteWorkbench(recordSet);
                    }
                }
            });
        }
        roc.setPopupMenu(popupMenu);
        NavBox.refresh(navBox);
        return roc;
    }

    private static class DataSetNavBox
    extends NavBox {
        public final String actionType;

        public DataSetNavBox(String name, boolean collapsable, boolean scrollable, String actionType) {
            super(name, collapsable, scrollable);
            this.actionType = actionType;
        }
    }
}

