/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.auth.BasicPermisionPanel;
import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.MenuItemDesc;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxAction;
import edu.ku.brc.af.core.NavBoxButton;
import edu.ku.brc.af.core.NavBoxIFace;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.NavBoxMgr;
import edu.ku.brc.af.core.ServiceInfo;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewLoader;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.specify.datamodel.SpReport;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgr;
import edu.ku.brc.specify.prefs.FormattingPrefsPanel;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.DataEntryConfigDlg;
import edu.ku.brc.specify.tasks.DataEntryView;
import edu.ku.brc.specify.tasks.DataEntryXML;
import edu.ku.brc.specify.tasks.InfoForTaskReport;
import edu.ku.brc.specify.tasks.InteractionsTask;
import edu.ku.brc.specify.tasks.RecordSetTask;
import edu.ku.brc.specify.tasks.TaskConfigItemIFace;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.Uploader;
import edu.ku.brc.specify.ui.BatchReidentifyPanel;
import edu.ku.brc.specify.ui.DBObjDialogFactory;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DataFlavorTableExt;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import edu.ku.brc.ui.ToolBarDropDownBtn;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.DataActionEvent;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.Trash;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DataEntryTask
extends BaseTask {
    private static final Logger log = Logger.getLogger(DataEntryTask.class);
    public static final String DATA_ENTRY = "Data_Entry";
    public static final String VIEW_WAS_OPENED = "ViewWasOpened";
    public static final String VIEW_WAS_SHOWN = "ViewWasShown";
    public static final String OPEN_NEW_VIEW = "OpenNewView";
    public static final String EDIT_DATA = "Edit";
    public static final String DATA = "Data";
    public static final DataFlavor DATAENTRY_FLAVOR = new DataFlavor(DataEntryTask.class, "Data_Entry");
    protected static final String resourceName = "DataEntryTaskInit";
    protected static Hashtable<String, ImageIcon> iconForFormClass = new Hashtable();
    protected Vector<NavBoxIFace> extendedNavBoxes = new Vector();
    protected NavBox viewsNavBox = null;
    protected NavBox containerNavBox = null;
    protected Vector<DataEntryView> stdViews = null;
    protected Vector<DataEntryView> miscViews = null;
    protected Vector<DataEntryView> availMiscViews = new Vector();
    protected NavBoxButton colObjNavBtn = null;
    protected String iconClassLookUpName = "";

    public DataEntryTask() {
        super(DATA_ENTRY, UIRegistry.getResourceString(DATA_ENTRY));
        CommandDispatcher.register(DATA_ENTRY, this);
        CommandDispatcher.register("Record_Set", this);
        CommandDispatcher.register(DATA, this);
        CommandDispatcher.register("Preferences", this);
        this.viewsNavBox = new NavBox(UIRegistry.getResourceString("CreateAndUpdate"));
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
            this.navBoxes.add(this.viewsNavBox);
        }
        this.isShowDefault = true;
    }

    protected static ImageIcon getIconForView(ViewIFace view) {
        ImageIcon imgIcon = null;
        if (imgIcon == null) {
            try {
                Class<?> clsObj = Class.forName(view.getClassName());
                imgIcon = IconManager.getIcon(clsObj.getSimpleName(), IconManager.IconSize.Std16);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataEntryTask.class, ex);
            }
            if (imgIcon == null) {
                return IconManager.getIcon(DATA_ENTRY, IconManager.IconSize.Std16);
            }
        }
        return imgIcon;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FormPane openView(final Taskable task, String viewSetName, String viewName, String modeArg, FormDataObjIFace data, boolean isNewForm) {
        ViewIFace view;
        String mode = modeArg;
        Vector<FormDataObjIFace> dataObjList = new Vector<FormDataObjIFace>();
        ViewIFace viewIFace = view = viewSetName == null ? SpecifyAppContextMgr.getInstance().getView(viewName) : SpecifyAppContextMgr.getInstance().getView(viewSetName, viewName);
        if (view == null) {
            UIRegistry.showError("Couldn't find default form for [" + viewName + "]");
            return null;
        }
        DBObjDialogFactory.FormLockStatus lockStatus = DBObjDialogFactory.isLockOK("LockTitle", view, isNewForm, mode == null || mode.equals("edit"));
        if (lockStatus != DBObjDialogFactory.FormLockStatus.OK) {
            if (lockStatus == DBObjDialogFactory.FormLockStatus.ViewOnly) {
                mode = "view";
            } else if (lockStatus == DBObjDialogFactory.FormLockStatus.Skip) {
                return null;
            }
        }
        Vector<FormDataObjIFace> dataObj = data;
        FormDataObjIFace formDataObj = data;
        if (formDataObj == null) {
            if (isNewForm) {
                try {
                    String className = view.getClassName();
                    if (StringUtils.isNotEmpty((String)className)) {
                        try {
                            PermissionSettings perm;
                            DBTableInfo tblInfo;
                            Class<?> dataClass = Class.forName(className);
                            if (AppContextMgr.isSecurityOn() && (tblInfo = DBTableIdMgr.getInstance().getByShortClassName(dataClass.getSimpleName())) != null && !(perm = tblInfo.getPermissions()).canAdd()) {
                                UIRegistry.showLocalizedMsg("DET_NO_ADD_PERM");
                                return null;
                            }
                            formDataObj = FormHelper.createAndNewDataObj(dataClass);
                            dataObjList.add(formDataObj);
                            dataObj = dataObjList;
                        }
                        catch (Exception ex) {
                            log.error((Object)("The Class[" + className + "] couldn't be created."));
                        }
                    }
                    log.error((Object)("Class name is empty for view[" + view.getName() + "]"));
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
            }
        } else {
            DataProviderFactory.getInstance().evict(data.getClass());
            dataObjList.add(data);
            dataObj = dataObjList;
        }
        final FormPane formPane = new FormPane(view.getName(), task, view, mode, dataObj, isNewForm ? 5 : 0, true);
        formPane.setIcon(DataEntryTask.getIconForView(view));
        if (isNewForm) {
            formPane.initSubViews();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubPaneIFace taskStarterPane;
                SubPaneIFace subPaneIFace = taskStarterPane = task != null ? task.getStarterPane() : null;
                if (taskStarterPane == null) {
                    SubPaneIFace curPane = SubPaneMgr.getInstance().getCurrentSubPane();
                    if (curPane instanceof DroppableFormRecordSetAccepter) {
                        SubPaneMgr.getInstance().replacePane(curPane, formPane);
                    }
                    DataEntryTask.this.addSubPaneToMgr(formPane);
                } else {
                    SubPaneMgr.getInstance().replacePane(taskStarterPane, formPane);
                    task.setStarterPane(null);
                }
                CommandDispatcher.dispatch(new CommandAction(DataEntryTask.DATA_ENTRY, DataEntryTask.VIEW_WAS_OPENED, formPane));
                formPane.focusFirstFormControl();
            }
        });
        return formPane;
    }

    @Override
    public void subPaneRemoved(SubPaneIFace subPane) {
        FormPane formPane;
        MultiView multiView;
        super.subPaneRemoved(subPane);
        if (subPane instanceof FormPane && (multiView = (formPane = (FormPane)subPane).getMultiView()) != null) {
            ViewIFace view = multiView.getView();
            Class<?> treeDefClass = ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getTreeDefClass(view);
            if (treeDefClass != null) {
                boolean hasDataOfTreeClass = false;
                for (SubPaneIFace sp : SubPaneMgr.getInstance().getSubPanes()) {
                    ViewIFace fpView;
                    FormPane fp;
                    if (!(sp instanceof FormPane) || (fp = (FormPane)sp) == formPane) continue;
                    ViewIFace viewIFace = fpView = fp.getViewable() != null ? fp.getViewable().getView() : null;
                    if (view == fpView || fpView == null || !fpView.getClassName().equals(view.getClassName())) continue;
                    hasDataOfTreeClass = true;
                    break;
                }
                if (!hasDataOfTreeClass) {
                    TaskSemaphoreMgr.decrementUsageCount(this.title, treeDefClass.getSimpleName(), TaskSemaphoreMgr.SCOPE.Discipline);
                }
            }
        }
    }

    public static void openView(Taskable task, ViewIFace view, String mode, String idStr) {
        PermissionSettings perm;
        DBTableInfo tblInfo;
        int tableId = DBTableIdMgr.getInstance().getIdByClassName(view.getClassName());
        if (AppContextMgr.isSecurityOn() && (tblInfo = DBTableIdMgr.getInstance().getInfoById(tableId)) != null && !(perm = tblInfo.getPermissions()).canView()) {
            return;
        }
        String sqlStr = DBTableIdMgr.getInstance().getQueryForTable(tableId, Integer.parseInt(idStr));
        if (StringUtils.isNotEmpty((String)sqlStr)) {
            try {
                List<?> data;
                block14: {
                    data = null;
                    DataProviderSessionIFace session = null;
                    try {
                        try {
                            session = DataProviderFactory.getInstance().createSession();
                            data = session.getDataList(sqlStr);
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(DataEntryTask.class, ex);
                            log.error((Object)ex);
                            ex.printStackTrace();
                            if (session != null) {
                                session.close();
                            }
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable;
                    }
                    if (session != null) {
                        session.close();
                    }
                }
                if (data != null && data.size() > 0) {
                    FormPane formPane = new FormPane(view.getName(), task, view.getViewSetName(), view.getName(), mode, data.get(0), 2);
                    formPane.setIcon(DataEntryTask.getIconForView(view));
                    CommandDispatcher.dispatch(new CommandAction(DATA_ENTRY, VIEW_WAS_OPENED, formPane));
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataEntryTask.class, ex);
                log.error((Object)ex);
                ex.printStackTrace();
            }
        } else {
            log.error((Object)("Query String is empty for tableId[" + tableId + "] idStr[" + idStr + "]"));
        }
    }

    protected static FormPane createFormFor(Taskable task, String name, String viewSetName, String viewName, RecordSetIFace recordSet) {
        return DataEntryTask.createFormFor(task, name, viewSetName, viewName, recordSet, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static FormPane createFormFor(Taskable task, String name, String viewSetName, String viewName, RecordSetIFace recordSet, boolean readOnlyArg) {
        String mode;
        int options;
        ViewIFace view;
        DBTableInfo tblInfo;
        boolean readOnly = readOnlyArg;
        if (AppContextMgr.isSecurityOn() && (tblInfo = DBTableIdMgr.getInstance().getInfoById(recordSet.getDbTableId())).getPermissions().hasNoPerm()) {
            return null;
        }
        FormPane formPane = null;
        SubPaneIFace subPane = SubPaneMgr.getSubPaneWithRecordSet(recordSet);
        if (subPane == null) {
            view = null;
            if (StringUtils.isNotEmpty((String)viewName)) {
                view = AppContextMgr.getInstance().getView(viewSetName, viewName);
            } else {
                String defaultFormName = DBTableIdMgr.getInstance().getDefaultFormNameById(recordSet.getDbTableId());
                if (StringUtils.isNotEmpty((String)defaultFormName)) {
                    view = AppContextMgr.getInstance().getView(defaultFormName);
                } else {
                    log.error((Object)("No Default View for Table Id[" + recordSet.getDbTableId() + "] from recordset"));
                }
            }
            if (view == null) throw new RuntimeException("The view was null and shouldn't be!");
            options = 1;
            mode = null;
            DBObjDialogFactory.FormLockStatus lockStatus = DBObjDialogFactory.isLockOK("LockTitle", view, false, !readOnlyArg);
            if (lockStatus != DBObjDialogFactory.FormLockStatus.OK) {
                if (lockStatus == DBObjDialogFactory.FormLockStatus.ViewOnly) {
                    mode = "view";
                    readOnly = true;
                } else if (lockStatus == DBObjDialogFactory.FormLockStatus.Skip) {
                    return null;
                }
            }
            options = readOnly ? (options |= 8) : (options |= 2);
        } else {
            SubPaneMgr.getInstance().showPane(subPane);
            return null;
        }
        formPane = new FormPane(name, task, view, mode, null, options);
        formPane.setIcon(DataEntryTask.getIconForView(view));
        formPane.setRecordSet(recordSet);
        CommandDispatcher.dispatch(new CommandAction(DATA_ENTRY, VIEW_WAS_OPENED, formPane));
        return formPane;
    }

    protected void buildFormNavBoxes(Vector<DataEntryView> devList, boolean doRegister) {
        SpecifyAppContextMgr appContextMgr = (SpecifyAppContextMgr)AppContextMgr.getInstance();
        boolean isUsingInteractions = this.isUsingInteractions();
        Taskable interactionsTask = TaskMgr.getTask("InteractionsTaskInit");
        for (DataEntryView dev : devList) {
            ViewIFace view = appContextMgr.getView(null, dev.getView());
            if (view != null) {
                DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(view.getClassName());
                dev.setTableInfo(tableInfo);
            }
            boolean isColObj = dev.getTableInfo() != null && dev.getTableInfo().getTableId() == CollectionObject.getClassTableId();
            ImageIcon iconImage = IconManager.getIcon(dev.getIconName(), IconManager.STD_ICON_SIZE);
            if (iconImage != null) {
                String iconNameStr;
                if (isColObj) {
                    iconNameStr = AppPreferences.getRemote().get(FormattingPrefsPanel.getDisciplineImageName(), "CollectionObject");
                    ImageIcon colIconImage = IconManager.getIcon(iconNameStr, IconManager.STD_ICON_SIZE);
                    if (colIconImage != null) {
                        iconImage = colIconImage;
                    }
                    this.iconClassLookUpName = iconNameStr = "CollectionObject";
                } else {
                    iconNameStr = dev.getView();
                }
                iconForFormClass.put(iconNameStr, iconImage);
            } else {
                log.error((Object)("Icon [" + dev.getIconName() + "] could not be found."));
            }
            if (view != null) {
                DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(view.getClassName());
                dev.setTableInfo(tableInfo);
                if (AppContextMgr.isSecurityOn() && !tableInfo.getPermissions().canView()) continue;
                if (tableInfo != null) {
                    if (tableInfo.isHidden()) continue;
                    CommandAction cmdAction = new CommandAction(DATA_ENTRY, EDIT_DATA);
                    cmdAction.setProperty("view", dev.getView());
                    if (doRegister) {
                        Taskable task;
                        int tblId = tableInfo.getTableId();
                        Taskable taskable = task = isUsingInteractions ? AppContextMgr.getInstance().getTaskFromTableId(tblId) : null;
                        if (task == interactionsTask && !isUsingInteractions) {
                            task = this;
                        }
                        cmdAction.setProperty("OriginatingTask", task);
                        ContextMgr.registerService(10, dev.getView(), tblId, cmdAction, this, DATA_ENTRY, tableInfo.getTitle(), true);
                    }
                    if (!dev.isSideBar()) continue;
                    cmdAction = new CommandAction(DATA_ENTRY, OPEN_NEW_VIEW);
                    cmdAction.setProperty("view", dev.getView());
                    cmdAction.setProperty("tableInfo", dev.getTableInfo());
                    NavBoxAction nba = new NavBoxAction(cmdAction);
                    NavBoxItemIFace nbi = NavBox.createBtnWithTT(dev.getTitle(), dev.getIconName(), dev.getToolTip(), IconManager.STD_ICON_SIZE, nba);
                    if (nbi instanceof NavBoxButton) {
                        NavBoxButton nbb = (NavBoxButton)nbi;
                        if (isColObj) {
                            this.colObjNavBtn = nbb;
                        }
                        nbb.addDragDataFlavor(Trash.TRASH_FLAVOR);
                        nbb.addDragDataFlavor(new DataFlavorTableExt(DataEntryTask.class, DATA_ENTRY, tableInfo.getTableId()));
                        nbb.addDropDataFlavor(new DataFlavorTableExt(RecordSetTask.class, "Record_Set", tableInfo.getTableId()));
                    }
                    this.viewsNavBox.add(nbi);
                    continue;
                }
                UIRegistry.showError("View's Class name[" + view.getClassName() + "] was not found in the DBTableIdMgr");
                continue;
            }
            UIRegistry.showError("View doesn't exist view[" + dev.getView() + "] for entry in dataentry_task.xml");
        }
    }

    protected boolean isUsingInteractions() {
        AppPreferences remotePrefs = AppPreferences.getRemote();
        String discipline = AppContextMgr.getInstance().getClassObject(Discipline.class).getType();
        return remotePrefs.getBoolean("Interactions.Using.Interactions." + discipline, true);
    }

    protected void initDataEntryViews(Vector<DataEntryView> list, boolean doRegister) {
        boolean isUsingInteractions = this.isUsingInteractions();
        Taskable interactionsTask = TaskMgr.getTask("InteractionsTaskInit");
        SpecifyAppContextMgr appContextMgr = (SpecifyAppContextMgr)AppContextMgr.getInstance();
        for (DataEntryView dev : list) {
            ViewIFace view = appContextMgr.getView(null, dev.getView());
            if (view != null) {
                DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(view.getClassName());
                dev.setTableInfo(tableInfo);
                CommandAction cmdAction = new CommandAction(DATA_ENTRY, EDIT_DATA);
                cmdAction.setProperty("view", dev.getView());
                if (!doRegister) continue;
                int tblId = tableInfo.getTableId();
                Taskable task = AppContextMgr.getInstance().getTaskFromTableId(tblId);
                if (task == interactionsTask && !isUsingInteractions) {
                    task = this;
                }
                cmdAction.setProperty("OriginatingTask", task);
                ContextMgr.registerService(10, dev.getView(), tblId, cmdAction, this, DATA_ENTRY, tableInfo.getTitle(), true);
                continue;
            }
            if (dev.getView().startsWith("Exsi")) continue;
            UIRegistry.showError("Couldn't find view[" + dev.getView() + "] for entry in dataentry_task.xml");
        }
    }

    protected ActionListener createMiscActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e instanceof DataActionEvent) {
                    DataActionEvent dataActionEv = (DataActionEvent)e;
                    if (dataActionEv.getSourceObj() != null) {
                        Object data = dataActionEv.getSourceObj().getData();
                        if (data instanceof RecordSetIFace) {
                            RecordSetIFace rs = (RecordSetIFace)data;
                            for (DataEntryView deView : DataEntryTask.this.miscViews) {
                                if (deView.getTableInfo().getTableId() != rs.getDbTableId().intValue()) continue;
                                DataEntryTask.this.editData(DataEntryTask.this, rs, deView.getView());
                                return;
                            }
                        } else {
                            DataEntryTask.this.showMiscViewsDlg();
                        }
                    }
                } else {
                    DataEntryTask.this.showMiscViewsDlg();
                }
            }
        };
    }

    protected void initializeViewsNavBoxFromXML() {
        boolean cacheDoVerify = ViewLoader.isDoFieldVerification();
        ViewLoader.setDoFieldVerification(false);
        if (this.viewsNavBox.getCount() == 0) {
            try {
                ViewIFace view;
                XStream xstream = new XStream();
                DataEntryTask.config(xstream);
                String xmlStr = null;
                AppResourceIFace escAppRes = AppContextMgr.getInstance().getResourceFromDir("Personal", resourceName);
                if (escAppRes != null) {
                    xmlStr = escAppRes.getDataAsString();
                } else {
                    AppResourceIFace newAppRes = AppContextMgr.getInstance().copyToDirAppRes("Personal", resourceName);
                    if (newAppRes != null) {
                        xmlStr = newAppRes.getDataAsString();
                    } else {
                        return;
                    }
                }
                DataEntryXML dataEntryXML = (DataEntryXML)xstream.fromXML(xmlStr);
                this.stdViews = dataEntryXML.getStd();
                this.miscViews = dataEntryXML.getMisc();
                SpecifyAppContextMgr acm = (SpecifyAppContextMgr)AppContextMgr.getInstance();
                for (DataEntryView dev : this.stdViews) {
                    if (StringUtils.isEmpty((String)dev.getToolTip())) {
                        view = acm.getView(dev.getView());
                        if (view == null) continue;
                        dev.setToolTip(UIRegistry.getLocalizedMessage("DET_OPEN_VIEW", view.getObjTitle()));
                        continue;
                    }
                    dev.setToolTip(dev.getToolTip());
                }
                for (DataEntryView dev : this.miscViews) {
                    if (StringUtils.isEmpty((String)dev.getToolTip())) {
                        view = acm.getView(dev.getView());
                        if (view == null) continue;
                        dev.setToolTip(UIRegistry.getLocalizedMessage("DET_OPEN_VIEW", view.getObjTitle()));
                        continue;
                    }
                    dev.setToolTip(dev.getToolTip());
                }
                this.buildNavBoxes(this.stdViews, this.miscViews, true);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataEntryTask.class, ex);
                log.error((Object)ex);
                ex.printStackTrace();
            }
        }
        ViewLoader.setDoFieldVerification(cacheDoVerify);
    }

    protected void buildNavBoxes(Vector<DataEntryView> stdList, Vector<DataEntryView> miscList, boolean doRegister) {
        this.buildFormNavBoxes(stdList, doRegister);
        if (miscList != null && !miscList.isEmpty()) {
            this.availMiscViews.clear();
            for (DataEntryView dev : miscList) {
                ViewIFace view = AppContextMgr.getInstance().getView(null, dev.getView());
                if (view != null) {
                    DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(view.getClassName());
                    dev.setTableInfo(tableInfo);
                    if (AppContextMgr.isSecurityOn() && !tableInfo.getPermissions().canView()) continue;
                }
                this.availMiscViews.add(dev);
            }
            if (this.availMiscViews.size() > 0) {
                this.initDataEntryViews(this.availMiscViews, doRegister);
                NavBoxItemIFace nbi = NavBox.createBtnWithTT(UIRegistry.getResourceString("DET_MISC_FORMS"), "MoreForms", UIRegistry.getResourceString("DET_CHOOSE_TT"), IconManager.STD_ICON_SIZE, this.createMiscActionListener());
                NavBoxButton roc = (NavBoxButton)nbi;
                for (DataEntryView dev : this.availMiscViews) {
                    if (dev.getTableInfo() == null) continue;
                    roc.addDropDataFlavor(new DataFlavorTableExt(DataEntryTask.class, "Record_Set", dev.getTableInfo().getTableId()));
                }
                this.viewsNavBox.add(nbi);
            }
        }
    }

    protected void showMiscViewsDlg() {
        UsageTracker.incrUsageCount("DE.SHOW.MISC");
        DataEntryView deView = null;
        ToggleButtonChooserDlg<DataEntryView> dlg = new ToggleButtonChooserDlg<DataEntryView>((Frame)UIRegistry.getTopWindow(), "DET_CHOOSE_TITLE", this.availMiscViews, ToggleButtonChooserPanel.Type.RadioButton);
        dlg.setUseScrollPane(true);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            deView = dlg.getSelectedObject();
        }
        if (deView != null) {
            this.openView(this, null, deView.getView(), "edit", null, true);
        }
    }

    @Override
    public List<NavBoxIFace> getNavBoxes() {
        this.initialize();
        this.initializeViewsNavBoxFromXML();
        this.extendedNavBoxes.clear();
        this.extendedNavBoxes.addAll(this.navBoxes);
        RecordSetTask rsTask = (RecordSetTask)ContextMgr.getTaskByClass(RecordSetTask.class);
        List<NavBoxIFace> nbs = rsTask.getNavBoxes();
        if (nbs != null) {
            this.extendedNavBoxes.addAll(nbs);
        }
        return this.extendedNavBoxes;
    }

    @Override
    public SubPaneIFace getStarterPane() {
        for (SubPaneIFace sb : SubPaneMgr.getInstance().getSubPanes()) {
            if (sb.getTask() != this || !(sb instanceof DroppableFormRecordSetAccepter)) continue;
            return sb;
        }
        if (this.starterPane == null) {
            this.starterPane = new DroppableFormRecordSetAccepter(this.title, this, "");
        }
        return this.starterPane;
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        this.toolbarItems = new Vector();
        String label = UIRegistry.getResourceString(DATA_ENTRY);
        String hint = UIRegistry.getResourceString("dataentry_hint");
        ToolBarDropDownBtn btn = this.createToolbarButton(label, this.iconName, hint);
        this.toolbarItems.add(new ToolBarItemDesc(btn));
        return this.toolbarItems;
    }

    @Override
    public List<MenuItemDesc> getMenuItems() {
        String menuDesc = "Specify.DATA_MENU";
        this.menuItems = new Vector();
        if (this.permissions == null || this.permissions.canModify()) {
            String menuTitle = "DET_BTCH_REIDENT_MENU";
            String mneu = "DET_BTCH_REIDENT_MNEU";
            String desc = "DET_BTCH_REIDENT_DESC";
            JMenuItem mi = UIHelper.createLocalizedMenuItem(menuTitle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    DataEntryTask.this.doBatchReidentify();
                }
            });
            MenuItemDesc rsMI = new MenuItemDesc(mi, menuDesc);
            rsMI.setPosition(MenuItemDesc.Position.After);
            this.menuItems.add(rsMI);
        }
        return this.menuItems;
    }

    protected void doBatchReidentify() {
        CustomDialog dlg;
        BatchReidentifyPanel panel = new BatchReidentifyPanel();
        if (panel.askForColObjs() && (dlg = panel.createDlg()) != null) {
            UIHelper.centerAndShow(dlg);
        }
    }

    public Vector<DataEntryView> getStdViews() {
        return this.stdViews;
    }

    public Vector<DataEntryView> getMiscViews() {
        return this.miscViews;
    }

    public Class<? extends BaseTask> getTaskClass() {
        return this.getClass();
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void doConfigure() {
        ContextMgr.dump();
        Vector<TaskConfigItemIFace> stdList = new Vector<TaskConfigItemIFace>();
        Vector<TaskConfigItemIFace> miscList = new Vector<TaskConfigItemIFace>();
        try {
            for (DataEntryView de : this.stdViews) {
                stdList.add((DataEntryView)de.clone());
            }
            for (DataEntryView de : this.miscViews) {
                miscList.add((DataEntryView)de.clone());
            }
        }
        catch (CloneNotSupportedException de) {
            // empty catch block
        }
        UsageTracker.incrUsageCount("DE.CONFIG");
        DataEntryConfigDlg dlg = new DataEntryConfigDlg(stdList, miscList, true, "DataEntryConfigure", "DET_CONFIGURE_VIEWS", "DET_STANDARD", "DET_MISC_FORMS", "DET_MOVE_TO_MISC_TT", "DET_MOVE_TO_STD_TT");
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            this.stdViews.clear();
            this.miscViews.clear();
            for (TaskConfigItemIFace entry : stdList) {
                this.stdViews.add((DataEntryView)entry);
            }
            for (TaskConfigItemIFace entry : miscList) {
                this.miscViews.add((DataEntryView)entry);
            }
            this.viewsNavBox.clear();
            this.unregisterServices(stdList, miscList);
            this.buildNavBoxes(this.stdViews, this.miscViews, true);
            this.viewsNavBox.validate();
            this.viewsNavBox.doLayout();
            NavBoxMgr.getInstance().validate();
            NavBoxMgr.getInstance().doLayout();
            NavBoxMgr.getInstance().repaint();
            DataEntryXML dataEntryXML = new DataEntryXML(this.stdViews, this.miscViews);
            XStream xstream = new XStream();
            DataEntryTask.config(xstream);
            AppResourceIFace escAppRes = AppContextMgr.getInstance().getResourceFromDir("Personal", resourceName);
            if (escAppRes != null) {
                escAppRes.setDataAsString(xstream.toXML((Object)dataEntryXML));
                AppContextMgr.getInstance().saveResource(escAppRes);
            } else {
                AppContextMgr.getInstance().putResourceAsXML(resourceName, xstream.toXML((Object)dataEntryXML));
            }
        }
    }

    protected void unregisterServices(Vector<? extends TaskConfigItemIFace> stdList, Vector<? extends TaskConfigItemIFace> miscList) {
        String srvName;
        DataEntryView dev;
        if (stdList != null) {
            for (TaskConfigItemIFace taskConfigItemIFace : stdList) {
                dev = (DataEntryView)taskConfigItemIFace;
                if (dev.getTableInfo() == null) continue;
                srvName = ServiceInfo.getHashKey(dev.getView(), this, dev.getTableInfo().getTableId());
                ContextMgr.unregisterService(srvName);
            }
        }
        if (miscList != null) {
            for (TaskConfigItemIFace taskConfigItemIFace : miscList) {
                dev = (DataEntryView)taskConfigItemIFace;
                if (dev.getTableInfo() == null) continue;
                srvName = ServiceInfo.getHashKey(dev.getView(), this, dev.getTableInfo().getTableId());
                ContextMgr.unregisterService(srvName);
            }
        }
    }

    protected void prefsChanged(AppPreferences appPrefs) {
        if (appPrefs == AppPreferences.getRemote()) {
            String iconNameStr = appPrefs.get(FormattingPrefsPanel.getDisciplineImageName(), "CollectionObject");
            ImageIcon iconImage = IconManager.getIcon(iconNameStr, IconManager.STD_ICON_SIZE);
            if (iconImage != null) {
                if (this.colObjNavBtn != null) {
                    this.colObjNavBtn.setIcon(iconImage);
                    this.colObjNavBtn.repaint();
                }
                if (iconForFormClass != null && StringUtils.isNotEmpty((String)this.iconClassLookUpName)) {
                    iconForFormClass.put(this.iconClassLookUpName, iconImage);
                }
            }
            if (this.starterPane != null && this.starterPane instanceof DroppableFormRecordSetAccepter) {
                ((DroppableFormRecordSetAccepter)this.starterPane).resetSplashIcon();
            }
        }
    }

    protected void openNewView(FormPane formPane) {
    }

    protected void adjustNewDataObject(Object dataObj) {
        if (dataObj != null && dataObj instanceof FormDataObjIFace && dataObj instanceof CollectionObject) {
            Agent agent;
            CollectionObject colObj = (CollectionObject)dataObj;
            if (colObj.getCollection() == null) {
                Collection catSeries = AppContextMgr.getInstance().getClassObject(Collection.class);
                colObj.setCollection(catSeries);
            }
            if ((agent = Agent.getUserAgent()) != null) {
                colObj.setCataloger(agent);
            }
        }
    }

    protected void editData(Taskable task, Object data, String viewName) {
        this.editData(task, data, viewName, false);
    }

    protected void editData(Taskable task, Object data, String viewName, boolean readOnly) {
        if (data instanceof RecordSetIFace) {
            FormPane formPane = DataEntryTask.createFormFor(task, this.name, null, viewName, (RecordSetIFace)data, readOnly);
            if (formPane != null) {
                this.addSubPaneToMgr(formPane);
            }
        } else if (data instanceof Object[]) {
            Object[] dataList = (Object[])data;
            if (dataList.length == 3) {
                ViewIFace view = (ViewIFace)dataList[0];
                String mode = (String)dataList[1];
                String idStr = (String)dataList[2];
                DataEntryTask.openView(task, view, mode, idStr);
            } else {
                log.error((Object)"The Edit Command was sent with an object Array that was not 3 components!");
            }
        } else {
            log.error((Object)"The Edit Command was sent that didn't have data that was a RecordSet or an Object Array");
        }
    }

    protected void processDataEntryCommands(final CommandAction cmdAction) {
        if (cmdAction.isAction(OPEN_NEW_VIEW)) {
            String viewName = cmdAction.getPropertyAsString("view");
            Taskable task = (Taskable)cmdAction.getProperty("OriginatingTask");
            Object data = cmdAction.getData();
            if (data instanceof RecordSetIFace) {
                this.editData(task != null ? task : this, data, viewName);
            } else if (data instanceof Pair) {
                Taxon parentTaxon;
                Taxon childForForm;
                Pair p = (Pair)data;
                if (p.first instanceof Taxon && p.second instanceof String && ((String)p.second).equals("createchild") && (childForForm = this.addChildToParentInForm(parentTaxon = (Taxon)p.first)) != null) {
                    this.openView(task != null ? task : this, null, "Taxon", "edit", childForForm, true);
                }
            } else {
                this.openView(task != null ? task : this, null, viewName, "edit", null, true);
            }
        } else if (cmdAction.isAction(EDIT_DATA)) {
            Taskable task = (Taskable)cmdAction.getProperty("OriginatingTask");
            this.editData(task != null ? task : this, cmdAction.getData(), null, cmdAction.getProperty("readonly") != null);
        } else if (cmdAction.isAction("ShowView")) {
            if (cmdAction.getData() instanceof Object[]) {
                Object[] dataList = (Object[])cmdAction.getData();
                ViewIFace view = (ViewIFace)dataList[0];
                String mode = (String)dataList[1];
                String idStr = (String)dataList[2];
                DataEntryTask.openView(this, view, mode, idStr);
            }
        } else if (cmdAction.isAction(VIEW_WAS_SHOWN)) {
            if (cmdAction.getData() instanceof FormViewObj) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MultiView mv = ((FormViewObj)cmdAction.getData()).getMVParent();
                        if (mv != null && mv.isTopLevel()) {
                            mv.focus();
                        }
                    }
                });
            }
        } else if (!cmdAction.isAction("SaveBeforeSetData") && cmdAction.isAction("PrintColObjLabel")) {
            this.checkToPrintLabel(cmdAction, true);
        }
    }

    private Taxon addChildToParentInForm(Taxon parentTaxon) {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            Taxon parent = session.get(Taxon.class, parentTaxon.getId());
            Taxon newTaxon = new Taxon();
            newTaxon.initialize();
            newTaxon.setParent(parent);
            parent.getChildren().add(newTaxon);
            Taxon taxon = newTaxon;
            return taxon;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    protected void checkToPrintLabel(CommandAction cmdAction, boolean doOverride) {
        if (cmdAction.getData() instanceof CollectionObject) {
            CollectionObject colObj = (CollectionObject)cmdAction.getData();
            if (colObj.getDeterminations().size() == 0 || colObj.getPreparations().size() == 0) {
                UIRegistry.showLocalizedError("DET_NOLBL_CO");
                return;
            }
            Boolean doPrintLabel = null;
            if (!doOverride) {
                Component comp;
                FormViewObj formViewObj = this.getCurrentFormViewObj();
                if (formViewObj != null && (comp = formViewObj.getControlByName("generateLabelChk")) instanceof JCheckBox) {
                    doPrintLabel = ((JCheckBox)comp).isSelected();
                }
                if (doPrintLabel == null) {
                    return;
                }
            }
            if (doOverride || doPrintLabel.booleanValue()) {
                InfoForTaskReport inforForPrinting = this.getLabelReportInfo();
                if (inforForPrinting == null) {
                    return;
                }
                DataProviderSessionIFace session = null;
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    String hql = "FROM CollectionObject WHERE id = " + colObj.getId();
                    colObj = (CollectionObject)session.getData(hql);
                    Set<Determination> deters = colObj.getDeterminations();
                    if (deters != null && deters.size() == 0) {
                        UIRegistry.displayErrorDlg(UIRegistry.getResourceString("NO_DETERS_ERROR"));
                    } else {
                        RecordSet rs = new RecordSet();
                        rs.initialize();
                        rs.setName(colObj.getIdentityTitle());
                        rs.setDbTableId(CollectionObject.getClassTableId());
                        rs.addItem(colObj.getId());
                        this.dispatchReport(inforForPrinting, rs, "ColObjLabel");
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InfoForTaskReport getLabelReportInfo() {
        DataProviderSessionIFace session = null;
        ChooseFromListDlg dlg = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            List<AppResourceIFace> reps = AppContextMgr.getInstance().getResourceByMimeType("jrxml/label");
            reps.addAll(AppContextMgr.getInstance().getResourceByMimeType("jrxml/report"));
            Vector<InfoForTaskReport> repInfo = new Vector<InfoForTaskReport>();
            for (AppResourceIFace rep : reps) {
                boolean includeIt;
                SpReport spReport;
                block16: {
                    Properties params = rep.getMetaDataMap();
                    String tableid = params.getProperty("tableid");
                    spReport = null;
                    includeIt = false;
                    try {
                        DataProviderSessionIFace.QueryIFace q;
                        List<?> spReps;
                        Integer tblId = null;
                        try {
                            tblId = Integer.valueOf(tableid);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (tblId == null) continue;
                        if (tblId.equals(CollectionObject.getClassTableId())) {
                            includeIt = true;
                            break block16;
                        }
                        if (!tblId.equals(-1) || (spReps = (q = session.createQuery("from SpReport spr join spr.appResource apr join spr.query spq where apr.id = " + ((SpAppResource)rep).getId() + " and spq.contextTableId = " + CollectionObject.getClassTableId(), false)).list()).size() <= 0) break block16;
                        includeIt = true;
                        spReport = (SpReport)((Object[])spReps.get(0))[0];
                        spReport.forceLoad();
                        if (spReps.size() > 1) {
                            log.error((Object)("More than SpReport exists for " + rep.getName()));
                        }
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(InteractionsTask.class, ex);
                    }
                }
                if (!includeIt) continue;
                repInfo.add(new InfoForTaskReport((SpAppResource)rep, spReport));
            }
            if (repInfo.size() == 0) {
                UIRegistry.displayInfoMsgDlgLocalized("InteractionsTask.NoInvoiceFound", DBTableIdMgr.getInstance().getTitleForId(CollectionObject.getClassTableId()));
                return null;
            }
            if (repInfo.size() == 1) {
                InfoForTaskReport infoForTaskReport = (InfoForTaskReport)repInfo.get(0);
                return infoForTaskReport;
            }
            dlg = new ChooseFromListDlg((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("REP_CHOOSE_INVOICE"), repInfo);
            dlg.setVisible(true);
            if (dlg.isCancelled()) {
                return null;
            }
            InfoForTaskReport infoForTaskReport = (InfoForTaskReport)dlg.getSelectedObject();
            return infoForTaskReport;
        }
        finally {
            session.close();
            if (dlg != null) {
                dlg.dispose();
            }
        }
    }

    @Override
    public PermissionEditorIFace getPermEditorPanel() {
        return new BasicPermisionPanel(null, "ENABLE");
    }

    @Override
    protected boolean[][] getPermsArray() {
        boolean[][] blArrayArray = new boolean[4][];
        blArrayArray[0] = new boolean[]{true, true, true, true};
        blArrayArray[1] = new boolean[]{true, true, true, true};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArray[3] = true;
        blArrayArray[2] = blArray;
        blArrayArray[3] = new boolean[]{true, true, true, true};
        return blArrayArray;
    }

    protected boolean processRecordSetCommand(CommandAction cmdAction, List<DataEntryView> list) {
        if (ContextMgr.getCurrentContext() == this && cmdAction.getSrcObj() instanceof RecordSetIFace) {
            RecordSetIFace rs = (RecordSetIFace)cmdAction.getSrcObj();
            for (DataEntryView dev : list) {
                if (dev.getTableInfo().getTableId() != rs.getDbTableId().intValue()) continue;
                this.editData(this, rs, dev.getView());
                return true;
            }
        }
        return false;
    }

    protected void processRecordSetCommand(CommandAction cmdAction) {
        FormPane formPane;
        if (!this.processRecordSetCommand(cmdAction, this.stdViews) && !this.processRecordSetCommand(cmdAction, this.miscViews) && cmdAction.getDstObj() instanceof RecordSetIFace && (formPane = DataEntryTask.createFormFor(this, "", null, null, (RecordSetIFace)cmdAction.getDstObj())) != null) {
            this.addSubPaneToMgr(formPane);
        }
    }

    @Override
    protected void doProcessAppCommands(CommandAction cmdAction) {
        super.doProcessAppCommands(cmdAction);
        if (cmdAction.isAction("AppRestart") || cmdAction.isAction("StartUp")) {
            this.unregisterServices(this.stdViews, this.miscViews);
            this.viewsNavBox.clear();
            this.initializeViewsNavBoxFromXML();
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        super.doCommand(cmdAction);
        if (cmdAction.isType(DATA_ENTRY)) {
            this.processDataEntryCommands(cmdAction);
        } else if (cmdAction.isType("Record_Set") && cmdAction.isAction("Clicked")) {
            this.processRecordSetCommand(cmdAction);
        } else if (cmdAction.isType(DATA) && cmdAction.isAction("NewObjDataCreated")) {
            this.adjustNewDataObject(cmdAction.getData());
        } else if (cmdAction.isType("Preferences")) {
            this.prefsChanged((AppPreferences)cmdAction.getData());
        }
    }

    @Override
    protected boolean canRequestContext() {
        return Uploader.checkUploadLock(this) == 0;
    }

    protected static void config(XStream xstream) {
        DataEntryXML.config(xstream);
        DataEntryView.config(xstream);
    }

    public DroppableFormRecordSetAccepter createDroppableFormRecordSetAccepter(String nameArg, Taskable task, String desc) {
        return new DroppableFormRecordSetAccepter(nameArg, task, desc);
    }

    public class DroppableFormRecordSetAccepter
    extends FormPane {
        protected ImageIcon bgImg;

        public DroppableFormRecordSetAccepter(String name, Taskable task, String desc) {
            super(name, task, desc);
            this.bgImg = IconManager.getIcon("SpecifySplash");
            this.dropFlavors.add(RecordSetTask.RECORDSET_FLAVOR);
            this.createMouseInputAdapter();
            this.icon = IconManager.getIcon(DataEntryTask.DATA_ENTRY, IconManager.IconSize.Std16);
            this.setBackground(Color.WHITE);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.bgImg != null) {
                Dimension size = this.getSize();
                int imgW = Math.min(size.width, this.bgImg.getIconWidth());
                int imgH = Math.min(size.height, this.bgImg.getIconHeight());
                int x = (size.width - imgW) / 2;
                int y = (size.height - imgH) / 2;
                g.drawImage(this.bgImg.getImage(), x, y, imgW, imgH, null);
            }
        }

        public void addDropFlavor(DataFlavor df) {
            this.dropFlavors.add(df);
        }

        public void resetSplashIcon() {
            this.bgImg = IconManager.getIcon("SpecifySplash");
            this.repaint();
        }

        @Override
        public void doAction(GhostActionable src) {
            FormPane formPane;
            Object srcData = src.getData();
            if (srcData instanceof RecordSetIFace && (formPane = DataEntryTask.createFormFor(this.task, "XXXX", null, null, (RecordSetIFace)srcData)) != null) {
                DataEntryTask.this.addSubPaneToMgr(formPane);
            }
        }

        @Override
        public void doCommand(CommandAction cmdAction) {
        }
    }
}

