/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.tasks.DataEntryView;
import edu.ku.brc.specify.tasks.InteractionsTask;
import edu.ku.brc.specify.tasks.TaskConfigItemIFace;
import edu.ku.brc.specify.tasks.TaskConfigureDlg;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Frame;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import org.apache.commons.lang.StringUtils;

public class DataEntryConfigDlg
extends TaskConfigureDlg {
    public DataEntryConfigDlg(Vector<TaskConfigItemIFace> stdList, Vector<TaskConfigItemIFace> miscList, boolean includeAddPanels, String helpContext, String titleKey, String stdTitle, String miscTitle, String mvRightTTKey, String mvLeftTTKey) {
        super(stdList, miscList, includeAddPanels, helpContext, titleKey, stdTitle, miscTitle, mvRightTTKey, mvLeftTTKey);
    }

    @Override
    protected void addItem(JList list, Vector<TaskConfigItemIFace> itemList) {
        DataEntryView dev;
        Hashtable<String, Comparable<TaskConfigItemIFace>> hash = new Hashtable<String, Comparable<TaskConfigItemIFace>>();
        ListModel model = this.stdPanel.getOrderModel();
        int i = 0;
        while (i < model.getSize()) {
            dev = (DataEntryView)model.getElementAt(i);
            hash.put(dev.getView(), dev);
            ++i;
        }
        model = this.miscPanel.getOrderModel();
        i = 0;
        while (i < model.getSize()) {
            dev = (DataEntryView)model.getElementAt(i);
            hash.put(dev.getView(), dev);
            ++i;
        }
        Vector<String> uniqueList = new Vector<String>();
        List<ViewIFace> views = ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getAllViews();
        Hashtable<String, ViewIFace> newAvailViews = new Hashtable<String, ViewIFace>();
        for (ViewIFace view : views) {
            if (hash.get(view.getName()) != null) continue;
            DBTableInfo ti = DBTableIdMgr.getInstance().getByClassName(view.getClassName());
            if (ti != null) {
                String title;
                if (ti.isHidden() || InteractionsTask.isInteractionTable(ti.getTableId())) continue;
                hash.put(view.getName(), view);
                String string = StringUtils.isNotEmpty((String)view.getObjTitle()) ? view.getObjTitle() : (title = ti != null ? ti.getTitle() : view.getName());
                if (newAvailViews.get(title) != null) {
                    title = view.getName();
                }
                uniqueList.add(title);
                newAvailViews.put(title, view);
                continue;
            }
            System.err.println("DBTableInfo was null for class[" + view.getClassName() + "]");
        }
        if (uniqueList.size() == 0) {
            JOptionPane.showMessageDialog(this, UIRegistry.getResourceString("DET_DEV_NONE_AVAIL"), UIRegistry.getResourceString("DET_DEV_NONE_AVAIL_TITLE"), 1);
            return;
        }
        Collections.sort(uniqueList);
        ToggleButtonChooserDlg dlg = new ToggleButtonChooserDlg((Frame)UIRegistry.getTopWindow(), "DET_AVAIL_VIEWS", uniqueList);
        dlg.setUseScrollPane(true);
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled()) {
            model = list.getModel();
            for (String title : dlg.getSelectedObjects()) {
                ViewIFace view = (ViewIFace)newAvailViews.get(title);
                DBTableInfo ti = DBTableIdMgr.getInstance().getByClassName(view.getClassName());
                String frmTitle = StringUtils.isNotEmpty((String)view.getObjTitle()) ? view.getObjTitle() : (ti != null ? ti.getTitle() : view.getName());
                DataEntryView dev2 = new DataEntryView(frmTitle, view.getName(), ti != null ? ti.getName() : null, view.getObjTitle(), model.getSize(), true);
                dev2.setTableInfo(ti);
                ((DefaultListModel)model).addElement(dev2);
                itemList.add(dev2);
            }
        }
        this.setHasChanged(true);
    }
}

