/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.BasicPermisionPanel;
import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.MenuItemDesc;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionRelType;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.StartUpTask;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.EditDeleteAddPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CollectionRelTask
extends BaseTask {
    private static final String COLRELTSK = "COLRELTSK";
    private static final String CR_RELTYPES = "CR_RELTYPES";
    private static final String COLREL_MENU = "COLREL_MENU";
    private static final String COLREL_MNU = "COLREL_MNU";
    private static final String COLREL_TITLE = "COLREL_TITLE";
    private static final String COLREL_SECURITY = "COLRELEDIT";
    private JList relList;
    private EditDeleteAddPanel edaPanel;
    private Vector<Collection> colObjVec;
    private Vector<CollectionRelType> relObjVec;
    private Collection srcCollection = null;
    private Collection dstCollection = null;

    public CollectionRelTask() {
        super(COLRELTSK, UIRegistry.getResourceString(COLRELTSK));
        this.iconName = "SystemSetup";
        CommandDispatcher.register(COLRELTSK, this);
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
        }
        this.isShowDefault = true;
    }

    public static List<?> getList(Class<?> clsObj) {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            List<?> list = session.getDataList("FROM " + clsObj.getSimpleName());
            for (Object dataObj : list) {
                if (!(dataObj instanceof FormDataObjIFace)) continue;
                ((FormDataObjIFace)dataObj).forceLoad();
            }
            List<?> list2 = list;
            return list2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return new ArrayList();
    }

    private DefaultListModel fillLDM(Vector<?> list) {
        DefaultListModel model = new DefaultListModel();
        for (Object item : list) {
            model.addElement(item);
        }
        return model;
    }

    private void showSourceList() {
        this.srcCollection = null;
        ChooseFromListDlg<Collection> dlg = new ChooseFromListDlg<Collection>((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString(COLREL_TITLE), UIRegistry.getResourceString("COLREL_CHS_SRC"), 7, this.colObjVec);
        dlg.setHelpContext("cr_configure");
        dlg.setOkLabel(UIRegistry.getResourceString("NEXT"));
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled()) {
            this.srcCollection = dlg.getSelectedObject();
            this.showDestinationList();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void showDestinationList() {
        Vector<Object> filteredList;
        boolean allowSelfRefColRel = AppPreferences.getLocalPrefs().getBoolean("SELF_COLREL", false);
        if (allowSelfRefColRel) {
            filteredList = new Vector<Collection>(this.colObjVec);
        } else {
            filteredList = new Vector();
            for (Collection col : this.colObjVec) {
                if (!col.getCatalogNumFormatName().equals(this.srcCollection.getCatalogNumFormatName()) || col.getId().equals(this.srcCollection.getId())) continue;
                filteredList.add(col);
            }
        }
        if (filteredList.size() == 1) {
            this.dstCollection = (Collection)filteredList.get(0);
        } else if (filteredList.size() > 1) {
            ChooseFromListDlg<Object> dlg = new ChooseFromListDlg<Object>((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString(COLREL_TITLE), UIRegistry.getResourceString("COLREL_CHS_DST"), 7, filteredList);
            dlg.setHelpContext("cr_configure");
            dlg.setOkLabel(UIRegistry.getResourceString("NEXT"));
            UIHelper.centerAndShow(dlg);
            if (dlg.isCancelled()) return;
            this.dstCollection = (Collection)dlg.getSelectedObject();
        } else {
            UIRegistry.showLocalizedError("COLREL_NO_COL");
            return;
        }
        this.addRel();
    }

    private void createRelMgrUI() {
        this.colObjVec = new Vector(CollectionRelTask.getList(Collection.class));
        this.relObjVec = new Vector(CollectionRelTask.getList(CollectionRelType.class));
        this.relList = new JList(this.fillLDM(this.relObjVec));
        ActionListener editAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionRelTask.this.editRel();
            }
        };
        ActionListener addAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionRelTask.this.showSourceList();
            }
        };
        ActionListener delAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionRelTask.this.delRel();
            }
        };
        this.relList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CollectionRelTask.this.editRel();
                }
            }
        });
        this.edaPanel = new EditDeleteAddPanel(editAL, delAL, addAL);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:MAX(300px;p):g", "p,2px,f:p:g,2px,p"));
        pb.add((Component)UIHelper.createI18NLabel("CR_REL", 0), cc.xy(1, 1));
        pb.add((Component)UIHelper.createScrollPane(this.relList), cc.xy(1, 3));
        pb.add((Component)this.edaPanel, cc.xy(1, 5));
        pb.setDefaultDialogBorder();
        this.edaPanel.getAddBtn().setEnabled(true);
        ListSelectionListener relLSL = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CollectionRelTask.this.updateBtnUI();
                }
            }
        };
        this.relList.addListSelectionListener(relLSL);
        CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString(COLREL_TITLE), true, 1, (Component)pb.getPanel());
        dlg.setOkLabel(UIRegistry.getResourceString("CLOSE"));
        dlg.setVisible(true);
    }

    private void editRel() {
        CollectionRelType crt = (CollectionRelType)this.relList.getSelectedValue();
        if (crt != null) {
            this.createRelType(crt);
        }
    }

    private void addRel() {
        this.createRelType(null);
    }

    private void delRel() {
        CollectionRelType collectionRel = (CollectionRelType)this.relList.getSelectedValue();
        if (collectionRel != null) {
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    CollectionRelType colRelTyp = session.get(CollectionRelType.class, collectionRel.getId());
                    String key = null;
                    if (colRelTyp != null) {
                        int cnt = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM collectionrelationship WHERE CollectionRelTypeID = " + collectionRel.getId());
                        if (cnt == 0) {
                            Collection rRelCol = colRelTyp.getRightSideCollection();
                            Collection lRelCol = colRelTyp.getLeftSideCollection();
                            Discipline leftDisp = lRelCol.getDiscipline();
                            TaxonTreeDef leftTaxonTreeDef = leftDisp.getTaxonTreeDef();
                            String sql = String.format("SELECT COUNT(*) FROM collectingeventattribute cea INNER JOIN taxon t ON cea.HostTaxonID = t.TaxonID WHERE cea.DisciplineID = %d AND t.TaxonTreeDefID = %d", rRelCol.getDiscipline().getId(), leftTaxonTreeDef.getId());
                            cnt = BasicSQLUtils.getCountAsInt(sql);
                            if (cnt > 0) {
                                key = "COLREL_USEDBY_HST";
                            }
                        } else {
                            key = "COLREL_USEDBY_CR";
                        }
                        if (key != null) {
                            UIRegistry.showLocalizedError(key);
                        } else if (BasicSQLUtils.update("DELETE FROM collectionreltype WHERE CollectionRelTypeID = " + colRelTyp.getId()) == 1) {
                            DefaultListModel model = (DefaultListModel)this.relList.getModel();
                            model.remove(this.relList.getSelectedIndex());
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    private boolean save(FormDataObjIFace dataObj) {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            session.beginTransaction();
            session.saveOrUpdate(dataObj);
            session.commit();
            return true;
        }
        catch (Exception ex) {
            if (session != null) {
                session.rollback();
            }
            ex.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return false;
    }

    private CollectionRelType createRelType(final CollectionRelType crt) {
        CollectionRelType colRelType;
        boolean isEdit = crt != null;
        ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Dialog)UIRegistry.getMostRecentWindow(), "SystemSetup", "CollectionRelType", null, UIRegistry.getResourceString(COLREL_TITLE), UIRegistry.getResourceString("OK"), null, null, true, 792);
        dlg.setFormAdjuster(new FormPane.FormPaneAdjusterIFace(){

            @Override
            public void adjustForm(FormViewObj fvo) {
                Collection rightCol;
                JLabel leftLbl = fvo.getLabelById("left");
                JLabel rightLbl = fvo.getLabelById("right");
                Collection leftCol = crt != null ? crt.getLeftSideCollection() : CollectionRelTask.this.srcCollection;
                Collection collection = rightCol = crt != null ? crt.getRightSideCollection() : CollectionRelTask.this.dstCollection;
                if (leftCol != null) {
                    leftLbl.setText(leftCol.getCollectionName());
                }
                if (rightCol != null) {
                    rightLbl.setText(rightCol.getCollectionName());
                }
                Font bold = leftLbl.getFont().deriveFont(1).deriveFont(leftLbl.getFont().getSize2D() + 2.0f);
                leftLbl.setFont(bold);
                rightLbl.setFont(bold);
            }
        });
        if (isEdit) {
            colRelType = crt;
        } else {
            colRelType = new CollectionRelType();
            colRelType.initialize();
        }
        dlg.setHelpContext("cr_name");
        dlg.setData(colRelType);
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled()) {
            if (!isEdit) {
                if (this.srcCollection != null && this.dstCollection != null) {
                    try {
                        block20: {
                            DataProviderSessionIFace session = null;
                            try {
                                try {
                                    session = DataProviderFactory.getInstance().createSession();
                                    this.srcCollection = session.get(Collection.class, this.srcCollection.getId());
                                    this.dstCollection = session.get(Collection.class, this.dstCollection.getId());
                                    colRelType.setLeftSideCollection(this.srcCollection);
                                    colRelType.setRightSideCollection(this.dstCollection);
                                    this.srcCollection.getLeftSideRelTypes().add(colRelType);
                                    this.dstCollection.getRightSideRelTypes().add(colRelType);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    if (session != null) {
                                        session.close();
                                    }
                                    break block20;
                                }
                            }
                            catch (Throwable throwable) {
                                if (session != null) {
                                    session.close();
                                }
                                throw throwable;
                            }
                            if (session != null) {
                                session.close();
                            }
                        }
                        if (this.save(colRelType)) {
                            ((DefaultListModel)this.relList.getModel()).addElement(colRelType);
                            return colRelType;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (this.save(colRelType)) {
                    return colRelType;
                }
            } else if (this.save(colRelType)) {
                return colRelType;
            }
        }
        return colRelType;
    }

    private void updateBtnUI() {
        boolean isSelected = !this.relList.isSelectionEmpty();
        this.edaPanel.getEditBtn().setEnabled(isSelected);
        this.edaPanel.getDelBtn().setEnabled(isSelected);
    }

    @Override
    public PermissionEditorIFace getPermEditorPanel() {
        return new BasicPermisionPanel(null, "ENABLE");
    }

    @Override
    protected boolean[][] getPermsArray() {
        boolean[][] blArrayArray = new boolean[4][];
        blArrayArray[0] = new boolean[]{true, true, true, true};
        blArrayArray[1] = new boolean[]{true, true, true, true};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArray[3] = true;
        blArrayArray[2] = blArray;
        blArrayArray[3] = new boolean[]{true, true, true, true};
        return blArrayArray;
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        this.toolbarItems = new Vector();
        return this.toolbarItems;
    }

    @Override
    public List<MenuItemDesc> getMenuItems() {
        String SYSTEM_MENU = "Specify.SYSTEM_MENU";
        SecurityMgr secMgr = SecurityMgr.getInstance();
        this.menuItems = new Vector();
        String securityName = "Task.COLRELEDIT";
        if (!AppContextMgr.isSecurityOn() || secMgr.getPermission(securityName) != null && !secMgr.getPermission(securityName).hasNoPerm()) {
            JMenuItem mi = UIHelper.createLocalizedMenuItem(COLREL_MENU, COLREL_MNU, COLREL_TITLE, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CollectionRelTask.this.createRelMgrUI();
                }
            });
            MenuItemDesc mid = new MenuItemDesc(mi, "Specify.SYSTEM_MENU");
            mid.setPosition(MenuItemDesc.Position.Bottom);
            this.menuItems.add(mid);
        }
        return this.menuItems;
    }

    @Override
    public SubPaneIFace getStarterPane() {
        this.starterPane = StartUpTask.createFullImageSplashPanel(this.title, this);
        return this.starterPane;
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        super.doCommand(cmdAction);
        if (cmdAction.isType(COLRELTSK)) {
            if (cmdAction.isAction(CR_RELTYPES)) {
                this.createRelMgrUI();
            }
        } else {
            cmdAction.isType("Record_Set");
        }
    }
}

