/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.MenuItemDesc;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxIFace;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.tasks.subpane.SimpleDescPane;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgr;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.StartUpTask;
import edu.ku.brc.specify.tasks.TreeTaskMgr;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.Uploader;
import edu.ku.brc.specify.ui.treetables.TreeBrowserPanel;
import edu.ku.brc.specify.ui.treetables.TreeDefinitionEditor;
import edu.ku.brc.specify.ui.treetables.TreeTableViewer;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.ToolBarDropDownBtn;
import edu.ku.brc.ui.UIRegistry;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.log4j.Logger;

public abstract class BaseTreeTask<T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>>
extends BaseTask
implements Comparable<BaseTreeTask<?, ?, ?>> {
    protected static final Logger log = Logger.getLogger(BaseTreeTask.class);
    protected static DataFlavor TREE_DEF_FLAVOR = new DataFlavor(TreeDefIface.class, TreeDefIface.class.getName());
    public static final String OPEN_TREE = "OpenTree";
    public static final String EDIT_TREE_DEF = "EditTreeDef";
    protected static Vector<ToolBarItemDesc> treeToolBarItems = null;
    protected NavBox treeNavBox = null;
    protected NavBox treeDefNavBox = null;
    protected NavBox unlockNavBox = null;
    protected NavBox browseNavBox = null;
    protected Vector<NavBoxIFace> extendedNavBoxes = new Vector();
    protected Class<D> treeDefClass;
    protected Class<T> treeClass;
    protected D currentDef;
    protected boolean currentDefInUse;
    protected boolean isOpeningTree = false;
    protected SubPaneIFace visibleSubPane;
    protected String commandTypeString;
    protected BusinessRulesIFace businessRules = null;
    protected Action treeEditAction = null;
    protected Action treeDefEditAction = null;
    protected Action unlockAction = null;
    protected Action browseAction = null;
    protected static SubPaneIFace starterPaneTree = null;

    protected BaseTreeTask(String name, String title) {
        super(name, title);
        CommandDispatcher.register("Data_Entry", this);
        this.setIconName("TreePref");
        TreeTaskMgr.getInstance().add(this);
    }

    @Override
    public synchronized void initialize() {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.currentDef = this.getCurrentTreeDef();
            this.menuItems = this.createMenus();
            if (this.commandTypeString != null) {
                CommandDispatcher.register(this.commandTypeString, this);
            }
            this.treeNavBox = new NavBox(UIRegistry.getResourceString("BaseTreeTask.EditTrees"));
            this.treeDefNavBox = new NavBox(UIRegistry.getResourceString("BaseTreeTask.TreeDefs"));
            this.unlockNavBox = new NavBox(UIRegistry.getResourceString("BaseTreeTask.UNLOCK"));
            this.browseNavBox = new NavBox(UIRegistry.getResourceString("BaseTreeTask.BROWSE"));
            this.navBoxes.add(this.browseNavBox);
            this.navBoxes.add(this.treeNavBox);
            this.navBoxes.add(this.treeDefNavBox);
            this.navBoxes.add(this.unlockNavBox);
            DBTableInfo treeTI = DBTableIdMgr.getInstance().getByClassName(this.getTreeClass().getName());
            DBTableInfo tdTI = DBTableIdMgr.getInstance().getByClassName(this.getTreeDefClass().getName());
            PermissionSettings treePerms = treeTI.getPermissions();
            PermissionSettings tdPerms = tdTI.getPermissions();
            if (AppContextMgr.isSecurityOn()) {
                if (treePerms.canView()) {
                    this.browseAction = this.createActionForTreeEditing(treeTI.getTitle(), false);
                    if (treePerms.canModify()) {
                        this.treeEditAction = this.createActionForTreeEditing(treeTI.getTitle(), treePerms.canModify());
                    }
                }
                if (tdPerms.canView() && tdPerms.canModify()) {
                    this.treeDefEditAction = this.createActionForTreeDefEditing(treeTI.getTitle());
                    this.unlockAction = this.createActionForTreeUnlocking(treeTI.getTitle(), true);
                    this.browseAction = this.createActionForTreeEditing(treeTI.getTitle(), false);
                }
            } else {
                this.treeEditAction = this.createActionForTreeEditing(treeTI.getTitle(), true);
                this.treeDefEditAction = this.createActionForTreeDefEditing(treeTI.getTitle());
                this.unlockAction = this.createActionForTreeUnlocking(treeTI.getTitle(), true);
                this.browseAction = this.createActionForTreeEditing(treeTI.getTitle(), false);
            }
        }
        this.isShowDefault = true;
    }

    @Override
    public List<NavBoxIFace> getNavBoxes() {
        this.extendedNavBoxes.clear();
        this.extendedNavBoxes.addAll(this.navBoxes);
        return this.extendedNavBoxes;
    }

    protected void loadTreeNavBoxes() {
        this.treeNavBox.clear();
        this.treeDefNavBox.clear();
        this.unlockNavBox.clear();
        this.browseNavBox.clear();
        boolean skip = AppContextMgr.isSecurityOn() && !DBTableIdMgr.getInstance().getByShortClassName(this.treeClass.getSimpleName()).getPermissions().canView();
        TreeTaskMgr.getInstance().fillNavBoxes(this.treeNavBox, this.treeDefNavBox, this.unlockNavBox, this.browseNavBox);
        if (!skip) {
            for (NavBoxItemIFace nbi : this.treeNavBox.getItems()) {
                ((RolloverCommand)nbi.getUIComponent()).addDropDataFlavor(null);
            }
        }
        this.browseNavBox.setVisible(this.browseNavBox.getComponentCount() > 0);
        this.treeNavBox.setVisible(this.treeNavBox.getComponentCount() > 0);
        this.treeDefNavBox.setVisible(this.treeDefNavBox.getComponentCount() > 0);
        this.unlockNavBox.setVisible(this.unlockNavBox.getComponentCount() > 0);
        TreeTaskMgr.checkLocks();
    }

    public Action getTreeEditAction() {
        return this.treeEditAction;
    }

    public Action getTreeDefEditAction() {
        return this.treeDefEditAction;
    }

    public Action getTreeUnlockAction() {
        return this.unlockAction;
    }

    public Action getTreeBrowseAction() {
        return this.browseAction;
    }

    public Class<D> getTreeDefClass() {
        return this.treeDefClass;
    }

    public Class<T> getTreeClass() {
        return this.treeClass;
    }

    protected abstract D getCurrentTreeDef();

    protected void openTreeViewerInBGThread(final String titleArg, boolean isEditModeArg) {
        if (!this.isOpeningTree) {
            boolean isViewMode;
            PermissionSettings perms = DBTableIdMgr.getInstance().getByShortClassName(this.treeClass.getSimpleName()).getPermissions();
            boolean isViewOnly = perms != null && perms.isViewOnly();
            boolean isViewable = perms == null || perms.canView();
            final boolean isEditable = perms == null || perms.canModify();
            TaskSemaphoreMgr.USER_ACTION action = isViewOnly || !isEditModeArg ? TaskSemaphoreMgr.USER_ACTION.ViewMode : TaskSemaphoreMgr.lock(titleArg, this.treeDefClass.getSimpleName(), "def", TaskSemaphoreMgr.SCOPE.Discipline, true, null, true);
            boolean bl = isViewMode = action == TaskSemaphoreMgr.USER_ACTION.ViewMode;
            if (isViewable && (action == TaskSemaphoreMgr.USER_ACTION.ViewMode || action == TaskSemaphoreMgr.USER_ACTION.OK) || isEditable && (action == TaskSemaphoreMgr.USER_ACTION.OK || action == TaskSemaphoreMgr.USER_ACTION.ViewMode)) {
                this.isOpeningTree = true;
                SwingWorker bgWorker = new SwingWorker(){
                    private TreeTableViewer<T, D, I> treeViewer;

                    @Override
                    public Object construct() {
                        UsageTracker.incrUsageCount("TR.OPEN." + BaseTreeTask.this.treeDefClass.getSimpleName());
                        this.treeViewer = BaseTreeTask.this.createTreeViewer(titleArg, !isViewMode && isEditable);
                        if (isViewMode) {
                            this.treeViewer.setDoUnlock(false);
                        }
                        return this.treeViewer;
                    }

                    @Override
                    public void finished() {
                        super.finished();
                        ContextMgr.requestContext(BaseTreeTask.this);
                        BaseTreeTask.this.currentDefInUse = true;
                        BaseTreeTask.this.visibleSubPane = this.treeViewer;
                        BaseTreeTask.this.addSubPaneToMgr(this.treeViewer);
                        BaseTreeTask.this.isOpeningTree = false;
                        TreeTaskMgr.checkLocks();
                    }
                };
                bgWorker.start();
            }
        }
    }

    protected Action createActionForTreeUnlocking(final String titleArg, boolean isEditMode) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String lockName = BaseTreeTask.this.treeDefClass.getSimpleName();
                String formLockName = String.valueOf(lockName) + "Form";
                UsageTracker.incrUsageCount("TD.UNLOCK." + BaseTreeTask.this.treeDefClass.getSimpleName());
                boolean okToUnlock = TaskSemaphoreMgr.askUserToUnlock(titleArg, lockName, TaskSemaphoreMgr.SCOPE.Discipline);
                if (okToUnlock) {
                    if (TaskSemaphoreMgr.isLocked(titleArg, formLockName, TaskSemaphoreMgr.SCOPE.Discipline)) {
                        TaskSemaphoreMgr.unlock(titleArg, formLockName, TaskSemaphoreMgr.SCOPE.Discipline);
                    } else {
                        log.warn((Object)(String.valueOf(titleArg) + " form was not locked."));
                    }
                    if (TaskSemaphoreMgr.isLockedOrInUse(titleArg, lockName, TaskSemaphoreMgr.SCOPE.Discipline)) {
                        TaskSemaphoreMgr.unlock(titleArg, lockName, TaskSemaphoreMgr.SCOPE.Discipline);
                    } else {
                        log.warn((Object)(String.valueOf(titleArg) + " was not locked."));
                    }
                    TreeTaskMgr.checkLocks();
                }
            }
        };
    }

    protected Action createActionForTreeBrowse(final String titleArg) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tableName = BaseTreeTask.this.treeClass.getSimpleName().toLowerCase();
                String clsName = BaseTreeTask.this.treeClass.getSimpleName();
                String sql = String.format("SELECT %sID FROM %s WHERE RankID = 0 AND %sID = %d ", clsName, tableName, BaseTreeTask.this.currentDef.getClass().getSimpleName(), BaseTreeTask.this.currentDef.getTreeDefId());
                Integer rootId = BasicSQLUtils.getCount(sql);
                if (rootId != null) {
                    TreeBrowserPanel browsePanel = new TreeBrowserPanel(tableName, BaseTreeTask.this.treeClass, BaseTreeTask.this.currentDef.getTreeDefId(), rootId);
                    SubPaneMgr.getInstance().addPane(new SimpleDescPane(titleArg, (Taskable)BaseTreeTask.this, browsePanel));
                }
            }
        };
    }

    protected Action createActionForTreeEditing(final String titleArg, final boolean isEditMode) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!BaseTreeTask.this.currentDefInUse) {
                    if (BaseTreeTask.this.visibleSubPane == null || BaseTreeTask.this.visibleSubPane instanceof TreeTableViewer) {
                        BaseTreeTask.this.openTreeViewerInBGThread(titleArg, isEditMode);
                    } else {
                        BaseTreeTask.this.switchViewType(isEditMode, true);
                    }
                } else {
                    if (BaseTreeTask.this.visibleSubPane instanceof TreeTableViewer) {
                        TreeTableViewer treeViewer = (TreeTableViewer)BaseTreeTask.this.visibleSubPane;
                        if (treeViewer.isEditMode() == isEditMode) {
                            SubPaneMgr.getInstance().showPane(BaseTreeTask.this.visibleSubPane);
                        } else {
                            BaseTreeTask.this.switchViewType(isEditMode, true);
                        }
                    } else {
                        BaseTreeTask.this.switchViewType(isEditMode, true);
                    }
                    TreeTaskMgr.checkLocks();
                }
            }
        };
    }

    private Action createActionForTreeDefEditing(final String titleArg) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BaseTreeTask.this.currentDefInUse) {
                    TaskSemaphoreMgr.USER_ACTION action = TaskSemaphoreMgr.lock(titleArg, BaseTreeTask.this.treeDefClass.getSimpleName(), "def", TaskSemaphoreMgr.SCOPE.Discipline, false, null, true);
                    if (action == TaskSemaphoreMgr.USER_ACTION.OK) {
                        SwingWorker bgWorker = new SwingWorker(){
                            private TreeDefinitionEditor<T, D, I> defEditor;

                            @Override
                            public Object construct() {
                                UsageTracker.incrUsageCount("TD.OPEN." + (this).BaseTreeTask.this.treeDefClass.getSimpleName());
                                this.defEditor = BaseTreeTask.this.createDefEditor(titleArg);
                                return this.defEditor;
                            }

                            @Override
                            public void finished() {
                                super.finished();
                                ContextMgr.requestContext(BaseTreeTask.this);
                                (this).BaseTreeTask.this.currentDefInUse = true;
                                (this).BaseTreeTask.this.visibleSubPane = this.defEditor;
                                BaseTreeTask.this.addSubPaneToMgr(this.defEditor);
                                TreeTaskMgr.checkLocks();
                            }
                        };
                        bgWorker.start();
                    }
                } else if (BaseTreeTask.this.visibleSubPane instanceof TreeDefinitionEditor) {
                    SubPaneMgr.getInstance().showPane(BaseTreeTask.this.visibleSubPane);
                } else {
                    BaseTreeTask.this.switchViewType(false, false);
                }
            }
        };
    }

    public boolean isTreeOnByDefault() {
        return true;
    }

    protected Vector<MenuItemDesc> createMenus() {
        Vector<MenuItemDesc> menus = new Vector<MenuItemDesc>();
        return menus;
    }

    protected TreeTableViewer<T, D, I> createTreeViewer(String titleArg, boolean isEditMode) {
        DataProviderSessionIFace session = null;
        try {
            TreeTableViewer ttv;
            session = DataProviderFactory.getInstance().createSession();
            TreeDefIface treeDef = (TreeDefIface)session.load(this.currentDef.getClass(), this.currentDef.getTreeDefId());
            TreeTableViewer treeTableViewer = ttv = new TreeTableViewer(treeDef, titleArg, this, isEditMode);
            return treeTableViewer;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(BaseTreeTask.class, ex);
            ex.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    public TreeDefinitionEditor<T, D, I> openTreeDefEditor(D treeDef) {
        ContextMgr.requestContext(this);
        String tabName = String.valueOf(UIRegistry.getResourceString("TreeDefEditor")) + ": " + treeDef.getName();
        TreeDefinitionEditor defEditor = new TreeDefinitionEditor(treeDef, tabName, this, true);
        this.addSubPaneToMgr(defEditor);
        return defEditor;
    }

    protected TreeDefinitionEditor<T, D, I> createDefEditor(String titleArg) {
        DataProviderSessionIFace session = null;
        try {
            TreeDefinitionEditor defEditor;
            boolean canEditTreeDef = true;
            session = DataProviderFactory.getInstance().createSession();
            TreeDefIface treeDef = (TreeDefIface)session.load(this.currentDef.getClass(), this.currentDef.getTreeDefId());
            TreeDefinitionEditor treeDefinitionEditor = defEditor = new TreeDefinitionEditor(treeDef, titleArg, this, canEditTreeDef);
            return treeDefinitionEditor;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(BaseTreeTask.class, ex);
            ex.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    protected void switchViewType(final boolean isEditMode, final boolean switchMode) {
        if (!this.isOpeningTree) {
            this.isOpeningTree = true;
            SwingWorker bgWorker = new SwingWorker(){
                private SubPaneIFace oldPane = null;

                @Override
                public Object construct() {
                    String tabTitle = UIRegistry.getResourceString(BaseTreeTask.this.name);
                    if (BaseTreeTask.this.visibleSubPane instanceof TreeTableViewer && !switchMode) {
                        String lockName;
                        String formLockName;
                        DBTableInfo treeTI = DBTableIdMgr.getInstance().getByClassName(BaseTreeTask.this.getTreeClass().getName());
                        String trTitle = treeTI.getTitle();
                        if (!TaskSemaphoreMgr.isLockedOrInUse(trTitle, formLockName = String.valueOf(lockName = BaseTreeTask.this.treeDefClass.getSimpleName()) + "Form", TaskSemaphoreMgr.SCOPE.Discipline)) {
                            ((TreeTableViewer)BaseTreeTask.this.visibleSubPane).setDoUnlock(false);
                            TreeDefinitionEditor defEditor = BaseTreeTask.this.createDefEditor(tabTitle);
                            this.oldPane = BaseTreeTask.this.visibleSubPane;
                            BaseTreeTask.this.currentDefInUse = true;
                            BaseTreeTask.this.visibleSubPane = defEditor;
                        } else {
                            UIRegistry.showLocalizedError("BaseTreeTask.NO_EDT_TRDEF", treeTI.getTitle());
                        }
                    } else if (BaseTreeTask.this.visibleSubPane instanceof TreeDefinitionEditor && switchMode) {
                        ((TreeDefinitionEditor)BaseTreeTask.this.visibleSubPane).setDoUnlock(false);
                        TreeTableViewer treeViewer = BaseTreeTask.this.createTreeViewer(tabTitle, isEditMode);
                        this.oldPane = BaseTreeTask.this.visibleSubPane;
                        BaseTreeTask.this.currentDefInUse = true;
                        BaseTreeTask.this.visibleSubPane = treeViewer;
                    }
                    return BaseTreeTask.this.visibleSubPane;
                }

                @Override
                public void finished() {
                    super.finished();
                    if (this.oldPane != null) {
                        SubPaneMgr.getInstance().replacePane(this.oldPane, BaseTreeTask.this.visibleSubPane);
                    }
                    BaseTreeTask.this.isOpeningTree = false;
                }
            };
            bgWorker.start();
        }
    }

    @Override
    public List<MenuItemDesc> getMenuItems() {
        return this.menuItems;
    }

    @Override
    public SubPaneIFace getStarterPane() {
        if (starterPaneTree == null) {
            starterPaneTree = StartUpTask.createFullImageSplashPanel(UIRegistry.getResourceString("BaseTreeTask.Trees"), this);
        }
        return starterPaneTree;
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        if (treeToolBarItems == null) {
            treeToolBarItems = new Vector();
            String label = UIRegistry.getResourceString("BaseTreeTask.Trees");
            String hint = UIRegistry.getResourceString("tree_hint");
            ToolBarDropDownBtn btn = this.createToolbarButton(label, this.iconName, hint);
            treeToolBarItems.add(new ToolBarItemDesc(btn));
        }
        this.toolbarItems = treeToolBarItems;
        return this.toolbarItems;
    }

    public Class<? extends BaseTreeTask> getTaskClass() {
        return this.getClass();
    }

    @Override
    public void subPaneRemoved(SubPaneIFace subPane) {
        if (subPane.getTask().equals(this) && subPane == this.visibleSubPane) {
            this.currentDefInUse = false;
            this.visibleSubPane = null;
        }
    }

    @Override
    protected void doProcessAppCommands(CommandAction cmdAction) {
        super.doProcessAppCommands(cmdAction);
        this.currentDef = this.getCurrentTreeDef();
        if (cmdAction.isAction("AppRestart") || cmdAction.isAction("StartUp")) {
            this.loadTreeNavBoxes();
        }
    }

    protected void fillListWithIds(String sqlStr, Vector<Integer> list) {
        list.clear();
        String sql = QueryAdjusterForDomain.getInstance().adjustSQL(sqlStr);
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = DBConnection.getInstance().createConnection();
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    list.add(rs.getInt(1));
                }
                rs.close();
            }
            catch (SQLException ex) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(BaseTreeTask.class, ex);
                log.error((Object)("SQLException: " + ex.toString()));
                log.error((Object)ex.getMessage());
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ex2) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(BaseTreeTask.class, ex2);
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(BaseTreeTask.class, ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    protected boolean canRequestContext() {
        return Uploader.checkUploadLock(this) == 0;
    }

    @Override
    protected SubPaneIFace addSubPaneToMgr(SubPaneIFace subPane) {
        if (starterPaneTree != null) {
            SubPaneMgr.getInstance().replacePane(starterPaneTree, subPane);
            starterPaneTree = null;
        } else {
            SubPaneMgr.getInstance().addPane(subPane);
        }
        return subPane;
    }

    @Override
    public void setStarterPane(SubPaneIFace pane) {
        starterPaneTree = pane;
    }

    @Override
    public boolean isStarterPane() {
        return starterPaneTree != null;
    }

    @Override
    public boolean isPermissionsSettable() {
        return false;
    }

    @Override
    protected boolean[][] getPermsArray() {
        boolean[][] blArrayArray = new boolean[4][];
        blArrayArray[0] = new boolean[]{true, true, true, true};
        blArrayArray[1] = new boolean[]{true, true, true, true};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArrayArray[2] = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[0] = true;
        blArrayArray[3] = blArray2;
        return blArrayArray;
    }

    @Override
    public int compareTo(BaseTreeTask<?, ?, ?> obj) {
        if (this.getTreeClass() != null && obj.getTreeClass() != null) {
            DBTableInfo treeTI = DBTableIdMgr.getInstance().getByClassName(this.getTreeClass().getName());
            DBTableInfo treeTI2 = DBTableIdMgr.getInstance().getByClassName(obj.getTreeClass().getName());
            return treeTI.getTitle().compareTo(treeTI2.getTitle());
        }
        return 1;
    }
}

