/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.auth.SecurityOption;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.specify.datamodel.SpReport;
import edu.ku.brc.specify.tasks.InfoForTaskReport;
import edu.ku.brc.specify.tasks.PermissionOptionPersist;
import edu.ku.brc.specify.tasks.StartUpTask;
import edu.ku.brc.specify.tasks.subpane.qb.QueryBldrPane;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Hashtable;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public abstract class BaseTask
extends edu.ku.brc.af.tasks.BaseTask {
    protected static final Logger baseLog = Logger.getLogger(BaseTask.class);
    protected static SoftReference<Hashtable<String, PermissionOptionPersist>> taskPermsListSR = null;

    public BaseTask(String name, String title) {
        super(name, title);
    }

    public static Hashtable<String, Hashtable<String, PermissionOptionPersist>> readDefaultPermsFromXML(String fileName) {
        Hashtable hash = new Hashtable();
        XStream xstream = new XStream();
        PermissionOptionPersist.config(xstream);
        String xmlStr = null;
        try {
            File permFile = new File(XMLHelper.getConfigDirPath("defaultperms" + File.separator + fileName));
            if (permFile.exists()) {
                xmlStr = FileUtils.readFileToString((File)permFile);
            }
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(BaseTask.class, ex);
            ex.printStackTrace();
        }
        if (xmlStr != null) {
            hash = (Hashtable)xstream.fromXML(xmlStr);
        }
        return hash;
    }

    protected Hashtable<String, PermissionOptionPersist> getAndSetDefPerms() {
        Hashtable<String, Hashtable<String, PermissionOptionPersist>> taskHash;
        Hashtable<String, PermissionOptionPersist> hash;
        if (taskPermsListSR == null) {
            taskPermsListSR = new SoftReference<Object>(null);
        }
        if ((hash = taskPermsListSR.get()) == null && (taskHash = BaseTask.readDefaultPermsFromXML("tasks.xml")) != null && (hash = taskHash.get(this.name)) != null) {
            taskPermsListSR = new SoftReference<Hashtable<String, PermissionOptionPersist>>(hash);
        }
        return hash;
    }

    public boolean isTabsClosed() {
        Collection<SubPaneIFace> allSubPanes = SubPaneMgr.getInstance().getSubPanes();
        if (allSubPanes.size() > 0) {
            for (SubPaneIFace sp : allSubPanes) {
                if (sp.getTask().getClass() != StartUpTask.class) {
                    UIRegistry.displayInfoMsgDlgLocalized("BaseTask.PL_CLOSE_TABS", new Object[0]);
                    return false;
                }
                if (sp.getTask() == this) break;
            }
        }
        return true;
    }

    public boolean isAnyOtherUsersOn() {
        return !((SpecifyAppContextMgr)AppContextMgr.getInstance()).displayAgentsLoggedInDlg("SystemSetupTask.CFG_SETUP");
    }

    protected void dispatchReport(InfoForTaskReport reportInfo, RecordSetIFace rs, String titleKey) {
        if (reportInfo.getSpReport() != null) {
            SpReport spRep = reportInfo.getSpReport();
            QueryBldrPane.runReport(spRep, UIRegistry.getResourceString(titleKey), rs);
        } else {
            SpAppResource rep = reportInfo.getSpAppResource();
            CommandAction cmd = new CommandAction("Reports", "RPT.PrintReport", rs);
            cmd.getProperties().put("title", rep.getName());
            cmd.getProperties().put("file", rep.getFileName());
            cmd.getProperties().put("reporttype", "report");
            cmd.getProperties().put("name", rep.getName());
            CommandDispatcher.dispatch(cmd);
        }
    }

    @Override
    public PermissionIFace getDefaultPermissions(String userType) {
        Hashtable<String, PermissionOptionPersist> hash = this.getAndSetDefPerms();
        if (hash != null) {
            PermissionOptionPersist permOpt = hash.get(userType);
            if (permOpt != null) {
                return permOpt.getDefaultPerms();
            }
            baseLog.error((Object)("No permissions from hash for user type[" + userType + "]"));
        } else {
            baseLog.error((Object)"No hashtable from getAndSetDefPerms!");
        }
        return null;
    }

    @Override
    public abstract SubPaneIFace getStarterPane();

    protected void addPerms(SecurityOption secOpt, boolean[][] perms) {
        int i = 0;
        SpecifyUserTypes.UserType[] userTypeArray = SpecifyUserTypes.UserType.values();
        int n = userTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpecifyUserTypes.UserType userType = userTypeArray[n2];
            boolean[] p = perms[i++];
            secOpt.addDefaultPerm(userType.toString(), new PermissionSettings(p[0], p[1], p[2], p[3]));
            ++n2;
        }
    }
}

