/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.rstools;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.services.mapping.LatLonPlacemarkIFace;
import edu.ku.brc.specify.datamodel.WorkbenchDataItem;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.util.GeoRefConverter;
import edu.ku.brc.util.Pair;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringUtils;

public class WorkbenchRowPlacemarkWrapper
implements LatLonPlacemarkIFace {
    protected WorkbenchRow wbRow;
    protected String label;
    protected Hashtable<Short, WorkbenchTemplateMappingItem> mappings = null;
    protected Vector<WorkbenchDataItem> dataList = null;
    protected List<WorkbenchTemplateMappingItem> visibleColumns;
    protected Hashtable<WorkbenchTemplateMappingItem, Boolean> visibleMap = new Hashtable();

    public WorkbenchRowPlacemarkWrapper(WorkbenchRow row, String label, List<WorkbenchTemplateMappingItem> visibleColumns) {
        this.wbRow = row;
        this.label = label;
        this.visibleColumns = visibleColumns;
        for (WorkbenchTemplateMappingItem wbtmi : visibleColumns) {
            this.visibleMap.put(wbtmi, true);
        }
    }

    protected void initExportData() {
        if (this.mappings == null) {
            this.mappings = new Hashtable();
            for (WorkbenchTemplateMappingItem wbtmi : this.wbRow.getWorkbench().getWorkbenchTemplate().getWorkbenchTemplateMappingItems()) {
                this.mappings.put(wbtmi.getViewOrder(), wbtmi);
            }
        }
        if (this.dataList == null) {
            this.dataList = new Vector<WorkbenchDataItem>(this.wbRow.getWorkbenchDataItems());
            Collections.sort(this.dataList);
        }
    }

    @Override
    public void cleanup() {
        this.mappings.clear();
        this.mappings = null;
    }

    @Override
    public String getHtmlContent(String textColorArg) {
        String textColor = UIHelper.fixColorForHTML(textColorArg);
        boolean useCaptions = AppPreferences.getRemote().getBoolean("google.earth.useorigheaders", true);
        this.initExportData();
        StringBuilder sb = new StringBuilder("<table>");
        for (WorkbenchDataItem wbdi : this.dataList) {
            WorkbenchTemplateMappingItem wbtmi = this.mappings.get(wbdi.getColumnNumber());
            if (this.visibleMap.get(wbtmi) == null || !wbtmi.getIsExportableToContent().booleanValue()) continue;
            sb.append("<tr><td align=\"right\"><font color=\"");
            sb.append(textColor);
            sb.append("\">");
            sb.append(useCaptions ? wbtmi.getCaption() : wbtmi.getTitle());
            sb.append(":</font></td><td align=\"left\" valign=\"middle\"><font color=\"");
            sb.append(textColor);
            sb.append("\">");
            sb.append(wbdi.getCellData());
            sb.append("</font></td></tr>\n");
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    @Override
    public Pair<Double, Double> getLatLon() {
        GeoRefConverter converter = new GeoRefConverter();
        this.initExportData();
        Double latitude = null;
        Double longitude = null;
        for (WorkbenchDataItem wbdi : this.dataList) {
            String valStr;
            WorkbenchTemplateMappingItem wbtmi = this.mappings.get(wbdi.getColumnNumber());
            if (wbtmi.getFieldName().equals("latitude1")) {
                valStr = wbdi.getCellData();
                if (!StringUtils.isNotEmpty((String)valStr)) continue;
                try {
                    String latStr = converter.convert(StringUtils.stripToNull((String)valStr), GeoRefConverter.GeoRefFormat.D_PLUS_MINUS.name());
                    latitude = UIHelper.parseDouble(latStr);
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(WorkbenchRowPlacemarkWrapper.class, e);
                    latitude = null;
                }
                continue;
            }
            if (!wbtmi.getFieldName().equals("longitude1") || !StringUtils.isNotEmpty((String)(valStr = wbdi.getCellData()))) continue;
            try {
                String lonStr = converter.convert(StringUtils.stripToNull((String)valStr), GeoRefConverter.GeoRefFormat.D_PLUS_MINUS.name());
                longitude = UIHelper.parseDouble(lonStr);
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(WorkbenchRowPlacemarkWrapper.class, e);
                longitude = null;
            }
        }
        if (latitude != null && longitude != null) {
            return new Pair<Object, Object>(latitude, longitude);
        }
        return null;
    }

    @Override
    public String getTitle() {
        this.initExportData();
        return this.label;
    }

    @Override
    public ImageIcon getImageIcon() {
        return null;
    }

    @Override
    public Double getAltitude() {
        return null;
    }
}

