/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.rstools;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.services.mapping.LatLonPlacemarkIFace;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.dbsupport.RecordSetLoader;
import edu.ku.brc.specify.rstools.RecordSetToolsIFace;
import edu.ku.brc.specify.tasks.services.CollectingEventLocalityKMLGenerator;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.Pair;
import edu.ku.brc.util.services.GenericKMLGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GoogleEarthExporter
implements RecordSetToolsIFace {
    private static final Logger log = Logger.getLogger(GoogleEarthExporter.class);
    private boolean useKMZ = false;

    @Override
    public void processRecordSet(RecordSetIFace recordSet, Properties reqParams) {
        this.useKMZ = AppPreferences.getLocalPrefs().getBoolean("USE_GE_KMZ", false);
        String description = JOptionPane.showInputDialog(UIRegistry.getTopWindow(), (Object)UIRegistry.getResourceString("GE_ENTER_DESC"));
        log.info((Object)"Exporting RecordSet");
        int dataTableId = recordSet.getDbTableId();
        if (dataTableId == CollectingEvent.getClassTableId()) {
            this.exportDataObjects(description, RecordSetLoader.loadRecordSet(recordSet), this.useKMZ, this.getPlacemarkIcon());
        } else if (dataTableId == CollectionObject.getClassTableId()) {
            this.exportCollectionObjectRecordSet(description, recordSet);
        } else if (dataTableId == Locality.getClassTableId()) {
            this.exportLocalityRecordSet(description, recordSet);
        } else {
            throw new RuntimeException("Only Collection Objects, Colelcting Events and Localities are supported for GoogleEarth export.");
        }
    }

    private ImageIcon getPlacemarkIcon() {
        String discipline = AppContextMgr.getInstance().getClassObject(Discipline.class).getType();
        for (Pair<String, ImageIcon> pair : IconManager.getListByType("disciplines", IconManager.IconSize.Std32)) {
            if (!((String)pair.first).equals(discipline)) continue;
            return (ImageIcon)pair.second;
        }
        return null;
    }

    @Override
    public void processDataList(List<?> data, Properties reqParams) throws Exception {
        log.info((Object)"Exporting data list");
        if (data == null || data.size() == 0) {
            log.warn((Object)"Empty or null data list given to GoogleEarthExporter");
            return;
        }
        if (data.get(0) instanceof LatLonPlacemarkIFace) {
            try {
                File tmpFile = File.createTempFile("sp6export", ".kmz");
                tmpFile.deleteOnExit();
                log.info((Object)("Writing KML output to " + tmpFile.getAbsolutePath()));
                ImageIcon imageIcon = this.getIconFromPrefs();
                List<LatLonPlacemarkIFace> mappedPlacemarks = this.exportPlacemarkList(reqParams.getProperty("description"), data, imageIcon, tmpFile);
                if (mappedPlacemarks.size() != data.size()) {
                    UIRegistry.getStatusBar().setErrorMessage(String.format(UIRegistry.getResourceString("NOT_ALL_MAPPED"), data.size() - mappedPlacemarks.size(), data.size()));
                }
                try {
                    this.openExternalViewer(tmpFile);
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to open external viewer (e.g. Google Earth) for KML file", (Throwable)e);
                    String errorMessage = UIRegistry.getResourceString("GOOGLE_EARTH_ERROR");
                    UIRegistry.getStatusBar().setErrorMessage(errorMessage, e);
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception caught while creating KML output or opening Google Earth", (Throwable)e);
                String errorMessage = UIRegistry.getResourceString("KML_EXPORT_ERROR");
                UIRegistry.getStatusBar().setErrorMessage(errorMessage, e);
            }
        }
    }

    protected void exportCollectionObjectRecordSet(String description, RecordSetIFace recordSet) {
        Vector<Object> list = new Vector<Object>();
        List<Object> records = RecordSetLoader.loadCollectionObjectsRecordSet(recordSet);
        for (Object obj : records) {
            Locality loc;
            CollectionObject colObj;
            if (!(obj instanceof CollectionObject) || (colObj = (CollectionObject)obj).getCollectingEvent() == null || colObj.getCollectingEvent().getLocality() == null || (loc = colObj.getCollectingEvent().getLocality()).getLatitude1() == null || loc.getLongitude1() == null) continue;
            list.add(obj);
        }
        if (list.size() > 0) {
            this.exportDataObjects(description, list, this.useKMZ, this.getIconFromPrefs());
        } else {
            UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString("GE_NO_POINTS"), Color.RED);
        }
    }

    protected void exportLocalityRecordSet(String description, RecordSetIFace recordSet) {
        Vector<Object> list = new Vector<Object>();
        List<Object> records = RecordSetLoader.loadRecordSet(recordSet);
        for (Object o : records) {
            list.add((Locality)o);
        }
        if (list.size() > 0) {
            this.exportDataObjects(description, list, this.useKMZ, this.getIconFromPrefs());
        } else {
            UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString("GE_NO_POINTS"), Color.RED);
        }
    }

    protected ImageIcon getIconFromPrefs() {
        String iconUrl = AppPreferences.getRemote().getProperties().getProperty("google.earth.icon", null);
        if (StringUtils.isNotEmpty((String)iconUrl)) {
            try {
                return new ImageIcon(new File(iconUrl).toURL());
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(GoogleEarthExporter.class, ex);
            }
        }
        return null;
    }

    protected void exportDataObjects(String description, List<Object> dataObjList, boolean doKMZ, ImageIcon imgIconArg) {
        try {
            if (dataObjList != null && dataObjList.size() > 0) {
                ImageIcon defaultIcon;
                CollectingEventLocalityKMLGenerator kmlGen = new CollectingEventLocalityKMLGenerator();
                kmlGen.setDescription(description);
                ImageIcon imageIcon = defaultIcon = IconManager.getImage("DefaultPlacemark");
                imageIcon = imgIconArg == null ? this.getPlacemarkIcon() : imgIconArg;
                File defaultIconFile = null;
                if (doKMZ && imageIcon != null) {
                    kmlGen.setPlacemarkIconURL("files/specify32.png");
                    defaultIconFile = File.createTempFile("sp6-export-icon-", ".png");
                    if (!this.writeImageIconToFile(imageIcon, defaultIconFile)) {
                        if (imageIcon != defaultIcon) {
                            if (!this.writeImageIconToFile(defaultIcon, defaultIconFile)) {
                                kmlGen.setPlacemarkIconURL(null);
                            }
                        } else {
                            kmlGen.setPlacemarkIconURL(null);
                        }
                    }
                } else {
                    kmlGen.setPlacemarkIconURL(null);
                }
                Color geBGColor = AppPreferences.getRemote().getColor("google.earth.bgcolor", new Color(0, 102, 179));
                String bgColor = UIHelper.getBGRHexFromColor(geBGColor);
                Color geFGColor = AppPreferences.getRemote().getColor("google.earth.fgcolor", new Color(255, 255, 255));
                String fgColor = UIHelper.getBGRHexFromColor(geFGColor);
                kmlGen.setBalloonStyleBgColor("FF" + bgColor);
                kmlGen.setBalloonStyleTextColor("FF" + fgColor);
                kmlGen.setBalloonStyleText(this.getBalloonText(fgColor));
                kmlGen.setTextColor(fgColor);
                for (Object obj : dataObjList) {
                    if (!(obj instanceof FormDataObjIFace)) continue;
                    kmlGen.addDataObj((FormDataObjIFace)obj, null);
                }
                File outputFile = File.createTempFile("sp6export", doKMZ ? ".kmz" : ".kml");
                kmlGen.outputToFile(outputFile.getAbsolutePath());
                log.debug((Object)outputFile.getAbsolutePath());
                if (doKMZ) {
                    this.createKMZ(outputFile, defaultIconFile);
                }
                if (imageIcon != null && defaultIconFile != null) {
                    defaultIconFile.delete();
                }
                this.openExternalViewer(outputFile);
            } else {
                UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString("GE_NO_POINTS"), Color.RED);
            }
        }
        catch (Exception ex) {
            UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString("GE_EXPORT_PROB"), Color.RED);
            ex.printStackTrace();
        }
    }

    protected String getBalloonText(String textColorArg) {
        String textColor = UIHelper.fixColorForHTML(textColorArg);
        return "<b><font color=\"" + textColor + "\" size=\"+3\"><center>$[name]</center></font></b>" + "<br/><hr><br/>" + "$[description]<br/><br/>" + "<center><a href=\"http://www.specifysoftware.org/\"><font color=\"" + textColor + "\">http://www.specifysoftware.org</font></a></center>";
    }

    protected List<LatLonPlacemarkIFace> exportPlacemarkList(String description, List<LatLonPlacemarkIFace> placemarks, ImageIcon imgIconArg, File outputFile) throws IOException {
        ImageIcon defaultIcon = IconManager.getImage("DefaultPlacemark");
        Vector<LatLonPlacemarkIFace> mappedPlacemarks = new Vector<LatLonPlacemarkIFace>();
        GenericKMLGenerator kmlGenerator = new GenericKMLGenerator();
        if (description != null) {
            kmlGenerator.setDescription(description);
        } else if (placemarks.size() == 1) {
            LatLonPlacemarkIFace pm = placemarks.get(0);
            kmlGenerator.setDescription(pm.getTitle());
            if (pm.getImageIcon() != null) {
                defaultIcon = pm.getImageIcon();
            }
        }
        Color geBGColor = AppPreferences.getRemote().getColor("google.earth.bgcolor", new Color(0, 102, 179), true);
        String bgColor = UIHelper.getBGRHexFromColor(geBGColor);
        Color geFGColor = AppPreferences.getRemote().getColor("google.earth.fgcolor", new Color(255, 255, 255), true);
        String fgColor = UIHelper.getBGRHexFromColor(geFGColor);
        kmlGenerator.setBalloonStyleBgColor("FF" + bgColor);
        kmlGenerator.setBalloonStyleTextColor("FF" + fgColor);
        kmlGenerator.setBalloonStyleText(this.getBalloonText(fgColor));
        ImageIcon imageIcon = defaultIcon;
        imageIcon = imgIconArg == null ? this.getPlacemarkIcon() : imgIconArg;
        File defaultIconFile = null;
        if (imageIcon != null) {
            kmlGenerator.setPlacemarkIconURL("files/specify32.png");
            defaultIconFile = File.createTempFile("sp6-export-icon-", ".png");
            if (!this.writeImageIconToFile(imageIcon, defaultIconFile)) {
                if (imageIcon != defaultIcon) {
                    if (!this.writeImageIconToFile(defaultIcon, defaultIconFile)) {
                        kmlGenerator.setPlacemarkIconURL(null);
                    }
                } else {
                    kmlGenerator.setPlacemarkIconURL(null);
                }
            }
        } else {
            kmlGenerator.setPlacemarkIconURL(null);
        }
        for (LatLonPlacemarkIFace pm : placemarks) {
            String name = pm.getTitle();
            name = name == null ? "" : name;
            Pair<Double, Double> geoRef = pm.getLatLon();
            if (geoRef != null) {
                mappedPlacemarks.add(pm);
                String htmlDesc = pm.getHtmlContent(kmlGenerator.getBalloonStyleTextColor());
                kmlGenerator.addPlacemark(geoRef, name, htmlDesc);
                continue;
            }
            log.warn((Object)"Placemark returned a null geocoordinate");
        }
        kmlGenerator.generateKML(outputFile);
        this.createKMZ(outputFile, defaultIconFile);
        if (defaultIconFile != null) {
            defaultIconFile.delete();
        }
        return mappedPlacemarks;
    }

    protected boolean writeImageIconToFile(ImageIcon icon, File output) throws IOException {
        if (icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0 && output != null) {
            try {
                Graphics2D g;
                BufferedImage bimage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                if (bimage != null && (g = bimage.createGraphics()) != null) {
                    g.drawImage(icon.getImage(), 0, 0, null);
                    g.dispose();
                    ImageIO.write((RenderedImage)bimage, "PNG", output);
                    return true;
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(GoogleEarthExporter.class, ex);
            }
        }
        return false;
    }

    protected void createKMZ(File outputFile, File defaultIconFile) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        File outputKMZ = File.createTempFile("sp6-export-", ".kmz");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outputKMZ));
        FileInputStream in = new FileInputStream(outputFile);
        out.putNextEntry(new ZipEntry("doc.kml"));
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.closeEntry();
        in.close();
        ZipEntry filesDir = new ZipEntry("files/");
        out.putNextEntry(filesDir);
        out.closeEntry();
        if (defaultIconFile != null) {
            File iconTmpFile = defaultIconFile;
            in = new FileInputStream(iconTmpFile);
            out.putNextEntry(new ZipEntry("files/specify32.png"));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
        }
        out.close();
        FileUtils.copyFile((File)outputKMZ, (File)outputFile);
        outputKMZ.delete();
    }

    protected void openExternalViewer(File f) throws Exception {
        AttachmentUtils.openFile(f);
    }

    @Override
    public Class<?>[] getHandledClasses() {
        return new Class[]{CollectingEvent.class, LatLonPlacemarkIFace.class};
    }

    @Override
    public String getName() {
        return UIRegistry.getResourceString("GoogleEarth");
    }

    @Override
    public String getIconName() {
        return "GoogleEarth";
    }

    @Override
    public String getDescription() {
        return UIRegistry.getResourceString("GoogleEarth_Description");
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public int[] getTableIds() {
        return new int[]{1, 2, 10};
    }
}

