/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.rstools;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.services.biogeomancer.GeoCoordDataIFace;
import edu.ku.brc.services.biogeomancer.GeoCoordProviderListenerIFace;
import edu.ku.brc.services.biogeomancer.GeoCoordServiceProviderIFace;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.GeoCoordDetail;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.rstools.GeoCoordData;
import edu.ku.brc.specify.rstools.RecordSetToolsIFace;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.LatLonConverter;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.JList;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

public abstract class GeoRefRecordSetProcessorBase
implements RecordSetToolsIFace,
GeoCoordProviderListenerIFace {
    private static final Logger log = Logger.getLogger(GeoRefRecordSetProcessorBase.class);

    public abstract String getGeoRefProviderName();

    @Override
    public void processDataList(List<?> data, Properties requestParams) throws Exception {
        throw new RuntimeException("Not Implemented!");
    }

    protected void retrieveIds(String hSQL, Vector<Integer> ids) {
        Session session = HibernateUtil.getNewSession();
        try {
            try {
                Query query = session.createQuery(hSQL);
                HashSet results = new HashSet(query.list());
                for (Object obj : results) {
                    ids.add((Integer)obj);
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(GeoRefRecordSetProcessorBase.class, ex);
                log.error((Object)ex);
                session.close();
            }
        }
        finally {
            session.close();
        }
    }

    protected void retrieveIdsSQL(String sql, Vector<Integer> ids) {
        Vector<Object[]> rows = BasicSQLUtils.query(sql);
        if (rows != null && rows.size() > 0) {
            for (Object[] r : rows) {
                ids.add((Integer)r[0]);
            }
        }
    }

    @Override
    public abstract void processRecordSet(RecordSetIFace var1, Properties var2) throws Exception;

    public void processRecordSet(RecordSetIFace recordSet, Properties requestParams, GeoCoordServiceProviderIFace geoRefService) throws Exception {
        String sql;
        Vector<Integer> ids = new Vector<Integer>();
        if (recordSet.getDbTableId() == CollectionObject.getClassTableId()) {
            sql = "SELECT loc.LocalityID FROM collectingevent ce INNER JOIN locality loc ON ce.LocalityID = loc.LocalityID INNER JOIN collectionobject co ON co.CollectingEventID = ce.CollectingEventID WHERE co.CollectionObjectID " + DBTableIdMgr.getInstance().getInClause(recordSet);
            this.retrieveIdsSQL(sql, ids);
        } else if (recordSet.getDbTableId() == CollectingEvent.getClassTableId()) {
            sql = "SELECT loc.LocalityID FROM collectingevent ce INNER JOIN locality loc ON ce.LocalityID = loc.LocalityID WHERE ce.CollectingEventID " + DBTableIdMgr.getInstance().getInClause(recordSet);
            this.retrieveIdsSQL(sql, ids);
        } else if (recordSet.getDbTableId() == Locality.getClassTableId()) {
            for (RecordSetItemIFace rsi : recordSet.getItems()) {
                ids.add(rsi.getRecordId());
            }
        }
        if (ids.size() > 0) {
            if (ids.size() < recordSet.getNumItems()) {
                UIRegistry.showLocalizedMsg(null, "GeoRefRSProc.NOT_ALL_RES", ids.size(), recordSet.getNumItems());
            }
            Vector<GeoCoordDataIFace> geoRefDataList = new Vector<GeoCoordDataIFace>();
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                Vector<String> noGeoList = new Vector<String>();
                Vector<String> hasLatLonList = new Vector<String>();
                for (Integer id : ids) {
                    Locality locality = session.getData(Locality.class, "localityId", id, DataProviderSessionIFace.CompareType.Equals);
                    if (locality == null) continue;
                    Geography geo = locality.getGeography();
                    if (geo != null) {
                        String country = GeoRefRecordSetProcessorBase.getNameForRank(geo, 200);
                        String state = GeoRefRecordSetProcessorBase.getNameForRank(geo, 300);
                        String county = GeoRefRecordSetProcessorBase.getNameForRank(geo, 400);
                        GeoCoordData geoRefData = new GeoCoordData(locality.getLocalityId(), country, state, county, locality.getLocalityName(), locality.getErrorPolygon(), locality.getErrorEstimate());
                        geoRefDataList.add(geoRefData);
                        if (locality.getLatitude1() != null && locality.getLongitude1() != null) {
                            hasLatLonList.add(locality.getIdentityTitle());
                        }
                        session.evict(geo);
                    } else {
                        noGeoList.add(locality.getIdentityTitle());
                    }
                    session.evict(locality);
                }
                if (noGeoList.size() > 0 || hasLatLonList.size() > 0) {
                    String rowDef = "p,2px,f:p:g" + (noGeoList.size() > 0 && hasLatLonList.size() > 0 ? ",10px, p,2px,f:p:g" : "");
                    CellConstraints cc = new CellConstraints();
                    PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", rowDef));
                    int y = 1;
                    if (noGeoList.size() > 0) {
                        JList noGeoLst = new JList(noGeoList);
                        pb.add((Component)UIHelper.createI18NLabel("GeoRefRSProc.BAD_GEOS"), cc.xy(1, y));
                        pb.add((Component)UIHelper.createScrollPane(noGeoLst, true), cc.xy(1, y += 2));
                        y += 2;
                    }
                    if (hasLatLonList.size() > 0) {
                        JList locLst = new JList(hasLatLonList);
                        pb.add((Component)UIHelper.createI18NLabel("GeoRefRSProc.HAS_LOCS"), cc.xy(1, y));
                        pb.add((Component)UIHelper.createScrollPane(locLst, true), cc.xy(1, y += 2));
                    }
                    pb.setDefaultDialogBorder();
                    CustomDialog dlg = new CustomDialog(null, UIRegistry.getResourceString("WARNING"), true, 3, (Component)pb.getPanel());
                    dlg.setOkLabel("Continue");
                    UIHelper.centerAndShow(dlg);
                    if (dlg.isCancelled()) {
                        return;
                    }
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(GeoRefRecordSetProcessorBase.class, ex);
            }
            finally {
                session.close();
            }
            geoRefService.processGeoRefData(geoRefDataList, this, requestParams != null ? requestParams.getProperty("helpcontext") : null);
        } else {
            UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString("GeoRefRSProc.NO_LOCS"));
        }
    }

    public static String getNameForRank(Geography geo, int rankId) {
        if (geo.getRankId() != null) {
            if (geo.getRankId() == rankId) {
                return geo.getName();
            }
            if (geo.getRankId() < rankId) {
                return null;
            }
        } else {
            return null;
        }
        return GeoRefRecordSetProcessorBase.getNameForRank(geo.getParent(), rankId);
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public Class<?>[] getHandledClasses() {
        return null;
    }

    @Override
    public abstract String getIconName();

    @Override
    public abstract String getName();

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public int[] getTableIds() {
        return new int[]{1, 2, 10};
    }

    @Override
    public void aboutToDisplayResults() {
    }

    @Override
    public void complete(List<GeoCoordDataIFace> items, int itemsUpdated) {
        if (itemsUpdated > 0) {
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                try {
                    for (GeoCoordDataIFace item : items) {
                        try {
                            Locality locality;
                            if (item.getLatitude() == null || item.getLongitude() == null || (locality = session.getData(Locality.class, "localityId", item.getGeoCoordId(), DataProviderSessionIFace.CompareType.Equals)) == null) continue;
                            BigDecimal lat = UIHelper.parseDoubleToBigDecimal(item.getLatitude());
                            BigDecimal lon = UIHelper.parseDoubleToBigDecimal(item.getLongitude());
                            locality.setLatitude1(lat);
                            locality.setLongitude1(lon);
                            locality.setLat1text(LatLonConverter.convertToDDDDDD(lat, LatLonConverter.DEGREES_FORMAT.String, LatLonConverter.DIRECTION.NorthSouth, 6));
                            locality.setLong1text(LatLonConverter.convertToDDDDDD(lon, LatLonConverter.DEGREES_FORMAT.String, LatLonConverter.DIRECTION.EastWest, 6));
                            locality.setSrcLatLongUnit((byte)0);
                            Set<GeoCoordDetail> geoCoordDetails = locality.getGeoCoordDetails();
                            GeoCoordDetail gcDetail = null;
                            if (geoCoordDetails.size() == 0) {
                                gcDetail = new GeoCoordDetail();
                                gcDetail.initialize();
                                locality.addReference(gcDetail, "geoCoordDetails");
                            } else if (geoCoordDetails.size() == 1) {
                                gcDetail = geoCoordDetails.iterator().next();
                            } else {
                                throw new RuntimeException("Locality can only have ONE GeoCoordDetail!");
                            }
                            try {
                                gcDetail.setGeoRefDetBy(Agent.getUserAgent());
                                gcDetail.setGeoRefDetDate(Calendar.getInstance());
                                gcDetail.setGeoRefDetRef(this.getGeoRefProviderName());
                                session.beginTransaction();
                                session.saveOrUpdate(locality);
                                session.commit();
                                session.evict(locality);
                            }
                            catch (Exception ex) {
                                UsageTracker.incrHandledUsageCount();
                                ExceptionTracker.getInstance().capture(GeoRefRecordSetProcessorBase.class, ex);
                                log.error((Object)ex);
                                ex.printStackTrace();
                                session.rollback();
                            }
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(GeoRefRecordSetProcessorBase.class, ex);
                            log.error((Object)ex);
                        }
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(GeoRefRecordSetProcessorBase.class, ex);
                    log.error((Object)ex);
                    session.close();
                }
            }
            finally {
                session.close();
            }
        }
    }
}

