/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.rstools;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.rstools.ExportFileConfigurationFactory;
import edu.ku.brc.specify.rstools.RecordSetToolsIFace;
import edu.ku.brc.specify.tasks.subpane.wb.CSVExport;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureCSV;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureXLS;
import edu.ku.brc.specify.tasks.subpane.wb.DataExport;
import edu.ku.brc.specify.tasks.subpane.wb.XLSExport;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIRegistry;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;

public class ExportToFile
implements RecordSetToolsIFace {
    protected DataExport buildExporter(Properties reqParams) {
        String mimeType = reqParams.getProperty("mimetype");
        if (mimeType == ExportFileConfigurationFactory.XLS_MIME_TYPE) {
            return new XLSExport(new ConfigureXLS(reqParams));
        }
        if (mimeType == ExportFileConfigurationFactory.CSV_MIME_TYPE) {
            return new CSVExport(new ConfigureCSV(reqParams));
        }
        return null;
    }

    @Override
    public void processDataList(List<?> data, Properties reqParams) throws Exception {
        DataExport exporter = this.buildExporter(reqParams);
        if (exporter != null) {
            final String name = FilenameUtils.getName((String)exporter.getConfig().getFileName());
            final String msgKey = reqParams.getProperty("statusmsgkey") == null ? "EXPORTING_TO" : reqParams.getProperty("statusmsgkey");
            final String doneMsgKey = reqParams.getProperty("statusdonemsgkey") == null ? "EXPORTING_DONE" : reqParams.getProperty("statusdonemsgkey");
            final JStatusBar statusBar = UIRegistry.getStatusBar();
            if (statusBar != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        statusBar.setText(String.format(UIRegistry.getResourceString(msgKey), name));
                    }
                });
            }
            try {
                exporter.writeData(data);
                if (statusBar != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            statusBar.setText(String.format(UIRegistry.getResourceString(doneMsgKey), name));
                        }
                    });
                }
            }
            catch (IOException e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ExportToFile.class, e);
                throw e;
            }
        }
    }

    @Override
    public void processRecordSet(RecordSetIFace data, Properties reqParams) throws Exception {
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Class<?>[] getHandledClasses() {
        return null;
    }

    @Override
    public String getIconName() {
        return "AppIcon";
    }

    @Override
    public String getName() {
        return UIRegistry.getResourceString("FILE");
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public int[] getTableIds() {
        return new int[]{79};
    }
}

