/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.prefs;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.GenericPrefsPanel;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.GeologicTimePeriod;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDef;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDefItem;
import edu.ku.brc.specify.datamodel.LithoStrat;
import edu.ku.brc.specify.datamodel.LithoStratTreeDef;
import edu.ku.brc.specify.datamodel.LithoStratTreeDefItem;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;

public class TreePrefs
extends GenericPrefsPanel {
    private static final String PREF_NAME = "TreeEditor.Rank.Threshold.";
    protected Hashtable<Class<?>, DefModelFiller<?, ?, ?>> fillers = new Hashtable();

    public TreePrefs() {
        this.createUI();
    }

    protected void createUI() {
        this.createForm("Preferences", "TreeOptions");
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            try {
                GeologicTimePeriodTreeDef gtptd;
                DefModelFiller txFiller = new DefModelFiller();
                txFiller.fill("1", session, AppContextMgr.getInstance().getClassObject(TaxonTreeDef.class), Taxon.class);
                this.fillers.put(Taxon.class, txFiller);
                DefModelFiller geoFiller = new DefModelFiller();
                geoFiller.fill("2", session, AppContextMgr.getInstance().getClassObject(GeographyTreeDef.class), Geography.class);
                this.fillers.put(Geography.class, geoFiller);
                LithoStratTreeDef lstd = AppContextMgr.getInstance().getClassObject(LithoStratTreeDef.class);
                if (lstd != null) {
                    DefModelFiller<LithoStrat, LithoStratTreeDef, LithoStratTreeDefItem> lithoFiller = new DefModelFiller<LithoStrat, LithoStratTreeDef, LithoStratTreeDefItem>();
                    lithoFiller.fill("3", session, lstd, LithoStrat.class);
                    this.fillers.put(LithoStrat.class, lithoFiller);
                }
                if ((gtptd = AppContextMgr.getInstance().getClassObject(GeologicTimePeriodTreeDef.class)) != null) {
                    DefModelFiller<GeologicTimePeriod, GeologicTimePeriodTreeDef, GeologicTimePeriodTreeDefItem> gtpFiller = new DefModelFiller<GeologicTimePeriod, GeologicTimePeriodTreeDef, GeologicTimePeriodTreeDefItem>();
                    gtpFiller.fill("4", session, gtptd, GeologicTimePeriod.class);
                    this.fillers.put(GeologicTimePeriod.class, gtpFiller);
                }
                DefModelFiller storageFiller = new DefModelFiller();
                storageFiller.fill("5", session, AppContextMgr.getInstance().getClassObject(StorageTreeDef.class), Storage.class);
                this.fillers.put(Storage.class, storageFiller);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(TreePrefs.class, ex);
                ex.printStackTrace();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    @Override
    public String getHelpContext() {
        return "PrefsTree";
    }

    @Override
    public void savePrefs() {
        super.savePrefs();
        for (DefModelFiller<?, ?, ?> filler : this.fillers.values()) {
            filler.setValueIntoPref();
        }
    }

    class DefModelFiller<T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>> {
        protected String id;
        protected Class<?> clazz;

        public void fill(String fillerId, DataProviderSessionIFace session, TreeDefIface<T, D, I> tdi, Class<?> fillerClass) {
            this.id = fillerId;
            this.clazz = fillerClass;
            ValComboBox cbx = (ValComboBox)TreePrefs.this.form.getCompById(fillerId);
            if (tdi == null) {
                cbx.setEnabled(false);
                return;
            }
            DefaultComboBoxModel<TreeDefItemIface> model = new DefaultComboBoxModel<TreeDefItemIface>();
            cbx.getComboBox().setModel(model);
            int rankId = AppPreferences.getRemote().getInt(TreePrefs.PREF_NAME + fillerClass.getSimpleName(), 0);
            Vector<I> list = new Vector<I>(tdi.getTreeDefItems());
            Comparator itemComparator = new Comparator<TreeDefItemIface<T, D, I>>(){

                @Override
                public int compare(TreeDefItemIface<T, D, I> o1, TreeDefItemIface<T, D, I> o2) {
                    return o1.getRankId().compareTo(o2.getRankId());
                }
            };
            Collections.sort(list, itemComparator);
            int inx = -1;
            int i = 0;
            for (TreeDefItemIface ttdi : list) {
                if (ttdi.getRankId() == rankId) {
                    inx = i;
                }
                model.addElement(ttdi);
                ++i;
            }
            if (inx > -1) {
                cbx.getComboBox().setSelectedIndex(inx);
            }
        }

        public void setValueIntoPref() {
            ValComboBox taxonCBX = (ValComboBox)TreePrefs.this.form.getCompById(this.id);
            TreeDefItemIface tdi = (TreeDefItemIface)taxonCBX.getComboBox().getSelectedItem();
            if (tdi != null) {
                AppPreferences.getRemote().put(TreePrefs.PREF_NAME + this.clazz.getSimpleName(), Integer.toString(tdi.getRankId()));
            }
        }
    }
}

