/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.prefs;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.GenericPrefsPanel;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.af.ui.forms.validation.ValBrowseBtnPanel;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.ui.IconEntry;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;

public class SystemPrefs
extends GenericPrefsPanel {
    protected static final String SPECIFY_BG_IMG_PATH = "specify.bg.image";
    protected static final String VERSION_CHECK = "version_check.auto";
    protected static final String SEND_STATS = "usage_tracking.send_stats";
    protected static final String SEND_ISA_STATS = "usage_tracking.send_isa_stats";
    protected static final String USE_WORLDWIND = "USE.WORLDWIND";
    protected static final String SYSTEM_HasOpenGL = "SYSTEM.HasOpenGL";
    protected static final String ALWAYS_ASK_COLL = "ALWAYS.ASK.COLL";
    protected AppPreferences remotePrefs = AppPreferences.getRemote();
    protected AppPreferences localPrefs = AppPreferences.getLocalPrefs();
    protected String oldSplashPath = null;

    public SystemPrefs() {
        this.createForm("Preferences", "System");
        JButton clearCache = (JButton)this.form.getCompById("clearcache");
        clearCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemPrefs.this.clearCache();
            }
        });
        ValBrowseBtnPanel browse = (ValBrowseBtnPanel)this.form.getCompById("7");
        if (browse != null) {
            this.oldSplashPath = this.localPrefs.get(SPECIFY_BG_IMG_PATH, null);
            browse.setValue(this.oldSplashPath, null);
        }
        final ValComboBox localeCBX = (ValComboBox)this.form.getCompById("5");
        localeCBX.getComboBox().setRenderer(new LocaleRenderer());
        localeCBX.setEnabled(false);
        SwingWorker workerThread = new SwingWorker(){
            protected int inx = -1;

            @Override
            public Object construct() {
                Vector locales = new Vector();
                Collections.addAll(locales, Locale.getAvailableLocales());
                Collections.sort(locales, new Comparator<Locale>(){

                    @Override
                    public int compare(Locale o1, Locale o2) {
                        return o1.getDisplayName().compareTo(o2.getDisplayName());
                    }
                });
                int i = 0;
                String language = AppPreferences.getLocalPrefs().get("locale.lang", Locale.getDefault().getLanguage());
                String country = AppPreferences.getLocalPrefs().get("locale.country", Locale.getDefault().getCountry());
                String variant = AppPreferences.getLocalPrefs().get("locale.var", Locale.getDefault().getVariant());
                Locale prefLocale = new Locale(language, country, variant);
                int justLangIndex = -1;
                Locale cachedLocale = Locale.getDefault();
                for (Locale l : locales) {
                    try {
                        boolean isOK;
                        Locale.setDefault(l);
                        ResourceBundle rb = ResourceBundle.getBundle("resources", l);
                        boolean bl = isOK = l.getLanguage().equals("en") && StringUtils.isEmpty((String)l.getCountry()) || l.getLanguage().equals("pt") && l.getCountry().equals("PT");
                        if (!isOK || !rb.getKeys().hasMoreElements()) continue;
                        if (l.getLanguage().equals(prefLocale.getLanguage())) {
                            justLangIndex = i;
                        }
                        if (l.equals(prefLocale)) {
                            this.inx = i;
                        }
                        localeCBX.getComboBox().addItem(l);
                        ++i;
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
                if (this.inx == -1 && justLangIndex > -1) {
                    this.inx = justLangIndex;
                }
                Locale.setDefault(cachedLocale);
                return null;
            }

            @Override
            public void finished() {
                UIValidator.setIgnoreAllValidation("SystemPrefs", true);
                localeCBX.setEnabled(true);
                localeCBX.getComboBox().setSelectedIndex(this.inx);
                JTextField loadingLabel = (JTextField)SystemPrefs.this.form.getCompById("6");
                if (loadingLabel != null) {
                    loadingLabel.setText(UIRegistry.getResourceString("LOCALE_RESTART_REQUIRED"));
                }
                UIValidator.setIgnoreAllValidation("SystemPrefs", false);
            }
        };
        workerThread.start();
        ValCheckBox chk = (ValCheckBox)this.form.getCompById("2");
        chk.setValue(this.localPrefs.getBoolean(VERSION_CHECK, true), "true");
        chk = (ValCheckBox)this.form.getCompById("3");
        chk.setValue(this.remotePrefs.getBoolean(SEND_STATS, true), "true");
        chk = (ValCheckBox)this.form.getCompById("9");
        chk.setValue(this.remotePrefs.getBoolean(SEND_ISA_STATS, true), "true");
        chk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String isaNumber;
                Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
                if (collection != null && StringUtils.isNotEmpty((String)(isaNumber = collection.getIsaNumber())) && !((JCheckBox)e.getSource()).isSelected()) {
                    UIRegistry.showLocalizedMsg("ISA_STATS_WARNING");
                }
            }
        });
        ValCheckBox useWWChk = (ValCheckBox)this.form.getCompById(USE_WORLDWIND);
        ValCheckBox hasOGLChk = (ValCheckBox)this.form.getCompById(SYSTEM_HasOpenGL);
        useWWChk.setValue(this.localPrefs.getBoolean(USE_WORLDWIND, false), null);
        hasOGLChk.setValue(this.localPrefs.getBoolean(SYSTEM_HasOpenGL, false), null);
        hasOGLChk.setEnabled(false);
    }

    protected void clearCache() {
        String CLEAR_CACHE = "CLEAR_CACHE";
        final JStatusBar statusBar = UIRegistry.getStatusBar();
        statusBar.setIndeterminate("CLEAR_CACHE", true);
        Container dlg = this.getParent();
        while (dlg != null && !(dlg instanceof JDialog)) {
            dlg = dlg.getParent();
        }
        Point loc = null;
        if (dlg != null) {
            loc = dlg.getLocation();
        }
        final JDialog parentDlg = (JDialog)dlg;
        Rectangle screenRect = dlg.getGraphicsConfiguration().getBounds();
        parentDlg.setLocation(loc.x, screenRect.height);
        javax.swing.SwingWorker<Integer, Integer> backupWorker = new javax.swing.SwingWorker<Integer, Integer>(){

            @Override
            protected Integer doInBackground() throws Exception {
                try {
                    long startTm = System.currentTimeMillis();
                    Specify.getCacheManager().clearAll();
                    FormValidator validator = ((FormViewObj)SystemPrefs.this.form).getValidator();
                    if (validator != null) {
                        validator.setHasChanged(true);
                        validator.wasValidated(null);
                        validator.dataChanged(null, null, null);
                    }
                    Thread.sleep(Math.max(0L, 2000L - (System.currentTimeMillis() - startTm)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                statusBar.setProgressDone("CLEAR_CACHE");
                UIRegistry.clearSimpleGlassPaneMsg();
                UIRegistry.displayLocalizedStatusBarText("SystemPrefs.CACHE_CLEARED", new Object[0]);
                UIHelper.centerWindow(parentDlg);
            }
        };
        UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getLocalizedMessage("SystemPrefs.CLEARING_CACHE", new Object[0]), 24);
        backupWorker.execute();
    }

    @Override
    public String getHelpContext() {
        return "PrefsSystem";
    }

    @Override
    public void savePrefs() {
        if (this.form.getValidator() == null || this.form.getValidator().hasChanged()) {
            super.savePrefs();
            ValCheckBox chk = (ValCheckBox)this.form.getCompById("2");
            this.localPrefs.putBoolean(VERSION_CHECK, (Boolean)chk.getValue());
            chk = (ValCheckBox)this.form.getCompById("3");
            this.remotePrefs.putBoolean(SEND_STATS, (Boolean)chk.getValue());
            chk = (ValCheckBox)this.form.getCompById("9");
            this.remotePrefs.putBoolean(SEND_ISA_STATS, (Boolean)chk.getValue());
            chk = (ValCheckBox)this.form.getCompById(USE_WORLDWIND);
            this.localPrefs.putBoolean(USE_WORLDWIND, (Boolean)chk.getValue());
            chk = (ValCheckBox)this.form.getCompById(SYSTEM_HasOpenGL);
            this.localPrefs.putBoolean(SYSTEM_HasOpenGL, (Boolean)chk.getValue());
            chk = (ValCheckBox)this.form.getCompById(USE_WORLDWIND);
            this.localPrefs.putBoolean(USE_WORLDWIND, (Boolean)chk.getValue());
            ValComboBox localeCBX = (ValComboBox)this.form.getCompById("5");
            Locale item = (Locale)localeCBX.getComboBox().getSelectedItem();
            if (item != null) {
                String newSplashPath;
                if (item.equals(UIRegistry.getPlatformLocale())) {
                    this.localPrefs.remove("locale.lang");
                    this.localPrefs.remove("locale.country");
                    this.localPrefs.remove("locale.var");
                    Locale.setDefault(UIRegistry.getPlatformLocale());
                } else {
                    if (item.getLanguage() == null) {
                        this.localPrefs.remove("locale.lang");
                    } else {
                        this.localPrefs.put("locale.lang", item.getLanguage());
                    }
                    if (item.getCountry() == null) {
                        this.localPrefs.remove("locale.country");
                    } else {
                        this.localPrefs.put("locale.country", item.getCountry());
                    }
                    if (item.getVariant() == null) {
                        this.localPrefs.remove("locale.var");
                    } else {
                        this.localPrefs.put("locale.var", item.getVariant());
                    }
                }
                ValBrowseBtnPanel browse = (ValBrowseBtnPanel)this.form.getCompById("7");
                if (!(browse == null || (newSplashPath = browse.getValue().toString()) == null || this.oldSplashPath != null && this.oldSplashPath.equals(newSplashPath))) {
                    if (newSplashPath.isEmpty()) {
                        SystemPrefs.resetSplashImage();
                        this.localPrefs.remove(SPECIFY_BG_IMG_PATH);
                    } else {
                        this.localPrefs.put(SPECIFY_BG_IMG_PATH, newSplashPath);
                        SystemPrefs.changeSplashImage();
                    }
                }
                try {
                    this.localPrefs.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
        }
    }

    public static void resetSplashImage() {
        IconEntry entry = IconManager.getIconEntryByName("SpecifySplash");
        IconEntry entryCache = IconManager.getIconEntryByName("SpecifySplashCache");
        entry.setIcon(entryCache.getIcon());
    }

    public static void changeSplashImage() {
        IconEntry entry;
        String userSplashIconPath = AppPreferences.getLocalPrefs().get(SPECIFY_BG_IMG_PATH, null);
        if (StringUtils.isNotEmpty((String)userSplashIconPath) && (entry = IconManager.getIconEntryByName("SpecifySplash")) != null) {
            try {
                entry.setIcon(new ImageIcon(userSplashIconPath));
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SystemPrefs.class, ex);
                ex.printStackTrace();
            }
        }
    }

    public class LocaleRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean iss, boolean chf) {
            super.getListCellRendererComponent((JList<?>)list, value, index, iss, chf);
            if (value != null) {
                this.setText(((Locale)value).getDisplayName());
            }
            return this;
        }
    }
}

