/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.prefs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.db.BackupServiceFactory;
import edu.ku.brc.af.core.db.MySQLBackupService;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.PrefsPanelIFace;
import edu.ku.brc.af.prefs.PrefsPanelMgrIFace;
import edu.ku.brc.af.prefs.PrefsSavable;
import edu.ku.brc.af.tasks.BackupTask;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.af.ui.forms.validation.ValBrowseBtnPanel;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.StringUtils;

public class MySQLPrefs
extends JPanel
implements PrefsSavable,
PrefsPanelIFace {
    static final String MYSQL_PREF_NAME = "Task.BackupTask";
    private static final String securityPrefix = "Prefs.";
    private final String MYSQL_LOC = "mysql.location";
    private final String MYSQLDUMP_LOC = "mysqldump.location";
    private final String MYSQLBCK_LOC = "backup.location";
    private ValBrowseBtnPanel mysqlLocBP = new ValBrowseBtnPanel(new ValTextField(), false, true);
    private ValBrowseBtnPanel mysqlDumpLocBP = new ValBrowseBtnPanel(new ValTextField(), false, true);
    private ValBrowseBtnPanel backupLocBP = new ValBrowseBtnPanel(new ValTextField(), true, true);
    private JButton backupBtn;
    private JButton restoreBtn;
    private boolean doShowRestore;
    private FormValidator validator = new FormValidator(null);
    protected PrefsPanelMgrIFace mgr = null;
    protected String name;
    protected String title;
    protected String hContext = "PrefsMySQL";
    protected Color shadeColor = null;
    protected PermissionIFace permissions = null;

    public MySQLPrefs() {
        this(false);
        this.validator.setName("MySQL Validator");
        this.validator.setNewObj(true);
        this.validator.hookupTextField(this.mysqlLocBP.getTextField(), "1", false, UIValidator.Type.Changed, null, true);
        this.validator.hookupTextField(this.mysqlDumpLocBP.getTextField(), "2", false, UIValidator.Type.Changed, null, true);
        this.validator.hookupTextField(this.backupLocBP.getTextField(), "3", false, UIValidator.Type.Changed, null, true);
    }

    public MySQLPrefs(boolean doShowRestore) {
        this.doShowRestore = doShowRestore;
        UIRegistry.loadAndPushResourceBundle("preferences");
        this.createUI();
        UIRegistry.popResourceBundle();
        this.setOpaque(false);
    }

    @Override
    public FormValidator getValidator() {
        return this.validator;
    }

    protected void createUI() {
        AppPreferences prefs = AppPreferences.getLocalPrefs();
        CellConstraints cc = new CellConstraints();
        this.backupBtn = UIHelper.createI18NButton("MYS_BACKUP");
        this.restoreBtn = UIHelper.createI18NButton("MYS_RESTORE");
        PanelBuilder btnPB = new PanelBuilder(new FormLayout("f:p:g,2px,p,5px,p,f:p:g", "p"));
        if (!UIRegistry.isMobile() && !UIRegistry.isEmbedded().booleanValue()) {
            btnPB.add((Component)this.backupBtn, cc.xy(3, 1));
            if (this.doShowRestore) {
                btnPB.add((Component)this.restoreBtn, cc.xy(5, 1));
            }
        }
        btnPB.setOpaque(false);
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,p,p:g,f:p:g", "p,2dlu,p,2dlu,p,2dlu,p,14px,p"), (JPanel)this);
        pb.addSeparator(UIRegistry.getResourceString("BCKRSTR_OPTIONS"), cc.xyw(1, 1, 5));
        pb.add((Component)UIHelper.createI18NFormLabel("MYS_DUMP_PATH"), cc.xy(1, 3));
        pb.add((Component)this.mysqlDumpLocBP, cc.xyw(3, 3, 3));
        pb.add((Component)UIHelper.createI18NFormLabel("MYS_RESTR_PATH"), cc.xy(1, 5));
        pb.add((Component)this.mysqlLocBP, cc.xyw(3, 5, 3));
        pb.add((Component)UIHelper.createI18NFormLabel("MYS_BCK_PATH"), cc.xy(1, 7));
        pb.add((Component)this.backupLocBP, cc.xyw(3, 7, 3));
        pb.add((Component)btnPB.getPanel(), cc.xyw(1, 9, 5));
        pb.setDefaultDialogBorder();
        String mysqlLoc = prefs.get("mysql.location", null);
        String mysqlDumpLoc = prefs.get("mysqldump.location", null);
        String backupLoc = prefs.get("backup.location", null);
        if (StringUtils.isEmpty((String)mysqlLoc)) {
            mysqlLoc = MySQLBackupService.getDefaultMySQLLoc();
        }
        if (StringUtils.isEmpty((String)mysqlDumpLoc)) {
            mysqlDumpLoc = MySQLBackupService.getDefaultMySQLDumpLoc();
        }
        if (StringUtils.isEmpty((String)backupLoc)) {
            backupLoc = MySQLBackupService.getDefaultBackupLoc();
        }
        this.mysqlLocBP.setValue(mysqlLoc, mysqlLoc);
        this.mysqlDumpLocBP.setValue(mysqlDumpLoc, mysqlDumpLoc);
        this.backupLocBP.setValue(backupLoc, backupLoc);
        DocumentAdaptor dl = new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                MySQLPrefs.this.validator.setHasChanged(true);
                MySQLPrefs.this.validator.validateRoot();
                MySQLPrefs.this.updateEnableUI();
            }
        };
        this.mysqlLocBP.getTextField().getDocument().addDocumentListener(dl);
        this.mysqlDumpLocBP.getTextField().getDocument().addDocumentListener(dl);
        this.backupLocBP.getTextField().getDocument().addDocumentListener(dl);
        this.backupBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((MySQLPrefs.this.mgr == null || MySQLPrefs.this.mgr.closePrefs()) && MySQLPrefs.this.isOKToSave()) {
                    BackupServiceFactory.getInstance().doBackUp();
                }
            }
        });
        this.restoreBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MySQLPrefs.this.isOKToSave()) {
                    MySQLPrefs.this.savePrefs();
                    MySQLPrefs.this.doRestore();
                }
            }
        });
        if (!this.doShowRestore && AppContextMgr.isSecurityOn()) {
            PermissionSettings perm = SecurityMgr.getInstance().getPermission(MYSQL_PREF_NAME);
            this.restoreBtn.setVisible(perm.canModify());
            this.backupBtn.setVisible(perm.canView());
        }
    }

    private void updateEnableUI() {
        this.backupBtn.setEnabled(!this.backupLocBP.getTextField().getText().isEmpty() && !this.mysqlDumpLocBP.getTextField().getText().isEmpty());
        this.restoreBtn.setEnabled(!this.mysqlLocBP.getTextField().getText().isEmpty());
    }

    protected void doRestore() {
        if (this.mgr == null || this.mgr.closePrefs()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SubPaneMgr.getInstance().aboutToShutdown()) {
                        Taskable task = TaskMgr.getTask("BackupTask");
                        if (task != null) {
                            SubPaneIFace splash = ((BackupTask)TaskMgr.getTask("BackupTask")).getSplashPane();
                            SubPaneMgr.getInstance().addPane(splash);
                            SubPaneMgr.getInstance().showPane(splash);
                        }
                        BackupServiceFactory.getInstance().doRestore();
                    }
                }
            });
        }
    }

    @Override
    public boolean isOKToSave() {
        return true;
    }

    @Override
    public void savePrefs() {
        AppPreferences prefs = AppPreferences.getLocalPrefs();
        prefs.put("mysql.location", (String)this.mysqlLocBP.getValue());
        prefs.put("mysqldump.location", (String)this.mysqlDumpLocBP.getValue());
        prefs.put("backup.location", (String)this.backupLocBP.getValue());
    }

    @Override
    public boolean isOKToLoad() {
        Institution institution = AppContextMgr.getInstance().getClassObject(Institution.class);
        return institution.getIsServerBased() == false;
    }

    @Override
    public void getChangedFields(Properties changeHash) {
    }

    @Override
    public PermissionIFace getPermissions() {
        if (this.permissions == null) {
            this.permissions = SecurityMgr.getInstance().getPermission(securityPrefix + this.getPermissionName());
        }
        return this.permissions;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    protected String getPermissionName() {
        return this.name;
    }

    @Override
    public void setPermissions(PermissionIFace permissions) {
        this.permissions = permissions;
    }

    @Override
    public void setPrefsPanelMgr(PrefsPanelMgrIFace mgrArg) {
        this.mgr = mgrArg;
    }

    @Override
    public String getHelpContext() {
        return this.hContext;
    }

    @Override
    public void setHelpContext(String context) {
        this.hContext = context;
    }

    @Override
    public void setShadeColor(Color color) {
        this.shadeColor = color;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean isFormValid() {
        String mysql = this.mysqlLocBP.getTextField().getText();
        String mysqldump = this.mysqlDumpLocBP.getTextField().getText();
        return StringUtils.isNotEmpty((String)mysql) && StringUtils.contains((String)mysql.toLowerCase(), (String)"mysql") && StringUtils.isNotEmpty((String)mysqldump) && StringUtils.contains((String)mysqldump.toLowerCase(), (String)"mysqldump") && StringUtils.isNotEmpty((String)this.backupLocBP.getTextField().getText());
    }

    @Override
    public void setTitle(String titleArg) {
        this.title = titleArg;
    }
}

