/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.prefs;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.GenericPrefsPanel;
import edu.ku.brc.af.prefs.PrefsPanelIFace;
import edu.ku.brc.af.prefs.PrefsSavable;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.af.ui.forms.validation.ValSpinner;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Agent;

public class LoansPrefsPanel
extends GenericPrefsPanel
implements PrefsSavable,
PrefsPanelIFace {
    public LoansPrefsPanel() {
        this.createUI();
    }

    protected void createUI() {
        ValComboBoxFromQuery shippedBy;
        ValComboBox shipMeth;
        this.createForm("Preferences", "LoansPrefs");
        AppPreferences prefs = AppPreferences.getRemote();
        Integer dueInMonths = prefs.getInt("loans.dueinmons", 6);
        String shippingMethod = prefs.get("loans.shipmeth", null);
        Integer shippedByAgentId = prefs.getInt("loans.shippedby", null);
        FormViewObj fvo = (FormViewObj)this.form;
        ValSpinner dueSpinner = (ValSpinner)fvo.getCompById("OVERDUETIME");
        if (dueSpinner != null) {
            dueSpinner.setValue(dueInMonths);
        }
        if ((shipMeth = (ValComboBox)fvo.getCompById("SHIPMETH")) != null) {
            shipMeth.setValue(shippingMethod, null);
        }
        if ((shippedBy = (ValComboBoxFromQuery)fvo.getCompById("SHIPPEDBY")) != null && shippedByAgentId != null) {
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    Agent agent = session.get(Agent.class, shippedByAgentId);
                    shippedBy.setValue(agent, null);
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ValComboBoxFromQuery.class, ex);
                    ex.printStackTrace();
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    @Override
    public void savePrefs() {
        ValComboBoxFromQuery shippedBy;
        String method;
        ValComboBox shipMeth;
        Integer val;
        AppPreferences prefs = AppPreferences.getRemote();
        FormViewObj fvo = (FormViewObj)this.form;
        ValSpinner dueSpinner = (ValSpinner)fvo.getCompById("OVERDUETIME");
        if (dueSpinner != null && (val = (Integer)dueSpinner.getValue()) != null) {
            prefs.putInt("loans.dueinmons", val);
        }
        if ((shipMeth = (ValComboBox)fvo.getCompById("SHIPMETH")) != null && (method = (String)shipMeth.getValue()) != null) {
            prefs.put("loans.shipmeth", method);
        }
        if ((shippedBy = (ValComboBoxFromQuery)fvo.getCompById("SHIPPEDBY")) != null) {
            Agent agent = (Agent)shippedBy.getValue();
            if (agent != null) {
                prefs.putInt("loans.shippedby", agent.getAgentId());
            } else {
                prefs.remove("loans.shippedby");
            }
        }
    }
}

