/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.prefs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.GenericLSIDGeneratorFactory;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.GenericPrefsPanel;
import edu.ku.brc.af.ui.forms.validation.DataChangeNotifier;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.specify.tasks.StartUpTask;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;

public class LSIDPrefsPanel
extends GenericPrefsPanel {
    protected static String PREF_NAME_PREFIX = "Prefs.LSID.";
    protected Hashtable<GenericLSIDGeneratorFactory.CATEGORY_TYPE, ValCheckBox> checkBoxes = new Hashtable();
    protected ValCheckBox useVersioning;
    protected FormValidator validator = new FormValidator(null);

    public LSIDPrefsPanel() {
        this.name = this.title = "LSIDPrefsPanel";
        this.hContext = "PrefsLSID";
        this.validator.setName("LSID Validator");
        this.validator.setNewObj(true);
        UIRegistry.loadAndPushResourceBundle("preferences");
        this.createUI();
        UIRegistry.popResourceBundle();
    }

    protected void createUI() {
        ArrayList<String> list = new ArrayList<String>(GenericLSIDGeneratorFactory.CATEGORY_TYPE.values().length);
        GenericLSIDGeneratorFactory.CATEGORY_TYPE[] cATEGORY_TYPEArray = GenericLSIDGeneratorFactory.CATEGORY_TYPE.values();
        int n = cATEGORY_TYPEArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericLSIDGeneratorFactory.CATEGORY_TYPE cat = cATEGORY_TYPEArray[n2];
            list.add(cat.toString());
            ++n2;
        }
        Collections.sort(list);
        CellConstraints cc = new CellConstraints();
        AppPreferences remote = AppPreferences.getRemote();
        String rowDef = UIHelper.createDuplicateJGoodiesDef("p", "2px", GenericLSIDGeneratorFactory.CATEGORY_TYPE.values().length + 1);
        PanelBuilder pb = new PanelBuilder(new FormLayout("10px,p,f:p:g", String.valueOf(rowDef) + ",10px,p,10px,p"), (JPanel)this);
        pb.addSeparator(UIRegistry.getResourceString("LSSEP"), cc.xyw(1, 1, 3));
        int y = 3;
        GenericLSIDGeneratorFactory.CATEGORY_TYPE[] cATEGORY_TYPEArray2 = GenericLSIDGeneratorFactory.CATEGORY_TYPE.values();
        int n3 = cATEGORY_TYPEArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            GenericLSIDGeneratorFactory.CATEGORY_TYPE cat = cATEGORY_TYPEArray2[n4];
            String pName = String.valueOf(PREF_NAME_PREFIX) + cat.toString();
            ValCheckBox vcb = new ValCheckBox(cat.toString(), false, false);
            this.checkBoxes.put(cat, vcb);
            vcb.setSelected(remote.getBoolean(pName, false));
            pb.add((Component)vcb, cc.xy(2, y));
            DataChangeNotifier dcn = this.validator.createDataChangeNotifer(pName, vcb, null);
            vcb.addActionListener(dcn);
            y += 2;
            ++n4;
        }
        pb.addSeparator(UIRegistry.getResourceString("LSADD"), cc.xyw(1, y, 3));
        y += 2;
        String pName = String.valueOf(PREF_NAME_PREFIX) + "UseVersioning";
        this.useVersioning = new ValCheckBox("Use Versioning", false, false);
        this.useVersioning.setSelected(remote.getBoolean(pName, false));
        DataChangeNotifier dcn = this.validator.createDataChangeNotifer(pName, this.useVersioning, null);
        this.useVersioning.addActionListener(dcn);
        JButton updateLSIDsBtn = UIHelper.createI18NButton("CREATE_LSIDS");
        updateLSIDsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LSIDPrefsPanel.this.savePrefs();
                LSIDPrefsPanel.this.createLSIDs();
            }
        });
        PanelBuilder pbInner = new PanelBuilder(new FormLayout("p,20px,p", "p"));
        pbInner.add((Component)updateLSIDsBtn, cc.xy(1, 1));
        pb.add((Component)pbInner.getPanel(), cc.xyw(1, y, 3));
        y += 2;
        pb.setDefaultDialogBorder();
    }

    protected void createLSIDs() {
        if (this.mgr == null || this.mgr.closePrefs()) {
            String COUNT = "COUNT";
            final GhostGlassPane glassPane = UIRegistry.writeGlassPaneMsg(UIRegistry.getResourceString("SETTING_LSIDS"), UIRegistry.STD_FONT_SIZE);
            glassPane.setProgress(0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SubPaneMgr.getInstance().aboutToShutdown()) {
                        Taskable task = TaskMgr.getTask("Startup");
                        if (task != null) {
                            SubPaneIFace splash = StartUpTask.createFullImageSplashPanel(task.getTitle(), task);
                            SubPaneMgr.getInstance().addPane(splash);
                            SubPaneMgr.getInstance().showPane(splash);
                        }
                        LSIDWorker worker = new LSIDWorker(LSIDPrefsPanel.this){

                            @Override
                            protected Integer doInBackground() throws Exception {
                                GenericLSIDGeneratorFactory.getInstance().buildLSIDs(this);
                                return null;
                            }

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                if (evt.getPropertyName().equals("COUNT")) {
                                    this.firePropertyChange("COUNT", 0, evt.getNewValue());
                                }
                            }

                            @Override
                            protected void done() {
                                glassPane.setProgress(100);
                                UIRegistry.clearGlassPaneMsg();
                            }
                        };
                        worker.addPropertyChangeListener(new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                if ("COUNT".equals(evt.getPropertyName())) {
                                    glassPane.setProgress((int)((double)((Integer)evt.getNewValue()).intValue() * 100.0 / (double)GenericLSIDGeneratorFactory.CATEGORY_TYPE.values().length));
                                }
                            }
                        });
                        worker.execute();
                    }
                }
            });
        }
    }

    @Override
    public FormValidator getValidator() {
        return this.validator;
    }

    @Override
    public void getChangedFields(Properties changeHash) {
        for (String key : this.validator.getDCNs().keySet()) {
            Object value;
            String[] toks = StringUtils.split((String)key, (String)".");
            ValCheckBox chkbx = toks[2].startsWith("Use") ? this.useVersioning : this.checkBoxes.get((Object)GenericLSIDGeneratorFactory.CATEGORY_TYPE.valueOf(toks[2]));
            if (!chkbx.isChanged() || (value = chkbx.getValue()) == null) continue;
            changeHash.put(key, value);
        }
    }

    @Override
    public boolean isFormValid() {
        return true;
    }

    @Override
    public void savePrefs() {
        AppPreferences remote = AppPreferences.getRemote();
        for (String key : this.validator.getDCNs().keySet()) {
            Object value;
            String[] toks = StringUtils.split((String)key, (String)".");
            ValCheckBox chkbx = toks[2].indexOf("Use") > -1 ? this.useVersioning : this.checkBoxes.get((Object)GenericLSIDGeneratorFactory.CATEGORY_TYPE.valueOf(toks[2]));
            if (!chkbx.isChanged() || (value = chkbx.getValue()) == null) continue;
            remote.putBoolean(key, chkbx.isSelected());
        }
    }

    class LSIDWorker
    extends SwingWorker<Integer, Integer>
    implements PropertyChangeListener {
        LSIDWorker() {
        }

        @Override
        protected Integer doInBackground() throws Exception {
            return null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
        }

        @Override
        protected void done() {
            super.done();
        }
    }
}

