/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.prefs;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.GenericPrefsPanel;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.datamodel.Discipline;
import java.util.Properties;

public class GEOLocatePrefsPanel
extends GenericPrefsPanel {
    private static final String GL_HYWX = "GEOLocate.HYWX";
    private static final String GL_WTRBODY = "GEOLocate.WATERBODY";
    private static final String GL_RESTRICT = "GEOLocate.RESTRICTTOLOWESTADM";
    private static final String GL_DOUNCERT = "GEOLocate.DOUNCERT";
    private static final String GL_DOPOLY = "GEOLocate.DOPOLY";
    private static final String GL_DISPLACEPOLY = "GEOLocate.DISPLACEPOLY";
    private static final String GL_LANGKEY = "GEOLocate.LANGUAGEKEY";
    private static final String GL_USEGL_MAPS = "GEOLocate.USEGL_MAPS";
    protected ValCheckBox hywXCBX;
    protected ValCheckBox waterBodyCBX;
    protected ValCheckBox restrictToLowestAdmCBX;
    protected ValCheckBox doUncertCBX;
    protected ValCheckBox doPolyCBX;
    protected ValCheckBox displacePolyCBX;
    protected ValCheckBox geoLocMapServerCBX;
    protected ValComboBox languageKeyCoBX;

    public GEOLocatePrefsPanel() {
        this.createUI();
    }

    protected void createUI() {
        this.createForm("Preferences", "GEOLocatePrefs");
        AppPreferences prefs = AppPreferences.getRemote();
        String languageKey = prefs.get(GL_LANGKEY, "English");
        FormViewObj fvo = (FormViewObj)this.form;
        this.languageKeyCoBX = (ValComboBox)fvo.getCompById(GL_LANGKEY);
        if (this.languageKeyCoBX != null) {
            this.languageKeyCoBX.setValue(languageKey, null);
        }
    }

    @Override
    public void createForm(String viewSetName, String viewName) {
        super.createForm(viewSetName, viewName);
        this.hywXCBX = (ValCheckBox)this.form.getCompById(GL_HYWX);
        this.waterBodyCBX = (ValCheckBox)this.form.getCompById(GL_WTRBODY);
        this.restrictToLowestAdmCBX = (ValCheckBox)this.form.getCompById(GL_RESTRICT);
        this.doUncertCBX = (ValCheckBox)this.form.getCompById(GL_DOUNCERT);
        this.doPolyCBX = (ValCheckBox)this.form.getCompById(GL_DOPOLY);
        this.displacePolyCBX = (ValCheckBox)this.form.getCompById(GL_DISPLACEPOLY);
        this.languageKeyCoBX = (ValComboBox)this.form.getCompById(GL_LANGKEY);
        this.geoLocMapServerCBX = (ValCheckBox)this.form.getCompById(GL_USEGL_MAPS);
        boolean isFish = Discipline.isCurrentDiscipline(DisciplineType.STD_DISCIPLINES.fish);
        AppPreferences locPrefs = AppPreferences.getLocalPrefs();
        this.hywXCBX.setValue(locPrefs.getBoolean(GL_HYWX, isFish), null);
        this.waterBodyCBX.setValue(locPrefs.getBoolean(GL_WTRBODY, isFish), null);
        this.restrictToLowestAdmCBX.setValue(locPrefs.getBoolean(GL_RESTRICT, false), null);
        this.doUncertCBX.setValue(locPrefs.getBoolean(GL_DOUNCERT, isFish), null);
        this.doPolyCBX.setValue(locPrefs.getBoolean(GL_DOPOLY, isFish), null);
        this.displacePolyCBX.setValue(locPrefs.getBoolean(GL_DISPLACEPOLY, isFish), null);
        this.geoLocMapServerCBX.setValue(locPrefs.getBoolean(GL_USEGL_MAPS, true), null);
    }

    public Viewable getForm() {
        return this.form;
    }

    @Override
    public void getChangedFields(Properties changeHash) {
        this.checkChanged(this.hywXCBX, GL_HYWX, changeHash);
        this.checkChanged(this.waterBodyCBX, GL_WTRBODY, changeHash);
    }

    private void checkChanged(ValCheckBox cbx, String cmpName, Properties changeHash) {
        Object value;
        if (cbx != null && cbx.isChanged() && (value = cbx.getValue()) != null) {
            changeHash.put(cmpName, value);
        }
    }

    @Override
    public boolean isFormValid() {
        return true;
    }

    private void saveCBX(ValCheckBox cbx, String prefName) {
        Object value;
        if (cbx.isChanged() && (value = cbx.getValue()) != null) {
            AppPreferences.getLocalPrefs().putBoolean(prefName, cbx.isSelected());
        }
    }

    private void saveCoBX(ValComboBox cbx, String prefName) {
        String method;
        if (cbx.isChanged() && (method = (String)cbx.getValue()) != null) {
            AppPreferences.getRemote().put(prefName, method);
        }
    }

    @Override
    public void savePrefs() {
        this.saveCBX(this.hywXCBX, GL_HYWX);
        this.saveCBX(this.waterBodyCBX, GL_WTRBODY);
        this.saveCBX(this.restrictToLowestAdmCBX, GL_RESTRICT);
        this.saveCBX(this.doUncertCBX, GL_DOUNCERT);
        this.saveCBX(this.doPolyCBX, GL_DOPOLY);
        this.saveCBX(this.displacePolyCBX, GL_DISPLACEPOLY);
        this.saveCBX(this.geoLocMapServerCBX, GL_USEGL_MAPS);
        this.saveCoBX(this.languageKeyCoBX, GL_LANGKEY);
    }
}

