/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.prefs;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.GenericPrefsPanel;
import edu.ku.brc.af.prefs.PrefsPanelIFace;
import edu.ku.brc.af.prefs.PrefsSavable;
import edu.ku.brc.af.tasks.BaseTask;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.helpers.ImageFilter;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.ui.GraphicsUtils;
import edu.ku.brc.ui.IconEntry;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;

public class FormattingPrefsPanel
extends GenericPrefsPanel
implements PrefsPanelIFace,
PrefsSavable {
    protected static final String iconPrefName = "ui.formatting.user_icon_path";
    protected static final String iconImagePrefName = "ui.formatting.user_icon_image";
    protected static final String iconImageDiscipPrefName = "ui.formatting.disciplineicon";
    protected static final String BNR_ICON_SIZE = "banner.icon.size";
    protected final String INNER_APPICON_NAME = "InnerAppIcon";
    protected final int[] pixelSizes = new int[]{16, 20, 24, 32};
    protected final int BASE_FONT_SIZE = 6;
    protected JComboBox fontNames = null;
    protected JComboBox fontSizes = null;
    protected JComboBox controlSizes = null;
    protected ValComboBox formTypesCBX = null;
    protected JTextField testField = null;
    protected ValComboBox disciplineCBX;
    protected ValComboBox appIconCBX;
    protected String newAppIconName = null;
    protected ValComboBox dateFieldCBX;
    protected boolean clearFontSettings = false;
    protected ValComboBox bnrIconSizeCBX;
    protected Hashtable<String, UIHelper.CONTROLSIZE> controlSizesHash = new Hashtable();
    protected Hashtable<String, String> formTypeHash = new Hashtable();

    public FormattingPrefsPanel() {
        this.createUI();
    }

    protected void addFormats(Vector<String> formats, Character ch) {
        formats.add("MM" + ch + "dd" + ch + "yyyy");
        formats.add("dd" + ch + "MM" + ch + "yyyy");
        formats.add("yyyy" + ch + "MM" + ch + "dd");
        formats.add("yyyy" + ch + "dd" + ch + "MM");
    }

    protected void fillDateFormat() {
        String currentFormat = AppPreferences.getRemote().get("ui.formatting.scrdateformat", null);
        TimeZone tz = TimeZone.getDefault();
        DateFormat dateFormatter = DateFormat.getDateInstance(3, Locale.getDefault());
        dateFormatter.setTimeZone(tz);
        String dateStr = dateFormatter.format(Calendar.getInstance().getTime());
        Character ch = null;
        int i = 0;
        while (i < 10) {
            if (!StringUtils.isNumeric((String)dateStr.substring(i, i + 1))) {
                ch = Character.valueOf(dateStr.charAt(i));
                break;
            }
            ++i;
        }
        if (ch != null) {
            boolean skip = false;
            Vector<String> formats = new Vector<String>();
            if (ch.charValue() == '/') {
                this.addFormats(formats, Character.valueOf('/'));
                skip = true;
            }
            if (ch.charValue() != '.') {
                this.addFormats(formats, Character.valueOf('.'));
                skip = true;
            }
            if (ch.charValue() != '-') {
                this.addFormats(formats, Character.valueOf('-'));
                skip = true;
            }
            if (!skip) {
                this.addFormats(formats, ch);
            }
            int selectedInx = 0;
            int inx = 0;
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.dateFieldCBX.getModel();
            for (String fmt : formats) {
                model.addElement(fmt);
                if (currentFormat != null && currentFormat.equals(fmt)) {
                    selectedInx = inx;
                }
                ++inx;
            }
            this.dateFieldCBX.getComboBox().setSelectedIndex(selectedInx);
        }
    }

    protected void fillFormTypes() {
        String[] formTypeArray = new String[]{"win", "lnx", "mac", "exp"};
        String[] formTypeDesc = new String[]{"Small Font Format (ideal for Windows)", "Medium Font Format (ideal for Linux)", "Large Font Format (ideal for Mac)", "Elastic Layout"};
        String curFormType = AppPreferences.getLocalPrefs().get("ui.formatting.formtype", UIHelper.getOSTypeAsStr());
        int selectedInx = 0;
        int inx = 0;
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.formTypesCBX.getModel();
        String[] stringArray = formTypeArray;
        int n = formTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            model.addElement(formTypeDesc[inx]);
            this.formTypeHash.put(formTypeDesc[inx], type);
            if (curFormType != null && curFormType.equals(type)) {
                selectedInx = inx;
            }
            ++inx;
            ++n2;
        }
        this.formTypesCBX.getComboBox().setSelectedIndex(selectedInx);
        this.formTypesCBX.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormattingPrefsPanel.this.form.getValidator().dataChanged(null, null, null);
            }
        });
    }

    protected void createUI() {
        int n;
        this.createForm("Preferences", "Formatting");
        UIValidator.setIgnoreAllValidation(this, true);
        JLabel fontNamesLabel = this.form.getLabelFor("fontNames");
        ValComboBox fontNamesVCB = (ValComboBox)this.form.getCompById("fontNames");
        JLabel fontSizesLabel = this.form.getLabelFor("fontSizes");
        ValComboBox fontSizesVCB = (ValComboBox)this.form.getCompById("fontSizes");
        JLabel controlSizesLabel = this.form.getLabelFor("controlSizes");
        ValComboBox controlSizesVCB = (ValComboBox)this.form.getCompById("controlSizes");
        this.formTypesCBX = (ValComboBox)this.form.getCompById("formtype");
        this.fontNames = fontNamesVCB.getComboBox();
        this.fontSizes = fontSizesVCB.getComboBox();
        this.controlSizes = controlSizesVCB.getComboBox();
        this.testField = (JTextField)this.form.getCompById("fontTest");
        if (this.testField != null) {
            this.testField.setText(UIRegistry.getResourceString("FormattingPrefsPanel.THIS_TEST"));
        }
        if (UIHelper.isMacOS_10_5_X()) {
            fontNamesLabel.setVisible(false);
            fontNamesVCB.setVisible(false);
            fontSizesLabel.setVisible(false);
            fontSizesVCB.setVisible(false);
            this.testField.setVisible(false);
            int inx = -1;
            int i = 0;
            Vector<String> controlSizeTitles = new Vector<String>();
            UIHelper.CONTROLSIZE[] cONTROLSIZEArray = UIHelper.CONTROLSIZE.values();
            int n2 = cONTROLSIZEArray.length;
            n = 0;
            while (n < n2) {
                UIHelper.CONTROLSIZE cs = cONTROLSIZEArray[n];
                String titleStr = UIRegistry.getResourceString(cs.toString());
                controlSizeTitles.add(titleStr);
                this.controlSizesHash.put(titleStr, cs);
                this.controlSizes.addItem(titleStr);
                if (cs == UIHelper.getControlSize()) {
                    inx = i;
                }
                ++i;
                ++n;
            }
            this.controlSizes.setSelectedIndex(inx);
            Font baseFont = UIRegistry.getBaseFont();
            if (baseFont != null) {
                this.fontNames.addItem(baseFont.getFamily());
                this.fontSizes.addItem(Integer.toString(baseFont.getSize()));
                this.fontNames.setSelectedIndex(0);
                this.fontSizes.setSelectedIndex(0);
            }
        } else {
            controlSizesLabel.setVisible(false);
            controlSizesVCB.setVisible(false);
            Hashtable<String, Boolean> namesUsed = new Hashtable<String, Boolean>();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font[] fontArray = ge.getAllFonts();
            n = fontArray.length;
            int baseFont = 0;
            while (baseFont < n) {
                Font font = fontArray[baseFont];
                if (namesUsed.get(font.getFamily()) == null) {
                    this.fontNames.addItem(font.getFamily());
                    namesUsed.put(font.getFamily(), true);
                }
                ++baseFont;
            }
            int i = 6;
            while (i < 22) {
                this.fontSizes.addItem(Integer.toString(i));
                ++i;
            }
            Font baseFont2 = UIRegistry.getBaseFont();
            if (baseFont2 != null) {
                this.fontNames.setSelectedItem(baseFont2.getFamily());
                this.fontSizes.setSelectedItem(Integer.toString(baseFont2.getSize()));
                if (this.testField != null) {
                    ActionListener al = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            FormattingPrefsPanel.this.testField.setFont(new Font((String)FormattingPrefsPanel.this.fontNames.getSelectedItem(), 0, FormattingPrefsPanel.this.fontSizes.getSelectedIndex() + 6));
                            FormattingPrefsPanel.this.form.getUIComponent().validate();
                            FormattingPrefsPanel.this.clearFontSettings = false;
                        }
                    };
                    this.fontNames.addActionListener(al);
                    this.fontSizes.addActionListener(al);
                }
            }
        }
        String iconName = AppPreferences.getRemote().get(FormattingPrefsPanel.getDisciplineImageName(), "CollectionObject");
        List<Pair<String, ImageIcon>> list = IconManager.getListByType("disciplines", IconManager.IconSize.Std16);
        Collections.sort(list, new Comparator<Pair<String, ImageIcon>>(){

            @Override
            public int compare(Pair<String, ImageIcon> o1, Pair<String, ImageIcon> o2) {
                String s1 = UIRegistry.getResourceString((String)o1.first);
                String s2 = UIRegistry.getResourceString((String)o2.first);
                return s1.compareTo(s2);
            }
        });
        this.disciplineCBX = (ValComboBox)this.form.getCompById("disciplineIconCBX");
        final JLabel dispLabel = (JLabel)this.form.getCompById("disciplineIcon");
        JComboBox comboBox = this.disciplineCBX.getComboBox();
        comboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList listArg, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Pair item = (Pair)value;
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)listArg, value, index, isSelected, cellHasFocus);
                if (item != null) {
                    label.setIcon((Icon)item.second);
                    label.setText(UIRegistry.getResourceString((String)item.first));
                }
                return label;
            }
        });
        int inx = 0;
        Pair<String, ImageIcon> colObj = new Pair<String, ImageIcon>("colobj_backstop", IconManager.getIcon("colobj_backstop", IconManager.IconSize.Std16));
        comboBox.addItem(colObj);
        int cnt = 1;
        for (Pair<String, ImageIcon> item : list) {
            if (((String)item.first).equals(iconName)) {
                inx = cnt;
            }
            comboBox.addItem(item);
            ++cnt;
        }
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cbx = (JComboBox)e.getSource();
                Pair item = (Pair)cbx.getSelectedItem();
                if (item != null) {
                    dispLabel.setIcon(IconManager.getIcon((String)item.first));
                    FormattingPrefsPanel.this.form.getUIComponent().validate();
                }
            }
        });
        comboBox.setSelectedIndex(inx);
        this.dateFieldCBX = (ValComboBox)this.form.getCompById("scrdateformat");
        this.fillDateFormat();
        this.fillFormTypes();
        JButton getIconBtn = (JButton)this.form.getCompById("GetIconImage");
        final JButton clearIconBtn = (JButton)this.form.getCompById("ClearIconImage");
        final JLabel appLabel = (JLabel)this.form.getCompById("appIcon");
        JButton resetDefFontBtn = (JButton)this.form.getCompById("ResetDefFontBtn");
        String imgEncoded = AppPreferences.getRemote().get(iconImagePrefName, "");
        ImageIcon innerAppImgIcon = null;
        if (StringUtils.isNotEmpty((String)imgEncoded)) {
            innerAppImgIcon = GraphicsUtils.uudecodeImage("", imgEncoded);
            if (innerAppImgIcon != null && innerAppImgIcon.getIconWidth() != 32 || innerAppImgIcon.getIconHeight() != 32) {
                innerAppImgIcon = null;
                clearIconBtn.setEnabled(false);
            } else {
                clearIconBtn.setEnabled(true);
            }
        }
        if (innerAppImgIcon == null) {
            innerAppImgIcon = IconManager.getIcon("AppIcon");
            clearIconBtn.setEnabled(false);
        } else {
            clearIconBtn.setEnabled(true);
        }
        appLabel.setIcon(innerAppImgIcon);
        getIconBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormattingPrefsPanel.this.chooseToolbarIcon(appLabel, clearIconBtn);
            }
        });
        clearIconBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageIcon appIcon = IconManager.getIcon("AppIcon");
                IconEntry entry = IconManager.getIconEntryByName("InnerAppIcon");
                entry.setIcon(appIcon);
                if (entry.getIcons().get((Object)IconManager.IconSize.Std32) != null) {
                    entry.getIcons().get((Object)IconManager.IconSize.Std32).setImageIcon(appIcon);
                }
                appLabel.setIcon(IconManager.getIcon("AppIcon"));
                clearIconBtn.setEnabled(false);
                AppPreferences.getRemote().remove(FormattingPrefsPanel.iconImagePrefName);
                FormattingPrefsPanel.this.form.getValidator().dataChanged(null, null, null);
            }
        });
        resetDefFontBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font sysDefFont = UIRegistry.getDefaultFont();
                ComboBoxModel model = FormattingPrefsPanel.this.fontNames.getModel();
                int i = 0;
                while (i < model.getSize()) {
                    if (model.getElementAt(i).toString().equals(sysDefFont.getFamily())) {
                        FormattingPrefsPanel.this.fontNames.setSelectedIndex(i);
                        FormattingPrefsPanel.this.clearFontSettings = true;
                        break;
                    }
                    ++i;
                }
                if (FormattingPrefsPanel.this.clearFontSettings) {
                    FormattingPrefsPanel.this.fontSizes.setSelectedIndex(sysDefFont.getSize() - 6);
                    FormattingPrefsPanel.this.clearFontSettings = true;
                }
                FormattingPrefsPanel.this.form.getValidator().dataChanged(null, null, null);
            }
        });
        String fmtStr = "%d x %d pixels";
        this.bnrIconSizeCBX = (ValComboBox)this.form.getCompById("bnrIconSizeCBX");
        int size = AppPreferences.getLocalPrefs().getInt(BNR_ICON_SIZE, 20);
        inx = 0;
        cnt = 0;
        int[] nArray = this.pixelSizes;
        int n3 = this.pixelSizes.length;
        int n4 = 0;
        while (n4 < n3) {
            int pixelSize = nArray[n4];
            ((DefaultComboBoxModel)this.bnrIconSizeCBX.getModel()).addElement(String.format(fmtStr, pixelSize, pixelSize));
            if (pixelSize == size) {
                inx = cnt;
            }
            ++cnt;
            ++n4;
        }
        this.bnrIconSizeCBX.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormattingPrefsPanel.this.form.getUIComponent().validate();
            }
        });
        this.bnrIconSizeCBX.getComboBox().setSelectedIndex(inx);
        UIValidator.setIgnoreAllValidation(this, false);
        fontNamesVCB.setChanged(false);
        fontSizesVCB.setChanged(false);
        this.form.getValidator().validateForm();
    }

    protected void chooseToolbarIcon(JLabel appLabel, JButton clearIconBtn) {
        String fullPath;
        File imageFile;
        FileDialog fileDialog = new FileDialog((Frame)UIRegistry.get("frame"), UIRegistry.getResourceString("PREF_CHOOSE_APPICON_TITLE"), 0);
        fileDialog.setFilenameFilter(new ImageFilter());
        UIHelper.centerAndShow(fileDialog);
        fileDialog.dispose();
        String path = fileDialog.getDirectory();
        if (StringUtils.isNotEmpty((String)path) && (imageFile = new File(fullPath = String.valueOf(path) + File.separator + fileDialog.getFile())).exists()) {
            ImageIcon appIcon;
            ImageIcon newIcon = null;
            ImageIcon icon = new ImageIcon(fullPath);
            if (icon.getIconWidth() != -1 && icon.getIconHeight() != -1) {
                if (icon.getIconWidth() > 32 || icon.getIconHeight() > 32) {
                    Image img = GraphicsUtils.getScaledImage(icon, 32, 32, false);
                    if (img != null) {
                        newIcon = new ImageIcon(img);
                    }
                } else {
                    newIcon = icon;
                }
            }
            if (newIcon != null) {
                appLabel.setIcon(newIcon);
                clearIconBtn.setEnabled(true);
                String imgBufStr = GraphicsUtils.uuencodeImage(this.newAppIconName, newIcon);
                AppPreferences.getRemote().put(iconImagePrefName, imgBufStr);
                appIcon = newIcon;
            } else {
                appIcon = IconManager.getIcon("AppIcon");
                appLabel.setIcon(appIcon);
                clearIconBtn.setEnabled(false);
                AppPreferences.getRemote().remove(iconImagePrefName);
            }
            IconEntry entry = IconManager.getIconEntryByName("InnerAppIcon");
            entry.setIcon(appIcon);
            if (entry.getIcons().get((Object)IconManager.IconSize.Std32) != null) {
                entry.getIcons().get((Object)IconManager.IconSize.Std32).setImageIcon(appIcon);
            }
            this.form.getValidator().dataChanged(null, null, null);
        }
    }

    public static String getDisciplineImageName() {
        Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
        if (collection != null) {
            return "ui.formatting.disciplineicon." + collection.getCollectionName();
        }
        return null;
    }

    @Override
    public String getHelpContext() {
        return "PrefsFormatting";
    }

    @Override
    public void getChangedFields(Properties changeHash) {
        Pair item;
        super.getChangedFields(changeHash);
        if (this.disciplineCBX.isChanged() && (item = (Pair)this.disciplineCBX.getComboBox().getSelectedItem()) != null) {
            changeHash.put(FormattingPrefsPanel.getDisciplineImageName(), item.first);
        }
        if (UIHelper.isMacOS_10_5_X()) {
            changeHash.remove("fontSizes");
            changeHash.remove("fontNames");
            changeHash.remove("controlSizes");
        } else {
            changeHash.remove("controlSizes");
        }
    }

    @Override
    public void savePrefs() {
        if (this.form.getValidator() == null || this.form.getValidator().hasChanged()) {
            String key;
            int inx;
            super.savePrefs();
            Pair item = (Pair)this.disciplineCBX.getComboBox().getSelectedItem();
            if (item != null) {
                AppPreferences.getRemote().put(FormattingPrefsPanel.getDisciplineImageName(), (String)item.first);
                IconManager.aliasImages((String)item.first, "collectionobject");
                IconManager.aliasImages((String)item.first, "CollectionObject");
            }
            if ((inx = this.bnrIconSizeCBX.getComboBox().getSelectedIndex()) > -1) {
                AppPreferences.getLocalPrefs().putInt(BNR_ICON_SIZE, this.pixelSizes[inx]);
            }
            AppPreferences local = AppPreferences.getLocalPrefs();
            if (!UIHelper.isMacOS_10_5_X()) {
                key = "ui.formatting.controlSizes";
                if (this.clearFontSettings) {
                    local.remove(String.valueOf(key) + ".FN");
                    local.remove(String.valueOf(key) + ".SZ");
                    UIRegistry.setBaseFont(UIRegistry.getDefaultFont());
                    BaseTask.setToolbarBtnFont(UIRegistry.getBaseFont());
                    RolloverCommand.setDefaultFont(UIRegistry.getBaseFont());
                } else {
                    Font baseFont = UIRegistry.getBaseFont();
                    if (!baseFont.getFamily().equals(this.fontNames.getSelectedItem()) || baseFont.getSize() != this.fontSizes.getSelectedIndex() + 6) {
                        Font newBaseFont = UIRegistry.adjustPerDefaultFont(new Font((String)this.fontNames.getSelectedItem(), 0, this.fontSizes.getSelectedIndex() + 6));
                        UIRegistry.setBaseFont(newBaseFont);
                        BaseTask.setToolbarBtnFont(newBaseFont);
                        RolloverCommand.setDefaultFont(newBaseFont);
                        local.put(String.valueOf(key) + ".FN", (String)this.fontNames.getSelectedItem());
                        local.putInt(String.valueOf(key) + ".SZ", this.fontSizes.getSelectedIndex() + 6);
                    }
                }
            } else {
                key = "ui.formatting.controlSizes";
                UIHelper.setControlSize(this.controlSizesHash.get(this.controlSizes.getSelectedItem()));
                local.put(key, this.controlSizesHash.get(this.controlSizes.getSelectedItem()).toString());
            }
            String fType = this.formTypeHash.get(this.formTypesCBX.getComboBox().getSelectedItem()).toString();
            local.put("ui.formatting.formtype", fType);
        }
    }
}

