/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.prefs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.prefs.GenericPrefsPanel;
import edu.ku.brc.af.prefs.PrefsPanelIFace;
import edu.ku.brc.af.prefs.PrefsSavable;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.validation.ValPasswordField;
import edu.ku.brc.helpers.EMailHelper;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class EMailPrefsPanel
extends GenericPrefsPanel
implements PrefsSavable,
PrefsPanelIFace {
    protected ImageIcon checkIcon = IconManager.getIcon("Checkmark", IconManager.IconSize.Std24);
    protected ImageIcon exclaimIcon = IconManager.getIcon("Error", IconManager.IconSize.Std24);
    protected ImageIcon exclaimYWIcon = IconManager.getIcon("Warning", IconManager.IconSize.Std24);
    protected CustomDialog checkerDialog = null;
    protected JLabel[] checkerLabels;
    protected JLabel[] checkerIcons;
    protected JProgressBar progressBar;
    protected JPanel checkPanel;
    protected String testMessage = "Specify Test Message";
    protected EMailCheckerRunnable emailCheckerRunnable;

    public EMailPrefsPanel() {
        this.createUI();
    }

    protected void createUI() {
        FormViewObj fvo;
        JButton btn;
        this.createForm("Preferences", "EMail");
        if (this.formView != null & this.form != null && this.form.getUIComponent() != null && this.form instanceof FormViewObj && (btn = (JButton)(fvo = (FormViewObj)this.form).getCompById("testconnection")) != null) {
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EMailPrefsPanel.this.startEMailSettingsTest();
                }
            });
        }
    }

    protected EMailHelper.ErrorType simpleTestSettings() {
        String usernameStr = (String)this.form.getDataFromUIComp("username");
        String passwordStr = (String)this.form.getDataFromUIComp("password");
        String smtpStr = (String)this.form.getDataFromUIComp("smtp");
        String emailStr = (String)this.form.getDataFromUIComp("email");
        String portStr = (String)this.form.getDataFromUIComp("port");
        String securityStr = (String)this.form.getDataFromUIComp("security");
        Component comp = this.form.getValidator().getComp("password");
        if (comp != null && comp instanceof ValPasswordField && ((ValPasswordField)comp).isEncrypted()) {
            passwordStr = Encryption.decrypt(passwordStr);
        }
        String htmlMsg = "<html><body>" + this.testMessage + "</body></html>";
        return EMailHelper.sendMsg(smtpStr, usernameStr, passwordStr, emailStr, emailStr, this.testMessage, htmlMsg, "text/html", portStr, securityStr, null);
    }

    protected void testSettings() {
    }

    protected void startEMailSettingsTest() {
        String rowDef = UIHelper.createDuplicateJGoodiesDef("p", "4dlu", 4);
        PanelBuilder builder = new PanelBuilder(new FormLayout("f:p:g", rowDef));
        CellConstraints cc = new CellConstraints();
        int row = 1;
        builder.add((Component)UIHelper.createI18NLabel("checkingemailsettings"), cc.xy(1, row));
        this.progressBar = new JProgressBar(0, 100);
        builder.add((Component)this.progressBar, cc.xy(1, row += 2));
        this.progressBar.setIndeterminate(true);
        row += 2;
        builder.setDefaultDialogBorder();
        this.checkPanel = builder.getPanel();
        this.checkPanel.doLayout();
        builder.getPanel().doLayout();
        this.checkerDialog = UIRegistry.getMostRecentWindow() instanceof Dialog ? new CustomDialog((Dialog)UIRegistry.getMostRecentWindow(), "", true, 1, (Component)this.checkPanel) : new CustomDialog((Frame)UIRegistry.getMostRecentWindow(), "", true, 1, (Component)this.checkPanel);
        this.checkerDialog.setModal(true);
        this.checkerDialog.setOkLabel(UIRegistry.getResourceString("CLOSE"));
        this.checkerDialog.createUI();
        this.checkerDialog.pack();
        Dimension size = this.checkerDialog.getSize();
        this.checkerDialog.setSize(new Dimension(Math.max(400, size.width), size.height));
        this.emailCheckerRunnable = new EMailCheckerRunnable(this.checkerDialog);
        this.emailCheckerRunnable.start();
        UIHelper.centerAndShow(this.checkerDialog);
    }

    @Override
    public String getHelpContext() {
        return "PrefsEMail";
    }

    public class EMailCheckerRunnable
    extends SwingWorker {
        protected JDialog parentDlg;
        protected EMailHelper.ErrorType status = EMailHelper.ErrorType.OK;

        public EMailCheckerRunnable(JDialog parentDlg) {
            this.parentDlg = parentDlg;
        }

        @Override
        public Object construct() {
            this.status = EMailPrefsPanel.this.simpleTestSettings();
            return null;
        }

        @Override
        public void finished() {
            if (this.status != EMailHelper.ErrorType.Cancel) {
                if (this.status == EMailHelper.ErrorType.Error) {
                    String errMsg = EMailHelper.getLastErrorMsg();
                    if (errMsg != null) {
                        UIRegistry.showLocalizedError("EMailPrefsPanel.ERROR", errMsg);
                    }
                } else {
                    UIRegistry.showLocalizedMsg(1, "INFORMATION", "EMailPrefsPanel.OK", new Object[0]);
                }
            }
            this.parentDlg.setVisible(false);
            this.parentDlg.dispose();
        }
    }
}

