/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.prefs;

import com.jgoodies.forms.layout.CellConstraints;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.GenericPrefsPanel;
import edu.ku.brc.af.prefs.PrefsPanelIFace;
import edu.ku.brc.af.prefs.PrefsSavable;
import edu.ku.brc.af.ui.forms.PanelViewable;
import edu.ku.brc.af.ui.forms.validation.ValBrowseBtnPanel;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.FileStoreAttachmentManager;
import edu.ku.brc.util.WebStoreAttachmentMgr;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;

public class AttachmentPrefs
extends GenericPrefsPanel
implements PrefsSavable,
PrefsPanelIFace {
    protected static final String USE_GLOBAL_PREFS = "USE_GLOBAL_PREFS";
    protected static final String EDT_GLOBAL_PREFS = "EDT_GLOBAL_PREFS";
    protected static final String ATTACHMENT_USE_PATH = "attachment.use_path";
    protected static final String ATTACHMENT_PATH = "attachment.path";
    protected static final String ATTACHMENT_URL = "attachment.url";
    protected static final String ATTCH_PATH_ID = "attch_path";
    protected static final String ATTCH_URL_ID = "attch_url";
    protected boolean isUsingGlobalAttchPrefs = false;
    protected boolean canEditGlobalAttchPrefs = false;
    protected AppPreferences remotePrefs = AppPreferences.getRemote();
    protected AppPreferences localPrefs = AppPreferences.getLocalPrefs();
    protected AppPreferences globalPrefs = AppPreferences.getGlobalPrefs();
    protected ValBrowseBtnPanel pathBrwse;
    protected JLabel pathLbl;
    protected ValTextField urlTxt;
    protected JLabel urlLbl;
    protected boolean isInitialized = false;
    protected String oldAttachmentPath = null;
    protected String oldAttachmentURL = null;
    protected String cachedAttachmentPath = null;
    protected String cachedAttachmentURL = null;
    protected JRadioButton pathRB;
    protected JRadioButton urlRB;

    public AttachmentPrefs() {
        this.createForm("Preferences", "Attachments");
        PanelViewable pathPanel = (PanelViewable)this.form.getCompById("path_panel");
        PanelViewable urlPanel = (PanelViewable)this.form.getCompById("url_panel");
        this.pathBrwse = (ValBrowseBtnPanel)this.form.getCompById(ATTCH_PATH_ID);
        this.pathLbl = this.form.getLabelFor(ATTCH_PATH_ID);
        this.urlTxt = (ValTextField)this.form.getCompById(ATTCH_URL_ID);
        this.urlLbl = this.form.getLabelFor(ATTCH_URL_ID);
        boolean bl = this.isInitialized = pathPanel != null && urlPanel != null && this.pathBrwse != null && this.pathLbl != null && this.urlTxt != null && this.urlLbl != null;
        if (!this.isInitialized) {
            UIRegistry.showError("The form is not setup correctly.");
            return;
        }
        this.isUsingGlobalAttchPrefs = this.globalPrefs.getBoolean(USE_GLOBAL_PREFS, false);
        this.canEditGlobalAttchPrefs = this.localPrefs.getBoolean(EDT_GLOBAL_PREFS, false);
        UIRegistry.loadAndPushResourceBundle("preferences");
        this.pathRB = UIHelper.createRadioButton(UIRegistry.getResourceString("USE_ATTACH_PATH"));
        this.urlRB = UIHelper.createRadioButton(UIRegistry.getResourceString("USE_ATTACH_URL"));
        UIRegistry.popResourceBundle();
        ButtonGroup group = new ButtonGroup();
        group.add(this.pathRB);
        group.add(this.urlRB);
        CellConstraints cc = new CellConstraints();
        if (pathPanel != null) {
            pathPanel.add((Component)this.pathRB, cc.xy(1, 1));
        }
        if (urlPanel != null) {
            urlPanel.add((Component)this.urlRB, cc.xy(1, 1));
        }
        JButton saveGGblPrefs = (JButton)this.form.getCompById("SaveGGblPrefs");
        JButton clearGGblPrefs = (JButton)this.form.getCompById("ClearGGblPrefs");
        if (saveGGblPrefs != null) {
            saveGGblPrefs.setVisible(this.isUsingGlobalAttchPrefs && this.canEditGlobalAttchPrefs);
            saveGGblPrefs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AttachmentPrefs.this.globalPrefs.put(AttachmentPrefs.ATTACHMENT_PATH, AttachmentPrefs.this.oldAttachmentPath);
                    AttachmentPrefs.this.globalPrefs.put(AttachmentPrefs.ATTACHMENT_URL, AttachmentPrefs.this.oldAttachmentURL);
                    AttachmentPrefs.this.globalPrefs.putBoolean(AttachmentPrefs.ATTACHMENT_USE_PATH, AttachmentPrefs.this.pathRB.isSelected());
                    AttachmentPrefs.this.localPrefs.putBoolean(AttachmentPrefs.ATTACHMENT_USE_PATH, AttachmentPrefs.this.pathRB.isSelected());
                }
            });
        }
        if (clearGGblPrefs != null) {
            clearGGblPrefs.setVisible(this.isUsingGlobalAttchPrefs && this.canEditGlobalAttchPrefs);
            clearGGblPrefs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AttachmentPrefs.this.globalPrefs.remove(AttachmentPrefs.ATTACHMENT_PATH);
                    AttachmentPrefs.this.globalPrefs.remove(AttachmentPrefs.ATTACHMENT_URL);
                    AttachmentPrefs.this.globalPrefs.remove(AttachmentPrefs.ATTACHMENT_USE_PATH);
                    try {
                        AttachmentPrefs.this.globalPrefs.flush();
                    }
                    catch (BackingStoreException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        if (!this.isUsingGlobalAttchPrefs || this.canEditGlobalAttchPrefs) {
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttachmentPrefs.this.toggleAttachmentsEnabledState(AttachmentPrefs.this.pathRB.isSelected());
                }
            };
            this.pathRB.addActionListener(al);
            this.urlRB.addActionListener(al);
        } else {
            this.pathBrwse.setEnabled(false);
            this.urlTxt.setEnabled(false);
            this.pathRB.setEnabled(false);
            this.urlRB.setEnabled(false);
        }
        this.setDataIntoUI();
    }

    private void setRadio(final boolean isUsingPath) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AttachmentPrefs.this.pathRB.setSelected(isUsingPath);
                AttachmentPrefs.this.urlRB.setSelected(!isUsingPath);
            }
        });
    }

    protected void toggleAttachmentsEnabledState(boolean isPathSelected) {
        if (!this.isInitialized) {
            return;
        }
        this.pathBrwse.setEnabled(isPathSelected);
        this.pathLbl.setEnabled(isPathSelected);
        this.urlTxt.setEnabled(!isPathSelected);
        this.urlLbl.setEnabled(!isPathSelected);
        if (isPathSelected) {
            String newURL = this.urlTxt.getText().trim();
            if (StringUtils.isNotEmpty((String)newURL)) {
                this.cachedAttachmentURL = newURL;
            }
            this.pathBrwse.setValue(this.cachedAttachmentPath, null);
            this.urlTxt.setValue("", null);
        } else {
            String newPath = (String)this.pathBrwse.getValue();
            if (StringUtils.isNotEmpty((String)newPath)) {
                this.cachedAttachmentPath = newPath;
            }
            this.urlTxt.setValue(this.cachedAttachmentURL, null);
            this.pathBrwse.setValue("", null);
        }
    }

    private boolean setDataIntoUI() {
        AppPreferences prefs = !this.isUsingGlobalAttchPrefs || this.canEditGlobalAttchPrefs ? this.localPrefs : this.globalPrefs;
        return this.setDataIntoUI(prefs);
    }

    private boolean setDataIntoUI(AppPreferences prefs) {
        boolean isUsingPath = true;
        this.oldAttachmentPath = prefs.get(ATTACHMENT_PATH, null);
        this.oldAttachmentURL = prefs.get(ATTACHMENT_URL, null);
        this.cachedAttachmentPath = prefs.get(ATTACHMENT_PATH, "");
        this.cachedAttachmentURL = prefs.get(ATTACHMENT_URL, "");
        if (StringUtils.isEmpty((String)this.oldAttachmentPath) && StringUtils.isNotEmpty((String)this.oldAttachmentURL)) {
            isUsingPath = false;
        }
        this.pathBrwse.setValue(this.oldAttachmentPath, null);
        this.urlTxt.setValue(this.oldAttachmentURL, null);
        this.setRadio(isUsingPath);
        this.toggleAttachmentsEnabledState(isUsingPath);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isOKToSave() {
        if (this.pathRB.isSelected()) {
            this.oldAttachmentPath = (String)this.pathBrwse.getValue();
            this.oldAttachmentURL = "";
            if (StringUtils.isNotEmpty((String)this.oldAttachmentPath)) {
                try {
                    if (AttachmentUtils.getAttachmentManager() == null) {
                        AttachmentUtils.setAttachmentManager(new FileStoreAttachmentManager(new File(this.oldAttachmentPath)));
                        return true;
                    } else {
                        AttachmentUtils.getAttachmentManager().setDirectory(new File(this.oldAttachmentPath));
                    }
                    return true;
                }
                catch (IOException ex) {
                    UIRegistry.showLocalizedError("SystemPrefs.BAD_ATTCH_PATH");
                    return false;
                }
            } else {
                UIRegistry.showLocalizedError("SystemPrefs.NOEMPTY_ATTCH");
            }
            return false;
        } else {
            this.oldAttachmentPath = "";
            this.oldAttachmentURL = this.urlTxt.getText().trim();
            if (StringUtils.isNotEmpty((String)this.oldAttachmentURL)) {
                WebStoreAttachmentMgr webAssetMgr = new WebStoreAttachmentMgr();
                if (webAssetMgr.isInitialized(this.oldAttachmentURL)) return true;
                webAssetMgr = null;
                UIRegistry.showLocalizedError("SystemPrefs.BAD_ATTCH_URL");
                return false;
            } else {
                UIRegistry.showLocalizedError("SystemPrefs.NOEMPTY_URL");
            }
        }
        return false;
    }

    @Override
    public void savePrefs() {
        if (!this.isInitialized) {
            return;
        }
        boolean usingPath = this.pathRB.isSelected();
        if ((usingPath || !this.isUsingGlobalAttchPrefs || this.canEditGlobalAttchPrefs) && (this.form.getValidator() == null || this.form.getValidator().hasChanged())) {
            super.savePrefs();
            if (usingPath) {
                this.localPrefs.put(ATTACHMENT_PATH, this.oldAttachmentPath);
                this.localPrefs.put(ATTACHMENT_URL, "");
            } else {
                this.localPrefs.put(ATTACHMENT_URL, this.oldAttachmentURL);
                this.localPrefs.put(ATTACHMENT_PATH, "");
            }
            this.localPrefs.putBoolean(ATTACHMENT_USE_PATH, usingPath);
            try {
                this.localPrefs.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getHelpContext() {
        return "PrefsAttachments";
    }
}

