/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.sgr;

import edu.ku.brc.sgr.datamodel.BatchMatchResultItem;
import edu.ku.brc.sgr.datamodel.BatchMatchResultSet;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.plugins.sgr.SGRColors;
import edu.ku.brc.ui.tmanfe.SpreadSheet;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Highlighter;

public class WorkbenchColorizer {
    private final Workbench workbench;
    private final SpreadSheet spreadSheet;
    private Highlighter highlighter = null;
    private final Map<String, Float> sgrScores = new HashMap<String, Float>();
    private float maxScore;
    private final Color origGridColor;
    private BatchMatchResultSet resultSet;

    public WorkbenchColorizer(Workbench workbench, SpreadSheet spreadSheet) {
        this.workbench = workbench;
        this.spreadSheet = spreadSheet;
        this.origGridColor = spreadSheet.getGridColor();
    }

    public void setBatchResults(BatchMatchResultSet results) {
        this.resultSet = results;
        if (this.highlighter != null) {
            this.spreadSheet.removeHighlighter(this.highlighter);
        }
        this.maxScore = (float)results.getMax();
        this.sgrScores.clear();
        List items = results.getAllItems();
        for (BatchMatchResultItem item : items) {
            Color c = SGRColors.colorForScore(item.maxScore(), this.maxScore);
            this.sgrScores.put(item.matchedId(), Float.valueOf(item.maxScore()));
        }
        this.highlighter = new AbstractHighlighter(){

            protected Component doHighlight(Component arg0, ComponentAdapter arg1) {
                if (arg1.isSelected()) {
                    return arg0;
                }
                WorkbenchRow row = WorkbenchColorizer.this.workbench.getRow(WorkbenchColorizer.this.spreadSheet.convertRowIndexToModel(arg1.row));
                Float score = WorkbenchColorizer.this.getScoreForRow(row);
                if (score != null) {
                    Color c = SGRColors.colorForScore(score.floatValue(), WorkbenchColorizer.this.maxScore);
                    arg0.setBackground(c);
                }
                return arg0;
            }
        };
        this.spreadSheet.addHighlighter(this.highlighter);
        this.spreadSheet.setGridColor(Color.DARK_GRAY);
    }

    public Float getScoreForRow(WorkbenchRow row) {
        return this.getScoreForRow(row, false);
    }

    public Float getScoreForRow(WorkbenchRow row, boolean scaled) {
        Float score = this.sgrScores.get("TOMATCH-" + row.getId());
        if (scaled && score != null && (double)this.maxScore > 0.0) {
            return Float.valueOf(score.floatValue() / this.maxScore);
        }
        return score;
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    public BatchMatchResultSet getResultSet() {
        return this.resultSet;
    }

    public void stopColoring() {
        if (this.highlighter != null) {
            this.spreadSheet.removeHighlighter(this.highlighter);
            this.spreadSheet.setGridColor(this.origGridColor);
            this.highlighter = null;
        }
    }

    public void cleanup() {
        this.stopColoring();
    }
}

