/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.sgr;

import com.google.common.collect.ImmutableMultimap;
import edu.ku.brc.sgr.SGRRecord;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import java.util.Collection;

public class Workbench2SGR {
    private final ImmutableMultimap<String, Short> fieldName2Index;

    public Workbench2SGR(Workbench workbench) {
        ImmutableMultimap.Builder mb = new ImmutableMultimap.Builder();
        for (WorkbenchTemplateMappingItem item : workbench.getWorkbenchTemplate().getWorkbenchTemplateMappingItems()) {
            mb.put((Object)item.getFieldName(), (Object)item.getViewOrder());
        }
        this.fieldName2Index = mb.build();
    }

    public SGRRecord row2SgrRecord(WorkbenchRow row) {
        SGRRecord.Builder doc = SGRRecord.builder((String)("TOMATCH-" + row.getId()));
        this.addCollectors(row, doc);
        this.addDeterminations(row, doc);
        this.addField("collector_number", new String[]{"stationFieldNumber", "fieldNumber"}, row, doc);
        this.addField("date_collected", new String[]{"verbatimDate", "startDate", "endDate"}, row, doc);
        this.addField("locality", new String[]{"verbatimLocality"}, row, doc);
        this.addField("catalog_number", new String[]{"catalogNumber", "altCatalogNumber"}, row, doc);
        this.addField("location", new String[]{"country", "state", "county", "localityName", "namedPlace"}, row, doc);
        return doc.build();
    }

    public Collection<Short> getFieldsFor(String specifyField) {
        return this.fieldName2Index.get((Object)specifyField);
    }

    private void addCollectors(WorkbenchRow row, SGRRecord.Builder doc) {
        int c = 1;
        while (c < 9) {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = new String[]{"collectorFirstName", "collectorMiddle", "collectorLastName"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                for (short ind : this.getFieldsFor(String.valueOf(field) + c)) {
                    sb.append(String.valueOf(row.getData(ind)) + " ");
                }
                ++n2;
            }
            if (sb.length() > 0) {
                doc.put("collectors", sb.toString().trim());
            }
            ++c;
        }
    }

    private void addDeterminations(WorkbenchRow row, SGRRecord.Builder doc) {
        StringBuilder sb = new StringBuilder();
        int c = 1;
        while (c < 3) {
            String[] stringArray = new String[]{"genus", "species", "subspecies"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                for (short ind : this.getFieldsFor(String.valueOf(field) + c)) {
                    sb.append(String.valueOf(row.getData(ind)) + " ");
                }
                ++n2;
            }
            ++c;
        }
        if (sb.length() > 0) {
            doc.put("scientific_name", sb.toString().trim());
        }
    }

    private void addField(String outputField, String[] inputFields, WorkbenchRow row, SGRRecord.Builder doc) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = inputFields;
        int n = inputFields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            for (short ind : this.getFieldsFor(field)) {
                sb.append(String.valueOf(row.getData(ind)) + " ");
            }
            ++n2;
        }
        if (sb.length() > 0) {
            doc.put(outputField, sb.toString().trim());
        }
    }
}

