/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.sgr;

import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.sgr.Matchable;
import edu.ku.brc.sgr.datamodel.BatchMatchResultSet;
import edu.ku.brc.sgr.datamodel.MatchConfiguration;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.plugins.sgr.SGRBatchScenario;
import edu.ku.brc.specify.plugins.sgr.Workbench2SGR;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import java.util.Iterator;
import java.util.Set;

public class WorkBenchBatchMatch {
    public static SGRBatchScenario resumeScenario(BatchMatchResultSet resultSet) {
        DataProviderSessionIFace mySession = DataProviderFactory.getInstance().createSession();
        Workbench workbench = WorkbenchTask.loadWorkbench((int)resultSet.getRecordSetId().longValue(), mySession);
        Workbench2SGR workbench2SGR = new Workbench2SGR(workbench);
        return new SGRBatchScenario(resultSet, WorkBenchBatchMatch.recordGenerator(workbench, workbench2SGR, mySession));
    }

    public static SGRBatchScenario newScenario(RecordSetIFace recordSet, MatchConfiguration matchConfig) {
        DataProviderSessionIFace mySession = DataProviderFactory.getInstance().createSession();
        Workbench workbench = WorkbenchTask.loadWorkbench(recordSet.getOnlyItem().getRecordId(), mySession);
        Workbench2SGR workbench2SGR = new Workbench2SGR(workbench);
        return new SGRBatchScenario(recordSet, matchConfig, WorkBenchBatchMatch.recordGenerator(workbench, workbench2SGR, mySession), workbench.getName(), (long)workbench.getId());
    }

    public static SGRBatchScenario newScenario(int workbenchId, MatchConfiguration matchConfig) {
        DataProviderSessionIFace mySession = DataProviderFactory.getInstance().createSession();
        Workbench workbench = WorkbenchTask.loadWorkbench(workbenchId, mySession);
        Workbench2SGR workbench2SGR = new Workbench2SGR(workbench);
        return new SGRBatchScenario(matchConfig, WorkBenchBatchMatch.recordGenerator(workbench, workbench2SGR, mySession), workbench.getName(), (long)workbench.getId(), workbench.getDbTableId());
    }

    private static SGRBatchScenario.RecordGenerator recordGenerator(Workbench workbench, final Workbench2SGR workbench2sgr, final DataProviderSessionIFace session) {
        return new SGRBatchScenario.RecordGenerator(workbench){
            Set<WorkbenchRow> rows;
            Iterator<WorkbenchRow> iter;
            final int total;
            {
                this.rows = workbench.getWorkbenchRows();
                this.iter = this.rows.iterator();
                this.total = this.rows.size();
            }

            @Override
            public Matchable next() {
                return workbench2sgr.row2SgrRecord(this.iter.next()).asMatchable();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int totalRecords() {
                return this.total;
            }

            @Override
            public void close() {
                session.close();
            }
        };
    }
}

