/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.sgr;

import edu.ku.brc.sgr.Match;
import edu.ku.brc.sgr.MatchResults;
import edu.ku.brc.sgr.SGRRecord;
import edu.ku.brc.specify.plugins.sgr.SGRColors;
import edu.ku.brc.specify.plugins.sgr.SGRColumnOrdering;
import edu.ku.brc.ui.BiColorTableCellRenderer;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jexifviewer.JSettings;
import jexifviewer.Main;
import org.apache.commons.lang.StringUtils;
import shared.files.JPathHelper;

public class SGRResultsDisplay
extends JPanel
implements TableColumnModelListener {
    private static final int ROW_HEIGHT = 22;

    public SGRResultsDisplay(int width, MatchResults results) {
        if (Main.m_settings == null) {
            Main.m_settings = new JSettings(true);
            Main.m_settings.load(String.valueOf(JPathHelper.addSeparator((String)System.getProperty("user.home"))) + "jexifviewer.properties", "1.8");
            Main.m_sysLocale = Locale.getDefault();
            if (Main.m_settings.getLocale().length() > 0) {
                Locale.setDefault(new Locale(Main.m_settings.getLocale()));
            }
        }
        SGRColumnOrdering columns = SGRColumnOrdering.getInstance();
        String[] fields = columns.getFields();
        DefaultTableModel resultsTableModel = new DefaultTableModel(columns.getHeadings(), 0);
        LinkedList<List<Color>> rowColors = new LinkedList<List<Color>>();
        for (Match result : results) {
            SGRRecord match = result.match;
            float score = result.score;
            float maxScore = 22.0f;
            LinkedList<Color> cellColors = new LinkedList<Color>();
            LinkedList<String> data = new LinkedList<String>();
            String[] stringArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                if (field.equals("id")) {
                    data.add(match.id);
                    cellColors.add(SGRColors.colorForScore(score, maxScore));
                } else if (field.equals("score")) {
                    data.add(Float.valueOf(score).toString());
                    cellColors.add(SGRColors.colorForScore(score, maxScore));
                } else {
                    data.add(StringUtils.join((Object[])match.getFieldValues(field).toArray(), (char)';'));
                    Float fieldContribution = (Float)result.fieldScoreContributions().get((Object)field);
                    Color color = SGRColors.colorForScore(score, maxScore, fieldContribution);
                    cellColors.add(color);
                }
                ++n2;
            }
            resultsTableModel.addRow(data.toArray());
            rowColors.add(cellColors);
        }
        JTable table = this.createTable(resultsTableModel, rowColors);
        Dimension preferredSize = table.getPreferredSize();
        preferredSize.width = Math.min((int)(0.9 * (double)width), preferredSize.width);
        table.setPreferredScrollableViewportSize(preferredSize);
        table.getColumnModel().addColumnModelListener(this);
        this.add(new JScrollPane(table));
    }

    private JTable createTable(DefaultTableModel resultsTableModel, final List<List<Color>> rowColors) {
        JTable table = new JTable(resultsTableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int colIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, colIndex);
                Color bgColor = this.isCellSelected(rowIndex, colIndex) ? this.getSelectionBackground() : (Color)((List)rowColors.get(rowIndex)).get(colIndex);
                c.setBackground(bgColor);
                return c;
            }
        };
        DefaultTableCellRenderer tcr = this.getTableCellRenderer();
        int i = 0;
        while (i < resultsTableModel.getColumnCount()) {
            if (resultsTableModel.getColumnClass(i) != Boolean.class) {
                table.setDefaultRenderer(resultsTableModel.getColumnClass(i), tcr);
            }
            ++i;
        }
        table.setCellSelectionEnabled(true);
        table.setAutoResizeMode(0);
        UIHelper.makeTableHeadersCentered(table, false);
        table.setDefaultRenderer(String.class, new BiColorTableCellRenderer(false));
        table.setRowHeight(22);
        this.autoResizeColWidth(table, resultsTableModel);
        return table;
    }

    private DefaultTableCellRenderer getTableCellRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                boolean doCenter = false;
                Object val = value;
                if (value instanceof Pair) {
                    Pair pair = (Pair)value;
                    val = pair.first;
                    doCenter = true;
                }
                JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column);
                lbl.setHorizontalTextPosition(doCenter ? 0 : 2);
                return lbl;
            }
        };
    }

    private JTable autoResizeColWidth(JTable table, DefaultTableModel model) {
        table.setAutoResizeMode(0);
        table.setModel(model);
        int margin = 5;
        int i = 0;
        while (i < table.getColumnCount()) {
            int vColIndex = i;
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
            TableColumn col = colModel.getColumn(vColIndex);
            int width = 0;
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width;
            int r = 0;
            while (r < table.getRowCount()) {
                renderer = table.getCellRenderer(r, vColIndex);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
                width = Math.max(width, comp.getPreferredSize().width);
                ++r;
            }
            col.setPreferredWidth(width += 2 * margin);
            ++i;
        }
        ((DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
        return table;
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        int to;
        int from = e.getFromIndex();
        if (from == (to = e.getToIndex())) {
            return;
        }
        System.out.println(e.getSource() + " " + from + " " + to);
        SGRColumnOrdering.getInstance().moveColumn(from, to);
    }

    @Override
    public void columnAdded(TableColumnModelEvent arg0) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent arg0) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent arg0) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent arg0) {
    }
}

