/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.sgr;

import com.google.common.base.Function;
import edu.ku.brc.sgr.MatchResults;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.plugins.sgr.SGRResultsDisplay;
import edu.ku.brc.ui.tmanfe.SpreadSheet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class SGRResultsChooser
extends JDialog
implements WindowListener {
    private SGRResultsDisplay resultsDisplayPanel;
    private final Function<Void, Void> finished;
    private final SpreadSheet spreadSheet;
    private final ColorHighlighter highlighter;

    public SGRResultsChooser(Frame parent, final WorkbenchRow row, MatchResults results, SpreadSheet spreadSheet, Function<Void, Void> finished) {
        super(parent);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        this.finished = finished;
        this.spreadSheet = spreadSheet;
        Rectangle r = spreadSheet.getCellRect(row.getRowNumber().shortValue(), 0, false);
        Point p = spreadSheet.getLocationOnScreen();
        Container ssParent = spreadSheet.getParent();
        p.translate(r.x, r.y + r.height + 10);
        this.setLocation(p);
        this.resultsDisplayPanel = new SGRResultsDisplay(ssParent.getWidth(), results);
        this.setContentPane(this.resultsDisplayPanel);
        this.pack();
        this.highlighter = new ColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component arg0, ComponentAdapter arg1) {
                return row.getRowNumber() == arg1.row;
            }
        }, Color.YELLOW, Color.BLACK);
        spreadSheet.addHighlighter((Highlighter)this.highlighter);
        spreadSheet.clearSelection();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.spreadSheet.removeHighlighter((Highlighter)this.highlighter);
        this.spreadSheet.repaint();
        this.finished.apply(null);
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

