/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.sgr;

import com.google.common.collect.ImmutableList;
import edu.ku.brc.sgr.MatchResults;
import edu.ku.brc.sgr.SGRMatcher;
import edu.ku.brc.sgr.SGRRecord;
import edu.ku.brc.sgr.datamodel.BatchMatchResultSet;
import edu.ku.brc.sgr.datamodel.DataModel;
import edu.ku.brc.sgr.datamodel.MatchConfiguration;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.plugins.sgr.Workbench2SGR;
import edu.ku.brc.specify.plugins.sgr.WorkbenchColorizer;
import edu.ku.brc.specify.tasks.SGRTask;
import edu.ku.brc.specify.tasks.subpane.wb.SGRFormPane;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchPaneSS;
import edu.ku.brc.ui.DropDownButtonStateless;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.WorkBenchPluginIFace;
import edu.ku.brc.ui.tmanfe.SpreadSheet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class SGRPluginImpl
implements WorkBenchPluginIFace {
    private SpreadSheet spreadSheet;
    private Workbench workbench;
    private SGRMatcher matcher;
    private MatchConfiguration matcherConfiguration;
    private WorkbenchColorizer colorizer;
    private WorkbenchPaneSS workbenchPaneSS;
    private Workbench2SGR workbench2SGR;
    private List<JComponent> ssButtons;
    private List<JComponent> formButtons;
    protected Integer nResults;
    private DropDownButtonStateless matcherButton;
    private DropDownButtonStateless batchButton;

    public void setBatchMatchResults(BatchMatchResultSet rs) {
        for (DropDownButtonStateless.MenuInfo mi : this.batchButton.getMenuInfos()) {
            BatchMenuInfo bmi = (BatchMenuInfo)mi;
            if (bmi.resultSet.id() != rs.id()) continue;
            this.batchButton.setSelected(bmi);
            this.setMatcherConfiguration(rs.getMatchConfiguration());
            return;
        }
    }

    public void setMatcherConfiguration(MatchConfiguration mc) {
        for (DropDownButtonStateless.MenuInfo mi : this.matcherButton.getMenuInfos()) {
            MatcherMenuInfo mmi = (MatcherMenuInfo)mi;
            if (mmi.matchConfiguration.id() != mc.id()) continue;
            this.matcherButton.setSelected(mmi);
            return;
        }
    }

    public boolean isReady() {
        return this.matcherConfiguration != null;
    }

    public MatchResults doQuery(WorkbenchRow row) {
        assert (this.isReady());
        SGRRecord doc = this.workbench2SGR.row2SgrRecord(row);
        return this.matcher.match(doc.asMatchable(), this.nResults);
    }

    @Override
    public Collection<JComponent> getSSButtons() {
        if (this.ssButtons != null) {
            return this.ssButtons;
        }
        if (this.workbenchPaneSS.getTask() instanceof SGRTask) {
            UIRegistry.loadAndPushResourceBundle("specify_plugins");
            String tooltip = UIRegistry.getResourceString("SGR_SHOW_RESULTS");
            String label = UIRegistry.getResourceString("SGR_BATCH_RESULTS");
            UIRegistry.popResourceBundle();
            ImageIcon icon = IconManager.getIcon("SGR", IconManager.IconSize.Std20);
            this.batchButton = new DropDownButtonStateless(label, icon, tooltip, new DropDownButtonStateless.MenuGenerator(){

                @Override
                public List<DropDownButtonStateless.MenuInfo> getItems() {
                    LinkedList<DropDownButtonStateless.MenuInfo> batchList = new LinkedList<DropDownButtonStateless.MenuInfo>();
                    for (BatchMatchResultSet rs : DataModel.getBatchMatchResultSetsFor((Long)((Object)SGRPluginImpl.this.workbench.getId()), (Integer)SGRPluginImpl.this.workbench.getDbTableId())) {
                        batchList.add(new BatchMenuInfo(rs));
                    }
                    return batchList;
                }
            });
            this.batchButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SGRPluginImpl.this.workbenchPaneSS.showPanel(WorkbenchPaneSS.PanelType.Form);
                }
            });
            this.ssButtons = ImmutableList.of((Object)this.batchButton);
        } else {
            this.ssButtons = ImmutableList.of();
        }
        return this.ssButtons;
    }

    @Override
    public Collection<JComponent> getFormButtons() {
        if (this.formButtons != null) {
            return this.formButtons;
        }
        if (this.workbenchPaneSS.getTask() instanceof SGRTask) {
            UIRegistry.loadAndPushResourceBundle("specify_plugins");
            String tooltip = UIRegistry.getResourceString("SGR_REFRESH_RESULTS");
            String label = UIRegistry.getResourceString("SGR_SELECT_MATCHER");
            UIRegistry.popResourceBundle();
            ImageIcon icon = IconManager.getIcon("SGRMatchers", IconManager.IconSize.Std20);
            this.matcherButton = new DropDownButtonStateless(label, icon, tooltip, new DropDownButtonStateless.MenuGenerator(){

                @Override
                public List<DropDownButtonStateless.MenuInfo> getItems() {
                    LinkedList<DropDownButtonStateless.MenuInfo> matchersList = new LinkedList<DropDownButtonStateless.MenuInfo>();
                    for (MatchConfiguration mc : DataModel.getMatcherConfigurations()) {
                        matchersList.add(new MatcherMenuInfo(mc));
                    }
                    return matchersList;
                }
            });
            this.matcherButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SGRPluginImpl.this.refreshFormPane();
                }
            });
            this.formButtons = ImmutableList.of((Object)this.matcherButton);
        } else {
            this.formButtons = ImmutableList.of();
        }
        return this.formButtons;
    }

    private void refreshFormPane() {
        SGRFormPane sgrFormPane;
        try {
            sgrFormPane = (SGRFormPane)this.workbenchPaneSS.getFormPane();
        }
        catch (ClassCastException e) {
            return;
        }
        sgrFormPane.copyDataFromForm();
        sgrFormPane.refreshResults();
    }

    public MatchConfiguration getMatcher() {
        return this.matcherConfiguration;
    }

    @Override
    public void setSpreadSheet(SpreadSheet ss) {
        this.spreadSheet = ss;
    }

    @Override
    public void setWorkbench(Workbench workbench) {
        this.workbench = workbench;
        if (workbench != null) {
            this.workbench2SGR = new Workbench2SGR(workbench);
        }
        if (this.colorizer != null) {
            this.colorizer.cleanup();
        }
        this.colorizer = new WorkbenchColorizer(workbench, this.spreadSheet);
    }

    @Override
    public List<String> getMissingFieldsForPlugin() {
        return null;
    }

    @Override
    public void shutdown() {
        if (this.colorizer != null) {
            this.colorizer.cleanup();
        }
        this.workbench = null;
        this.workbenchPaneSS = null;
    }

    public WorkbenchColorizer getColorizer() {
        return this.colorizer;
    }

    public Workbench2SGR getWorkbench2SGR() {
        return this.workbench2SGR;
    }

    @Override
    public void setWorkbenchPaneSS(WorkbenchPaneSS wbpss) {
        this.workbenchPaneSS = wbpss;
    }

    private class BatchMenuInfo
    extends DropDownButtonStateless.MenuInfo {
        public final BatchMatchResultSet resultSet;

        public BatchMenuInfo(BatchMatchResultSet rs) {
            super(rs.name(), null, null);
            this.resultSet = rs;
        }

        @Override
        public void selected() {
            SGRPluginImpl.this.colorizer.setBatchResults(this.resultSet);
            SGRPluginImpl.this.workbenchPaneSS.showHideSgrCol(true);
            SGRPluginImpl.this.workbenchPaneSS.sgrSort();
            SGRPluginImpl.this.setMatcherConfiguration(this.resultSet.getMatchConfiguration());
        }
    }

    private class MatcherMenuInfo
    extends DropDownButtonStateless.MenuInfo {
        public final MatchConfiguration matchConfiguration;

        public MatcherMenuInfo(MatchConfiguration mc) {
            super(mc.name(), null, null);
            this.matchConfiguration = mc;
        }

        @Override
        public void selected() {
            SGRMatcher.Factory matcherFactory = this.matchConfiguration.createMatcherFactory();
            matcherFactory.docSupplied = true;
            matcherFactory.debugQuery = true;
            try {
                SGRPluginImpl.this.matcher = matcherFactory.build();
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
            SGRPluginImpl.this.matcherConfiguration = this.matchConfiguration;
            SGRPluginImpl.this.refreshFormPane();
            BatchMatchResultSet rs = null;
            try {
                rs = SGRPluginImpl.this.colorizer.getResultSet();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (rs != null && SGRPluginImpl.this.matcherConfiguration.id() != rs.getMatchConfiguration().id()) {
                SGRPluginImpl.this.colorizer.stopColoring();
                SGRPluginImpl.this.batchButton.reset();
            }
        }
    }
}

