/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.sgr;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.NavBoxButton;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.sgr.SGRMatcher;
import edu.ku.brc.sgr.datamodel.DataModel;
import edu.ku.brc.sgr.datamodel.MatchConfiguration;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.plugins.sgr.AvailableIndicesFetcher;
import edu.ku.brc.specify.plugins.sgr.SGRColumnOrdering;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.core.QueryNodeException;
import org.apache.lucene.queryParser.standard.StandardQueryParser;
import org.apache.lucene.search.Query;

public class SGRMatcherUI
extends CustomDialog {
    public static final String[] availableFields = new String[]{"collectors", "collector_number", "location", "date_collected", "date_split", "scientific_name"};
    private final SGRMatcherUIPanel uiPanel;
    private final Function<MatchConfiguration, Void> finished;
    private NavBoxItemIFace nbi = null;

    public static SGRMatcherUI dialogForNewConfig(Frame parent, Function<MatchConfiguration, Void> onFinished) {
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        String title = UIRegistry.getResourceString("SGR_CREATE_MATCHER");
        UIRegistry.popResourceBundle();
        SGRMatcherUI dialog = new SGRMatcherUI(parent, title, new SGRMatcherUIPanel(null), onFinished);
        return dialog;
    }

    public static SGRMatcherUI dialogForEditing(Frame parent, NavBoxItemIFace nbi) {
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        String title = UIRegistry.getResourceString("SGR_EDIT_MATCHER");
        UIRegistry.popResourceBundle();
        SGRMatcherUI dialog = new SGRMatcherUI(parent, title, new SGRMatcherUIPanel(nbi), null);
        dialog.nbi = nbi;
        return dialog;
    }

    private SGRMatcherUI(Frame frame, String title, SGRMatcherUIPanel uiPanel, Function<MatchConfiguration, Void> finished) throws HeadlessException {
        super(frame, title, true, 7, (Component)uiPanel);
        this.finished = finished;
        this.uiPanel = uiPanel;
        this.helpContext = "sgr_matcher_create";
        this.pack();
    }

    @Override
    protected void okButtonPressed() {
        if (StringUtils.isBlank((String)this.uiPanel.name.getText())) {
            UIRegistry.loadAndPushResourceBundle("specify_plugins");
            UIRegistry.showLocalizedError("SGR_MATCHER_NAME_REQUIRED_ERROR");
            UIRegistry.popResourceBundle();
            return;
        }
        if (this.nbi == null) {
            String collectionCode;
            SGRMatcher.Factory mf = SGRMatcher.getFactory();
            String name = this.uiPanel.name.getText();
            String index = (String)((JComboBox)this.uiPanel.index).getSelectedItem();
            mf.serverUrl = this.uiPanel.indices.get(index);
            mf.nRows = ((Number)this.uiPanel.nRows.getValue()).intValue();
            mf.boostInterestingTerms = this.uiPanel.boost.isSelected();
            LinkedList<String> similarityFields = new LinkedList<String>();
            LinkedList<String> boosts = new LinkedList<String>();
            String[] stringArray = availableFields;
            int n = availableFields.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                String ctrlField = field.equals("date_split") ? "date_collected" : field;
                switch ((WeightChoice)((Object)this.uiPanel.similarityFields.get(ctrlField).getSelectedItem())) {
                    case High: {
                        boosts.add(String.valueOf(field) + "^5.0");
                        similarityFields.add(field);
                        break;
                    }
                    case Low: {
                        boosts.add(String.valueOf(field) + "^0.2");
                        similarityFields.add(field);
                        break;
                    }
                    case Normal: {
                        similarityFields.add(field);
                    }
                }
                ++n2;
            }
            mf.similarityFields = StringUtils.join(similarityFields.iterator(), (char)',');
            mf.queryFields = StringUtils.join(boosts.iterator(), (char)' ');
            LinkedList<String> filters = new LinkedList<String>();
            String institutionCode = this.uiPanel.institutionCode.getText();
            if (!StringUtils.isBlank((String)institutionCode)) {
                filters.add("-institution_code:\"" + institutionCode + "\"");
            }
            if (!StringUtils.isBlank((String)(collectionCode = this.uiPanel.collectionCode.getText()))) {
                filters.add("-collection_code:\"" + collectionCode + "\"");
            }
            mf.filterQuery = StringUtils.join((Object[])filters.toArray(), (char)' ');
            this.finished.apply((Object)DataModel.persistMatchConfiguration((String)name, (String)this.uiPanel.remarks.getText(), (SGRMatcher.Factory)mf));
        } else {
            MatchConfiguration matchConfig = (MatchConfiguration)this.nbi.getData();
            String name = this.uiPanel.name.getText();
            String remarks = this.uiPanel.remarks.getText();
            matchConfig.updateProperties(name, remarks);
            ((NavBoxButton)this.nbi).setLabelText(name);
            ((NavBoxButton)this.nbi).getParent().repaint();
        }
        this.dispose();
    }

    public static class AvailableIndicesFetchException
    extends RuntimeException {
        public AvailableIndicesFetchException() {
        }

        public AvailableIndicesFetchException(String arg0, Throwable arg1) {
            super(arg0, arg1);
        }

        public AvailableIndicesFetchException(String arg0) {
            super(arg0);
        }

        public AvailableIndicesFetchException(Throwable arg0) {
            super(arg0);
        }
    }

    private static class SGRMatcherUIPanel
    extends JPanel {
        JTextField name = new JTextField("New matcher");
        JComponent index;
        JFormattedTextField nRows = new JFormattedTextField((Object)10);
        JCheckBox boost = new JCheckBox("Boost Interesting Terms", true);
        Map<String, JComboBox> similarityFields = new HashMap<String, JComboBox>(availableFields.length);
        JTextField institutionCode = new JTextField();
        JTextField collectionCode = new JTextField();
        JTextArea remarks = new JTextArea(10, 20);
        Map<String, String> indices;

        public SGRMatcherUIPanel(NavBoxItemIFace nbi) {
            this.remarks.setLineWrap(true);
            String[] stringArray = availableFields;
            int n = availableFields.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                if (!field.equals("date_split")) {
                    JComboBox<WeightChoice> comboBox = new JComboBox<WeightChoice>(WeightChoice.values());
                    comboBox.setSelectedItem((Object)WeightChoice.Normal);
                    this.similarityFields.put(field, comboBox);
                }
                ++n2;
            }
            if (nbi != null) {
                MatchConfiguration matchConfig = (MatchConfiguration)nbi.getData();
                this.name.setText(matchConfig.name());
                JTextField serverUrl = new JTextField();
                serverUrl.setText(matchConfig.serverUrl());
                serverUrl.setEditable(false);
                this.index = serverUrl;
                this.nRows.setText("" + matchConfig.nRows());
                this.boost.setSelected(matchConfig.boostInterestingTerms());
                this.boost.setEnabled(false);
                Set<String> selectedFields = this.parseSimilarityFields(matchConfig.similarityFields());
                Map<String, Float> boosts = this.parseBoosts(matchConfig.queryFields());
                String[] stringArray2 = availableFields;
                int n3 = availableFields.length;
                int n4 = 0;
                while (n4 < n3) {
                    String field = stringArray2[n4];
                    if (!field.equals("date_split")) {
                        if (!selectedFields.contains(field)) {
                            this.similarityFields.get(field).setSelectedItem((Object)WeightChoice.Ignore);
                        } else if (boosts.containsKey(field)) {
                            if (boosts.get(field).floatValue() > 1.0f) {
                                this.similarityFields.get(field).setSelectedItem((Object)WeightChoice.High);
                            } else if (boosts.get(field).floatValue() < 1.0f) {
                                this.similarityFields.get(field).setSelectedItem((Object)WeightChoice.Low);
                            } else {
                                this.similarityFields.get(field).setSelectedItem((Object)WeightChoice.Normal);
                            }
                        } else {
                            this.similarityFields.get(field).setSelectedItem((Object)WeightChoice.Normal);
                        }
                    }
                    ++n4;
                }
                for (JComboBox cb : this.similarityFields.values()) {
                    cb.setEnabled(false);
                }
                this.institutionCode.setText(this.extractFieldFromQuery(matchConfig.filterQuery(), "institution_code"));
                this.institutionCode.setEditable(false);
                this.collectionCode.setText(this.extractFieldFromQuery(matchConfig.filterQuery(), "collection_code"));
                this.collectionCode.setEditable(false);
                this.remarks.setText(matchConfig.remarks());
            } else {
                JComboBox<Object> availIndices;
                this.institutionCode.setText(AppContextMgr.getInstance().getClassObject(Institution.class).getCode());
                this.collectionCode.setText(AppContextMgr.getInstance().getClassObject(Collection.class).getCode());
                try {
                    this.indices = AvailableIndicesFetcher.getIndices();
                }
                catch (Exception e) {
                    throw new AvailableIndicesFetchException(e);
                }
                this.index = availIndices = new JComboBox<Object>(this.indices.keySet().toArray());
                Discipline disc = AppContextMgr.getInstance().getClassObject(Discipline.class);
                String discTitle = disc.getName();
                int i = 0;
                while (i < availIndices.getItemCount()) {
                    if (availIndices.getItemAt(i).equals(discTitle)) {
                        availIndices.setSelectedIndex(i);
                    }
                    ++i;
                }
            }
            int rows = this.similarityFields.size() + 7;
            StringBuilder colSpec = new StringBuilder();
            int i = 0;
            while (i < rows) {
                colSpec.append("p, 2dlu,");
                ++i;
            }
            colSpec.append("p");
            FormLayout layout = new FormLayout("right:max(50dlu;p), 4dlu, 150dlu:grow", colSpec.toString());
            PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            UIRegistry.loadAndPushResourceBundle("specify_plugins");
            int y = 1;
            builder.add((Component)UIHelper.createI18NFormLabel("SGR_MATCHER_NAME"), cc.xy(1, y));
            builder.add((Component)this.name, cc.xy(3, y));
            builder.add((Component)UIHelper.createI18NFormLabel("SGR_INDEX"), cc.xy(1, y += 2));
            builder.add((Component)this.index, cc.xy(3, y));
            builder.addSeparator(UIRegistry.getResourceString("SGR_EXCLUDE"), cc.xyw(1, y += 2, 3));
            builder.add((Component)UIHelper.createI18NFormLabel("SGR_INST_CODE"), cc.xy(1, y += 2));
            builder.add((Component)this.institutionCode, cc.xy(3, y));
            builder.add((Component)UIHelper.createI18NFormLabel("SGR_COLL_CODE"), cc.xy(1, y += 2));
            builder.add((Component)this.collectionCode, cc.xy(3, y));
            builder.addSeparator(UIRegistry.getResourceString("SGR_SIMILARITY"), cc.xyw(1, y += 2, 3));
            y += 2;
            SGRColumnOrdering columnOrdering = SGRColumnOrdering.getInstance();
            String[] stringArray3 = availableFields;
            int n5 = availableFields.length;
            int n6 = 0;
            while (n6 < n5) {
                String field = stringArray3[n6];
                if (this.similarityFields.containsKey(field)) {
                    String label = columnOrdering.getHeadingFor(field);
                    label = label == null ? WordUtils.capitalize((String)field) : label;
                    builder.add((Component)UIHelper.createFormLabel(label), cc.xy(1, y));
                    builder.add((Component)this.similarityFields.get(field), cc.xy(3, y));
                    y += 2;
                }
                ++n6;
            }
            builder.addSeparator(UIRegistry.getResourceString("SGR_REMARKS"), cc.xyw(1, y, 3));
            JScrollPane scrollPane = new JScrollPane(this.remarks, 20, 31);
            builder.add((Component)scrollPane, cc.xyw(1, y += 2, 3));
            y += 2;
            UIRegistry.popResourceBundle();
        }

        private String extractFieldFromQuery(String query, String field) {
            Query q;
            if (StringUtils.isBlank((String)query)) {
                return "";
            }
            StandardQueryParser qp = new StandardQueryParser();
            try {
                q = qp.parse(query, "defaultField");
            }
            catch (QueryNodeException e) {
                throw new RuntimeException(e);
            }
            HashSet terms = new HashSet();
            q.extractTerms(terms);
            for (Term t : terms) {
                if (!t.field().equals(field)) continue;
                return t.text();
            }
            return "";
        }

        private Set<String> parseSimilarityFields(String fields) {
            ImmutableSet.Builder b = ImmutableSet.builder();
            String[] stringArray = StringUtils.split((String)fields, (char)',');
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                b.add((Object)field.trim());
                ++n2;
            }
            return b.build();
        }

        private Map<String, Float> parseBoosts(String queryFields) {
            ImmutableMap.Builder b = ImmutableMap.builder();
            String[] stringArray = availableFields;
            int n = availableFields.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                Pattern p = Pattern.compile(String.valueOf(field) + "\\^" + "([-+]?[0-9]*\\.?[0-9]+)");
                Matcher m = p.matcher(queryFields);
                if (m.find()) {
                    b.put((Object)field, (Object)Float.valueOf(m.group(1)));
                }
                ++n2;
            }
            return b.build();
        }
    }

    public static enum WeightChoice {
        Ignore,
        Low,
        Normal,
        High;

    }
}

