/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.sgr;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class SGRColumnOrdering {
    private static final SGRColumnOrdering instance = new SGRColumnOrdering();
    private String[] fields = new String[]{"id", "catalog_number", "collector_number", "collectors", "scientific_name", "determiner", "determination_date", "date_collected", "latitude", "longitude", "locality", "municipality_name", "county_name", "state_name", "country_name", "institution_code", "collection_code", "source", "score"};
    private static final Map<String, String> fieldHeadings = new HashMap<String, String>();

    static {
        fieldHeadings.put("id", "ID");
        fieldHeadings.put("catalog_number", "Catalog #");
        fieldHeadings.put("collector_number", "Collector/Field #");
        fieldHeadings.put("collectors", "Collectors");
        fieldHeadings.put("scientific_name", "Taxon Name");
        fieldHeadings.put("determiner", "Determiner");
        fieldHeadings.put("determination_date", "Det. Date");
        fieldHeadings.put("date_collected", "Date");
        fieldHeadings.put("latitude", "Latitude");
        fieldHeadings.put("longitude", "Longitude");
        fieldHeadings.put("locality", "Locality");
        fieldHeadings.put("municipality_name", "Municipality");
        fieldHeadings.put("county_name", "County");
        fieldHeadings.put("state_name", "State");
        fieldHeadings.put("country_name", "Country");
        fieldHeadings.put("institution_code", "Institution");
        fieldHeadings.put("collection_code", "Collection");
        fieldHeadings.put("source", "Source");
        fieldHeadings.put("score", "Score");
    }

    public static SGRColumnOrdering getInstance() {
        return instance;
    }

    private SGRColumnOrdering() {
    }

    public String[] getFields() {
        return this.fields;
    }

    public void moveColumn(int from, int to) {
        if (to == from) {
            return;
        }
        String s = this.fields[from];
        this.fields[from] = this.fields[to];
        this.fields[to] = s;
    }

    public String getHeadingFor(String field) {
        return fieldHeadings.get(field);
    }

    public String[] getHeadings() {
        LinkedList<String> headings = new LinkedList<String>();
        String[] stringArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            headings.add(this.getHeadingFor(field));
            ++n2;
        }
        return headings.toArray(new String[headings.size()]);
    }
}

