/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.sgr;

import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.sgr.BatchMatchResultAccumulator;
import edu.ku.brc.sgr.BatchMatcher;
import edu.ku.brc.sgr.Matchable;
import edu.ku.brc.sgr.SGRMatcher;
import edu.ku.brc.sgr.datamodel.AccumulateResults;
import edu.ku.brc.sgr.datamodel.BatchMatchResultSet;
import edu.ku.brc.sgr.datamodel.DataModel;
import edu.ku.brc.sgr.datamodel.MatchConfiguration;
import edu.ku.brc.ui.UIRegistry;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class SGRBatchScenario {
    private SwingWorker<Integer, Integer> worker = null;
    private final List<Runnable> onFinished = new LinkedList<Runnable>();
    private final SGRMatcher matcher;
    private BatchMatchResultSet resultSet = null;
    private final RecordGenerator recordGenerator;
    private boolean started = false;
    private AccumulateResults accumulator;
    private BatchMatcher batchMatcher;

    public SGRBatchScenario(BatchMatchResultSet resultSet, RecordGenerator recordGenerator) {
        this.resultSet = resultSet;
        this.recordGenerator = recordGenerator;
        this.matcher = this.setupMatcher(resultSet.getMatchConfiguration());
    }

    public SGRBatchScenario(RecordSetIFace recordSet, MatchConfiguration matchConfig, RecordGenerator recordGenerator, String sourceName, Long sourceId) {
        this.recordGenerator = recordGenerator;
        this.matcher = this.setupMatcher(matchConfig);
        String name = String.valueOf(sourceName) + " " + matchConfig.name();
        this.resultSet = DataModel.createBatchMatchResultSet((String)name, (SGRMatcher)this.matcher, (Long)sourceId, (Integer)recordSet.getDbTableId(), (long)matchConfig.id());
    }

    public SGRBatchScenario(MatchConfiguration matchConfig, RecordGenerator recordGenerator, String sourceName, Long sourceId, Integer dbTableId) {
        this.recordGenerator = recordGenerator;
        this.matcher = this.setupMatcher(matchConfig);
        String name = String.valueOf(sourceName) + " " + matchConfig.name();
        this.resultSet = DataModel.createBatchMatchResultSet((String)name, (SGRMatcher)this.matcher, (Long)sourceId, (Integer)dbTableId, (long)matchConfig.id());
    }

    private SGRMatcher setupMatcher(MatchConfiguration matchConfig) {
        SGRMatcher.Factory matcherFactory = matchConfig.createMatcherFactory();
        matcherFactory.docSupplied = true;
        matcherFactory.debugQuery = false;
        try {
            return matcherFactory.build();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public BatchMatchResultSet getResultSet() {
        return this.resultSet;
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("already started");
        }
        this.started = true;
        this.accumulator = new AccumulateResults(this.matcher, this.resultSet);
        this.batchMatcher = new BatchMatcher((Iterator)this.recordGenerator, (BatchMatchResultAccumulator)this.accumulator, 4);
        this.worker = new SwingWorker<Integer, Integer>(){

            /*
             * Unable to fully structure code
             */
            @Override
            protected Integer doInBackground() throws Exception {
                try {
                    SGRBatchScenario.access$3(SGRBatchScenario.this).run();
                }
                finally {
                    SGRBatchScenario.access$0(SGRBatchScenario.this, null);
                    SGRBatchScenario.access$1(SGRBatchScenario.this).close();
                    ** for (r : SGRBatchScenario.access$2((SGRBatchScenario)SGRBatchScenario.this))
                }
lbl-1000:
                // 1 sources

                {
                    SwingUtilities.invokeLater(r);
                    continue;
                }
lbl10:
                // 1 sources

                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    Logger.getLogger(SGRBatchScenario.class).error((Object)"Failed to fetch SGR results from SGR server.", (Throwable)e);
                    UIRegistry.loadAndPushResourceBundle("specify_plugins");
                    UIRegistry.showLocalizedError("SGR_ERROR_SERVER_FAIL");
                    UIRegistry.popResourceBundle();
                }
            }
        };
        this.worker.execute();
    }

    public boolean isRunning() {
        return this.worker != null;
    }

    public void abort() {
        if (this.isRunning()) {
            this.worker.cancel(true);
        } else {
            this.recordGenerator.close();
        }
    }

    public void addOnFinished(Runnable func) {
        this.onFinished.add(func);
    }

    public int totalRecords() {
        if (!this.started) {
            throw new IllegalStateException("not started");
        }
        return this.recordGenerator.totalRecords();
    }

    public int finishedRecords() {
        if (!this.started) {
            throw new IllegalStateException("not started");
        }
        return this.accumulator.nCompleted();
    }

    static /* synthetic */ void access$0(SGRBatchScenario sGRBatchScenario, SwingWorker swingWorker) {
        sGRBatchScenario.worker = swingWorker;
    }

    static /* synthetic */ RecordGenerator access$1(SGRBatchScenario sGRBatchScenario) {
        return sGRBatchScenario.recordGenerator;
    }

    static /* synthetic */ List access$2(SGRBatchScenario sGRBatchScenario) {
        return sGRBatchScenario.onFinished;
    }

    static /* synthetic */ BatchMatcher access$3(SGRBatchScenario sGRBatchScenario) {
        return sGRBatchScenario.batchMatcher;
    }

    public static interface RecordGenerator
    extends Iterator<Matchable> {
        public int totalRecords();

        public void close();
    }
}

