/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.sgr;

import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.sgr.Matchable;
import edu.ku.brc.sgr.MatchableIndexedId;
import edu.ku.brc.sgr.datamodel.BatchMatchResultSet;
import edu.ku.brc.sgr.datamodel.MatchConfiguration;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.plugins.sgr.SGRBatchScenario;
import java.util.Iterator;

public class RecordSetBatchMatch {
    public static SGRBatchScenario newScenario(RecordSetIFace recordSet, MatchConfiguration matchConfig) {
        if (!recordSet.getDataClassFormItems().equals(CollectionObject.class)) {
            throw new IllegalArgumentException("record set must contain collection objects");
        }
        return new SGRBatchScenario(recordSet, matchConfig, RecordSetBatchMatch.recordGenerator(recordSet), recordSet.getName(), (long)recordSet.getRecordSetId());
    }

    public static SGRBatchScenario resumeScenario(BatchMatchResultSet resultSet) {
        Long recordSetId = resultSet.getRecordSetId();
        if (recordSetId == null) {
            throw new IllegalArgumentException("result set has no associated record set");
        }
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        RecordSet recordSet = session.getData(RecordSet.class, "recordSetId", recordSetId, DataProviderSessionIFace.CompareType.Equals);
        return new SGRBatchScenario(resultSet, RecordSetBatchMatch.recordGenerator(recordSet));
    }

    private static SGRBatchScenario.RecordGenerator recordGenerator(final RecordSetIFace recordSet) {
        return new SGRBatchScenario.RecordGenerator(){
            Iterator<RecordSetItemIFace> items;
            {
                this.items = recordSetIFace.getItems().iterator();
            }

            @Override
            public Matchable next() {
                return RecordSetBatchMatch.item2Matchable(this.items.next());
            }

            @Override
            public boolean hasNext() {
                return this.items.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }

            @Override
            public int totalRecords() {
                return recordSet.getNumItems();
            }
        };
    }

    private static Matchable item2Matchable(RecordSetItemIFace item) {
        return new MatchableIndexedId(String.valueOf(item.getRecordId().toString()) + "-KANU");
    }
}

