/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.sgr;

import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.tasks.subpane.BaseSubPane;
import edu.ku.brc.sgr.datamodel.BatchMatchResultSet;
import edu.ku.brc.specify.plugins.sgr.SGRBatchScenario;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class HistogramChart
extends BaseSubPane {
    final SwingWorker<Void, Void> chartUpdater;
    private final BatchMatchResultSet resultSet;

    public HistogramChart(String name, Taskable task, BatchMatchResultSet resultSet, final SGRBatchScenario scenario, float binSize) {
        super(name, task);
        this.resultSet = resultSet;
        this.update();
        this.chartUpdater = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Thread.currentThread().setName("Histogram-Updater");
                while (true) {
                    try {
                        if (!scenario.isRunning()) {
                            return null;
                        }
                    }
                    catch (NullPointerException e) {
                        return null;
                    }
                    Thread.sleep(2000L);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HistogramChart.this.update();
                        }
                    });
                }
            }
        };
        this.chartUpdater.execute();
    }

    private void update() {
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        HistogramDataset dataSet = new HistogramDataset();
        double max = this.resultSet.getMax();
        dataSet.addSeries((Comparable)((Object)UIRegistry.getResourceString("SGR_HISTO_DATASERIES")), this.resultSet.getValues(1.0), 40, 0.0, max);
        JFreeChart chart = ChartFactory.createHistogram((String)UIRegistry.getResourceString("SGR_HISTO_TITLE"), (String)UIRegistry.getResourceString("SGR_HISTO_X_AXIS"), (String)UIRegistry.getResourceString("SGR_HISTO_Y_AXIS"), (IntervalXYDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        UIRegistry.popResourceBundle();
        XYPlot plot = chart.getXYPlot();
        CustomRenderer.setDefaultBarPainter((XYBarPainter)new StandardXYBarPainter());
        CustomRenderer renderer = new CustomRenderer(dataSet);
        plot.setRenderer((XYItemRenderer)renderer);
        renderer.setMargin(0.1);
        ChartPanel chartPanel = new ChartPanel(chart, true, true, true, true, true);
        this.removeAll();
        this.add((Component)chartPanel);
        this.validate();
    }

    @Override
    public void shutdown() {
        this.chartUpdater.cancel(true);
        this.removeAll();
        super.shutdown();
    }

    public BatchMatchResultSet getResultSet() {
        return this.resultSet;
    }

    private static class ChartBoundingPanel
    extends JPanel
    implements ChartMouseListener {
        private ChartPanel chartPanel;
        private Rectangle rect = null;
        private Rectangle[] boundings = null;
        private CategoryItemEntity[] currEntities = null;
        private ImageIcon thumb = IconManager.getIcon("TTV_ToParent");
        private BasicStroke lineStroke = new BasicStroke(2.0f, 1, 1);
        private CategoryItemEntity currEntity = null;
        private Integer currEntityIndex = null;
        private ArrayList<CategoryItemEntity> entities = null;
        private int maxHeight = 0;
        private int maxY = 0;

        public ChartBoundingPanel(ChartPanel chartPanel) {
            super(new BorderLayout());
            this.chartPanel = chartPanel;
            this.add((Component)chartPanel, "Center");
            chartPanel.addChartMouseListener((ChartMouseListener)this);
            chartPanel.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (ChartBoundingPanel.this.currEntityIndex != null) {
                        ((ChartBoundingPanel)ChartBoundingPanel.this).currEntities[((ChartBoundingPanel)ChartBoundingPanel.this).currEntityIndex.intValue()] = ChartBoundingPanel.this.currEntity;
                        ChartBoundingPanel.this.currEntityIndex = null;
                    } else if (ChartBoundingPanel.this.currEntity != null) {
                        int i = 0;
                        while (i < ChartBoundingPanel.this.currEntities.length) {
                            System.out.println(String.valueOf(i) + "  " + ChartBoundingPanel.this.currEntities[i].hashCode());
                            ++i;
                        }
                        Number val2 = ChartBoundingPanel.this.currEntity.getDataset().getValue(ChartBoundingPanel.this.currEntity.getRowKey(), ChartBoundingPanel.this.currEntity.getColumnKey());
                        int i2 = 0;
                        while (i2 < ChartBoundingPanel.this.currEntities.length) {
                            Number val1 = ChartBoundingPanel.this.currEntities[i2].getDataset().getValue(ChartBoundingPanel.this.currEntities[i2].getRowKey(), ChartBoundingPanel.this.currEntities[i2].getColumnKey());
                            if (val1.doubleValue() == val2.doubleValue()) {
                                ChartBoundingPanel.this.currEntityIndex = i2;
                                break;
                            }
                            ++i2;
                        }
                    }
                }
            });
        }

        protected Rectangle adjustRect(Rectangle rect) {
            int x = rect.x + (int)(rect.getWidth() / 2.0);
            rect.x = x = (int)((double)x * this.chartPanel.getScaleX());
            rect.width = (int)((double)rect.width * this.chartPanel.getScaleX());
            rect.y = (int)((double)rect.y * this.chartPanel.getScaleY());
            rect.height = (int)((double)rect.height * this.chartPanel.getScaleY());
            return rect;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.rect != null) {
                int i;
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(Color.RED);
                this.adjustRect(this.rect);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setStroke(this.lineStroke);
                if (this.boundings == null) {
                    this.boundings = new Rectangle[4];
                    if (this.entities == null) {
                        this.entities = new ArrayList();
                        EntityCollection entCol = this.chartPanel.getChartRenderingInfo().getEntityCollection();
                        int i2 = 0;
                        while (i2 < entCol.getEntityCount()) {
                            ChartEntity ce = entCol.getEntity(i2);
                            if (ce instanceof CategoryItemEntity) {
                                CategoryItemEntity cie = (CategoryItemEntity)ce;
                                Rectangle r = this.adjustRect(cie.getArea().getBounds());
                                if (r.height > this.maxHeight) {
                                    this.maxHeight = (int)cie.getArea().getBounds().getHeight();
                                    this.maxY = r.y;
                                }
                                this.entities.add(cie);
                            }
                            ++i2;
                        }
                    }
                    int half = (this.entities.size() - 1) / 2;
                    this.boundings[0] = this.getEntityPoint(this.entities, 0);
                    this.boundings[1] = this.getEntityPoint(this.entities, half);
                    this.boundings[2] = this.getEntityPoint(this.entities, half + 1);
                    this.boundings[3] = this.getEntityPoint(this.entities, this.entities.size() - 1);
                    int[] nArray = new int[4];
                    nArray[1] = half;
                    nArray[2] = half + 1;
                    nArray[3] = this.entities.size() - 1;
                    int[] inxs = nArray;
                    this.currEntities = new CategoryItemEntity[4];
                    i = 0;
                    while (i < inxs.length) {
                        this.currEntities[i] = this.entities.get(inxs[i]);
                        ++i;
                    }
                }
                Rectangle[] rectangleArray = this.boundings;
                i = this.boundings.length;
                int inxs = 0;
                while (inxs < i) {
                    Rectangle r = rectangleArray[inxs];
                    g.drawImage(this.thumb.getImage(), r.x - this.thumb.getIconWidth() / 2 + 2, r.y + r.height - this.thumb.getIconHeight(), null);
                    ++inxs;
                }
                int x = (int)((double)this.boundings[0].x * 1.0);
                int w = (int)((double)(this.boundings[1].x - this.boundings[0].x) * 1.0);
                int h = (int)((double)this.maxHeight * this.chartPanel.getScaleY());
                g2d.setColor(new Color(255, 255, 255, 64));
                g2d.fillRect(x + 2, this.maxY, w, h);
                x = (int)((double)this.boundings[2].x * 1.0);
                w = (int)((double)(this.boundings[3].x - this.boundings[2].x) * 1.0);
                g2d.setColor(new Color(255, 255, 255, 64));
                g2d.fillRect(x + 2, this.maxY, w, h);
            }
        }

        private Rectangle getEntityPoint(ArrayList<CategoryItemEntity> entities, int index) {
            CategoryItemEntity cie = entities.get(index);
            Rectangle r = (Rectangle)cie.getArea().getBounds().clone();
            this.adjustRect(r);
            return r;
        }

        public void chartMouseClicked(ChartMouseEvent ev) {
            this.repaint();
        }

        public void chartMouseMoved(ChartMouseEvent ev) {
            this.currEntity = null;
            ChartEntity ce = ev.getEntity();
            if (ce instanceof CategoryItemEntity) {
                CategoryItemEntity cie;
                this.currEntity = cie = (CategoryItemEntity)ce;
                Shape shape = ce.getArea();
                this.rect = shape.getBounds();
                this.repaint();
            }
            if (this.currEntityIndex != null && this.currEntity != null) {
                this.boundings[this.currEntityIndex.intValue()] = this.adjustRect((Rectangle)this.currEntity.getArea().getBounds().clone());
                this.repaint();
            }
        }
    }

    private static class CustomRenderer
    extends XYBarRenderer {
        private final HistogramDataset data;

        public CustomRenderer(HistogramDataset data) {
            this.data = data;
        }

        public Paint getItemPaint(int row, int col) {
            double score = this.data.getStartXValue(row, col);
            double maxScore = this.data.getStartXValue(row, this.data.getItemCount(row) - 1);
            float x = (float)(Math.log(score / maxScore + 1.0) / Math.log(2.0));
            float h = 130.0f + 240.0f * (x - 1.0f);
            return Color.getHSBColor(h / 360.0f, 0.6f, 0.9f);
        }
    }
}

