/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.sgr;

import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.NavBoxButton;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.sgr.datamodel.BatchMatchResultSet;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.plugins.sgr.BatchResultPropertyEditor;
import edu.ku.brc.specify.plugins.sgr.SGRBatchScenario;
import edu.ku.brc.specify.plugins.sgr.WorkBenchBatchMatch;
import edu.ku.brc.specify.tasks.SGRTask;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandActionWrapper;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.Trash;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class BatchResultsMgr
extends NavBoxButton {
    public static final long PROGRESS_UPDATE_INTERVAL = 2000L;
    private final String sgrBatchItemsLabel;
    private SGRBatchScenario scenario;
    private JMenuItem stopProcessing;
    private JMenuItem resumeProcessing;
    private ProgressUpdater progressUpdater;
    private BatchMatchResultSet resultSet;

    public BatchResultsMgr(BatchMatchResultSet resultSet, PermissionIFace permissions) {
        this(resultSet, null, permissions);
    }

    public BatchResultsMgr(final BatchMatchResultSet resultSet, SGRBatchScenario initialScenario, PermissionIFace permissions) {
        super(resultSet.name(), IconManager.getIcon("SGR", IconManager.STD_ICON_SIZE));
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        this.scenario = initialScenario;
        this.resultSet = resultSet;
        this.sgrBatchItemsLabel = UIRegistry.getResourceString("SGR_BATCH_ITEMS");
        this.setData(resultSet);
        this.doToolTip();
        JPopupMenu popupMenu = new JPopupMenu();
        UIHelper.createLocalizedMenuItem(popupMenu, "SGR_EDIT_BATCH_RESULTS", "", null, true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final BatchResultPropertyEditor editor = new BatchResultPropertyEditor(BatchResultsMgr.this);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editor.setVisible(true);
                    }
                });
            }
        });
        this.stopProcessing = UIHelper.createLocalizedMenuItem(popupMenu, "SGR_STOP_PROCESSING", "", null, this.scenario != null && this.scenario.isRunning(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (BatchResultsMgr.this.scenario != null && BatchResultsMgr.this.scenario.isRunning()) {
                    BatchResultsMgr.this.scenario.abort();
                } else {
                    BatchResultsMgr.this.stopProcessing.setEnabled(false);
                    BatchResultsMgr.this.resumeProcessing.setEnabled(true);
                    BatchResultsMgr.this.setIcon(IconManager.getIcon("SGR", IconManager.STD_ICON_SIZE));
                }
            }
        });
        this.resumeProcessing = UIHelper.createLocalizedMenuItem(popupMenu, "SGR_RESUME_PROCESSING", "", null, this.scenario == null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (resultSet.getdbTableId().equals(Workbench.getClassTableId())) {
                    BatchResultsMgr.this.scenario = WorkBenchBatchMatch.resumeScenario(resultSet);
                    BatchResultsMgr.this.scenario.start();
                    BatchResultsMgr.this.stopProcessing.setEnabled(true);
                    BatchResultsMgr.this.resumeProcessing.setEnabled(false);
                    BatchResultsMgr.this.setUpScenario();
                }
            }
        });
        UIHelper.createLocalizedMenuItem(popupMenu, "SGR_SHOW_HISTOGRAM", "", null, true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SGRTask sgr = (SGRTask)ContextMgr.getTaskByClass(SGRTask.class);
                sgr.addHistogram(resultSet, BatchResultsMgr.this.scenario, 0.5f);
            }
        });
        this.setUpScenario();
        CommandAction delCmdAction = new CommandAction("SGR", "Delete", this);
        this.setDeleteCommandAction(delCmdAction);
        this.addDragDataFlavor(Trash.TRASH_FLAVOR);
        UIHelper.createLocalizedMenuItem(popupMenu, "DELETE", "", null, true, (ActionListener)new CommandActionWrapper(delCmdAction));
        this.setPopupMenu(popupMenu);
        this.addActionListener(new CommandActionWrapper(new CommandAction("SGR", "selected_resultset")));
        this.createMouseInputAdapter();
        this.setCursor(new Cursor(12));
        UIRegistry.popResourceBundle();
    }

    public void delete() {
        if (this.scenario != null) {
            this.scenario.abort();
        }
        this.resultSet.delete();
    }

    private void setUpScenario() {
        if (this.scenario != null) {
            this.scenario.addOnFinished(new Runnable(){

                @Override
                public void run() {
                    BatchResultsMgr.this.stopProcessing.setEnabled(false);
                    BatchResultsMgr.this.resumeProcessing.setEnabled(true);
                    BatchResultsMgr.this.scenario = null;
                    BatchResultsMgr.this.setIcon(IconManager.getIcon("SGR", IconManager.STD_ICON_SIZE));
                }
            });
            if (this.scenario.isRunning()) {
                this.setIcon(IconManager.getIcon("SGRGEAR", IconManager.STD_ICON_SIZE));
                this.progressUpdater = new ProgressUpdater();
                this.progressUpdater.execute();
            } else {
                this.setIcon(IconManager.getIcon("SGR", IconManager.STD_ICON_SIZE));
            }
        }
    }

    private void doToolTip() {
        String toolTip = this.resultSet.nItems() + " " + this.sgrBatchItemsLabel;
        this.setToolTip(toolTip);
    }

    private class ProgressUpdater
    extends SwingWorker<Void, Double> {
        private ProgressUpdater() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            while (true) {
                try {
                    try {
                        if (!BatchResultsMgr.this.scenario.isRunning()) {
                            throw new ScenarioNotRunning();
                        }
                    }
                    catch (NullPointerException e) {
                        throw new ScenarioNotRunning();
                    }
                }
                catch (ScenarioNotRunning e) {
                    BatchResultsMgr.this.doToolTip();
                    return null;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (BatchResultsMgr.this.scenario == null) {
                            return;
                        }
                        String toolTip = BatchResultsMgr.this.scenario.finishedRecords() + " / " + BatchResultsMgr.this.scenario.totalRecords();
                        BatchResultsMgr.this.setToolTip(toolTip);
                    }
                });
                Thread.sleep(2000L);
            }
        }
    }

    private static class ScenarioNotRunning
    extends Exception {
        private ScenarioNotRunning() {
        }
    }
}

