/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.sgr;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.NavBoxButton;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.sgr.datamodel.BatchMatchResultSet;
import edu.ku.brc.sgr.datamodel.MatchConfiguration;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;

public class BatchResultPropertyEditor
extends CustomDialog {
    private UIPanel uiPanel;
    private BatchMatchResultSet resultSet;
    private NavBoxItemIFace nbi;

    public BatchResultPropertyEditor(NavBoxItemIFace nbi) {
        super((Frame)UIRegistry.getTopWindow(), "", true, 7, (Component)new UIPanel());
        this.nbi = nbi;
        this.helpContext = "sgr_matchresults_properties";
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        this.setTitle(UIRegistry.getResourceString("SGR_EDIT_BATCH_RESULTS"));
        this.resultSet = (BatchMatchResultSet)nbi.getData();
        MatchConfiguration matcher = this.resultSet.getMatchConfiguration();
        this.uiPanel = (UIPanel)this.getContentPanel();
        this.uiPanel.name.setText(this.resultSet.name());
        this.uiPanel.matcher.setText(matcher.name());
        this.uiPanel.remarks.setText(this.resultSet.remarks());
        this.pack();
        UIRegistry.popResourceBundle();
    }

    @Override
    protected void okButtonPressed() {
        String name = this.uiPanel.name.getText();
        if (StringUtils.isBlank((String)name)) {
            UIRegistry.loadAndPushResourceBundle("specify_plugins");
            UIRegistry.showLocalizedError("SGR_BLANK_RESULTSET_NAME_ERROR");
            UIRegistry.popResourceBundle();
            return;
        }
        this.resultSet.updateProperties(name, this.uiPanel.remarks.getText());
        ((NavBoxButton)this.nbi).setLabelText(name);
        ((NavBoxButton)this.nbi).getParent().repaint();
        this.dispose();
    }

    private static class UIPanel
    extends JPanel {
        JTextField name = new JTextField();
        JTextField matcher = new JTextField();
        JTextArea remarks = new JTextArea(10, 20);

        public UIPanel() {
            this.remarks.setLineWrap(true);
            this.remarks.setWrapStyleWord(true);
            FormLayout layout = new FormLayout("right:max(50dlu;p), 4dlu, 150dlu:grow", "p, 2dlu, p, 2dlu, p");
            PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            UIRegistry.loadAndPushResourceBundle("specify_plugins");
            builder.addLabel(UIRegistry.getResourceString("SGR_BATCH_RESULTS_NAME"), cc.xy(1, 1));
            builder.add((Component)this.name, cc.xy(3, 1));
            builder.addLabel(UIRegistry.getResourceString("SGR_MATCHER"), cc.xy(1, 3));
            builder.add((Component)this.matcher, cc.xy(3, 3));
            this.matcher.setEditable(false);
            builder.addLabel(UIRegistry.getResourceString("SGR_REMARKS"), cc.xy(1, 5));
            JScrollPane scrollPane = new JScrollPane(this.remarks, 20, 31);
            builder.add((Component)scrollPane, cc.xy(3, 5));
            UIRegistry.popResourceBundle();
        }
    }
}

