/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.morphbank;

import java.io.File;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;

public class PostXMLSp {
    static String UPLOAD_FILE = "/home/timo/mb.xml";
    static String MorphBankServiceURL = "http://services.morphbank.net/mbd/restful";

    public static void main(String[] args) throws Exception {
        PostXMLSp postXML = new PostXMLSp();
        String uploadFile = UPLOAD_FILE;
        if (args.length > 0) {
            uploadFile = args[0];
        } else {
            System.out.println("Usage: java net.morphbank.webclient.PostXML [filepath] ");
        }
        PostResponse pr = postXML.post(uploadFile);
        System.out.println("status: " + pr.getStatusCode());
        System.out.println("response:");
        System.out.println(pr.getBody());
    }

    public PostResponse post(String strXMLFilename) throws Exception {
        File input = new File(strXMLFilename);
        PostMethod post = new PostMethod(MorphBankServiceURL);
        Part[] parts = new Part[]{new FilePart("uploadFile", strXMLFilename, input)};
        MultipartRequestEntity entity = new MultipartRequestEntity(parts, post.getParams());
        post.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            PostResponse postResponse = new PostResponse(result, post.getResponseBodyAsString());
            return postResponse;
        }
        finally {
            post.releaseConnection();
        }
    }

    public class PostResponse {
        protected final int statusCode;
        protected final String body;

        public PostResponse(int statusCode, String body) {
            this.statusCode = statusCode;
            this.body = body;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getBody() {
            return this.body;
        }
    }
}

