/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.morphbank;

import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.ObjectAttachmentIFace;
import edu.ku.brc.specify.plugins.morphbank.CollectionObjectFieldMapper;
import edu.ku.brc.specify.plugins.morphbank.DwcMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.util.Vector;
import net.morphbank.mbsvc3.xml.Credentials;
import net.morphbank.mbsvc3.xml.Insert;
import net.morphbank.mbsvc3.xml.Request;
import net.morphbank.mbsvc3.xml.XmlBaseObject;
import net.morphbank.mbsvc3.xml.XmlId;
import net.morphbank.mbsvc3.xml.XmlUtils;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.lang.NotImplementedException;

public class MorphBankTest {
    public static String MORPHBANK_URL = "http://www.morphbank.net";
    public static String MORPHBANK_IM_POST_URL = "http://itest.morphbank.net/Image/imageFileUpload.php";
    public static String MORPHBANK_IMAGE_Q = "?id=";

    protected static XmlBaseObject createXmlSpecimen(CollectionObjectFieldMapper mapper) throws Exception {
        XmlBaseObject xmlSpecimen = new XmlBaseObject("Specimen");
        xmlSpecimen.addDescription("From specimen " + mapper.getSpecNumber(null));
        mapper.setXmlSpecimenFields(xmlSpecimen);
        return xmlSpecimen;
    }

    public static Request createRequestFromCollectionObjectId(Integer id, Credentials submitter, Credentials owner, DwcMapper dwcMapper) throws Exception {
        return MorphBankTest.createRequestFromCollectionObjectId(id, submitter, owner, new CollectionObjectFieldMapper(id, dwcMapper));
    }

    public static Request createRequestFromCollectionObjectId(Integer id, Credentials submitter, Credentials owner, CollectionObjectFieldMapper fieldMapper) throws Exception {
        Request request = new Request();
        request.setSubmitter(submitter);
        Insert insert = new Insert();
        insert.setContributor(owner);
        request.getInsert().add(insert);
        XmlBaseObject xmlSpecimen = MorphBankTest.createXmlSpecimen(fieldMapper);
        xmlSpecimen.setOwner(owner);
        insert.getXmlObjectList().add(xmlSpecimen);
        Vector<XmlBaseObject> xmlImages = fieldMapper.getXmlImages();
        for (XmlBaseObject xmlImage : xmlImages) {
            xmlImage.setOwner(owner);
            xmlImage.getView().add(new XmlId(77407));
            insert.getXmlObjectList().add(xmlImage);
        }
        return request;
    }

    public static Request createRequestFromCollectionObject(CollectionObject obj, Credentials submitter, Credentials owner, Integer mappingId) throws Exception {
        CollectionObjectFieldMapper fieldMapper = new CollectionObjectFieldMapper(obj, mappingId);
        Request request = new Request();
        request.setSubmitter(submitter);
        Insert insert = new Insert();
        insert.setContributor(owner);
        request.getInsert().add(insert);
        XmlBaseObject xmlSpecimen = MorphBankTest.createXmlSpecimen(fieldMapper);
        insert.getXmlObjectList().add(xmlSpecimen);
        Vector<XmlBaseObject> xmlImages = fieldMapper.getXmlImages();
        for (XmlBaseObject xmlImage : xmlImages) {
            xmlImage.getView().add(new XmlId(77407));
            insert.getXmlObjectList().add(xmlImage);
        }
        return request;
    }

    public static Request createRequestFromImage(ObjectAttachmentIFace<?> image, Integer conceptMappingId, Credentials submitter, Credentials owner) throws Exception {
        if (!(image.getObject() instanceof CollectionObject)) {
            throw new NotImplementedException("MorphBankTest attachment type not supported: " + image.getClass().getName());
        }
        CollectionObjectFieldMapper fieldMapper = new CollectionObjectFieldMapper((CollectionObject)image.getObject(), conceptMappingId);
        Request request = new Request();
        request.setSubmitter(submitter);
        Insert insert = new Insert();
        insert.setContributor(owner);
        request.getInsert().add(insert);
        XmlBaseObject xmlSpecimen = MorphBankTest.createXmlSpecimen(fieldMapper);
        insert.getXmlObjectList().add(xmlSpecimen);
        XmlBaseObject xmlImage = fieldMapper.getXmlImage(image);
        xmlImage.getView().add(new XmlId(2088978));
        insert.getXmlObjectList().add(xmlImage);
        return request;
    }

    public static PostMethod getImagePostRequest(String id, String imageFileName) throws Exception {
        return MorphBankTest.getImagePostRequest(MORPHBANK_IM_POST_URL, id, "dummy", imageFileName);
    }

    public static PostMethod getImagePostRequest(String strURL, String id, String originalFileName, String imageFileName) throws Exception {
        File input = new File(imageFileName);
        PostMethod post = new PostMethod(strURL);
        Part[] parts = new Part[]{new StringPart("id", id), new StringPart("fileName", originalFileName), new FilePart("image", originalFileName, input)};
        MultipartRequestEntity entity = new MultipartRequestEntity(parts, post.getParams());
        post.setRequestEntity((RequestEntity)entity);
        return post;
    }

    public static void main(String[] args) {
        try {
            String connStr = "jdbc:mysql://localhost/lsusmollusca?characterEncoding=UTF-8&autoReconnect=true";
            CollectionObjectFieldMapper.connection = DwcMapper.connection = DriverManager.getConnection(connStr, "Master", "Master");
            FileWriter reportFile = new FileWriter("/home/timo/mbreport.xml");
            PrintWriter report = new PrintWriter(reportFile);
            Request request = MorphBankTest.createRequestFromCollectionObjectId((Integer)1, new Credentials(), new Credentials(), new DwcMapper());
            FileWriter outFile = new FileWriter("/home/timo/mb.xml");
            PrintWriter out = new PrintWriter(outFile);
            XmlUtils.printXml((PrintWriter)out, (Object)request);
            report.close();
            reportFile.close();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

