/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.morphbank;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.AttachmentImageAttribute;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.CollectionObjectAttachment;
import edu.ku.brc.specify.datamodel.ObjectAttachmentIFace;
import edu.ku.brc.specify.plugins.UIPluginBase;
import edu.ku.brc.specify.plugins.morphbank.MorphBankTest;
import edu.ku.brc.specify.plugins.morphbank.PostXMLSp;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ProgressDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.morphbank.mbsvc3.xml.Credentials;
import net.morphbank.mbsvc3.xml.Request;
import net.morphbank.mbsvc3.xml.XmlUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.NotImplementedException;
import org.dom4j.Element;
import org.dom4j.Node;

public class MorphBankPanel
extends UIPluginBase {
    protected static int kDetailsBtn = 0;
    protected static int kViewMBBtn = 1;
    protected static int kPutBtn = 2;
    protected static int kGetBtn = 3;
    protected static int kNotImageStatus = 4;
    protected static int kNotMorphBankedStatus = 5;
    protected static int kUpdatesNeededStatus = 6;
    protected static int kUpToDateStatus = 7;
    protected static int kMorphBankID = 8;
    protected static int kURLDisplayError = 9;
    protected static int kDetailsTitle = 10;
    protected static int kSendingToMorphbank = 11;
    protected static int kMoreThanOneImageObjectCreated = 12;
    protected static int kNoImageObjectCreated = 13;
    protected static int kSuccessfulImageInsert = 14;
    protected static int kImageInsertFailed = 15;
    protected static int kImageFileUploadFailed = 16;
    protected static int kDetailBtnHint = 17;
    protected static int kviewMBBtnHint = 18;
    protected static int kPutBtnHint = 19;
    protected static int kGetBtnHint = 20;
    protected static int kSettingsIncompleteHint = 21;
    protected static int textKeys = 22;
    protected String[] texts;
    protected JButton viewMBBtn;
    protected JButton putBtn;
    protected JButton getBtn;
    protected JButton detailsBtn;
    protected JLabel morphBankStatusLbl;
    protected CollectionObject colObj = null;
    protected Attachment attachment = null;
    protected ObjectAttachmentIFace<?> attacher = null;
    protected AttachmentImageAttribute imageAttribute = null;
    protected boolean isImage = false;
    protected AtomicBoolean isMorphBanked = new AtomicBoolean(false);
    protected String conceptMapping = null;
    protected Integer conceptMappingId = null;
    protected Integer ownerId = null;
    protected Integer groupId = null;
    protected String baseURL = null;
    protected String imageUploadURL = null;
    protected boolean settingsComplete = false;

    public MorphBankPanel() {
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        String[] keys = new String[]{"MorphBankPanel.DetailsBtn", "MorphBankPanel.ViewMBBtn", "MorphBankPanel.PutBtn", "MorphBankPanel.GetBtn", "MorphBankPanel.NotImageStatus", "MorphBankPanel.NotMorphBankedStatus", "MorphBankPanel.UpdatesNeededStatus", "MorphBankPanel.UpToDateStatus", "MorphBankPanel.MorphBankID", "MorphBankPanel.URLDisplayError", "MorphBankPanel.DetailsTitle", "MorphBankPanel.SendingToMorphbank", "MorphBankPanel.MoreThanOneImageObjectCreated", "MorphBankPanel.NoImageObjectCreated", "MorphBankPanel.SuccessfulImageInsert", "MorphBankPanel.ImageInsertFailed", "MorphBankPanel.ImageFileUploadFailed", "MorphBankPanel.DetailBtnHint", "MorphBankPanel.ViewMBBtnHint", "MorphBankPanel.PutBtnHint", "MorphBankPanel.GetBtnHint", "MorphBankPanel.SettingsIncompleteBtnHint"};
        this.texts = new String[textKeys];
        int k = 0;
        while (k < textKeys) {
            this.texts[k] = UIRegistry.getResourceString(keys[k]);
            ++k;
        }
        UIRegistry.popResourceBundle();
        AppPreferences prefs = AppPreferences.getRemote();
        String dwcName = prefs.get("morphbank.dwcmapping", null);
        if (dwcName != null) {
            this.conceptMappingId = (Integer)BasicSQLUtils.querySingleObj("select SpExportSchemaMappingID from spexportschemamapping where MappingName = '" + dwcName + "'");
        }
        this.ownerId = prefs.getInt("morphbank.userid", null);
        this.groupId = prefs.getInt("morphbank.groupid", null);
        this.baseURL = prefs.get("morphbank.baseurl", null);
        this.imageUploadURL = prefs.get("morphbank.imageposturl", null);
        if (this.baseURL != null) {
            MorphBankTest.MORPHBANK_URL = this.baseURL;
        }
        if (this.imageUploadURL != null) {
            MorphBankTest.MORPHBANK_IM_POST_URL = this.imageUploadURL;
        }
        this.settingsComplete = this.conceptMappingId != null && this.ownerId != null && this.groupId != null && this.baseURL != null && this.imageUploadURL != null;
    }

    protected Action addRecordKeyMappings(JComponent comp, int keyCode, String actionName, Action action) {
        InputMap inputMap = comp.getInputMap(1);
        ActionMap actionMap = comp.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(keyCode, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), actionName);
        actionMap.put(actionName, action);
        return action;
    }

    protected void createUI() {
        PanelBuilder tpb = new PanelBuilder(new FormLayout("2dlu, f:p:g, 2dlu, f:p, 2dlu, f:p, 2dlu, f:p, 2dlu, f:p, 2dlu", "2dlu, f:p, 2dlu"));
        CellConstraints cc = new CellConstraints();
        this.morphBankStatusLbl = new JLabel();
        tpb.add((Component)this.morphBankStatusLbl, cc.xy(2, 2));
        this.detailsBtn = UIHelper.createIconBtn("InfoIcon", IconManager.IconSize.Std24, null, false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MorphBankPanel.this.showMorphBankDetails();
            }
        });
        tpb.add((Component)this.detailsBtn, cc.xy(4, 2));
        this.viewMBBtn = UIHelper.createIconBtn("MorphBankLogo", IconManager.IconSize.Std24, null, false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MorphBankPanel.this.viewMorphBankImagePage(MorphBankPanel.this.getMbImageId());
                    }
                });
            }
        });
        tpb.add((Component)this.viewMBBtn, cc.xy(6, 2));
        this.putBtn = UIHelper.createIconBtn("Green Arrow Up", IconManager.IconSize.Std24, null, false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MorphBankPanel.this.sendToMorphBank(false);
            }
        });
        tpb.add((Component)this.putBtn, cc.xy(8, 2));
        this.getBtn = UIHelper.createIconBtn("Green Arrow Down", IconManager.IconSize.Std24, null, false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        tpb.add((Component)this.getBtn, cc.xy(10, 2));
        Color bgColor = this.getBackground();
        bgColor = new Color(Math.max(bgColor.getRed() - 20, 0), Math.max(bgColor.getGreen() - 20, 0), Math.max(bgColor.getBlue() - 20, 0));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(bgColor), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.add(tpb.getPanel());
    }

    protected void updateUIInfo() {
        this.setupButtons();
        this.morphBankStatusLbl.setText(this.getStatusText());
    }

    protected void setupButtons() {
        this.detailsBtn.setEnabled(this.isEnabled() && this.isMorphBanked.get());
        this.viewMBBtn.setEnabled(this.isEnabled() && this.isMorphBanked.get() && this.settingsComplete);
        this.putBtn.setEnabled(this.isEnabled() && this.isImage && this.settingsComplete && (!this.isMorphBanked.get() || this.updatesToPut()));
        this.getBtn.setEnabled(this.settingsComplete && this.isEnabled() && this.updatesToGet());
        this.setButtonHints();
    }

    protected void setButtonHints() {
        if (!this.settingsComplete) {
            this.detailsBtn.setToolTipText(this.texts[kSettingsIncompleteHint]);
            this.viewMBBtn.setToolTipText(this.texts[kSettingsIncompleteHint]);
            this.putBtn.setToolTipText(this.texts[kSettingsIncompleteHint]);
            this.getBtn.setToolTipText(this.texts[kSettingsIncompleteHint]);
        } else {
            this.detailsBtn.setToolTipText(this.texts[kDetailBtnHint]);
            this.viewMBBtn.setToolTipText(this.texts[kviewMBBtnHint]);
            this.putBtn.setToolTipText(this.texts[kPutBtnHint]);
            this.getBtn.setToolTipText(this.texts[kGetBtnHint]);
        }
    }

    protected String getStatusText() {
        if (!this.isImage) {
            return this.texts[kNotImageStatus];
        }
        if (!this.isMorphBanked.get()) {
            return this.texts[kNotMorphBankedStatus];
        }
        if (this.updatesToPut() || this.updatesToGet()) {
            return String.valueOf(this.getIdText()) + " [" + this.texts[kUpdatesNeededStatus] + "]";
        }
        return String.valueOf(this.getIdText()) + " [" + this.texts[kUpToDateStatus] + "]";
    }

    protected Integer getMbImageId() {
        if (this.isMorphBanked.get()) {
            return this.imageAttribute.getMbImageId();
        }
        return null;
    }

    protected String getIdText() {
        String result = this.texts[kMorphBankID];
        if (this.isMorphBanked.get()) {
            result = String.valueOf(result) + " " + this.getMbImageId();
        }
        return result;
    }

    protected boolean updatesToPut() {
        if (!this.isMorphBanked.get()) {
            return false;
        }
        AttachmentImageAttribute mbs = this.attachment.getAttachmentImageAttribute();
        if (mbs.getTimestampLastSend() == null) {
            return true;
        }
        return mbs.getTimestampLastSend().compareTo(this.attachment.getTimestampModified()) < 0;
    }

    protected boolean updatesToGet() {
        return false;
    }

    @Override
    public boolean isNotEmpty() {
        return false;
    }

    @Override
    public void initialize(Properties properties, boolean isViewMode) {
        super.initialize(properties, isViewMode);
        this.createUI();
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        this.colObj = null;
        this.isImage = false;
        this.isMorphBanked.set(false);
        this.attachment = null;
        this.attacher = null;
        if (value != null && this.fvo != null && this.fvo.getParentDataObj() != null && value instanceof AttachmentImageAttribute) {
            if (this.fvo.getParentDataObj() instanceof CollectionObjectAttachment) {
                this.imageAttribute = (AttachmentImageAttribute)value;
                this.attachment = this.imageAttribute.getAttachment();
                this.attacher = (CollectionObjectAttachment)this.fvo.getParentDataObj();
                this.colObj = ((CollectionObjectAttachment)this.attacher).getCollectionObject();
                if (this.attachment != null) {
                    this.isImage = this.isImageMimeType(this.attachment.getMimeType());
                    this.isMorphBanked.set(this.imageAttribute.getMbImageId() != null);
                }
            } else {
                throw new NotImplementedException("MorphBankUploadPanel does not support " + value.getClass().getName());
            }
        }
        this.setEnabled(this.isImage);
        this.updateUIInfo();
    }

    @Override
    public String[] getFieldNames() {
        return new String[]{"attachment", "collectionObject"};
    }

    protected void viewMorphBankImagePage(Integer imageId) {
        String url = String.valueOf(MorphBankTest.MORPHBANK_URL) + "/" + MorphBankTest.MORPHBANK_IMAGE_Q + imageId;
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (Exception ex) {
            UIRegistry.displayStatusBarErrMsg(String.format(this.texts[kURLDisplayError], url));
        }
    }

    protected void showMorphBankDetails() {
    }

    protected void sendToMorphBank(final boolean isUpdate) {
        if (isUpdate) {
            throw new NotImplementedException("MorphBankPanel.sendToMorphbank: updates not implemented");
        }
        final ProgressDialog progDlg = new ProgressDialog(this.texts[kSendingToMorphbank], false, false);
        progDlg.setResizable(false);
        progDlg.setDefaultCloseOperation(0);
        progDlg.setModal(true);
        progDlg.getProcessProgress().setIndeterminate(true);
        progDlg.setAlwaysOnTop(true);
        SwingWorker<Object, Object> sw = new SwingWorker<Object, Object>(){
            protected Integer morphBankImageId = null;
            protected String statusText = null;
            protected Boolean success = false;
            protected Boolean imageFilePosted = false;
            protected Exception killer = null;

            protected boolean updateMorphBankStatusRecord(Integer morphbankImageId, boolean isUpdate2) {
                if (isUpdate2) {
                    throw new NotImplementedException("MorphBankPanel.updateMorphBankStatusRecord: updates not implemented");
                }
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                boolean tblTransactionOpen = false;
                try {
                    session.attach(MorphBankPanel.this.attachment);
                    AttachmentImageAttribute aia = MorphBankPanel.this.attachment.getAttachmentImageAttribute();
                    if (aia == null) {
                        aia = new AttachmentImageAttribute();
                        aia.initialize();
                        aia.getAttachments().add(MorphBankPanel.this.attachment);
                        MorphBankPanel.this.attachment.setAttachmentImageAttribute(aia);
                    }
                    aia.setMbImageId(morphbankImageId);
                    aia.setTimestampLastSend(new Timestamp(System.currentTimeMillis()));
                    BusinessRulesIFace busRule = DBTableIdMgr.getInstance().getBusinessRule(AttachmentImageAttribute.class);
                    if (busRule != null) {
                        busRule.beforeSave(aia, session);
                    }
                    session.beginTransaction();
                    tblTransactionOpen = true;
                    session.saveOrUpdate(aia);
                    session.saveOrUpdate(MorphBankPanel.this.attachment);
                    if (busRule != null && !busRule.beforeSaveCommit(aia, session)) {
                        session.rollback();
                        throw new Exception("Business rules processing failed");
                    }
                    session.commit();
                    tblTransactionOpen = false;
                    if (busRule != null) {
                        busRule.afterSaveCommit(aia, session);
                    }
                    session.refresh(MorphBankPanel.this.attacher);
                    MorphBankPanel.this.imageAttribute = MorphBankPanel.this.attachment.getAttachmentImageAttribute();
                    MorphBankPanel.this.imageAttribute.forceLoad();
                    return true;
                }
                catch (Exception ex) {
                    if (tblTransactionOpen) {
                        session.rollback();
                    }
                    this.killer = ex;
                    return false;
                }
                finally {
                    session.close();
                }
            }

            private String getMorphbankIdStr(PostXMLSp.PostResponse response) {
                String result = null;
                try {
                    Element responseElement = XMLHelper.readStrToDOM4J(response.getBody());
                    for (Object respObj : responseElement.selectNodes("response/object")) {
                        Node id;
                        Element object = (Element)respObj;
                        if (!object.attributeValue("type").equals("Image") || (id = object.selectSingleNode("sourceId/morphbank")) == null) continue;
                        if (result != null) {
                            this.statusText = MorphBankPanel.this.texts[kMoreThanOneImageObjectCreated];
                            result = null;
                            break;
                        }
                        result = id.getText();
                    }
                }
                catch (Exception ex) {
                    this.killer = ex;
                    this.statusText = MorphBankPanel.this.texts[kNoImageObjectCreated];
                }
                return result;
            }

            private String getImageFileName() {
                File imageDir = AttachmentUtils.getAttachmentManager().getOriginal(MorphBankPanel.this.attachment);
                return imageDir.getAbsolutePath();
            }

            private boolean postImageFile() {
                boolean result = false;
                try {
                    PostMethod post = MorphBankTest.getImagePostRequest(this.morphBankImageId.toString(), this.getImageFileName());
                    HttpClient httpclient = new HttpClient();
                    int postStatus = httpclient.executeMethod((HttpMethod)post);
                    if (postStatus == 200) {
                        result = true;
                    }
                }
                catch (Exception ex) {
                    this.killer = ex;
                }
                if (!result) {
                    this.statusText = MorphBankPanel.this.texts[kImageFileUploadFailed];
                }
                return result;
            }

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    Request request = MorphBankTest.createRequestFromImage(MorphBankPanel.this.attacher, MorphBankPanel.this.conceptMappingId, MorphBankPanel.this.getSubmitterCredentials(), MorphBankPanel.this.getOwnerCredentials());
                    String requestFileName = String.valueOf(UIRegistry.getAppDataDir()) + File.separator + MorphBankPanel.this.colObj.getCatalogNumber() + ".xml";
                    FileWriter outFile = new FileWriter(requestFileName);
                    PrintWriter out = new PrintWriter(outFile);
                    XmlUtils.printXml((PrintWriter)out, (Object)request);
                    PostXMLSp poster = new PostXMLSp();
                    PostXMLSp.PostResponse response = poster.post(requestFileName);
                    if (response.getStatusCode() == 200) {
                        String morphbankIDStr = this.getMorphbankIdStr(response);
                        if (morphbankIDStr != null) {
                            this.morphBankImageId = Integer.valueOf(morphbankIDStr);
                            this.success = this.updateMorphBankStatusRecord(this.morphBankImageId, isUpdate);
                            if (this.success.booleanValue()) {
                                this.imageFilePosted = this.postImageFile();
                            }
                        } else {
                            this.statusText = MorphBankPanel.this.texts[kNoImageObjectCreated];
                        }
                    }
                }
                catch (Exception e) {
                    this.killer = e;
                    this.success = false;
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                progDlg.setVisible(false);
                if (this.success.booleanValue() && this.morphBankImageId != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), (this).MorphBankPanel.this.texts[kSuccessfulImageInsert], UIRegistry.getResourceString("INFORMATION"), 1);
                            if (!imageFilePosted.booleanValue()) {
                                JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), (this).MorphBankPanel.this.texts[kImageFileUploadFailed], UIRegistry.getResourceString("INFORMATION"), 1);
                            }
                            MorphBankPanel.this.setValue((this).MorphBankPanel.this.imageAttribute, null);
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String msg = statusText;
                            if (killer != null && killer.getLocalizedMessage() != null) {
                                msg = msg != null ? String.valueOf(msg) + " (" + killer.getLocalizedMessage() + ")" : killer.getLocalizedMessage();
                            }
                            UIRegistry.showError(msg);
                        }
                    });
                }
            }
        };
        sw.execute();
        UIHelper.centerAndShow(progDlg);
    }

    protected Credentials getOwnerCredentials() {
        Credentials result = new Credentials();
        result.setUserId(this.ownerId);
        result.setGroupId(this.groupId);
        return result;
    }

    protected Credentials getSubmitterCredentials() {
        Credentials result = new Credentials();
        result.setUserId(this.ownerId);
        result.setGroupId(this.groupId);
        return result;
    }

    protected boolean isImageMimeType(String mimeType) {
        return mimeType != null && (mimeType.startsWith("image") || mimeType.equals("png"));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setupButtons();
    }

    @Override
    public void setParent(FormViewObj parent) {
        super.setParent(parent);
        this.colObj = null;
        if (this.fvo != null && this.fvo.getDataObj() != null) {
            if (this.fvo.getDataObj() instanceof CollectionObject) {
                this.colObj = (CollectionObject)this.fvo.getDataObj();
            } else {
                throw new NotImplementedException("MorphBankUploadButton does not support " + this.fvo.getDataObj().getClass().getName());
            }
        }
    }
}

