/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.morphbank;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.tools.export.MappedFieldInfo;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class MappingInfo
implements Comparable<MappingInfo> {
    protected final String name;
    protected final Class<?> dataType;
    protected final String mapping;
    protected final int contextTableId;
    protected final boolean isFormatted;
    protected static Map<Class<?>, Set<String>> treeRankNames = new HashMap();

    public MappingInfo(String name, String dwcType, String mapping, int contextTableId, boolean isFormatted) {
        this.name = name;
        this.mapping = mapping;
        this.contextTableId = contextTableId;
        this.dataType = this.getClassForDwcType(dwcType, name);
        this.isFormatted = isFormatted;
    }

    public MappingInfo(String name, MappedFieldInfo mfi) {
        this.name = name;
        this.mapping = mfi.getStringId();
        this.contextTableId = mfi.getContextTableId();
        this.dataType = mfi.getDataType();
        this.isFormatted = mfi.isRel();
    }

    protected Class<?> getClassForDwcType(String dwcType, String name) {
        if (dwcType == null) {
            if (name.startsWith("DecimalLatitude") || name.equals("DecimalLongitude")) {
                return Double.class;
            }
            if (name.equalsIgnoreCase("DayCollected")) {
                return Calendar.class;
            }
            if (name.endsWith("Collected") || name.endsWith("Identified")) {
                return Integer.class;
            }
            return String.class;
        }
        if (dwcType.endsWith(":string")) {
            return String.class;
        }
        if (dwcType.endsWith(":dateTime")) {
            return Date.class;
        }
        if (dwcType.endsWith(":decimal") || dwcType.endsWith(":double")) {
            return Double.class;
        }
        if (dwcType.endsWith(":nonNegativeInteger")) {
            return Integer.class;
        }
        if (dwcType.endsWith(":gYear")) {
            return Integer.class;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getMapping() {
        return this.mapping;
    }

    public int getContextTableId() {
        return this.contextTableId;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public boolean isFormatted() {
        return this.isFormatted;
    }

    public int getMappedTblId() {
        String[] tbls = this.mapping.split(",");
        String tblSeg = tbls[tbls.length - 1];
        String[] tblSegs = tblSeg.split("\\.");
        String tbl = tblSegs[0];
        return Integer.parseInt(tbl.split("-")[0]);
    }

    public boolean isTreeRank() {
        DBTableInfo tbl = DBTableIdMgr.getInstance().getInfoById(this.getMappedTblId());
        if (Treeable.class.isAssignableFrom(tbl.getClassObj())) {
            return this.getTreeRanks(tbl.getClassObj()).contains(this.getMappedFieldName());
        }
        return false;
    }

    protected Set<String> getTreeRanks(Class<?> cls) {
        Set<String> ranks = treeRankNames.get(cls);
        if (ranks == null) {
            ranks = this.buildTreeRankNames(cls);
            treeRankNames.put(cls, ranks);
        }
        return ranks;
    }

    protected Set<String> buildTreeRankNames(Class<?> cls) {
        HashSet<String> result = new HashSet<String>();
        Vector<Object> ranks = BasicSQLUtils.querySingleCol("select distinct name from " + this.getTreeDefItemTblName(cls));
        for (Object rank : ranks) {
            result.add(rank.toString());
        }
        return result;
    }

    protected String getTreeDefItemTblName(Class<?> cls) {
        return String.valueOf(cls.getSimpleName().toLowerCase()) + "treedefitem";
    }

    protected String getMappedFieldName() {
        String[] chunks = this.mapping.split("\\.");
        return chunks[chunks.length - 1];
    }

    @Override
    public int compareTo(MappingInfo arg0) {
        if (this.getContextTableId() == arg0.getContextTableId()) {
            return this.getMapping().compareTo(arg0.getMapping());
        }
        return this.getContextTableId() < arg0.getContextTableId() ? -1 : 1;
    }
}

