/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.morphbank;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.plugins.morphbank.DarwinCoreSpecimen;
import edu.ku.brc.specify.plugins.morphbank.MappingInfo;
import edu.ku.brc.specify.tasks.subpane.qb.DateAccessorQRI;
import edu.ku.brc.specify.tools.export.ConceptMapUtils;
import edu.ku.brc.specify.tools.export.ExportPanel;
import edu.ku.brc.specify.tools.export.MappedFieldInfo;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Desktop;
import java.lang.reflect.Method;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;

public class DwcMapper {
    final Integer mappingId;
    final String mappingName;
    final String schemaName;
    final Integer mappingContextTableId;
    final String schemaURL;
    final Vector<MappingInfo> concepts = new Vector();
    public static Connection connection;

    public DwcMapper(Integer mappingId) {
        this.mappingId = mappingId;
        Vector<Object[]> rec = BasicSQLUtils.query(connection, this.getMappingQuery(mappingId));
        this.mappingName = (String)rec.get(0)[0];
        this.schemaName = (String)rec.get(0)[1];
        this.mappingContextTableId = (Integer)rec.get(0)[2];
        this.schemaURL = (String)rec.get(0)[3];
        this.fillConcepts();
        Collections.sort(this.concepts);
    }

    public DwcMapper() {
        this.mappingId = null;
        this.mappingName = UIRegistry.getResourceString("DwcMapper.Default");
        this.schemaName = null;
        this.mappingContextTableId = CollectionObject.getClassTableId();
        this.schemaURL = null;
        this.fillDefaultConcepts();
        Collections.sort(this.concepts);
    }

    protected String getMappingQuery(Integer mappingId) {
        return "select esm.MappingName, es.SchemaName, q.ContextTableId, es.Description from spexportschemamapping esm inner join spexportschemaitemmapping esim on esim.SpExportSchemaMappingID = esm.SpExportSchemaMappingID inner join spexportschemaitem esi on esi.SpExportSchemaItemID = esim.ExportSchemaItemID inner join spexportschema es on es.SpExportSchemaID = esi.SpExportSchemaID inner join spqueryfield qf on qf.SpQueryFieldID = esim.SpQueryFieldID inner join spquery q on q.SpQueryID = qf.SpQueryID where esm.SpExportSchemaMappingID = " + mappingId;
    }

    protected void fillConcepts() {
        Vector<Object[]> cpts = BasicSQLUtils.query(connection, this.getConceptQuery());
        this.concepts.clear();
        for (Object[] concept : cpts) {
            this.concepts.add(new MappingInfo((String)concept[0], (String)concept[1], (String)concept[2], this.mappingContextTableId, (Boolean)concept[3]));
        }
    }

    protected void fillDefaultConcepts() {
        this.concepts.clear();
        for (Map.Entry<String, Vector<MappedFieldInfo>> me : ConceptMapUtils.getDefaultDarwinCoreMappings().entrySet()) {
            this.concepts.add(new MappingInfo(me.getKey(), me.getValue().get(0)));
        }
    }

    protected String getMappingName(Integer mappingId) {
        return (String)BasicSQLUtils.querySingleObj(connection, "select MappingName from spexportschemamapping where  SpExportSchemaMappingID = " + mappingId);
    }

    protected String getConceptQuery() {
        return "select esi.FieldName, esi.DataType, qf.StringId, qf.IsRelFld from spexportschemaitemmapping esim inner join spexportschemaitem esi on esi.SpExportSchemaItemID = esim.ExportSchemaItemID inner join spqueryfield qf on qf.SpQueryFieldID = esim.SpQueryFieldID where esim.SpExportSchemaMappingID = " + this.mappingId;
    }

    public void setDarwinCoreConcepts(DarwinCoreSpecimen spec) throws Exception {
        spec.clearConcepts();
        for (MappingInfo mi : this.concepts) {
            spec.add(mi.getName(), null);
        }
    }

    protected String getValuesQuery(Integer collectionObjectId) {
        return "select * from " + ExportPanel.getCacheTableName(this.mappingName) + " where " + ExportPanel.getCacheTableName(this.mappingName) + "id = " + collectionObjectId;
    }

    public void setDarwinCoreValues(DarwinCoreSpecimen spec) throws Exception {
        if (spec.hasDataModelObject()) {
            this.setDarwinCoreValuesForObj(spec);
        } else {
            this.setDarwinCoreValuesForId(spec);
        }
    }

    protected void setDarwinCoreValuesForId(DarwinCoreSpecimen spec) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(this.getValuesQuery(spec.getCollectionObjectId()));
            if (!rs.next()) {
                throw new MissingRecordException("no record for " + spec.getCollectionObjectId() + " in " + this.mappingName, spec.getCollectionObjectId(), this.mappingName);
            }
            ResultSetMetaData metaData = rs.getMetaData();
            int c = 2;
            while (c < metaData.getColumnCount()) {
                String colName = metaData.getColumnLabel(c);
                spec.set(colName, rs.getObject(colName));
                ++c;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    protected void setDarwinCoreValuesForObj(DarwinCoreSpecimen spec) throws Exception {
        for (MappingInfo mi : this.concepts) {
            spec.set(mi.getName(), this.getMappedValue(mi, spec.getCollectionObject()));
        }
    }

    protected Object getMappedValue(MappingInfo mi, DataModelObjBase obj) throws Exception {
        String[] mapSegments = mi.getMapping().split(",");
        DataModelObjBase currentObject = obj;
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            session.attach(currentObject);
            if (mapSegments.length == 1) {
                Object object = this.getValueFromObject(currentObject, mapSegments[0], mi.isFormatted(), mi.isTreeRank(), session);
                return object;
            }
            int s = 1;
            while (s < mapSegments.length) {
                if (!(currentObject == null || s >= mapSegments.length - 1 && mi.isFormatted())) {
                    currentObject = this.getRelatedObject(currentObject, mapSegments[s]);
                }
                if (currentObject == null) {
                    return null;
                }
                session.attach(currentObject);
                if (s == mapSegments.length - 1) {
                    Object object = this.getValueFromObject(currentObject, mapSegments[s], mi.isFormatted(), mi.isTreeRank(), session);
                    return object;
                }
                ++s;
            }
        }
        finally {
            session.close();
        }
        return null;
    }

    protected DataModelObjBase getRelatedObject(DataModelObjBase object, String mapping) throws Exception {
        Object objs = this.getRelatedObjects(object, mapping);
        if (objs == null) {
            return null;
        }
        if (!Collection.class.isAssignableFrom(objs.getClass())) {
            return (DataModelObjBase)objs;
        }
        if (((Collection)objs).size() == 0) {
            return null;
        }
        if (((Collection)objs).size() == 1) {
            return (DataModelObjBase)((Collection)objs).iterator().next();
        }
        return this.selectRelatedObject(object, (Collection)objs);
    }

    protected Object getRelatedObjects(DataModelObjBase object, String mapping) throws Exception {
        String[] mapInfo = mapping.split("-");
        int tableId = Integer.parseInt(mapInfo[0].split("\\.")[0]);
        String relationshipName = mapInfo.length > 1 ? mapInfo[1].split("\\.")[0] : null;
        Class<?> relatedClass = DBTableIdMgr.getInstance().getInfoById(tableId).getClassObj();
        String methName = relationshipName == null ? "get" + relatedClass.getSimpleName() : "get" + relationshipName.substring(0, 1).toUpperCase().concat(relationshipName.substring(1));
        Method meth = object.getClass().getMethod(methName, new Class[0]);
        return meth.invoke((Object)object, new Object[0]);
    }

    protected DataModelObjBase selectRelatedObject(DataModelObjBase parent, Collection<DataModelObjBase> objects) throws Exception {
        if (objects.size() > 0) {
            for (DataModelObjBase obj : objects) {
                if (!this.isObjectToSelect(parent, obj)) continue;
                return obj;
            }
        }
        return null;
    }

    protected boolean isObjectToSelect(DataModelObjBase parent, DataModelObjBase obj) throws Exception {
        if (parent.getClass().equals(CollectionObject.class) && obj.getClass().equals(Determination.class)) {
            return ((Determination)obj).getIsCurrent();
        }
        throw new Exception("Unsupported parent class " + parent.getClass().getName());
    }

    protected boolean isDatePartAccessor(String methodName) {
        return methodName.endsWith(DateAccessorQRI.DATEPART.NumericDay.toString()) || methodName.endsWith(DateAccessorQRI.DATEPART.NumericMonth.toString()) || methodName.endsWith(DateAccessorQRI.DATEPART.NumericYear.toString());
    }

    protected String getDateFieldNameForDatePartAccessor(String methodName) {
        String strippee = null;
        if (methodName.endsWith(DateAccessorQRI.DATEPART.NumericDay.toString())) {
            strippee = DateAccessorQRI.DATEPART.NumericDay.toString();
        } else if (methodName.endsWith(DateAccessorQRI.DATEPART.NumericMonth.toString())) {
            strippee = DateAccessorQRI.DATEPART.NumericMonth.toString();
        } else if (methodName.endsWith(DateAccessorQRI.DATEPART.NumericYear.toString())) {
            strippee = DateAccessorQRI.DATEPART.NumericYear.toString();
        }
        return methodName.replace(strippee, "");
    }

    protected Integer getDatePart(Calendar object, String methodName) throws Exception {
        if (methodName.endsWith(DateAccessorQRI.DATEPART.NumericDay.toString())) {
            return object.get(5);
        }
        if (methodName.endsWith(DateAccessorQRI.DATEPART.NumericMonth.toString())) {
            return object.get(2) + 1;
        }
        if (methodName.endsWith(DateAccessorQRI.DATEPART.NumericYear.toString())) {
            return object.get(1);
        }
        throw new Exception("DwcMapper.getDatePart: unable to process " + methodName);
    }

    protected Object getValueFromObject(DataModelObjBase object, String mapping, boolean isFormatted, boolean isTreeRank, DataProviderSessionIFace session) throws Exception {
        if (!isFormatted && !isTreeRank) {
            String fieldName = mapping.split("\\.")[2];
            Vector<String> methNames = new Vector<String>();
            methNames.add("get" + fieldName.substring(0, 1).toUpperCase().concat(fieldName.substring(1)));
            if (this.isDatePartAccessor((String)methNames.get(0))) {
                methNames.add(this.getDateFieldNameForDatePartAccessor((String)methNames.get(0)));
            }
            boolean useDatePartAccessor = false;
            Method method = null;
            int m = 0;
            while (m < methNames.size()) {
                String methodName = (String)methNames.get(m);
                try {
                    method = object.getClass().getMethod(methodName, new Class[0]);
                    break;
                }
                catch (NoSuchMethodException ex) {
                    useDatePartAccessor = true;
                    ++m;
                }
            }
            if (method == null) {
                throw new NoSuchMethodException(mapping);
            }
            Object result = method.invoke((Object)object, new Object[0]);
            if (useDatePartAccessor && result != null) {
                result = this.getDatePart((Calendar)result, (String)methNames.get(0));
            }
            return result;
        }
        if (isTreeRank) {
            return this.getTreeRank((Treeable)((Object)object), mapping, session);
        }
        return this.getFormatted(object, mapping, session);
    }

    protected String getFormatted(DataModelObjBase object, String mapping, DataProviderSessionIFace session) throws Exception {
        Object objects = this.getRelatedObjects(object, mapping);
        if (objects == null) {
            return null;
        }
        if (!Collection.class.isAssignableFrom(objects.getClass())) {
            return DataObjFieldFormatMgr.getInstance().format(objects, objects.getClass());
        }
        Collection objs = (Collection)objects;
        if (objs.size() == 0) {
            return null;
        }
        return DataObjFieldFormatMgr.getInstance().aggregate(objs, objs.iterator().next().getClass());
    }

    protected String getTreeRank(Treeable<?, ?, ?> object, String mapping, DataProviderSessionIFace session) throws Exception {
        String tblName = object.getClass().getSimpleName().toLowerCase();
        String treeDefFld = String.valueOf(object.getClass().getSimpleName().toLowerCase()) + "TreeDefID";
        TreeDefIface treeDef = (TreeDefIface)session.get(object.getDefinition().getClass(), ((TreeDefIface)object.getDefinition()).getTreeDefId());
        for (TreeDefItemIface di : treeDef.getTreeDefItems()) {
            if (!mapping.endsWith(di.getName())) continue;
            String sql = "select name from " + tblName + " where " + treeDefFld + " = " + ((TreeDefIface)object.getDefinition()).getTreeDefId() + " and rankid = " + di.getRankId() + " and " + object.getNodeNumber() + " between NodeNumber and HighestChildNodeNumber";
            return (String)BasicSQLUtils.querySingleObj(sql);
        }
        return null;
    }

    public int getConceptCount() {
        return this.concepts.size();
    }

    public MappingInfo getConcept(int c) {
        return this.concepts.get(c);
    }

    public static void main(String[] args) {
        try {
            Desktop.getDesktop().browse(URI.create("http://test.morphbank.net/?id=1000346"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    public class MissingRecordException
    extends Exception {
        protected final Integer Id;
        protected final String mappingName;

        public MissingRecordException(String msg, Integer id, String mappingName) {
            super(msg);
            this.Id = id;
            this.mappingName = mappingName;
        }

        public Integer getId() {
            return this.Id;
        }

        public String getMappingName() {
            return this.mappingName;
        }
    }
}

