/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.morphbank;

import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.plugins.morphbank.DwcMapper;
import edu.ku.brc.util.Pair;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class DarwinCoreSpecimen {
    protected final DwcMapper mapper;
    protected Integer collectionObjectId;
    protected CollectionObject collectionObject;
    protected Map<String, Pair<String, Object>> concepts = new HashMap<String, Pair<String, Object>>();

    public DarwinCoreSpecimen(DwcMapper mapper) throws Exception {
        this.mapper = mapper;
        mapper.setDarwinCoreConcepts(this);
    }

    public void setCollectionObjectId(Integer collectionObjectId) throws Exception {
        this.collectionObjectId = collectionObjectId;
        this.collectionObject = null;
        this.mapper.setDarwinCoreValues(this);
    }

    protected void clearConcepts() {
        this.concepts.clear();
    }

    protected void add(String fieldName, String value) throws Exception {
        if (this.concepts.containsKey(fieldName.toLowerCase())) {
            throw new Exception(String.valueOf(fieldName) + " concept is already mapped.");
        }
        this.concepts.put(fieldName.toLowerCase(), new Pair<String, String>(fieldName, value));
    }

    protected void set(String fieldName, Object value) throws Exception {
        if (!this.concepts.containsKey(fieldName.toLowerCase())) {
            throw new Exception(String.valueOf(fieldName) + " concept is not mapped.");
        }
        this.concepts.put(fieldName.toLowerCase(), new Pair<String, Object>(fieldName, value));
    }

    public Object get(String fieldName) {
        return this.concepts.get(fieldName.toLowerCase()).getSecond();
    }

    public boolean isMapped(String conceptName) {
        return this.concepts.containsKey(conceptName.toLowerCase());
    }

    public int getFieldCount() {
        return this.concepts.size();
    }

    public Vector<Pair<String, Object>> getFieldValues() {
        Vector<Pair<String, Object>> result = new Vector<Pair<String, Object>>();
        for (Map.Entry<String, Pair<String, Object>> me : this.concepts.entrySet()) {
            result.add(new Pair<String, Object>(me.getValue().getFirst(), me.getValue().getSecond()));
        }
        return result;
    }

    public Integer getCollectionObjectId() {
        return this.collectionObjectId;
    }

    public static void main(String[] args) {
        try {
            String connStr = "jdbc:mysql://localhost/lsusmollusca?characterEncoding=UTF-8&autoReconnect=true";
            DwcMapper.connection = DriverManager.getConnection(connStr, "Master", "Master");
            DwcMapper mapper = new DwcMapper(1);
            DarwinCoreSpecimen spec = new DarwinCoreSpecimen(mapper);
            spec.setCollectionObjectId(1);
            for (Pair<String, Object> fld : spec.getFieldValues()) {
                System.out.println(String.valueOf(fld.getFirst()) + " = " + fld.getSecond());
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public CollectionObject getCollectionObject() {
        return this.collectionObject;
    }

    public void setCollectionObject(CollectionObject collectionObject) throws Exception {
        this.collectionObject = collectionObject;
        this.collectionObjectId = collectionObject != null ? collectionObject.getId() : null;
        this.mapper.setDarwinCoreValues(this);
    }

    public boolean hasDataModelObject() {
        return this.collectionObject != null;
    }
}

