/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.morphbank;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.AttachmentImageAttribute;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.ObjectAttachmentIFace;
import edu.ku.brc.specify.plugins.morphbank.DarwinCoreSpecimen;
import edu.ku.brc.specify.plugins.morphbank.DwcMapper;
import edu.ku.brc.specify.plugins.morphbank.MappingInfo;
import edu.ku.brc.specify.plugins.morphbank.NonRedactor;
import edu.ku.brc.specify.plugins.morphbank.RedactorIFace;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import net.morphbank.mbsvc3.fsuherb.MapFsuHerbSpreadsheetToXml;
import net.morphbank.mbsvc3.xml.ObjectFactory;
import net.morphbank.mbsvc3.xml.XmlBaseObject;
import net.morphbank.mbsvc3.xml.XmlId;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CollectionObjectFieldMapper {
    private static final Logger log = Logger.getLogger(CollectionObjectFieldMapper.class);
    protected CollectionObject collectionObject;
    protected Integer collectionObjectId;
    protected DwcMapper dwcMapper;
    protected Vector<QName> morphBankDwcQNames;
    protected DarwinCoreSpecimen spec;
    protected RedactorIFace redactor = new NonRedactor();
    public static Connection connection;

    protected Connection getConnection() {
        if (connection == null) {
            return DBConnection.getInstance().createConnection();
        }
        return connection;
    }

    public CollectionObjectFieldMapper(Integer collectionObjectId, Integer dwcMappingId) throws Exception {
        this.collectionObjectId = collectionObjectId;
        this.buildQNames();
        this.dwcMapper = this.getDwcMapper(dwcMappingId);
        this.spec = new DarwinCoreSpecimen(this.dwcMapper);
        this.spec.setCollectionObjectId(collectionObjectId);
    }

    public CollectionObjectFieldMapper(CollectionObject obj, Integer dwcMappingId) throws Exception {
        this.collectionObject = obj;
        this.dwcMapper = this.getDwcMapper(dwcMappingId);
        this.spec = new DarwinCoreSpecimen(this.dwcMapper);
        this.spec.setCollectionObject(obj);
    }

    public CollectionObjectFieldMapper(Integer collectionObjectId, DwcMapper dwcMapper) throws Exception {
        this.collectionObjectId = collectionObjectId;
        this.buildQNames();
        this.dwcMapper = dwcMapper;
        this.spec = new DarwinCoreSpecimen(dwcMapper);
        this.spec.setCollectionObjectId(collectionObjectId);
    }

    public void setCollectionObjectId(Integer collectionObjectId) throws Exception {
        this.collectionObjectId = collectionObjectId;
        this.spec.setCollectionObjectId(collectionObjectId);
    }

    public void setCollectionObject(CollectionObject obj) throws Exception {
        this.collectionObject = obj;
        this.spec.setCollectionObject(obj);
    }

    protected DwcMapper getDwcMapper(Integer mappingId) {
        if (mappingId != null) {
            return new DwcMapper(mappingId);
        }
        return new DwcMapper();
    }

    protected void buildQNames() throws Exception {
        Class<ObjectFactory> ojClass = ObjectFactory.class;
        Field[] flds = ojClass.getFields();
        this.morphBankDwcQNames = new Vector();
        Field[] fieldArray = flds;
        int n = flds.length;
        int n2 = 0;
        while (n2 < n) {
            Field fld = fieldArray[n2];
            int mod = fld.getModifiers();
            if (fld.getType().equals(QName.class) && Modifier.isFinal(mod) && Modifier.isStatic(mod) && Modifier.isPublic(mod)) {
                this.morphBankDwcQNames.add((QName)fld.get(null));
            }
            ++n2;
        }
    }

    public Object getSpecNumber(DarwinCoreSpecimen aSpec) {
        DarwinCoreSpecimen dws;
        DarwinCoreSpecimen darwinCoreSpecimen = dws = aSpec == null ? this.spec : aSpec;
        if (dws.isMapped("CatalogNumberNumeric")) {
            return dws.get("CatalogNumberNumeric");
        }
        if (dws.isMapped("CatalogNumberText")) {
            return dws.get("CatalogNumberText");
        }
        if (dws.isMapped("CatalogNumber")) {
            return dws.get("CatalogNumber");
        }
        return dws.getCollectionObjectId();
    }

    protected String getSpecId(DarwinCoreSpecimen spec, boolean isImage) {
        String result = "";
        if (!isImage) {
            result = spec.isMapped("InstitutionCode") && spec.isMapped("CollectionCode") ? spec.get("InstitutionCode") + "-" + spec.get("CollectionCode") : String.valueOf(AppContextMgr.getInstance().getClassObject(Institution.class).getCode()) + "-" + AppContextMgr.getInstance().getClassObject(Collection.class).getCode() + "-";
        }
        if (isImage) {
            result = String.valueOf(result) + "I:";
        }
        return String.valueOf(result) + this.getSpecNumber(spec);
    }

    protected String getMiName(MappingInfo mi) {
        if (mi.getName().equals("ContinentOcean")) {
            return "Continent";
        }
        if (mi.getName().equals("ScientificNameAuthor")) {
            return "AuthorYearOfScientificName";
        }
        return mi.getName();
    }

    protected void setDwcSpecimenFields(XmlBaseObject xmlSpec) throws Exception {
        Class<ObjectFactory> factory = ObjectFactory.class;
        ObjectFactory objFac = new ObjectFactory();
        int c = 0;
        while (c < this.dwcMapper.getConceptCount()) {
            MappingInfo mi = this.dwcMapper.getConcept(c);
            Class<Object> dataType = mi.getDataType();
            if (dataType == null) {
                log.warn((Object)("CollectionObjectMapper:setDwcSpecimenFields: skipping " + mi.getName() + ": unrecognized data type."));
            } else {
                Object val = this.spec.get(mi.getName());
                try {
                    if (this.redactor.isRedacted(this.spec, mi)) {
                        System.out.println(this.getSpecId(this.spec, false));
                    } else {
                        String miName = this.getMiName(mi);
                        if (miName.equalsIgnoreCase("CatalogNumberNumeric") || miName.equalsIgnoreCase("DecimalLatitude") || miName.equalsIgnoreCase("DecimalLongitude")) {
                            dataType = Double.class;
                            if (val != null) {
                                val = Double.valueOf(val.toString());
                            }
                        }
                        Method m = factory.getMethod("create" + StringUtils.capitalize((String)miName), dataType);
                        try {
                            xmlSpec.addDarwinTag((JAXBElement)m.invoke((Object)objFac, dataType.cast(val)));
                        }
                        catch (ClassCastException ex) {
                            xmlSpec.addDarwinTag((JAXBElement)m.invoke((Object)objFac, dataType.cast(val == null ? "" : val.toString())));
                        }
                    }
                }
                catch (NoSuchMethodException ex) {
                    log.warn((Object)("CollectionObjectMapper:setDwcSpecimenFields: skipping " + mi.getName() + ": no create method in Object Factory"));
                    xmlSpec.addUserProperty(mi.getName(), val.toString());
                }
            }
            ++c;
        }
    }

    public void setXmlSpecimenFields(XmlBaseObject xmlSpec) throws Exception {
        xmlSpec.setId(MapFsuHerbSpreadsheetToXml.getXmlExternalId((String)this.getSpecId(this.spec, false)));
        if (this.spec.isMapped("ScientificName")) {
            String sciNameAuthor;
            String string = sciNameAuthor = this.spec.isMapped("ScientificNameAuthor") ? (String)this.spec.get("ScientificNameAuthor") : null;
            if (sciNameAuthor == null) {
                String string2 = sciNameAuthor = this.spec.isMapped("AuthorYearOfScientificName") ? (String)this.spec.get("AuthorYearOfScientificName") : null;
            }
            if (StringUtils.isNotBlank((String)sciNameAuthor)) {
                xmlSpec.setDetermination(MapFsuHerbSpreadsheetToXml.getXmlExternalId((String)("SCI-NAME-AUTHOR:" + this.spec.get("ScientificName") + "|" + sciNameAuthor)));
            } else {
                xmlSpec.setDetermination(MapFsuHerbSpreadsheetToXml.getXmlExternalId((String)("SCI-NAME:" + this.spec.get("ScientificName"))));
            }
        }
        this.setDwcSpecimenFields(xmlSpec);
    }

    protected Vector<AttachmentRecord> getImages() throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "select at.AttachmentLocation, at.CopyrightHolder, at.CopyrightDate, at.MimeType, at.Credit, at.OrigFilename, at.Title, atia.height, atia.width, atia.resolution, atia.magnification, atia.creativeCommons, coat.remarks, coat.ordinal from collectionobjectattachment coat inner join attachment at on at.AttachmentID = coat.AttachmentID left join attachmentimageattribute atia on atia.attachmentimageattributeid = at.attachmentimageattributeid where at.MimeType like 'image/%' and coat.CollectionObjectID = " + this.collectionObjectId;
            stmt = this.getConnection().createStatement();
            rs = stmt.executeQuery(sql);
            Vector<AttachmentRecord> result = new Vector<AttachmentRecord>();
            while (rs.next()) {
                result.add(new AttachmentRecord(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getInt(8), rs.getInt(9), rs.getDouble(10), rs.getDouble(11), rs.getString(12), rs.getString(13), rs.getInt(14)));
            }
            Vector<AttachmentRecord> vector = result;
            return vector;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    protected AttachmentRecord getImage(ObjectAttachmentIFace<?> imageObj) {
        Attachment at = imageObj.getAttachment();
        AttachmentImageAttribute atia = at.getAttachmentImageAttribute();
        return new AttachmentRecord(at.getAttachmentLocation(), at.getCopyrightHolder(), at.getCopyrightDate(), at.getMimeType(), at.getCredit(), at.getOrigFilename(), at.getTitle(), atia != null ? atia.getHeight() : null, atia != null ? atia.getWidth() : null, atia != null ? atia.getResolution() : null, atia != null ? atia.getMagnification() : null, atia != null ? atia.getCreativeCommons() : null, imageObj.getRemarks(), imageObj.getOrdinal());
    }

    protected XmlId getImageId(AttachmentRecord imageAttachment) {
        String idStr = String.valueOf(this.getSpecId(this.spec, true)) + "." + imageAttachment.getOrdinal();
        if (idStr == null || idStr.length() == 0) {
            return null;
        }
        return MapFsuHerbSpreadsheetToXml.getXmlExternalId((String)idStr);
    }

    protected String getImageType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        return mimeType.replace("image/", "");
    }

    protected void setXmlImageFields(XmlBaseObject image, AttachmentRecord imageAttachment) {
        image.setId(this.getImageId(imageAttachment));
        image.setSpecimen(MapFsuHerbSpreadsheetToXml.getXmlExternalId((String)this.getSpecId(this.spec, false)));
        image.setOriginalFileName(imageAttachment.getOrigFileName());
        String copyrightText = imageAttachment.getCopyrightHolder();
        if (imageAttachment.getCopyrightDate() != null) {
            copyrightText = copyrightText != null ? String.valueOf(copyrightText) + " " + imageAttachment.getCopyrightDate() : imageAttachment.getCopyrightDate();
        }
        image.setCopyrightText(copyrightText);
        image.setImageType(this.getImageType(imageAttachment.getMimeType()));
        image.setPhotographer(imageAttachment.getCredit());
    }

    public Vector<XmlBaseObject> getXmlImages() throws Exception {
        Vector<XmlBaseObject> result = new Vector<XmlBaseObject>();
        Vector<AttachmentRecord> images = this.getImages();
        for (AttachmentRecord image : images) {
            XmlBaseObject xmlImage = new XmlBaseObject("Image");
            xmlImage.addDescription("From specimen " + this.getSpecNumber(this.spec));
            this.setXmlImageFields(xmlImage, image);
            result.add(xmlImage);
        }
        return result;
    }

    public XmlBaseObject getXmlImage(ObjectAttachmentIFace<?> image) {
        if (!(image.getObject() instanceof CollectionObject)) {
            throw new NotImplementedException("CollectionObjectFieldMapper: attachment type not supported: " + image.getClass().getName());
        }
        AttachmentRecord imageRec = this.getImage(image);
        XmlBaseObject xmlImage = new XmlBaseObject("Image");
        xmlImage.addDescription("From specimen " + this.getSpecNumber(this.spec));
        this.setXmlImageFields(xmlImage, imageRec);
        return xmlImage;
    }

    public Integer getCollectionObjectId() {
        return this.collectionObjectId;
    }

    public static void main(String[] args) {
    }

    private class AttachmentRecord {
        private String attachmentLocation;
        private String copyrightHolder;
        private String copyrightDate;
        private String mimeType;
        private String credit;
        private String origFileName;
        private String title;
        private Integer height;
        private Integer width;
        private Double resolution;
        private Double magnification;
        private String creativeCommons;
        private String remarks;
        private Integer ordinal;

        public AttachmentRecord(String attachmentLocation, String copyrightHolder, String copyrightDate, String mimeType, String credit, String origFileName, String title, Integer height, Integer width, Double resolution, Double magnification, String creativeCommons, String remarks, int ordinal) {
            this.attachmentLocation = attachmentLocation;
            this.copyrightHolder = copyrightHolder;
            this.copyrightDate = copyrightDate;
            this.mimeType = mimeType;
            this.credit = credit;
            this.origFileName = origFileName;
            this.title = title;
            this.height = height;
            this.width = width;
            this.resolution = resolution;
            this.magnification = magnification;
            this.creativeCommons = creativeCommons;
            this.remarks = remarks;
            this.ordinal = ordinal;
        }

        public String getAttachmentLocation() {
            return this.attachmentLocation;
        }

        public void setAttachmentLocation(String attachmentLocation) {
            this.attachmentLocation = attachmentLocation;
        }

        public String getCopyrightHolder() {
            return this.copyrightHolder;
        }

        public void setCopyrightHolder(String copyrightHolder) {
            this.copyrightHolder = copyrightHolder;
        }

        public String getOrigFileName() {
            return this.origFileName;
        }

        public void setOrigFileName(String origFileName) {
            this.origFileName = origFileName;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public void setRemarks(String remarks) {
            this.remarks = remarks;
        }

        public Integer getOrdinal() {
            return this.ordinal;
        }

        public void setOrdinal(Integer ordinal) {
            this.ordinal = ordinal;
        }

        public String getCopyrightDate() {
            return this.copyrightDate;
        }

        public void setCopyrightDate(String copyrightDate) {
            this.copyrightDate = copyrightDate;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getCredit() {
            return this.credit;
        }

        public void setCredit(String credit) {
            this.credit = credit;
        }

        public Integer getHeight() {
            return this.height;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }

        public Integer getWidth() {
            return this.width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public Double getResolution() {
            return this.resolution;
        }

        public void setResolution(Double resolution) {
            this.resolution = resolution;
        }

        public Double getMagnification() {
            return this.magnification;
        }

        public void setMagnification(Double magnification) {
            this.magnification = magnification;
        }

        public String getCreativeCommons() {
            return this.creativeCommons;
        }

        public void setCreativeCommons(String creativeCommons) {
            this.creativeCommons = creativeCommons;
        }
    }
}

