/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.latlon;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.PrefsPanel;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.GeoCoordDetail;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.plugins.UIPluginBase;
import edu.ku.brc.specify.plugins.latlon.BorderedRadioButton;
import edu.ku.brc.specify.plugins.latlon.DDDDPanel;
import edu.ku.brc.specify.plugins.latlon.LatLonUIIFace;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.MacBtnBorder;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.GeoRefConverter;
import edu.ku.brc.util.LatLonConverter;
import edu.ku.brc.util.Pair;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.math.BigDecimal;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LatLonUI
extends UIPluginBase
implements UIValidatable,
ChangeListener {
    private static final Logger log = Logger.getLogger(UIPluginBase.class);
    protected static final String LAT_PREF = "latlon.plugin.def_lat";
    protected static final String LON_PREF = "latlon.plugin.def_lon";
    protected static final String TYP_PREF = "latlon.plugin.def_typ";
    protected static final String FMT_PREF = "latlon.plugin.def_fmt";
    protected static final String[] formatClass = new String[]{"DDDDPanel", "DDMMSSPanel", "DDMMMMPanel"};
    protected static final String[] formats = new String[]{"DDD.DDD", "DD_MM_SS", "DD_MM.MM"};
    protected static final String[] pointNames = new String[]{"LatLonPoint", "LatLonLineLeft", "LatLonLineRight", "LatLonRectTopLeft", "LatLonRectBottomRight"};
    protected static final String[] typeNames = new String[]{"LatLonPoint", "LatLonLine", "LatLonRect"};
    protected static final String[] typeNamesKeys = new String[]{"Point", "Line", "Rect"};
    protected static final String[] typeToolTipKeys = new String[]{"PointTT", "LineTT", "RectTT"};
    protected static final LatLonUIIFace.LatLonType[] types = new LatLonUIIFace.LatLonType[]{LatLonUIIFace.LatLonType.LLPoint, LatLonUIIFace.LatLonType.LLLine, LatLonUIIFace.LatLonType.LLRect};
    protected static final String[] typeStrs = new String[]{"Point", "Line", "Rectangle"};
    protected String[] errorMessages;
    protected CellConstraints cc = new CellConstraints();
    protected String[] typeNamesLabels;
    protected String[] typeToolTips;
    protected Hashtable<LatLonUIIFace.LatLonType, String> typeMapper = new Hashtable();
    protected JComboBox formatSelector;
    protected LatLonUIIFace.LatLonType currentType;
    protected boolean stateChangeOK = true;
    protected String[] fieldNames;
    protected Hashtable<JToggleButton, LatLonUIIFace.LatLonType> selectedTypeHash = new Hashtable();
    protected ImageIcon[] pointImages;
    protected JComponent[] latLonPanes;
    protected CardLayout cardLayout = new CardLayout();
    protected JPanel[] cardSubPanes;
    protected JPanel cardPanel;
    protected JComponent currentCardSubPane;
    protected JPanel botPanel;
    protected JPanel rightPanel;
    protected Border panelBorder = BorderFactory.createEtchedBorder();
    protected JLabel typeLabel = null;
    protected int currentInx = -1;
    protected JToggleButton[] botBtns = null;
    protected Locality locality;
    protected DDDDPanel[] panels;
    protected String latLonType;
    protected boolean hasChanged = false;
    protected Pair<String, String> srcLatLon1 = new Pair();
    protected Pair<String, String> srcLatLon2 = new Pair();
    protected LatLonConverter.FORMAT srcFormat;
    protected LatLonConverter.FORMAT choosenFormat;
    protected GeoRefConverter geoRefCnv = new GeoRefConverter();
    protected PrefsPanel prefsPanel = null;
    protected UIValidatable.ErrorType valState = UIValidatable.ErrorType.Valid;
    protected boolean isRequired = false;
    protected boolean isChanged = false;
    protected boolean isNew = false;
    protected String reason = null;
    protected MultiView gcdMV = null;
    protected FormViewObj.FVOFieldInfo errPolyFieldInfo = null;
    protected FormViewObj.FVOFieldInfo errEstFieldInfo = null;
    protected boolean didGCDFieldCheck = false;

    public LatLonUI() {
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        this.title = UIRegistry.getResourceString("LatLonUI");
        this.typeNamesLabels = new String[typeNamesKeys.length];
        this.typeToolTips = new String[typeToolTipKeys.length];
        int i = 0;
        String[] stringArray = typeNamesKeys;
        int n = typeNamesKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.typeNamesLabels[i] = UIRegistry.getResourceString(key);
            this.typeToolTips[i] = UIRegistry.getResourceString(typeToolTipKeys[i]);
            ++i;
            ++n2;
        }
        String[] keys = new String[]{"LatLonUI.POINT_ERR", "LatLonUI.POINT_INCMP", "LatLonUI.FIRST_POINT_ERR", "LatLonUI.FIRST_POINT_INCMP", "LatLonUI.SEC_POINT_ERR", "LatLonUI.SEC_POINT_INCMP"};
        this.errorMessages = new String[keys.length];
        i = 0;
        String[] stringArray2 = keys;
        int n3 = keys.length;
        n = 0;
        while (n < n3) {
            String key = stringArray2[n];
            this.errorMessages[i++] = UIRegistry.getResourceString(key);
            ++n;
        }
        UIRegistry.popResourceBundle();
        this.fieldNames = new String[]{"latitude1", "longitude1", "latitude2", "longitude2", "lat1text", "long1text", "lat2text", "long2text", "latLongType", "originalLatLongUnit", "srcLatLongUnit"};
    }

    protected void createEditUI() {
        BorderedRadioButton rb;
        int i;
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        PanelBuilder builder = new PanelBuilder(new FormLayout("p", "p, 2px, p"), (JPanel)this);
        Color bgColor = this.getBackground();
        bgColor = new Color(Math.min(bgColor.getRed() + 20, 255), Math.min(bgColor.getGreen() + 20, 255), Math.min(bgColor.getBlue() + 20, 255));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(bgColor), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        int i2 = 0;
        while (i2 < types.length) {
            this.typeMapper.put(types[i2], typeStrs[i2]);
            ++i2;
        }
        this.currentType = LatLonUIIFace.LatLonType.LLPoint;
        this.pointImages = new ImageIcon[pointNames.length];
        i2 = 0;
        while (i2 < pointNames.length) {
            this.pointImages[i2] = IconManager.getIcon(pointNames[i2], IconManager.IconSize.Std16);
            ++i2;
        }
        Object[] formatLabels = new String[formats.length];
        int i3 = 0;
        while (i3 < formats.length) {
            formatLabels[i3] = UIRegistry.getResourceString(formats[i3]);
            ++i3;
        }
        this.cardPanel = new JPanel(this.cardLayout);
        this.formatSelector = UIHelper.createComboBox(formatLabels);
        this.latLonPanes = new JComponent[formatLabels.length];
        this.formatSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LatLonUI.this.swapForm(LatLonUI.this.formatSelector.getSelectedIndex(), LatLonUI.this.currentType);
                LatLonUI.this.cardLayout.show(LatLonUI.this.cardPanel, ((JComboBox)ae.getSource()).getSelectedItem().toString());
            }
        });
        Dimension preferredSize = new Dimension(0, 0);
        this.cardSubPanes = new JPanel[formats.length * 2];
        this.panels = new DDDDPanel[formats.length * 2];
        int paneInx = 0;
        int i4 = 0;
        while (i4 < formats.length) {
            this.cardSubPanes[i4] = new JPanel(new BorderLayout());
            try {
                String packageName = "edu.ku.brc.specify.plugins.latlon.";
                DDDDPanel latLon1 = Class.forName(String.valueOf(packageName) + formatClass[i4]).asSubclass(DDDDPanel.class).newInstance();
                latLon1.setIsRequired(this.isRequired);
                latLon1.setViewMode(this.isViewMode);
                latLon1.init();
                latLon1.setChangeListener(this);
                DDDDPanel panel1 = latLon1;
                panel1.setBorder(this.panelBorder);
                this.panels[paneInx++] = latLon1;
                this.latLonPanes[i4] = panel1;
                DDDDPanel latlon2 = Class.forName(String.valueOf(packageName) + formatClass[i4]).asSubclass(DDDDPanel.class).newInstance();
                latlon2.setIsRequired(this.isRequired);
                latlon2.setViewMode(this.isViewMode);
                latlon2.init();
                latlon2.setChangeListener(this);
                this.panels[paneInx++] = latlon2;
                JTabbedPane tabbedPane = new JTabbedPane(UIHelper.getOSType() == UIHelper.OSTYPE.MacOSX ? 3 : 4);
                tabbedPane.addTab(null, this.pointImages[0], this.panels[paneInx - 2]);
                tabbedPane.addTab(null, this.pointImages[0], this.panels[paneInx - 1]);
                this.latLonPanes[i4] = tabbedPane;
                Dimension size = tabbedPane.getPreferredSize();
                preferredSize.width = Math.max(preferredSize.width, size.width);
                preferredSize.height = Math.max(preferredSize.height, size.height);
                tabbedPane.removeAll();
                this.cardSubPanes[i4].add((Component)panel1, "Center");
                this.cardPanel.add((String)formatLabels[i4], this.cardSubPanes[i4]);
            }
            catch (Exception e) {
                e.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(LatLonUI.class, e);
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < formats.length) {
            this.cardSubPanes[i4].setPreferredSize(preferredSize);
            ++i4;
        }
        PanelBuilder botBtnBar = new PanelBuilder(new FormLayout("p:g,p,10px,p,10px,p,p:g", "p"));
        ButtonGroup btnGroup = new ButtonGroup();
        this.botBtns = new JToggleButton[typeNames.length];
        if (UIHelper.isMacOS()) {
            BorderedRadioButton.setSelectedBorder(BorderFactory.createBevelBorder(1));
            BorderedRadioButton.setUnselectedBorder(BorderFactory.createBevelBorder(0));
            i = 0;
            while (i < this.botBtns.length) {
                rb = new BorderedRadioButton(IconManager.getIcon(typeNames[i], IconManager.IconSize.Std16));
                this.botBtns[i] = rb;
                rb.makeSquare();
                rb.setBorder(new MacBtnBorder());
                ++i;
            }
        } else {
            BorderedRadioButton.setSelectedBorder(BorderFactory.createBevelBorder(1));
            BorderedRadioButton.setUnselectedBorder(BorderFactory.createBevelBorder(0));
            i = 0;
            while (i < this.botBtns.length) {
                rb = new BorderedRadioButton(IconManager.getIcon(typeNames[i], IconManager.IconSize.Std16));
                this.botBtns[i] = rb;
                rb.makeSquare();
                ++i;
            }
        }
        i = 0;
        while (i < this.botBtns.length) {
            this.botBtns[i].setToolTipText(this.typeToolTips[i]);
            botBtnBar.add((Component)this.botBtns[i], this.cc.xy(i * 2 + 2, 1));
            btnGroup.add(this.botBtns[i]);
            this.selectedTypeHash.put(this.botBtns[i], types[i]);
            this.botBtns[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ce) {
                    LatLonUI.this.stateChanged(null);
                    LatLonUI.this.currentType = LatLonUI.this.selectedTypeHash.get(ce.getSource());
                    LatLonUI.this.swapForm(LatLonUI.this.formatSelector.getSelectedIndex(), LatLonUI.this.currentType);
                }
            });
            ++i;
        }
        this.botBtns[0].setSelected(true);
        if (this.isViewMode) {
            this.typeLabel = UIHelper.createLabel(" ");
        }
        ActionListener infoAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LatLonUI.this.doPrefs();
            }
        };
        JButton infoBtn = UIHelper.createIconBtn("Preferences", IconManager.IconSize.Std16, UIRegistry.getResourceString("PREFERENCES"), true, infoAL);
        infoBtn.setEnabled(true);
        PanelBuilder topPane = new PanelBuilder(new FormLayout("l:p, c:p:g" + (this.isViewMode ? "" : ",4px,p,8px"), "p"));
        topPane.add((Component)this.formatSelector, this.cc.xy(1, 1));
        topPane.add((Component)(this.isViewMode ? this.typeLabel : botBtnBar.getPanel()), this.cc.xy(2, 1));
        if (!this.isViewMode) {
            topPane.add((Component)infoBtn, this.cc.xy(4, 1));
        }
        builder.add((Component)topPane.getPanel(), this.cc.xy(1, 1));
        builder.add((Component)this.cardPanel, this.cc.xy(1, 3));
        this.prefsPanel = new PrefsPanel(false);
        this.prefsPanel.add(UIRegistry.getResourceString("LatLonUI.LL_SEP"));
        this.prefsPanel.add(PrefsPanel.CompType.eCheckbox, UIRegistry.getResourceString("LatLonUI.LATDEF_DIR"), LAT_PREF, Boolean.class, true);
        this.prefsPanel.add(PrefsPanel.CompType.eCheckbox, UIRegistry.getResourceString("LatLonUI.LONDEF_DIR"), LON_PREF, Boolean.class, true);
        this.prefsPanel.add(PrefsPanel.CompType.eComboBox, UIRegistry.getResourceString("LatLonUI.DEF_TYP"), TYP_PREF, Integer.class, this.typeNamesLabels, 0);
        this.prefsPanel.add(PrefsPanel.CompType.eComboBox, UIRegistry.getResourceString("LatLonUI.DEF_FMT"), FMT_PREF, Integer.class, (String[])formatLabels, 0);
        this.prefsPanel.createForm(null, null);
        UIRegistry.popResourceBundle();
    }

    private void doPrefs() {
        CustomDialog dlg = new CustomDialog(null, UIRegistry.getResourceString("PREFERENCES"), true, 3, (Component)this.prefsPanel);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            this.prefsPanel.savePrefs();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.formatSelector.setEnabled(enabled);
        JComponent[] jComponentArray = this.panels;
        int n = this.panels.length;
        int n2 = 0;
        while (n2 < n) {
            DDDDPanel ll = jComponentArray[n2];
            ll.setEnabled(enabled);
            ++n2;
        }
        if (this.botBtns != null) {
            jComponentArray = this.botBtns;
            n = this.botBtns.length;
            n2 = 0;
            while (n2 < n) {
                JComponent brb = jComponentArray[n2];
                ((AbstractButton)brb).setEnabled(enabled);
                ++n2;
            }
        }
    }

    @Override
    public boolean isNotEmpty() {
        int curInx = this.formatSelector.getSelectedIndex() * 2;
        return this.panels[curInx].getLatitude() != null && this.panels[curInx].getLongitude() != null;
    }

    protected void checkPanel(boolean formatHasChanged, DDDDPanel prevPanel1, DDDDPanel prevPanel2, Pair<String, String> latLon1, Pair<String, String> latLon2, LatLonConverter.FORMAT fromFmt, LatLonConverter.FORMAT toFmt) {
        if (formatHasChanged) {
            if (prevPanel1.validateState(false) == UIValidatable.ErrorType.Valid) {
                this.srcFormat = prevPanel1.getDefaultFormat();
                latLon1.first = LatLonConverter.convert((String)latLon1.first, fromFmt, toFmt, LatLonConverter.LATLON.Latitude);
                latLon1.second = LatLonConverter.convert((String)latLon1.second, fromFmt, toFmt, LatLonConverter.LATLON.Longitude);
                if (prevPanel2 != null && latLon2 != null) {
                    latLon2.first = LatLonConverter.convert(prevPanel2.getLatitudeStr(), fromFmt, toFmt, LatLonConverter.LATLON.Latitude);
                    latLon2.second = LatLonConverter.convert(prevPanel2.getLongitudeStr(), fromFmt, toFmt, LatLonConverter.LATLON.Longitude);
                }
                this.hasChanged = true;
                this.stateChanged(null);
                prevPanel1.setHasChanged(false);
            }
        } else {
            if (latLon1.first == null && latLon1.second == null) {
                latLon1.first = prevPanel1.getLatitudeStr(false);
                latLon1.second = prevPanel1.getLongitudeStr();
            }
            if (prevPanel2 != null && latLon2 != null && latLon2.first == null && latLon2.second == null) {
                latLon2.first = prevPanel2.getLatitudeStr(false);
                latLon2.second = prevPanel2.getLongitudeStr();
            }
        }
    }

    protected void swapForm(int formInx, LatLonUIIFace.LatLonType type) {
        if (this.currentInx != -1 && this.currentInx != formInx) {
            boolean srcFormatHasChanged;
            LatLonConverter.FORMAT[] fmts = LatLonConverter.FORMAT.values();
            LatLonConverter.FORMAT fromFmt = this.srcFormat;
            LatLonConverter.FORMAT toFmt = fmts[formInx];
            DDDDPanel prevPanel1 = this.panels[this.currentInx * 2];
            DDDDPanel prevPanel2 = this.panels[this.currentInx * 2 + 1];
            DDDDPanel nextPanel1 = this.panels[formInx * 2];
            DDDDPanel nextPanel2 = this.panels[formInx * 2 + 1];
            boolean bl = srcFormatHasChanged = prevPanel1.getDefaultFormat() != this.srcFormat;
            if (type == LatLonUIIFace.LatLonType.LLPoint) {
                if (prevPanel1.hasChanged()) {
                    this.checkPanel(srcFormatHasChanged, prevPanel1, null, this.srcLatLon1, null, fromFmt, toFmt);
                } else if (this.srcLatLon1.first == null && this.srcLatLon1.second == null) {
                    this.srcFormat = nextPanel1.getDefaultFormat();
                }
            } else if (prevPanel1.hasChanged() && !prevPanel2.hasChanged()) {
                this.checkPanel(srcFormatHasChanged, prevPanel1, prevPanel2, this.srcLatLon1, this.srcLatLon2, fromFmt, toFmt);
            } else if (prevPanel2.hasChanged() && !prevPanel1.hasChanged()) {
                this.checkPanel(srcFormatHasChanged, prevPanel2, prevPanel1, this.srcLatLon2, this.srcLatLon1, fromFmt, toFmt);
            } else if (prevPanel1.hasChanged() && prevPanel2.hasChanged()) {
                this.checkPanel(srcFormatHasChanged, prevPanel1, null, this.srcLatLon1, null, fromFmt, toFmt);
                this.checkPanel(srcFormatHasChanged, prevPanel2, null, this.srcLatLon2, null, fromFmt, toFmt);
            } else if (this.srcLatLon1.first == null && this.srcLatLon1.second == null && this.srcLatLon2.first == null && this.srcLatLon2.second == null) {
                this.srcFormat = nextPanel1.getDefaultFormat();
            }
            nextPanel1.set(this.srcFormat, (String)this.srcLatLon1.first, (String)this.srcLatLon1.second);
            if (type == LatLonUIIFace.LatLonType.LLPoint) {
                nextPanel2.clear();
            } else {
                nextPanel2.set(this.srcFormat, (String)this.srcLatLon2.first, (String)this.srcLatLon2.second);
            }
            this.hasChanged = true;
            this.stateChanged(null);
            this.choosenFormat = toFmt;
        }
        for (JToggleButton rb : this.selectedTypeHash.keySet()) {
            if (this.selectedTypeHash.get(rb).ordinal() != type.ordinal()) continue;
            rb.setSelected(true);
            break;
        }
        DDDDPanel panel = this.panels[formInx * 2];
        this.cardSubPanes[formInx].removeAll();
        if (type == LatLonUIIFace.LatLonType.LLPoint) {
            this.cardSubPanes[formInx].add((Component)panel, "Center");
            panel.setBorder(this.panelBorder);
        } else {
            JTabbedPane tabbedPane = (JTabbedPane)this.latLonPanes[formInx];
            tabbedPane.removeAll();
            this.cardSubPanes[formInx].add((Component)tabbedPane, "Center");
            panel.setBorder(null);
            int inx = type == LatLonUIIFace.LatLonType.LLLine ? 1 : 3;
            tabbedPane.addTab(null, this.pointImages[inx++], this.panels[formInx * 2]);
            tabbedPane.addTab(null, this.pointImages[inx], this.panels[formInx * 2 + 1]);
        }
        this.cardPanel.validate();
        this.cardPanel.doLayout();
        this.cardPanel.repaint();
        this.currentInx = formInx;
    }

    protected static LatLonUIIFace.LatLonType convertLatLongType(String typeStr) {
        if (StringUtils.isEmpty((String)typeStr) || typeStr.equals("Point")) {
            return LatLonUIIFace.LatLonType.LLPoint;
        }
        if (typeStr.equals("Line")) {
            return LatLonUIIFace.LatLonType.LLLine;
        }
        if (typeStr.equals("Rectangle")) {
            return LatLonUIIFace.LatLonType.LLRect;
        }
        return LatLonUIIFace.LatLonType.LLPoint;
    }

    public void resetUI() {
        this.botBtns[0].doClick();
        this.formatSelector.setSelectedIndex(0);
    }

    public void setLatLon(String latStr1, String lonStr1, String latStr2, String lonStr2) {
        if (this.currentInx > -1) {
            this.srcLatLon1.first = latStr1;
            this.srcLatLon1.second = lonStr1;
            this.srcLatLon2.first = latStr2;
            this.srcLatLon2.second = lonStr2;
            LatLonConverter.FORMAT checkFmt = this.geoRefCnv.getLatLonFormat(latStr1);
            if (checkFmt != this.srcFormat) {
                this.srcFormat = checkFmt;
            }
            this.panels[this.currentInx * 2].set(this.srcFormat, latStr1, lonStr1);
            this.panels[this.currentInx * 2 + 1].set(this.srcFormat, latStr2, lonStr2);
            this.stateChanged(new ChangeEvent(this));
        }
    }

    public void setErrorInfo(String errorPoly, BigDecimal errorEstimate) {
        this.didGCDFieldCheck = false;
        if (this.fvo != null && this.gcdMV == null) {
            for (MultiView kidMV : this.fvo.getKids()) {
                if (!kidMV.isEditable() || !kidMV.getView().getClassName().equals(GeoCoordDetail.class.getName())) continue;
                this.gcdMV = kidMV;
                break;
            }
        }
        GeoCoordDetail geoCoordDetail = null;
        if (this.gcdMV != null) {
            boolean alreadyHasData;
            Object formData = this.gcdMV.getCurrentViewAsFormViewObj().getDataObj();
            boolean bl = alreadyHasData = formData != null;
            if (formData instanceof GeoCoordDetail) {
                geoCoordDetail = (GeoCoordDetail)formData;
            } else {
                geoCoordDetail = new GeoCoordDetail();
                geoCoordDetail.initialize();
                this.locality.getGeoCoordDetails().add(geoCoordDetail);
                geoCoordDetail.setLocality(this.locality);
                if (!alreadyHasData && geoCoordDetail.getId() == null) {
                    this.gcdMV.setData(this.locality.getGeoCoordDetails());
                }
            }
            if (!this.didGCDFieldCheck) {
                for (Viewable view : this.gcdMV.getViewables()) {
                    if (!view.isSubform() || !(view instanceof FormViewObj)) continue;
                    FormViewObj kidFVO = (FormViewObj)view;
                    this.errEstFieldInfo = kidFVO.getFieldInfoForName("maxUncertaintyEst");
                    this.errPolyFieldInfo = kidFVO.getFieldInfoForName("errorPolygon");
                }
                this.didGCDFieldCheck = true;
            }
            if (this.errEstFieldInfo != null) {
                ((GetSetValueIFace)((Object)this.errEstFieldInfo.getComp())).setValue(errorEstimate, null);
            } else {
                geoCoordDetail.setMaxUncertaintyEst(errorEstimate);
            }
            if (this.errPolyFieldInfo != null) {
                ((GetSetValueIFace)((Object)this.errPolyFieldInfo.getComp())).setValue(errorPoly, null);
            } else {
                geoCoordDetail.setErrorPolygon(errorPoly);
            }
        }
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        super.setValue(value, defaultValue);
        if (value != null && !(value instanceof Locality)) {
            throw new RuntimeException("Data [" + value.getClass().getSimpleName() + "] is not of class Locality!");
        }
        DDDDPanel[] dDDDPanelArray = this.panels;
        int n = this.panels.length;
        int n2 = 0;
        while (n2 < n) {
            DDDDPanel p = dDDDPanelArray[n2];
            p.setHasChanged(false);
            ++n2;
        }
        this.locality = (Locality)value;
        if (this.locality != null) {
            LatLonConverter.FORMAT defaultFormat = null;
            defaultFormat = this.locality.isOriginalLatLongUnitEmpty() ? LatLonConverter.convertIntToFORMAT(AppPreferences.getRemote().getInt(FMT_PREF, 0)) : LatLonConverter.convertIntToFORMAT(this.locality.getOriginalLatLongUnit());
            this.choosenFormat = defaultFormat;
            this.srcFormat = this.locality.getId() == null ? this.choosenFormat : LatLonConverter.convertIntToFORMAT(this.locality.getSrcLatLongUnit().byteValue());
            this.srcLatLon1.first = LatLonConverter.ensureFormattedString(this.locality.getLatitude1(), this.locality.getLat1text(), defaultFormat, LatLonConverter.LATLON.Latitude);
            this.srcLatLon1.second = LatLonConverter.ensureFormattedString(this.locality.getLongitude1(), this.locality.getLong1text(), defaultFormat, LatLonConverter.LATLON.Longitude);
            this.srcLatLon2.first = LatLonConverter.ensureFormattedString(this.locality.getLatitude2(), this.locality.getLat2text(), defaultFormat, LatLonConverter.LATLON.Latitude);
            this.srcLatLon2.second = LatLonConverter.ensureFormattedString(this.locality.getLongitude2(), this.locality.getLong2text(), defaultFormat, LatLonConverter.LATLON.Longitude);
            this.currentInx = defaultFormat.ordinal();
            this.currentType = this.locality.getLatLongType() == null ? types[AppPreferences.getRemote().getInt(TYP_PREF, 0)] : LatLonUI.convertLatLongType(this.locality.getLatLongType());
            this.setLatLon((String)this.srcLatLon1.first, (String)this.srcLatLon1.second, (String)this.srcLatLon2.first, (String)this.srcLatLon2.second);
        } else {
            this.currentInx = 0;
            this.currentType = LatLonUIIFace.LatLonType.LLPoint;
            this.setLatLon(null, null, null, null);
        }
        this.stateChangeOK = false;
        this.formatSelector.setSelectedIndex(this.currentInx);
        this.cardLayout.show(this.cardPanel, this.formatSelector.getSelectedItem().toString());
        if (this.typeLabel != null) {
            this.typeLabel.setText(this.typeNamesLabels[this.currentType.ordinal()]);
        }
        this.stateChangeOK = true;
    }

    @Override
    public Object getValue() {
        if (this.locality != null && this.currentType != null) {
            this.locality.setLatLongType(this.typeMapper.get((Object)this.currentType));
            this.locality.setOriginalLatLongUnit(this.choosenFormat.ordinal());
            log.debug((Object)("getValue - choosenFormat " + (Object)((Object)this.choosenFormat)));
            int curInx = this.formatSelector.getSelectedIndex() * 2;
            DDDDPanel prevPanel1 = this.panels[curInx];
            DDDDPanel prevPanel2 = this.panels[curInx + 1];
            prevPanel1.getDataFromUI();
            prevPanel2.getDataFromUI();
            if (prevPanel1.hasChanged()) {
                this.srcFormat = prevPanel1.getDefaultFormat();
            }
            this.locality.setLatitude1(prevPanel1.getLatitude());
            this.locality.setLongitude1(prevPanel1.getLongitude());
            this.locality.setLat1text(this.locality.getLat1() != null ? prevPanel1.getSrcLatitudeStr() : null);
            this.locality.setLong1text(this.locality.getLong1() != null ? prevPanel1.getSrcLongitudeStr() : null);
            this.locality.setLatitude2(prevPanel2.getLatitude());
            this.locality.setLongitude2(prevPanel2.getLongitude());
            this.locality.setLat2text(this.locality.getLat2() != null ? prevPanel2.getSrcLatitudeStr() : null);
            this.locality.setLong2text(this.locality.getLong2() != null ? prevPanel2.getSrcLongitudeStr() : null);
            this.locality.setSrcLatLongUnit((byte)this.srcFormat.ordinal());
        }
        return this.locality;
    }

    public Pair<BigDecimal, BigDecimal> getLatLon() {
        int curInx = this.formatSelector.getSelectedIndex() * 2;
        this.panels[curInx].getDataFromUI();
        this.panels[curInx + 1].getDataFromUI();
        Pair<BigDecimal, BigDecimal> latLon = new Pair<BigDecimal, BigDecimal>();
        latLon.first = this.panels[curInx].getLatitude();
        latLon.second = this.panels[curInx].getLongitude();
        return latLon;
    }

    @Override
    public void initialize(Properties propertiesArg, boolean isViewModeArg) {
        super.initialize(propertiesArg, isViewModeArg);
        this.createEditUI();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.locality = null;
    }

    @Override
    public void setParent(FormViewObj parent) {
        super.setParent(parent);
    }

    @Override
    public boolean canCarryForward() {
        return true;
    }

    @Override
    public String[] getCarryForwardFields() {
        return this.fieldNames;
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void cleanUp() {
        DDDDPanel[] dDDDPanelArray = this.panels;
        int n = this.panels.length;
        int n2 = 0;
        while (n2 < n) {
            DDDDPanel panel = dDDDPanelArray[n2];
            panel.cleanUp();
            ++n2;
        }
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.valState;
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public boolean isInError() {
        return this.valState != UIValidatable.ErrorType.Valid;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void reset() {
        this.setLatLon(null, null, null, null);
        this.valState = this.isRequired ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
        this.isChanged = false;
    }

    @Override
    public void setAsNew(boolean isNew) {
        this.isNew = isNew;
    }

    @Override
    public void setChanged(boolean isChanged) {
        int n;
        int n2;
        EventListener[] eventListenerArray;
        this.isChanged = isChanged;
        if (isChanged) {
            eventListenerArray = this.getPropertyChangeListeners();
            n2 = eventListenerArray.length;
            n = 0;
            while (n < n2) {
                EventListener l = eventListenerArray[n];
                l.propertyChange(new PropertyChangeEvent(this, "latlon", null, this.getLatLon()));
                ++n;
            }
        }
        if (!isChanged) {
            eventListenerArray = this.panels;
            n2 = this.panels.length;
            n = 0;
            while (n < n2) {
                EventListener panel = eventListenerArray[n];
                panel.setHasChanged(isChanged);
                ++n;
            }
        }
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        this.valState = state;
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        int startInx;
        this.reason = null;
        this.valState = UIValidatable.ErrorType.Valid;
        int i = startInx = this.currentInx * 2;
        while (i < startInx + 2) {
            UIValidatable.ErrorType errType;
            boolean isNotPoint;
            boolean bl = isNotPoint = this.currentType != LatLonUIIFace.LatLonType.LLPoint;
            if ((i == startInx || isNotPoint) && (errType = this.panels[i].validateState(isNotPoint)).ordinal() > this.valState.ordinal()) {
                this.valState = errType;
                this.reason = i == startInx ? (this.valState == UIValidatable.ErrorType.Incomplete ? (isNotPoint ? this.errorMessages[3] : this.errorMessages[1]) : (isNotPoint ? this.errorMessages[2] : this.errorMessages[0])) : (this.valState == UIValidatable.ErrorType.Incomplete ? this.errorMessages[5] : this.errorMessages[4]);
            }
            ++i;
        }
        return this.valState;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.stateChangeOK) {
            this.validateState();
            this.isChanged = true;
            this.notifyChangeListeners(e);
        }
    }
}

