/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.latlon;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextFieldSingle;
import edu.ku.brc.specify.plugins.latlon.DDDDPanel;
import edu.ku.brc.specify.plugins.latlon.DDMMMMPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.util.LatLonConverter;
import java.awt.Component;

public class DDMMSSPanel
extends DDMMMMPanel {
    protected ValFormattedTextFieldSingle latitudeSS;
    protected ValFormattedTextFieldSingle longitudeSS;

    public DDMMSSPanel() {
        this.defaultFormat = LatLonConverter.FORMAT.DDMMSS;
        this.decimalFmtLen = 3;
    }

    @Override
    public void init() {
        PanelBuilder builder = this.createUI("p, p, p, p, p, p, p, 2px, p", 3, 3, 9, true, true);
        this.latitudeSS = this.createTextField(Double.class, 6, 0.0, 59.99999999, this.latTFs);
        this.longitudeSS = this.createTextField(Double.class, 6, 0.0, 59.99999999, this.lonTFs);
        this.latitudeMM.setColumns(3);
        this.longitudeMM.setColumns(3);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)UIHelper.createLabel(" : "), cc.xy(6, 1));
        builder.add((Component)this.latitudeSS, cc.xy(7, 1));
        builder.add((Component)UIHelper.createLabel(" : "), cc.xy(6, 3));
        builder.add((Component)this.longitudeSS, cc.xy(7, 3));
        this.textFields.clear();
        this.textFields.addAll(this.latTFs);
        this.textFields.addAll(this.lonTFs);
    }

    @Override
    protected void setDataIntoUI() {
        if (this.latitudeStr != null && this.latInfoCnvrt != null) {
            this.latitudeDir.removeItemListener(this);
            this.latitudeDir.setSelectedIndex(this.latInfoCnvrt.isDirPositive() ? 0 : 1);
            this.latitudeDir.addItemListener(this);
            this.latitudeDD.setText(this.latInfoCnvrt.getPart(0));
            this.latitudeMM.setText(this.latInfoCnvrt.getPart(1));
            this.latitudeSS.setText(this.latInfoCnvrt.getPart(2));
            if (this.latitudeDirTxt != null) {
                this.latitudeDirTxt.setText(this.latInfoCnvrt.getDirStr());
            }
        } else {
            this.latitudeDir.removeItemListener(this);
            boolean isDefNorth = AppPreferences.getRemote().getBoolean("latlon.plugin.def_lat", true);
            this.latitudeDir.setSelectedIndex(isDefNorth ? 0 : 1);
            this.latitudeDir.addItemListener(this);
            this.latitudeDD.setText("");
            this.latitudeMM.setText("");
            this.latitudeSS.setText("");
            if (this.latitudeDirTxt != null) {
                this.latitudeDirTxt.setText("");
            }
            this.latitudeTF.setText("");
        }
        if (this.longitudeStr != null && this.lonInfoCnvrt != null) {
            this.longitudeDir.removeItemListener(this);
            this.longitudeDir.setSelectedIndex(this.lonInfoCnvrt.isDirPositive() ? 0 : 1);
            this.longitudeDir.addItemListener(this);
            this.longitudeDD.setText(this.lonInfoCnvrt.getPart(0));
            this.longitudeMM.setText(this.lonInfoCnvrt.getPart(1));
            this.longitudeSS.setText(this.lonInfoCnvrt.getPart(2));
            if (this.longitudeDirTxt != null) {
                this.longitudeDirTxt.setText(this.lonInfoCnvrt.getDirStr());
            }
        } else {
            this.longitudeDir.removeItemListener(this);
            boolean isDefWest = AppPreferences.getRemote().getBoolean("latlon.plugin.def_lon", true);
            this.longitudeDir.setSelectedIndex(isDefWest ? 1 : 0);
            this.longitudeDir.addItemListener(this);
            this.longitudeDD.setText("");
            this.longitudeMM.setText("");
            this.longitudeSS.setText("");
            if (this.latitudeDirTxt != null) {
                this.longitudeDirTxt.setText("");
            }
            this.longitudeTF.setText("");
        }
    }

    @Override
    public void getDataFromUI(boolean doLatitude) {
        if (doLatitude) {
            this.latitude = this.evalState(this.latitudeDD, this.latitudeMM, this.latitudeSS) == DDDDPanel.ValState.Valid ? LatLonConverter.convertDDMMSSStrToDDDDBD(this.getStringFromFields(this.latitudeDD, this.latitudeMM, this.latitudeSS), NORTH_SOUTH[this.latitudeDir.getSelectedIndex()]) : null;
        } else {
            this.longitude = this.evalState(this.longitudeDD, this.longitudeMM, this.longitudeSS) == DDDDPanel.ValState.Valid ? LatLonConverter.convertDDMMSSStrToDDDDBD(this.getStringFromFields(this.longitudeDD, this.longitudeMM, this.longitudeSS), EAST_WEST[this.longitudeDir.getSelectedIndex()]) : null;
        }
    }

    @Override
    public String getLatitudeStr(boolean inclZeroes) {
        return String.valueOf(this.getStringFromFields(true, inclZeroes, this.latitudeDD, this.latitudeMM, this.latitudeSS)) + " " + NORTH_SOUTH[this.latitudeDir.getSelectedIndex()];
    }

    @Override
    public String getLongitudeStr(boolean inclZeroes) {
        return String.valueOf(this.getStringFromFields(true, inclZeroes, this.longitudeDD, this.longitudeMM, this.longitudeSS)) + " " + EAST_WEST[this.longitudeDir.getSelectedIndex()];
    }

    @Override
    public void clear() {
        super.clear();
        this.latitudeSS.setText("");
        this.longitudeSS.setText("");
    }
}

