/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.latlon;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextFieldSingle;
import edu.ku.brc.specify.plugins.latlon.DDDDPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.util.LatLonConverter;
import java.awt.Component;
import org.apache.log4j.Logger;

public class DDMMMMPanel
extends DDDDPanel {
    protected static final Logger log = Logger.getLogger(DDMMMMPanel.class);
    protected ValFormattedTextFieldSingle latitudeMM;
    protected ValFormattedTextFieldSingle longitudeMM;

    public DDMMMMPanel() {
        this.defaultFormat = LatLonConverter.FORMAT.DDMMMM;
        this.decimalFmtLen = 5;
    }

    @Override
    public void init() {
        this.createUI("p, p, p, p, p, 2px, p", 3, 3, 7, true, false);
    }

    protected PanelBuilder createUI(String colDef, int latCols, int lonCols, int cbxIndex, boolean asDDIntegers, boolean asMMIntegers) {
        PanelBuilder builder = super.createUI(colDef, latCols, lonCols, cbxIndex, asDDIntegers);
        CellConstraints cc = new CellConstraints();
        this.latitudeMM = asMMIntegers ? this.createTextField(Integer.class, 8, 0, 59, this.latTFs) : this.createTextField(Double.class, 8, 0.0, 59.99999999, this.latTFs);
        this.longitudeMM = asMMIntegers ? this.createTextField(Integer.class, 8, 0, 59, this.lonTFs) : this.createTextField(Double.class, 8, 0.0, 59.99999999, this.lonTFs);
        builder.add((Component)UIHelper.createLabel(" "), cc.xy(4, 1));
        builder.add((Component)this.latitudeMM, cc.xy(5, 1));
        builder.add((Component)UIHelper.createLabel(" "), cc.xy(4, 3));
        builder.add((Component)this.longitudeMM, cc.xy(5, 3));
        this.textFields.clear();
        this.textFields.addAll(this.latTFs);
        this.textFields.addAll(this.lonTFs);
        return builder;
    }

    @Override
    protected void setDataIntoUI() {
        if (this.latitudeStr != null && this.latInfoCnvrt != null) {
            this.latitudeDir.removeItemListener(this);
            this.latitudeDir.setSelectedIndex(this.latInfoCnvrt.isDirPositive() ? 0 : 1);
            this.latitudeDir.addItemListener(this);
            this.latitudeDD.setText(this.latInfoCnvrt.getPart(0));
            this.latitudeMM.setText(this.latInfoCnvrt.getPart(1));
            if (this.latitudeDirTxt != null) {
                this.latitudeDirTxt.setText(this.latInfoCnvrt.getDirStr());
            }
        } else {
            this.latitudeDir.removeItemListener(this);
            boolean isDefNorth = AppPreferences.getRemote().getBoolean("latlon.plugin.def_lat", true);
            this.latitudeDir.setSelectedIndex(isDefNorth ? 0 : 1);
            this.latitudeDir.addItemListener(this);
            this.latitudeDD.setText("");
            this.latitudeMM.setText("");
            if (this.latitudeDirTxt != null) {
                this.latitudeDirTxt.setText("");
            }
            this.latitudeTF.setText("");
        }
        if (this.longitudeStr != null && this.lonInfoCnvrt != null) {
            this.longitudeDir.removeItemListener(this);
            this.longitudeDir.setSelectedIndex(this.lonInfoCnvrt.isDirPositive() ? 0 : 1);
            this.longitudeDir.addItemListener(this);
            this.longitudeDD.setText(this.lonInfoCnvrt.getPart(0));
            this.longitudeMM.setText(this.lonInfoCnvrt.getPart(1));
            if (this.longitudeDirTxt != null) {
                this.longitudeDirTxt.setText(this.lonInfoCnvrt.getDirStr());
            }
        } else {
            this.longitudeDir.removeItemListener(this);
            boolean isDefWest = AppPreferences.getRemote().getBoolean("latlon.plugin.def_lon", true);
            this.longitudeDir.setSelectedIndex(isDefWest ? 1 : 0);
            this.longitudeDir.addItemListener(this);
            this.longitudeDD.setText("");
            this.longitudeMM.setText("");
            if (this.latitudeDirTxt != null) {
                this.longitudeDirTxt.setText("");
            }
            this.longitudeTF.setText("");
        }
    }

    @Override
    protected void getDataFromUI(boolean doLatitude) {
        if (doLatitude) {
            this.latitude = this.evalState(this.latitudeDD, this.latitudeMM) == DDDDPanel.ValState.Valid ? LatLonConverter.convertDDMMMMStrToDDDDBD(this.getStringFromFields(this.latitudeDD, this.latitudeMM), NORTH_SOUTH[this.latitudeDir.getSelectedIndex()]) : null;
        } else {
            this.longitude = this.evalState(this.longitudeDD, this.longitudeMM) == DDDDPanel.ValState.Valid ? LatLonConverter.convertDDMMMMStrToDDDDBD(this.getStringFromFields(this.longitudeDD, this.longitudeMM), EAST_WEST[this.longitudeDir.getSelectedIndex()]) : null;
        }
    }

    @Override
    public String getLatitudeStr(boolean inclZeroes) {
        return String.valueOf(this.getStringFromFields(true, true, this.latitudeDD, this.latitudeMM)) + " " + NORTH_SOUTH[this.latitudeDir.getSelectedIndex()];
    }

    @Override
    public String getLongitudeStr(boolean inclZeroes) {
        return String.valueOf(this.getStringFromFields(true, inclZeroes, this.longitudeDD, this.longitudeMM)) + " " + EAST_WEST[this.longitudeDir.getSelectedIndex()];
    }

    @Override
    public void getDataFromUI() {
        this.getDataFromUI(true);
        this.getDataFromUI(false);
    }

    @Override
    public void clear() {
        super.clear();
        this.latitudeMM.setText("");
        this.longitudeMM.setText("");
    }
}

