/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.latlon;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.formatters.NumberMinMaxFormatter;
import edu.ku.brc.af.ui.forms.validation.DataChangeListener;
import edu.ku.brc.af.ui.forms.validation.DataChangeNotifier;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextFieldSingle;
import edu.ku.brc.specify.plugins.latlon.LatLonUIIFace;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.VerticalSeparator;
import edu.ku.brc.util.LatLonConverter;
import edu.ku.brc.util.LatLonValueInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;

public class DDDDPanel
extends JPanel
implements LatLonUIIFace,
DataChangeListener,
ItemListener {
    protected static final String[] NORTH_SOUTH = new String[]{"N", "S"};
    protected static final String[] EAST_WEST = new String[]{"E", "W"};
    protected static String[] northSouth = null;
    protected static String[] eastWest = null;
    protected BigDecimal minusOne = new BigDecimal("-1.0");
    protected int decimalFmtLen = 7;
    protected boolean isViewMode = false;
    protected ValFormattedTextFieldSingle latitudeDD;
    protected ValFormattedTextFieldSingle longitudeDD;
    protected LatLonValueInfo latInfoOrig = null;
    protected LatLonValueInfo lonInfoOrig = null;
    protected LatLonValueInfo latInfoCnvrt = null;
    protected LatLonValueInfo lonInfoCnvrt = null;
    protected BigDecimal latitude;
    protected BigDecimal longitude;
    protected String latitudeStr;
    protected String longitudeStr;
    protected LatLonConverter.FORMAT defaultFormat;
    protected JComboBox latitudeDir;
    protected JComboBox longitudeDir;
    protected JTextField latitudeDirTxt;
    protected JTextField longitudeDirTxt;
    protected JLabel latLabel;
    protected JLabel lonLabel;
    protected JTextField latitudeTF;
    protected JTextField longitudeTF;
    protected boolean hasChanged = false;
    protected boolean isRequired = false;
    protected ChangeListener changeListener = null;
    protected String reason = null;
    protected Vector<ValFormattedTextFieldSingle> textFields = new Vector();
    protected Vector<ValFormattedTextFieldSingle> latTFs = new Vector();
    protected Vector<ValFormattedTextFieldSingle> lonTFs = new Vector();
    protected Vector<DataChangeNotifier> dcNotifiers = new Vector();
    protected StringBuilder sb = new StringBuilder();

    public DDDDPanel() {
        this.defaultFormat = LatLonConverter.FORMAT.DDDDDD;
        if (northSouth == null) {
            northSouth = new String[]{UIRegistry.getResourceString(NORTH_SOUTH[0]), UIRegistry.getResourceString(NORTH_SOUTH[1])};
        }
        if (eastWest == null) {
            eastWest = new String[]{UIRegistry.getResourceString(EAST_WEST[0]), UIRegistry.getResourceString(EAST_WEST[1])};
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.latitudeDir != null) {
            this.latitudeDir.setEnabled(enabled);
            this.longitudeDir.setEnabled(enabled);
        }
        if (this.latitudeDirTxt != null) {
            this.latitudeDirTxt.setEnabled(enabled);
            this.longitudeDirTxt.setEnabled(enabled);
        }
        for (ValFormattedTextFieldSingle vtfs : this.textFields) {
            vtfs.setEnabled(enabled);
        }
        this.latLabel.setEnabled(enabled);
        this.lonLabel.setEnabled(enabled);
    }

    @Override
    public void init() {
        this.createUI("p, 2px, p, 2px, p", 10, 10, 5, false);
    }

    protected PanelBuilder createUI(String colDef, int latCols, int lonCols, int cbxIndex, boolean asDDIntegers) {
        JComponent lonDir;
        JComponent latDir;
        this.latitudeDD = asDDIntegers ? this.createTextField(Integer.class, latCols, 0, 90, this.latTFs) : this.createTextField(Double.class, latCols, 0.0, 90.0, this.latTFs);
        this.longitudeDD = asDDIntegers ? this.createTextField(Integer.class, lonCols, 0, 180, this.lonTFs) : this.createTextField(Double.class, lonCols, 0.0, 180.0, this.lonTFs);
        this.textFields.addAll(this.latTFs);
        this.textFields.addAll(this.lonTFs);
        PanelBuilder builder = new PanelBuilder(new FormLayout(colDef, "p, 1px, p, c:p:g"));
        CellConstraints cc = new CellConstraints();
        this.latitudeDir = this.createDirComboxbox(true);
        this.longitudeDir = this.createDirComboxbox(false);
        if (this.isViewMode) {
            this.latitudeDirTxt = new JTextField(2);
            this.longitudeDirTxt = new JTextField(2);
            UIHelper.setControlSize(this.latitudeDirTxt);
            UIHelper.setControlSize(this.longitudeDirTxt);
            ViewFactory.changeTextFieldUIForDisplay(this.latitudeDirTxt, false);
            ViewFactory.changeTextFieldUIForDisplay(this.longitudeDirTxt, false);
            latDir = this.latitudeDirTxt;
            lonDir = this.longitudeDirTxt;
        } else {
            latDir = this.latitudeDir;
            lonDir = this.longitudeDir;
        }
        this.latLabel = UIHelper.createI18NFormLabel("Latitude", 4);
        builder.add((Component)this.latLabel, cc.xy(1, 1));
        builder.add((Component)this.latitudeDD, cc.xy(3, 1));
        builder.add((Component)latDir, cc.xy(cbxIndex, 1));
        this.lonLabel = UIHelper.createI18NFormLabel("Longitude", 4);
        builder.add((Component)this.lonLabel, cc.xy(1, 3));
        builder.add((Component)this.longitudeDD, cc.xy(3, 3));
        builder.add((Component)lonDir, cc.xy(cbxIndex, 3));
        builder.setBorder(BorderFactory.createEmptyBorder(4, 2, 0, 2));
        PanelBuilder pb = new PanelBuilder(new FormLayout(colDef, "p, 1px, p, p"), (JPanel)this);
        PanelBuilder txtPanelPB = new PanelBuilder(new FormLayout("5px,p,5px,p,2px,p", "p, 4px, p"));
        this.latitudeTF = new JTextField(15);
        this.longitudeTF = new JTextField(15);
        if (!this.isViewMode) {
            Color bg = this.getBackground();
            txtPanelPB.add((Component)new VerticalSeparator(bg.darker(), bg.brighter()), cc.xywh(1, 1, 1, 3));
            txtPanelPB.add((Component)this.latitudeTF, cc.xy(4, 1));
            txtPanelPB.add((Component)UIHelper.createI18NLabel("SOURCE"), cc.xy(6, 1));
            txtPanelPB.add((Component)this.longitudeTF, cc.xy(4, 3));
            txtPanelPB.add((Component)UIHelper.createI18NLabel("SOURCE"), cc.xy(6, 3));
            txtPanelPB.setBorder(BorderFactory.createEmptyBorder(4, 2, 0, 2));
        }
        this.latitudeTF.setEditable(false);
        this.longitudeTF.setEditable(false);
        pb.add((Component)builder.getPanel(), cc.xy(1, 1));
        pb.add((Component)txtPanelPB.getPanel(), cc.xy(3, 1));
        this.textFields.addAll(this.latTFs);
        this.textFields.addAll(this.lonTFs);
        return builder;
    }

    public JComboBox createDirComboxbox(boolean forNorthSouth) {
        JComboBox cbx = UIHelper.createComboBox(forNorthSouth ? northSouth : eastWest);
        cbx.addItemListener(this);
        return cbx;
    }

    protected void setDataIntoUI() {
        if (StringUtils.isNotEmpty((String)this.latitudeStr)) {
            this.latitudeDir.removeItemListener(this);
            this.latitudeDir.setSelectedIndex(this.latInfoCnvrt.isDirPositive() ? 0 : 1);
            this.latitudeDir.addItemListener(this);
            this.latitudeDD.setText(this.latInfoCnvrt.getPart(0));
            if (this.latitudeDirTxt != null) {
                this.latitudeDirTxt.setText(this.latInfoCnvrt.getDirStr());
            }
        } else {
            this.latitudeDir.removeItemListener(this);
            boolean isDefNorth = AppPreferences.getRemote().getBoolean("latlon.plugin.def_lat", true);
            this.latitudeDir.setSelectedIndex(isDefNorth ? 0 : 1);
            this.latitudeDir.addItemListener(this);
            this.latitudeDD.setText("");
            if (this.latitudeDirTxt != null) {
                this.latitudeDirTxt.setText("");
            }
            this.latitudeTF.setText("");
        }
        if (StringUtils.isNotEmpty((String)this.longitudeStr)) {
            this.longitudeDir.removeItemListener(this);
            this.longitudeDir.setSelectedIndex(this.lonInfoCnvrt.isDirPositive() ? 0 : 1);
            this.longitudeDir.addItemListener(this);
            this.longitudeDD.setText(this.lonInfoCnvrt.getPart(0));
            if (this.longitudeDirTxt != null) {
                this.longitudeDirTxt.setText(this.lonInfoCnvrt.getDirStr());
            }
        } else {
            this.longitudeDir.removeItemListener(this);
            boolean isDefWest = AppPreferences.getRemote().getBoolean("latlon.plugin.def_lon", true);
            this.longitudeDir.setSelectedIndex(isDefWest ? 1 : 0);
            this.longitudeDir.addItemListener(this);
            this.longitudeDD.setText("");
            if (this.latitudeDirTxt != null) {
                this.longitudeDirTxt.setText("");
            }
            this.longitudeTF.setText("");
        }
    }

    protected String getStringFromFields(ValFormattedTextFieldSingle ... txtFields) {
        return this.getStringFromFields(false, true, txtFields);
    }

    public LatLonConverter.FORMAT getDefaultFormat() {
        return this.defaultFormat;
    }

    /*
     * Unable to fully structure code
     */
    protected String getStringFromFields(boolean doDisplay, boolean inclZeroes, ValFormattedTextFieldSingle ... txtFields) {
        degrees = "\u00b0";
        this.sb.setLength(0);
        cnt = 0;
        var9_6 = txtFields;
        var8_7 = txtFields.length;
        var7_8 = 0;
        while (var7_8 < var8_7) {
            tf = var9_6[var7_8];
            str = StringUtils.deleteWhitespace((String)tf.getText());
            if (!StringUtils.isEmpty((String)str)) ** GOTO lbl15
            if (!inclZeroes) {
                str = "";
            } else {
                str = "0";
lbl15:
                // 2 sources

                if (cnt > 0) {
                    this.sb.append(' ');
                }
                this.sb.append(str);
                if (doDisplay) {
                    if (cnt == 0) {
                        this.sb.append(degrees);
                    } else if (txtFields.length == 2) {
                        this.sb.append("'");
                    } else if (txtFields.length == 3) {
                        this.sb.append(cnt == 1 ? "'" : "\"");
                    }
                }
                ++cnt;
            }
            ++var7_8;
        }
        return this.sb.toString();
    }

    protected ValState evalState(ValFormattedTextFieldSingle ... txtFields) {
        ValFormattedTextFieldSingle[] valFormattedTextFieldSingleArray = txtFields;
        int n = txtFields.length;
        int n2 = 0;
        while (n2 < n) {
            ValFormattedTextFieldSingle tf = valFormattedTextFieldSingleArray[n2];
            tf.setState(UIValidatable.ErrorType.Valid);
            tf.repaint();
            ++n2;
        }
        ValState state = ValState.Empty;
        boolean isEmpty = false;
        ValFormattedTextFieldSingle prevTF = null;
        ValFormattedTextFieldSingle[] valFormattedTextFieldSingleArray2 = txtFields;
        int n3 = txtFields.length;
        int n4 = 0;
        while (n4 < n3) {
            ValFormattedTextFieldSingle tf = valFormattedTextFieldSingleArray2[n4];
            String str = StringUtils.deleteWhitespace((String)tf.getText());
            if (StringUtils.isEmpty((String)str)) {
                isEmpty = true;
            } else if (tf.getState() == UIValidatable.ErrorType.Valid && tf.getText().length() > 0) {
                if (isEmpty) {
                    if (prevTF != null) {
                        prevTF.setState(UIValidatable.ErrorType.Error);
                        prevTF.repaint();
                    }
                    return ValState.Error;
                }
                state = ValState.Valid;
            } else {
                return ValState.Error;
            }
            prevTF = tf;
            ++n4;
        }
        return state;
    }

    protected void getDataFromUI(boolean doLatitude) {
        if (doLatitude) {
            String str = this.latitudeDD.getText();
            if (StringUtils.isNotEmpty((String)StringUtils.deleteWhitespace((String)str))) {
                this.latitude = LatLonConverter.convertDDDDStrToDDDDBD(str, NORTH_SOUTH[this.latitudeDir.getSelectedIndex()]);
                this.latitudeStr = this.latitudeTF.getText();
            } else {
                this.latitude = null;
                this.latitudeStr = null;
            }
        } else {
            String str = this.longitudeDD.getText();
            if (StringUtils.isNotEmpty((String)StringUtils.deleteWhitespace((String)str))) {
                this.longitude = LatLonConverter.convertDDDDStrToDDDDBD(str, EAST_WEST[this.longitudeDir.getSelectedIndex()]);
                this.longitudeStr = this.latitudeTF.getText();
            } else {
                this.longitude = null;
                this.longitudeStr = null;
            }
        }
    }

    @Override
    public String getLatitudeStr() {
        return this.getLatitudeStr(true);
    }

    @Override
    public String getLongitudeStr() {
        return this.getLongitudeStr(true);
    }

    public String getLatitudeStr(boolean inclZeroes) {
        return String.valueOf(this.latitudeDD.getText()) + "\u00b0" + " " + NORTH_SOUTH[this.latitudeDir.getSelectedIndex()];
    }

    public String getLongitudeStr(boolean inclZeroes) {
        return String.valueOf(this.longitudeDD.getText()) + "\u00b0" + " " + EAST_WEST[this.longitudeDir.getSelectedIndex()];
    }

    protected ValFormattedTextFieldSingle createTextField(Class<?> dataCls, int columns, Number minValue, Number maxValue, Vector<ValFormattedTextFieldSingle> txtList) {
        NumberMinMaxFormatter fmt = new NumberMinMaxFormatter(dataCls, columns, minValue, maxValue);
        ValFormattedTextFieldSingle textField = new ValFormattedTextFieldSingle(fmt, false, false, false);
        if (this.isViewMode) {
            ViewFactory.changeTextFieldUIForDisplay(textField, false);
        } else {
            textField.setRequired(this.isRequired);
            DataChangeNotifier dcn = new DataChangeNotifier(null, textField, null);
            dcn.addDataChangeListener(this);
            this.dcNotifiers.add(dcn);
            textField.getDocument().addDocumentListener(dcn);
        }
        txtList.add(textField);
        return textField;
    }

    protected void doDataChangeNotify() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DDDDPanel.this.hasChanged = true;
                if (DDDDPanel.this.changeListener != null) {
                    DDDDPanel.this.changeListener.stateChanged(null);
                }
            }
        });
    }

    protected void doDataChanged() {
        this.doDataChangeNotify();
    }

    @Override
    public void setViewMode(boolean isViewModeArg) {
        this.isViewMode = isViewModeArg;
    }

    @Override
    public void getDataFromUI() {
        this.getDataFromUI(true);
        this.getDataFromUI(false);
    }

    @Override
    public void set(BigDecimal latitudeArg, BigDecimal longitudeArg, String latitudeStrArg, String longitudeStrArg) {
        throw new RuntimeException("Do Not call this");
    }

    public void set(LatLonConverter.FORMAT srcFormat, String srcLatitudeStr, String srcLongitudeStr) {
        if (srcLatitudeStr != null && srcLongitudeStr != null) {
            this.latInfoOrig = LatLonConverter.adjustLatLonStr(srcLatitudeStr, srcFormat, true, true, LatLonConverter.LATLON.Latitude);
            this.lonInfoOrig = LatLonConverter.adjustLatLonStr(srcLongitudeStr, srcFormat, true, true, LatLonConverter.LATLON.Longitude);
            if (srcFormat != this.defaultFormat) {
                this.latitudeStr = LatLonConverter.convert(this.latInfoOrig.getStrVal(true), this.latInfoOrig.getFormat(), this.defaultFormat, LatLonConverter.LATLON.Latitude);
                this.longitudeStr = LatLonConverter.convert(this.lonInfoOrig.getStrVal(true), this.lonInfoOrig.getFormat(), this.defaultFormat, LatLonConverter.LATLON.Longitude);
            } else {
                this.latitudeStr = srcLatitudeStr;
                this.longitudeStr = srcLongitudeStr;
            }
            this.latInfoCnvrt = LatLonConverter.adjustLatLonStr(this.latitudeStr, this.defaultFormat, false, false, LatLonConverter.LATLON.Latitude);
            this.lonInfoCnvrt = LatLonConverter.adjustLatLonStr(this.longitudeStr, this.defaultFormat, false, false, LatLonConverter.LATLON.Longitude);
            this.latitudeTF.setText(srcLatitudeStr);
            this.longitudeTF.setText(srcLongitudeStr);
        } else {
            this.latInfoOrig = null;
            this.lonInfoOrig = null;
            this.latitudeStr = "";
            this.longitudeStr = "";
            this.latInfoCnvrt = null;
            this.lonInfoCnvrt = null;
            this.latitudeTF.setText(srcLatitudeStr);
            this.longitudeTF.setText(srcLongitudeStr);
        }
        this.setDataIntoUI();
        this.hasChanged = false;
    }

    @Override
    public BigDecimal getLatitude() {
        this.getDataFromUI(true);
        return this.latitude;
    }

    @Override
    public BigDecimal getLongitude() {
        this.getDataFromUI(false);
        return this.longitude;
    }

    @Override
    public String getLatitudeDir() {
        this.getDataFromUI(true);
        return this.latitude.doubleValue() >= 0.0 ? northSouth[0] : northSouth[1];
    }

    @Override
    public String getLongitudeDir() {
        this.getDataFromUI(false);
        return this.longitude.doubleValue() >= 0.0 ? eastWest[0] : eastWest[1];
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void setHasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
        for (DataChangeNotifier dcn : this.dcNotifiers) {
            dcn.setDataChanged(hasChanged);
        }
    }

    @Override
    public void setIsRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Override
    public void cleanUp() {
        for (DataChangeNotifier dcn : this.dcNotifiers) {
            dcn.cleanUp();
        }
        this.reason = null;
    }

    @Override
    public void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    protected UIValidatable.ErrorType validateStateTexFields(boolean includeEmptyCheck, Vector<ValFormattedTextFieldSingle> txtList) {
        int completeCnt = 0;
        int cnt = 0;
        UIValidatable.ErrorType valState = UIValidatable.ErrorType.Valid;
        for (ValFormattedTextFieldSingle vtf : txtList) {
            if (vtf.getText().length() == 0) {
                if (includeEmptyCheck && cnt == completeCnt) {
                    if (valState != UIValidatable.ErrorType.Error) {
                        valState = UIValidatable.ErrorType.Incomplete;
                    }
                } else {
                    ++completeCnt;
                }
            } else {
                if (completeCnt != cnt && cnt > 0) {
                    return UIValidatable.ErrorType.Error;
                }
                UIValidatable.ErrorType errType = vtf.validateState();
                if (errType == UIValidatable.ErrorType.Valid) {
                    ++completeCnt;
                } else if (errType.ordinal() > valState.ordinal()) {
                    valState = errType;
                }
            }
            ++cnt;
        }
        return valState;
    }

    protected UIValidatable.ErrorType validateState(boolean includeEmptyCheck, Vector<ValFormattedTextFieldSingle> txtList, JTextField textTF, String formattedStr) {
        UIValidatable.ErrorType state = this.validateStateTexFields(includeEmptyCheck, txtList);
        if (this.hasChanged) {
            textTF.setText(state == UIValidatable.ErrorType.Valid || state == UIValidatable.ErrorType.Incomplete ? formattedStr : "");
        }
        return state;
    }

    @Override
    public UIValidatable.ErrorType validateState(boolean includeEmptyCheck) {
        this.reason = null;
        UIValidatable.ErrorType latState = this.validateState(includeEmptyCheck, this.latTFs, this.latitudeTF, this.getLatitudeStr(false));
        UIValidatable.ErrorType lonState = this.validateState(includeEmptyCheck, this.lonTFs, this.longitudeTF, this.getLongitudeStr(false));
        return latState.ordinal() > lonState.ordinal() ? latState : lonState;
    }

    public String getSrcLatitudeStr() {
        return this.latitudeTF.getText();
    }

    public String getSrcLongitudeStr() {
        return this.longitudeTF.getText();
    }

    @Override
    public void clear() {
        this.latitudeDD.setText("");
        this.longitudeDD.setText("");
        this.latitude = null;
        this.longitude = null;
        this.reason = null;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public void dataChanged(String name, Component comp, DataChangeNotifier dcn) {
        this.doDataChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.doDataChanged();
    }

    protected static enum ValState {
        Empty,
        Valid,
        Error;

    }
}

