/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.latlon;

import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.util.Triple;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BorderedRadioButton
extends JToggleButton {
    protected static Border selectedBorder = null;
    protected static Border unselectedBorder = null;
    protected Color hoverColor = UIHelper.getHoverColor();
    protected Color focusColor = null;
    protected Border emptyBorder;
    protected Border focusBorder = null;
    protected boolean hasFocus = false;
    protected boolean isHovering = false;

    public BorderedRadioButton() {
        this.init();
    }

    public BorderedRadioButton(Icon icon) {
        super(icon);
        this.init();
    }

    public BorderedRadioButton(Action a) {
        super(a);
        this.init();
    }

    public BorderedRadioButton(String text) {
        super(text);
        this.init();
    }

    public BorderedRadioButton(Icon arg0, boolean arg1) {
        super(arg0, arg1);
        this.init();
    }

    public BorderedRadioButton(String text, boolean b) {
        super(text, b);
        this.init();
    }

    public BorderedRadioButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public BorderedRadioButton(String text, Icon icon, boolean b) {
        super(text, icon, b);
        this.init();
    }

    protected void init() {
        if (unselectedBorder != null) {
            this.setBorder(unselectedBorder);
            this.setBorderPainted(true);
        }
        Triple<Border, Border, Color> focusInfo = UIHelper.getFocusBorders(this);
        this.focusBorder = (Border)focusInfo.first;
        this.emptyBorder = (Border)focusInfo.second;
        this.focusColor = (Color)focusInfo.third;
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.setIconTextGap(1);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                JToggleButton rb;
                rb.setBorder((rb = (JToggleButton)ce.getSource()).isSelected() ? selectedBorder : unselectedBorder);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                BorderedRadioButton.this.isHovering = true;
                BorderedRadioButton.this.repaint();
                super.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BorderedRadioButton.this.isHovering = false;
                BorderedRadioButton.this.repaint();
                super.mouseExited(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                BorderedRadioButton.this.hasFocus = true;
                if (((BorderedRadioButton)e.getSource()).isEnabled()) {
                    ((BorderedRadioButton)e.getSource()).setBorder(BorderedRadioButton.this.focusBorder);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                BorderedRadioButton.this.hasFocus = false;
                if (((BorderedRadioButton)e.getSource()).isEnabled()) {
                    ((BorderedRadioButton)e.getSource()).setBorder(BorderedRadioButton.this.isSelected() ? selectedBorder : unselectedBorder);
                }
            }
        });
        this.setBorder(this.emptyBorder);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isHovering && !this.hasFocus && this.isEnabled()) {
            g.setColor(this.hoverColor);
            Insets insets = this.getInsets();
            Dimension size = this.getSize();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RoundRectangle2D.Double rr = new RoundRectangle2D.Double(insets.left, insets.top, size.width - insets.right - insets.left, size.height - insets.bottom - insets.top, 10.0, 10.0);
            g2d.setStroke(UIHelper.getStdLineStroke());
            g2d.draw(rr);
            rr = new RoundRectangle2D.Double(insets.left + 1, insets.top + 1, size.width - insets.right - insets.left - 2, size.height - insets.bottom - insets.top - 2, 10.0, 10.0);
            g2d.draw(rr);
        }
    }

    public void makeSquare() {
        Dimension size = this.getMinimumSize();
        size.width = size.height;
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setPreferredSize(size);
    }

    public static void setSelectedBorder(Border selectedBorder) {
        BorderedRadioButton.selectedBorder = selectedBorder;
    }

    public static void setUnselectedBorder(Border unselectedBorder) {
        BorderedRadioButton.unselectedBorder = unselectedBorder;
    }
}

