/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.imgproc;

import edu.ku.brc.ui.GraphicsUtils;
import edu.ku.brc.ui.Trayable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;

public class TrayImageIcon
implements Trayable {
    protected ImageIcon imgIcon;
    protected ImageIcon imgIconFull;
    protected File file;

    public TrayImageIcon(File file) {
        this.file = file;
        this.imgIconFull = new ImageIcon(file.getAbsolutePath());
        BufferedImage destImage = null;
        int destWidth = 120;
        destImage = new BufferedImage(destWidth, destWidth, 1);
        Graphics2D graphics2D = destImage.createGraphics();
        graphics2D.drawImage(this.imgIconFull.getImage(), 0, 0, destWidth, destWidth, null);
        graphics2D.dispose();
        try {
            int[] hsv = new int[3];
            int i = 0;
            while (i < destWidth) {
                Color c = new Color(destImage.getRGB(i, 0));
                this.rgb2hsv(c.getRed(), c.getGreen(), c.getBlue(), hsv);
                System.out.print(String.valueOf(c.getRed()) + "," + c.getGreen() + "," + c.getBlue() + "   ");
                System.out.print(String.valueOf(hsv[0]) + "," + hsv[1] + "," + hsv[2] + "   ");
                double[] hsvDbl = TrayImageIcon.RGBtoHSV(c.getRed(), c.getGreen(), c.getBlue());
                System.out.println(String.valueOf(hsvDbl[0]) + "," + hsvDbl[1] + "," + hsvDbl[2] + "   ");
                ++i;
            }
            System.out.println();
            System.out.println();
            this.rgb2hsv(255, 0, 0, hsv);
            System.out.println(String.valueOf(hsv[0]) + "," + hsv[1] + "," + hsv[2] + "   ");
            double[] hsvDbl = TrayImageIcon.RGBtoHSV(255.0, 0.0, 0.0);
            System.out.println(String.valueOf(hsvDbl[0]) + "," + hsvDbl[1] + "," + hsvDbl[2] + "   ");
            this.rgb2hsv(0, 255, 0, hsv);
            System.out.println(String.valueOf(hsv[0]) + "," + hsv[1] + "," + hsv[2] + "   ");
            hsvDbl = TrayImageIcon.RGBtoHSV(0.0, 255.0, 0.0);
            System.out.println(String.valueOf(hsvDbl[0]) + "," + hsvDbl[1] + "," + hsvDbl[2] + "   ");
            this.rgb2hsv(0, 0, 255, hsv);
            System.out.println(String.valueOf(hsv[0]) + "," + hsv[1] + "," + hsv[2] + "   ");
            hsvDbl = TrayImageIcon.RGBtoHSV(0.0, 0.0, 255.0);
            System.out.println(String.valueOf(hsvDbl[0]) + "," + hsvDbl[1] + "," + hsvDbl[2] + "   ");
            this.imgIcon = GraphicsUtils.scaleImageToIconImage(destImage, 120, 120, true, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static double[] RGBtoHSV(double r, double g, double b) {
        double max;
        double min = Math.min(Math.min(r, g), b);
        double v = max = Math.max(Math.max(r, g), b);
        double delta = max - min;
        if (max == 0.0) {
            double s = 0.0;
            double h = -1.0;
            return new double[]{h, s, v};
        }
        double s = delta / max;
        double h = r == max ? (g - b) / delta : (g == max ? 2.0 + (b - r) / delta : 4.0 + (r - g) / delta);
        h *= 60.0;
        if (h < 0.0) {
            h += 360.0;
        }
        return new double[]{h, s, v};
    }

    private void rgb2hsv(int r, int g, int b, int[] hsv) {
        float S;
        int max;
        int min;
        if (r > g) {
            min = g;
            max = r;
        } else {
            min = r;
            max = g;
        }
        if (b > max) {
            max = b;
        }
        if (b < min) {
            min = b;
        }
        int delMax = max - min;
        float H = 0.0f;
        float V = max;
        if (delMax == 0) {
            H = 0.0f;
            S = 0.0f;
        } else {
            S = (float)delMax / 255.0f;
            if (r == max) {
                H = (float)(g - b) / (float)delMax * 60.0f;
            } else if (g == max) {
                H = (2.0f + (float)(b - r) / (float)delMax) * 60.0f;
            } else if (b == max) {
                H = (4.0f + (float)(r - g) / (float)delMax) * 60.0f;
            }
        }
        hsv[0] = (int)H;
        hsv[1] = (int)(S * 100.0f);
        hsv[2] = (int)(V * 100.0f);
    }

    @Override
    public ImageIcon getIcon() {
        return this.imgIcon;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

