/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.imgproc;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchTemplate;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.specify.plugins.imgproc.ConfigDlg;
import edu.ku.brc.specify.plugins.imgproc.IconTray;
import edu.ku.brc.specify.plugins.imgproc.ImageProcListener;
import edu.ku.brc.specify.plugins.imgproc.ImageProcessorPanel;
import edu.ku.brc.specify.plugins.imgproc.ImageTrayListCellRenderer;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchPaneSS;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.Trayable;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.WorkBenchPluginIFace;
import edu.ku.brc.ui.tmanfe.SpreadSheet;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ImageWorkFlowPanel
extends JPanel
implements ImageProcListener,
WorkBenchPluginIFace {
    protected CustomDialog dlg;
    protected ImageProcessorPanel imgProcPanel;
    protected IconTray<Trayable> imageTray;
    protected JStatusBar statusBar;
    protected JList list;
    protected boolean firstDisplay = true;
    protected JButton ssBtn = null;
    protected Workbench workbench = null;
    protected SpreadSheet spreadSheet = null;
    protected WorkbenchPaneSS wbpss = null;

    public ImageWorkFlowPanel() {
        this.createUI();
    }

    public void createUI() {
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,8px,f:p:g", "p,4px,f:max(150px;p):g,8px,p"), (JPanel)this);
        this.imageTray = new IconTray(1);
        this.imageTray.setCellRenderer(new ImageTrayListCellRenderer());
        this.imgProcPanel = new ImageProcessorPanel(this.imageTray, this);
        this.imgProcPanel.createUI();
        this.statusBar = new JStatusBar();
        this.list = new JList(new DefaultListModel());
        JScrollPane sc = UIHelper.createScrollPane(this.list);
        pb.add((Component)this.imgProcPanel, cc.xy(1, 1));
        pb.add((Component)sc, cc.xywh(3, 1, 1, 3));
        pb.add(this.imageTray, cc.xyw(1, 3, 1));
        pb.add((Component)this.statusBar, cc.xyw(1, 5, 3));
        pb.setDefaultDialogBorder();
        this.dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), "Image Processor", false, 11, this){

            @Override
            public JButton getOkBtn() {
                ImageWorkFlowPanel.this.imageTray.removeAllItems();
                return super.getOkBtn();
            }

            @Override
            protected void cancelButtonPressed() {
                ConfigDlg configDlg = new ConfigDlg(ImageWorkFlowPanel.this.dlg);
                UIHelper.centerAndShow(configDlg);
                if (!configDlg.isCancelled()) {
                    ImageWorkFlowPanel.this.imgProcPanel.readSetupPrefs();
                }
            }

            @Override
            protected void applyButtonPressed() {
                ImageWorkFlowPanel.this.imgProcPanel.clearFiles();
            }
        };
        this.dlg.setOkLabel("Close");
        this.dlg.setCancelLabel("Config");
        this.dlg.setApplyLabel("Clear");
        this.imgProcPanel.clearFiles();
    }

    @Override
    public void complete(ImageProcListener.ActionType actionType, Object data) {
        if (actionType == ImageProcListener.ActionType.eBarDecoding && data instanceof Pair) {
            Pair dataPair = (Pair)data;
            ((DefaultListModel)this.list.getModel()).addElement(dataPair.first);
            if (this.spreadSheet != null) {
                int rowInx = this.spreadSheet.getRowCount() - 1;
                this.spreadSheet.setRowSelectionInterval(rowInx, rowInx);
                this.wbpss.addRowAfter();
                WorkbenchRow row = this.workbench.getRow(++rowInx);
                if (row != null) {
                    for (File file : (ArrayList)dataPair.second) {
                        try {
                            row.addImage(file);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    WorkbenchTemplate wbt = this.workbench.getWorkbenchTemplate();
                    for (WorkbenchTemplateMappingItem item : wbt.getWorkbenchTemplateMappingItems()) {
                        System.out.println("[" + item.getFieldName() + "]");
                        if (!item.getFieldName().equals("catalogNumber")) continue;
                        short colInx = item.getViewOrder();
                        System.out.println("colInx[" + colInx + "]");
                        if (colInx <= -1) continue;
                        this.spreadSheet.setValueAt(dataPair.first, rowInx, colInx);
                    }
                    this.wbpss.refreshImagesForSelectedRow();
                }
            }
        }
    }

    @Override
    public void statusMsg(String msg) {
        this.statusBar.setText(msg);
    }

    @Override
    public List<String> getMissingFieldsForPlugin() {
        return null;
    }

    @Override
    public void setWorkbenchPaneSS(WorkbenchPaneSS wbpss) {
        this.wbpss = wbpss;
    }

    @Override
    public void setSpreadSheet(SpreadSheet ss) {
        this.spreadSheet = ss;
    }

    @Override
    public void setWorkbench(Workbench workbench) {
        this.workbench = workbench;
    }

    @Override
    public void shutdown() {
        this.workbench = null;
        this.spreadSheet = null;
        this.dlg.setVisible(false);
        this.dlg = null;
    }

    @Override
    public Collection<JComponent> getSSButtons() {
        if (this.ssBtn == null) {
            this.ssBtn = UIHelper.createIconBtn("ip_barcode20", null, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (ImageWorkFlowPanel.this.firstDisplay) {
                        UIHelper.centerAndShow(ImageWorkFlowPanel.this.dlg);
                        ImageWorkFlowPanel.this.firstDisplay = false;
                    } else {
                        ImageWorkFlowPanel.this.dlg.setVisible(!ImageWorkFlowPanel.this.dlg.isVisible());
                    }
                }
            });
            this.ssBtn.setEnabled(true);
        }
        ArrayList<JComponent> btns = new ArrayList<JComponent>();
        btns.add(this.ssBtn);
        return btns;
    }

    @Override
    public Collection<JComponent> getFormButtons() {
        return new ArrayList<JComponent>();
    }
}

