/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.imgproc;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.specify.plugins.imgproc.BarCodeDecoder;
import edu.ku.brc.specify.plugins.imgproc.IconTray;
import edu.ku.brc.specify.plugins.imgproc.ImageProcListener;
import edu.ku.brc.specify.plugins.imgproc.TrayImageIcon;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.Trayable;
import edu.ku.brc.util.Pair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class ImageProcessorPanel
extends JPanel {
    protected static final int PROC_ICON_SIZE = 120;
    protected static final int PROC_IMG_SIZE = 93;
    protected static BasicStroke lineStroke = new BasicStroke(1.5f, 1, 1);
    protected static Font font = null;
    protected BarCodeDecoder barDecoder = new BarCodeDecoder();
    protected IconTray<Trayable> iconTray;
    protected Timer timer = null;
    protected String[] imgNames = new String[]{"png", "tif", "bmp", "gif", "jpg"};
    protected int imgIndex = 0;
    protected ImageIcon circle;
    protected ImageProcListener listener;
    protected Vector<TrayImageIcon> trayItems = new Vector();
    protected String srcDir = "/Users/rods/Pictures/Eye-Fi/Pics";
    protected int step = 0;
    protected int numPics = 3;
    protected int barcodePicInx = 0;
    protected String[] procImgNames = new String[]{"camera", "barcode", "metadata", "disk"};
    protected ArrayList<ProcessObject> procObjs = new ArrayList();
    protected static RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    protected ArrayList<File> filesToProcess = new ArrayList();

    static {
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public ImageProcessorPanel(IconTray<Trayable> iconTray, ImageProcListener listener) {
        super(null);
        this.iconTray = iconTray;
        this.listener = listener;
    }

    public void createUI() {
        Dimension s = new Dimension(350, 350);
        this.setSize(s);
        this.setPreferredSize(s);
        this.setBackground(Color.WHITE);
        String[] stringArray = this.procImgNames;
        int n = this.procImgNames.length;
        int n2 = 0;
        while (n2 < n) {
            String imgNm = stringArray[n2];
            this.procObjs.add(new ProcessObject(imgNm));
            ++n2;
        }
        this.circle = IconManager.getIcon("ip_circle");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageProcessorPanel.this.doProcLayout();
                ImageProcessorPanel.this.step = -1;
                ImageProcessorPanel.this.doNextStep();
            }
        });
    }

    protected void doProcLayout() {
        Dimension size = this.getSize();
        int margin = 20;
        Point p = new Point(margin, margin);
        int i = 0;
        while (i < 4) {
            switch (i) {
                case 0: {
                    p.setLocation(margin, margin * 2);
                    break;
                }
                case 1: {
                    p.setLocation(size.width - 120 - margin, margin * 2);
                    break;
                }
                case 2: {
                    p.setLocation(size.width - 120 - margin, size.height - 120 - margin);
                    break;
                }
                case 3: {
                    p.setLocation(margin, size.height - 120 - margin);
                }
            }
            this.add(this.procObjs.get(i));
            this.procObjs.get(i).setLocation(p);
            this.procObjs.get(i).setVisible(true);
            ++i;
        }
    }

    @Override
    public void paint(Graphics g) {
        ((Graphics2D)g).addRenderingHints(hints);
        super.paint(g);
        if (font == null) {
            font = new JLabel().getFont();
            font = font.deriveFont(18.0f);
            font = font.deriveFont(1);
        }
        String title = "Specify Image Processor";
        g.setColor(new Color(32, 131, 155));
        g.setFont(font);
        int w = g.getFontMetrics().stringWidth(title);
        int y = g.getFontMetrics().getHeight() - 5;
        int x = (this.getSize().width - w) / 2;
        g.drawString(title, x, y);
    }

    protected void startWatching() {
        this.timer = new Timer(1500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageProcessorPanel.this.acquireImages();
            }
        });
        this.timer.start();
    }

    public void clearFiles() {
        File dir = new File(this.srcDir);
        if (dir != null && dir.exists()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String ext = FilenameUtils.getExtension((String)f.getName());
                if (!f.getName().startsWith(".") && ext != null && (ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("png"))) {
                    f.delete();
                }
                ++n2;
            }
        }
    }

    protected void doNextStep() {
        if (this.step > -1) {
            this.procObjs.get(this.step).setOn(false);
        }
        ++this.step;
        if (this.step >= this.procObjs.size()) {
            this.step = 0;
        }
        System.out.println("Step: " + this.step);
        this.procObjs.get(this.step).setOn(true);
        SwingWorker<Integer, Integer> worker = new SwingWorker<Integer, Integer>(){

            @Override
            protected Integer doInBackground() throws Exception {
                switch (ImageProcessorPanel.this.step) {
                    case 0: {
                        ImageProcessorPanel.this.acquireImages();
                        break;
                    }
                    case 1: {
                        ImageProcessorPanel.this.processBarCode();
                        break;
                    }
                    case 2: {
                        ImageProcessorPanel.this.processMetaData();
                        break;
                    }
                    case 3: {
                        ImageProcessorPanel.this.processSaveToDisk();
                    }
                }
                return null;
            }
        };
        worker.execute();
    }

    protected void advance() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageProcessorPanel.this.doNextStep();
            }
        });
    }

    protected void acquireImages() {
        int n;
        if (this.timer != null) {
            this.timer.stop();
        }
        File dir = new File(this.srcDir);
        String[] nms = dir.list();
        int cnt = 0;
        if (nms.length > 0) {
            String[] stringArray = nms;
            n = nms.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!s.startsWith(".")) {
                    ++cnt;
                }
                ++n2;
            }
        }
        if (cnt == this.numPics) {
            File[] files;
            this.filesToProcess.clear();
            this.trayItems.clear();
            this.iconTray.removeAllItems();
            File[] fileArray = files = dir.listFiles();
            int n3 = files.length;
            n = 0;
            while (n < n3) {
                File f = fileArray[n];
                if (!f.getName().startsWith(".")) {
                    this.filesToProcess.add(f);
                    System.out.println("Add: " + f.getName());
                }
                ++n;
            }
            Comparator<File> fileComp = new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return Long.valueOf(o1.lastModified()).compareTo(o2.lastModified());
                }
            };
            Collections.sort(this.filesToProcess, fileComp);
            this.iconTray.removeAllItems();
            for (File f : this.filesToProcess) {
                System.out.println(f.getName());
                TrayImageIcon trayItem = new TrayImageIcon(f);
                this.iconTray.addItem(trayItem);
                this.trayItems.add(trayItem);
            }
            this.iconTray.repaint();
            this.advance();
        } else {
            this.startWatching();
        }
    }

    public void readSetupPrefs() {
        AppPreferences locPrefs = AppPreferences.getLocalPrefs();
        this.numPics = locPrefs.getInt("IMGWRKFLW.PIC_CNT", 3);
        this.barcodePicInx = locPrefs.getInt("IMGWRKFLW.PIC_INX", 1);
        this.srcDir = locPrefs.get("IMGWRKFLW.PIC_DEST", "/Users/rods/Pictures/Eye-Fi/Pics");
    }

    protected void processBarCode() {
        this.listener.statusMsg("Reading BarCode from image...");
        File file = this.filesToProcess.get(this.barcodePicInx);
        System.out.println("BarCode: " + file.getName());
        try {
            this.barDecoder.decode(file);
            String number = this.barDecoder.getNumber();
            if (StringUtils.isNotEmpty((String)number)) {
                this.listener.statusMsg("Barcode: " + number);
                ArrayList<File> imgFiles = new ArrayList<File>();
                System.out.println(this.trayItems.size());
                int cnt = 1;
                for (TrayImageIcon trayItem : this.trayItems) {
                    String ext = FilenameUtils.getExtension((String)trayItem.getFile().getName());
                    String nm = String.format("processedimages/%s_%d.%s", number, cnt, ext);
                    File newFile = new File(nm);
                    try {
                        FileUtils.copyFile((File)trayItem.getFile(), (File)newFile);
                        imgFiles.add(newFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    trayItem.setFile(newFile);
                    ++cnt;
                }
                try {
                    this.listener.complete(ImageProcListener.ActionType.eBarDecoding, new Pair(number, imgFiles));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                this.listener.statusMsg("Error reading BarCode from image...");
            }
            this.iconTray.repaint();
        }
        catch (IOException e) {
            this.listener.statusMsg("Barcode Error!");
            e.printStackTrace();
        }
        this.advance();
    }

    protected void processMetaData() {
        this.listener.statusMsg("Setting metadata...");
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.advance();
    }

    protected void processSaveToDisk() {
        this.listener.statusMsg("Saving to disk...");
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.listener.statusMsg(" ");
        for (File f : this.filesToProcess) {
            f.delete();
        }
        this.filesToProcess.clear();
        this.iconTray.removeAllItems();
        this.iconTray.repaint();
        this.advance();
    }

    class ProcessObject
    extends JPanel {
        protected Point imgPnt;
        protected ImageIcon img;
        protected boolean isOn;

        public ProcessObject(String nm) {
            this.setSize(500, 500);
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.img = IconManager.getIcon(String.format("ip_%s", nm));
            this.setSize(120, 120);
            this.setOpaque(false);
            this.setVisible(false);
            int offsetX = (120 - this.img.getIconWidth()) / 2;
            int offsetY = (120 - this.img.getIconHeight()) / 2;
            this.imgPnt = new Point(offsetX, offsetY);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g.drawImage(this.img.getImage(), this.imgPnt.x, this.imgPnt.y, null);
            if (this.isOn) {
                g.drawImage(ImageProcessorPanel.this.circle.getImage(), 0, 0, null);
            }
        }

        public boolean isOn() {
            return this.isOn;
        }

        public void setOn(boolean isOn) {
            this.isOn = isOn;
            this.repaint();
        }
    }
}

