/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.imgproc;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.validation.ValBrowseBtnPanel;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.af.ui.forms.validation.ValSpinner;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class ConfigDlg
extends CustomDialog {
    protected ValCheckBox useNumCheckbox;
    protected ValSpinner numPicsSpin;
    protected ValSpinner barCodeInxSpin;
    protected ValTextField dstTxt;
    protected ValBrowseBtnPanel destination;

    public ConfigDlg(Dialog dialog) throws HeadlessException {
        super(dialog, "Configure", true, 7, null);
    }

    @Override
    public void createUI() {
        super.createUI();
        this.useNumCheckbox = new ValCheckBox("Use Picture Count", false, false);
        this.numPicsSpin = new ValSpinner(1, 10, false, false);
        this.barCodeInxSpin = new ValSpinner(1, 10, false, false);
        this.dstTxt = new ValTextField();
        this.destination = new ValBrowseBtnPanel(this.dstTxt, true, true);
        CellConstraints cc = new CellConstraints();
        PanelBuilder bldr = new PanelBuilder(new FormLayout("p,2px,p,f:p:g", "p,4px,p,4px,p,4px,p"));
        int y = 1;
        bldr.add((Component)UIHelper.createLabel(""), cc.xy(1, y));
        bldr.add((Component)this.useNumCheckbox, cc.xy(3, y));
        bldr.add((Component)UIHelper.createI18NFormLabel("Number of Pictures"), cc.xy(1, y += 2));
        bldr.add((Component)this.numPicsSpin, cc.xy(3, y));
        bldr.add((Component)UIHelper.createI18NFormLabel("Barcode Picture Number"), cc.xy(1, y += 2));
        bldr.add((Component)this.barCodeInxSpin, cc.xy(3, y));
        bldr.add((Component)UIHelper.createI18NFormLabel("Destination"), cc.xy(1, y += 2));
        bldr.add((Component)this.destination, cc.xyw(3, y, 2));
        y += 2;
        bldr.setDefaultDialogBorder();
        this.contentPanel = bldr.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        AppPreferences locPrefs = AppPreferences.getLocalPrefs();
        this.useNumCheckbox.setSelected(locPrefs.getBoolean("IMGWRKFLW.USE_CNT", true));
        this.numPicsSpin.setValue(locPrefs.getInt("IMGWRKFLW.PIC_CNT", 3));
        this.barCodeInxSpin.setValue(locPrefs.getInt("IMGWRKFLW.PIC_INX", 0) + 1);
        this.dstTxt.setValue(locPrefs.get("IMGWRKFLW.PIC_DEST", "/Users/rods/Pictures/Eye-Fi/Pics"), "");
        this.pack();
    }

    @Override
    protected void okButtonPressed() {
        File dir;
        AppPreferences locPrefs = AppPreferences.getLocalPrefs();
        locPrefs.putBoolean("IMGWRKFLW.USE_CNT", this.useNumCheckbox.isSelected());
        locPrefs.putInt("IMGWRKFLW.PIC_CNT", this.numPicsSpin.getIntValue());
        locPrefs.putInt("IMGWRKFLW.PIC_INX", this.barCodeInxSpin.getIntValue() - 1);
        String dstStr = this.dstTxt.getText();
        if (StringUtils.isNotEmpty((String)dstStr) && (dir = new File(dstStr)).exists()) {
            locPrefs.put("IMGWRKFLW.PIC_DEST", dstStr);
        }
        super.okButtonPressed();
    }
}

