/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins.imgproc;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.common.HybridBinarizer;
import edu.ku.brc.specify.plugins.imgproc.Config;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class BarCodeDecoder {
    Result result = null;
    private int successful;
    private final Config config = new Config();

    public int getSuccessful() {
        return this.successful;
    }

    public Result decode(File file) throws IOException {
        BufferedImage image;
        Hashtable<DecodeHintType, Object> hints = this.config.getHints();
        try {
            image = ImageIO.read(file);
        }
        catch (IllegalArgumentException iae) {
            throw new FileNotFoundException("Resource not found: " + file.getAbsolutePath());
        }
        if (image == null) {
            System.err.println(String.valueOf(file.toString()) + ": Could not load image");
            return null;
        }
        try {
            BufferedImageLuminanceSource source;
            if (this.config.getCrop() == null) {
                source = new BufferedImageLuminanceSource(image);
            } else {
                int[] crop = this.config.getCrop();
                source = new BufferedImageLuminanceSource(image, crop[0], crop[1], crop[2], crop[3]);
            }
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            this.result = new MultiFormatReader().decode(bitmap, hints);
            if (this.config.isBrief()) {
                System.out.println(String.valueOf(file.getAbsolutePath()) + ": Success");
            } else {
                ParsedResult parsedResult = ResultParser.parseResult((Result)this.result);
                System.out.println(String.valueOf(file.getAbsolutePath()) + " (format: " + this.result.getBarcodeFormat() + ", type: " + parsedResult.getType() + "):\nRaw result:\n" + this.result.getText() + "\nParsed result:\n" + parsedResult.getDisplayResult());
                System.out.println("Found " + this.result.getResultPoints().length + " result points.");
                int i = 0;
                while (i < this.result.getResultPoints().length) {
                    ResultPoint rp = this.result.getResultPoints()[i];
                    System.out.println("  Point " + i + ": (" + rp.getX() + ',' + rp.getY() + ')');
                    ++i;
                }
            }
            return this.result;
        }
        catch (NotFoundException nfe) {
            System.out.println(String.valueOf(file.getAbsolutePath()) + ": No barcode found");
            return null;
        }
    }

    public String getNumber() {
        ParsedResult parsedResult;
        if (this.result != null && (parsedResult = ResultParser.parseResult((Result)this.result)) != null) {
            return this.result.getText();
        }
        return null;
    }
}

